/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import com.metamatrix.core.util.CharOperation;
import com.metamatrix.internal.core.index.WordEntry;

public class WordEntryHashedArray {
    public WordEntry[] elements;
    public int elementSize;

    public WordEntryHashedArray(int size) {
        if (size < 7) {
            size = 7;
        }
        this.elements = new WordEntry[2 * size + 1];
        this.elementSize = 0;
    }

    public WordEntry add(WordEntry entry) {
        if (entry == null) {
            return null;
        }
        int newIndex = this.elementSize++;
        this.elements[newIndex] = entry;
        if (this.elementSize >= this.elements.length) {
            this.grow();
        }
        return entry;
    }

    public WordEntry[] asArray() {
        WordEntry[] array = new WordEntry[this.elementSize];
        if (this.elementSize > 0) {
            WordEntry current;
            int j2 = 0;
            int length = this.elements.length;
            for (int i2 = 0; i2 < length && (current = this.elements[i2]) != null; ++i2) {
                array[j2++] = current;
            }
        } else {
            return new WordEntry[0];
        }
        return array;
    }

    public WordEntry get(char[] word) {
        WordEntry current;
        int length = this.elements.length;
        int index = CharOperation.hashCode(word) % length;
        while ((current = this.elements[index]) != null) {
            if (CharOperation.equals(current.getWord(), word)) {
                return current;
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    private void grow() {
        WordEntry[] newArray = new WordEntry[this.elementSize * 2];
        int j2 = 0;
        int length = this.elements.length;
        for (int i2 = 0; i2 < length; ++i2) {
            if (this.elements[i2] == null) continue;
            newArray[j2++] = this.elements[i2];
        }
        this.elements = newArray;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        WordEntry[] entries = this.asArray();
        int length = entries.length;
        for (int i2 = 0; i2 < length; ++i2) {
            sb.append(entries[i2].toString() + "\n");
        }
        return sb.toString();
    }
}

