/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.text;

import com.metamatrix.internal.core.text.Utility;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class MessageFormat
extends Format {
    private Locale locale = Locale.getDefault();
    private String pattern = "";
    public static final int MAX_ARGUMENTS = 100;
    private Format[] formats = new Format[100];
    private int[] offsets = new int[100];
    private int[] argumentNumbers = new int[100];
    private int maxOffset = -1;
    private static final String[] typeList = new String[]{"", "", "number", "", "date", "", "time", "", "choice"};
    private static final String[] modifierList = new String[]{"", "", "currency", "", "percent", "", "integer"};
    private static final String[] dateModifierList = new String[]{"", "", "short", "", "medium", "", "long", "", "full"};

    public MessageFormat(String pattern) {
        this.applyPattern(pattern);
    }

    public void setLocale(Locale theLocale) {
        this.locale = theLocale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void applyPattern(String newPattern) {
        StringBuffer[] segments = new StringBuffer[4];
        for (int i2 = 0; i2 < segments.length; ++i2) {
            segments[i2] = new StringBuffer();
        }
        int part = 0;
        int formatNumber = 0;
        boolean inQuote = false;
        int braceStack = 0;
        this.maxOffset = -1;
        block7: for (int i3 = 0; i3 < newPattern.length(); ++i3) {
            char ch = newPattern.charAt(i3);
            if (part == 0) {
                if (ch == '\'') {
                    if (i3 + 1 < newPattern.length() && newPattern.charAt(i3 + 1) == '\'') {
                        segments[part].append(ch);
                        ++i3;
                        continue;
                    }
                    inQuote = !inQuote;
                    continue;
                }
                if (ch == '{' && !inQuote) {
                    part = 1;
                    continue;
                }
                segments[part].append(ch);
                continue;
            }
            if (inQuote) {
                segments[part].append(ch);
                if (ch != '\'') continue;
                inQuote = false;
                continue;
            }
            switch (ch) {
                case ',': {
                    if (part < 3) {
                        ++part;
                        continue block7;
                    }
                    segments[part].append(ch);
                    continue block7;
                }
                case '{': {
                    ++braceStack;
                    segments[part].append(ch);
                    continue block7;
                }
                case '}': {
                    if (braceStack == 0) {
                        part = 0;
                        this.makeFormat(i3, formatNumber, segments);
                        ++formatNumber;
                        continue block7;
                    }
                    --braceStack;
                    segments[part].append(ch);
                    continue block7;
                }
                case '\'': {
                    inQuote = true;
                }
                default: {
                    segments[part].append(ch);
                }
            }
        }
        if (braceStack == 0 && part != 0) {
            this.maxOffset = -1;
            throw new IllegalArgumentException("Unmatched braces in the pattern.");
        }
        this.pattern = segments[0].toString();
    }

    public String toPattern() {
        int lastOffset = 0;
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; i2 <= this.maxOffset; ++i2) {
            MessageFormat.copyAndFixQuotes(this.pattern, lastOffset, this.offsets[i2], result);
            lastOffset = this.offsets[i2];
            result.append('{');
            result.append(this.argumentNumbers[i2]);
            if (this.formats[i2] != null) {
                if (this.formats[i2] instanceof DecimalFormat) {
                    if (this.formats[i2].equals(NumberFormat.getInstance(this.locale))) {
                        result.append(",number");
                    } else if (this.formats[i2].equals(NumberFormat.getCurrencyInstance(this.locale))) {
                        result.append(",number,currency");
                    } else if (this.formats[i2].equals(NumberFormat.getPercentInstance(this.locale))) {
                        result.append(",number,percent");
                    } else if (this.formats[i2].equals(this.getIntegerFormat(this.locale))) {
                        result.append(",number,integer");
                    } else {
                        result.append(",number," + ((DecimalFormat)this.formats[i2]).toPattern());
                    }
                } else if (this.formats[i2] instanceof SimpleDateFormat) {
                    if (this.formats[i2].equals(DateFormat.getDateInstance(2, this.locale))) {
                        result.append(",date");
                    } else if (this.formats[i2].equals(DateFormat.getDateInstance(3, this.locale))) {
                        result.append(",date,short");
                    } else if (this.formats[i2].equals(DateFormat.getDateInstance(2, this.locale))) {
                        result.append(",date,medium");
                    } else if (this.formats[i2].equals(DateFormat.getDateInstance(1, this.locale))) {
                        result.append(",date,long");
                    } else if (this.formats[i2].equals(DateFormat.getDateInstance(0, this.locale))) {
                        result.append(",date,full");
                    } else if (this.formats[i2].equals(DateFormat.getTimeInstance(2, this.locale))) {
                        result.append(",time");
                    } else if (this.formats[i2].equals(DateFormat.getTimeInstance(3, this.locale))) {
                        result.append(",time,short");
                    } else if (this.formats[i2].equals(DateFormat.getTimeInstance(2, this.locale))) {
                        result.append(",time,medium");
                    } else if (this.formats[i2].equals(DateFormat.getTimeInstance(1, this.locale))) {
                        result.append(",time,long");
                    } else if (this.formats[i2].equals(DateFormat.getTimeInstance(0, this.locale))) {
                        result.append(",time,full");
                    } else {
                        result.append(",date," + ((SimpleDateFormat)this.formats[i2]).toPattern());
                    }
                } else if (this.formats[i2] instanceof ChoiceFormat) {
                    result.append(",choice," + ((ChoiceFormat)this.formats[i2]).toPattern());
                }
            }
            result.append('}');
        }
        MessageFormat.copyAndFixQuotes(this.pattern, lastOffset, this.pattern.length(), result);
        return result.toString();
    }

    public void setFormats(Format[] newFormats) {
        try {
            this.formats = (Format[])newFormats.clone();
        }
        catch (Exception e2) {
            return;
        }
    }

    public void setFormat(int variable, Format newFormat) {
        this.formats[variable] = newFormat;
    }

    public Format[] getFormats() {
        try {
            return (Format[])this.formats.clone();
        }
        catch (Exception e2) {
            return this.formats;
        }
    }

    public final StringBuffer format(Object[] source, StringBuffer result, FieldPosition ignore) {
        return this.format(source, result, ignore, 0);
    }

    public static String format(String pattern, Object[] arguments) {
        MessageFormat temp = new MessageFormat(pattern);
        return temp.format(arguments);
    }

    public final StringBuffer format(Object source, StringBuffer result, FieldPosition ignore) {
        return this.format((Object[])source, result, ignore, 0);
    }

    public Object[] parse(String source, ParsePosition status) {
        Object[] empty = new Object[]{};
        if (source == null) {
            return empty;
        }
        Object[] resultArray = new Object[100];
        int patternOffset = 0;
        int sourceOffset = status.getIndex();
        ParsePosition tempStatus = new ParsePosition(0);
        for (int i2 = 0; i2 <= this.maxOffset; ++i2) {
            int len = this.offsets[i2] - patternOffset;
            if (len == 0 || this.pattern.regionMatches(patternOffset, source, sourceOffset, len)) {
                sourceOffset += len;
                patternOffset += len;
            } else {
                status.setErrorIndex(sourceOffset);
                return null;
            }
            if (this.formats[i2] == null) {
                int tempLength = i2 != this.maxOffset ? this.offsets[i2 + 1] : this.pattern.length();
                int next = patternOffset >= tempLength ? source.length() : source.indexOf(this.pattern.substring(patternOffset, tempLength), sourceOffset);
                if (next < 0) {
                    status.setErrorIndex(sourceOffset);
                    return null;
                }
                String strValue = source.substring(sourceOffset, next);
                if (!strValue.equals("{" + this.argumentNumbers[i2] + "}")) {
                    resultArray[this.argumentNumbers[i2]] = source.substring(sourceOffset, next);
                }
                sourceOffset = next;
                continue;
            }
            tempStatus.setIndex(sourceOffset);
            resultArray[this.argumentNumbers[i2]] = this.formats[i2].parseObject(source, tempStatus);
            if (tempStatus.getIndex() == sourceOffset) {
                status.setErrorIndex(sourceOffset);
                return null;
            }
            sourceOffset = tempStatus.getIndex();
        }
        int len = this.pattern.length() - patternOffset;
        if (len != 0 && !this.pattern.regionMatches(patternOffset, source, sourceOffset, len)) {
            status.setErrorIndex(sourceOffset);
            return null;
        }
        status.setIndex(sourceOffset + len);
        return resultArray;
    }

    public Object[] parse(String source) throws ParseException {
        ParsePosition status = new ParsePosition(0);
        Object[] result = this.parse(source, status);
        if (status.getIndex() == 0) {
            throw new ParseException("MessageFormat parse error!", status.getErrorIndex());
        }
        return result;
    }

    public Object parseObject(String text, ParsePosition status) {
        return this.parse(text, status);
    }

    public Object clone() {
        MessageFormat other = (MessageFormat)super.clone();
        other.formats = (Format[])this.formats.clone();
        for (int i2 = 0; i2 < this.formats.length; ++i2) {
            if (this.formats[i2] == null) continue;
            other.formats[i2] = (Format)this.formats[i2].clone();
        }
        other.offsets = (int[])this.offsets.clone();
        other.argumentNumbers = (int[])this.argumentNumbers.clone();
        return other;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessageFormat other = (MessageFormat)obj;
        return this.maxOffset == other.maxOffset && this.pattern.equals(other.pattern) && Utility.objectEquals(this.locale, other.locale) && Utility.arrayEquals(this.offsets, (Object)other.offsets) && Utility.arrayEquals(this.argumentNumbers, (Object)other.argumentNumbers) && Utility.arrayEquals(this.formats, (Object)other.formats);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    private MessageFormat(String pattern, Locale loc) {
        this.locale = (Locale)loc.clone();
        this.applyPattern(pattern);
    }

    private StringBuffer format(Object[] arguments, StringBuffer result, FieldPosition status, int recursionProtection) {
        int lastOffset = 0;
        for (int i2 = 0; i2 <= this.maxOffset; ++i2) {
            String arg;
            result.append(this.pattern.substring(lastOffset, this.offsets[i2]));
            lastOffset = this.offsets[i2];
            int argumentNumber = this.argumentNumbers[i2];
            if (arguments == null || argumentNumber >= arguments.length) {
                result.append("{" + argumentNumber + "}");
                continue;
            }
            Object obj = arguments[argumentNumber];
            boolean tryRecursion = false;
            if (obj == null) {
                arg = "null";
            } else if (this.formats[i2] != null) {
                arg = this.formats[i2].format(obj);
                tryRecursion = this.formats[i2] instanceof ChoiceFormat;
            } else if (obj instanceof Number) {
                arg = NumberFormat.getInstance(this.locale).format(obj);
            } else if (obj instanceof Date) {
                arg = DateFormat.getDateTimeInstance(3, 3, this.locale).format(obj);
            } else if (obj instanceof String) {
                arg = (String)obj;
            } else {
                arg = obj.toString();
                if (arg == null) {
                    arg = "null";
                }
            }
            if (tryRecursion && arg.indexOf(123) >= 0) {
                MessageFormat temp = new MessageFormat(arg, this.locale);
                temp.format(arguments, result, status, recursionProtection);
                continue;
            }
            result.append(arg);
        }
        result.append(this.pattern.substring(lastOffset, this.pattern.length()));
        return result;
    }

    private void makeFormat(int position, int offsetNumber, StringBuffer[] segments) {
        int oldMaxOffset = this.maxOffset;
        try {
            int argumentNumber = Integer.parseInt(segments[1].toString());
            if (argumentNumber < 0 || argumentNumber >= 100) {
                throw new NumberFormatException();
            }
            this.maxOffset = offsetNumber;
            this.offsets[offsetNumber] = segments[0].length();
            this.argumentNumbers[offsetNumber] = argumentNumber;
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("argument number too large at ");
        }
        Format newFormat = null;
        block5 : switch (MessageFormat.findKeyword(segments[2].toString(), typeList)) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                switch (MessageFormat.findKeyword(segments[3].toString(), modifierList)) {
                    case 0: {
                        newFormat = NumberFormat.getInstance(this.locale);
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        newFormat = NumberFormat.getCurrencyInstance(this.locale);
                        break block5;
                    }
                    case 3: 
                    case 4: {
                        newFormat = NumberFormat.getPercentInstance(this.locale);
                        break block5;
                    }
                    case 5: 
                    case 6: {
                        newFormat = this.getIntegerFormat(this.locale);
                        break block5;
                    }
                }
                newFormat = NumberFormat.getInstance(this.locale);
                try {
                    ((DecimalFormat)newFormat).applyPattern(segments[3].toString());
                    break;
                }
                catch (Exception e3) {
                    this.maxOffset = oldMaxOffset;
                    throw new IllegalArgumentException("Pattern incorrect or locale does not support formats, error at ");
                }
            }
            case 3: 
            case 4: {
                switch (MessageFormat.findKeyword(segments[3].toString(), dateModifierList)) {
                    case 0: {
                        newFormat = DateFormat.getDateInstance(2, this.locale);
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        newFormat = DateFormat.getDateInstance(3, this.locale);
                        break block5;
                    }
                    case 3: 
                    case 4: {
                        newFormat = DateFormat.getDateInstance(2, this.locale);
                        break block5;
                    }
                    case 5: 
                    case 6: {
                        newFormat = DateFormat.getDateInstance(1, this.locale);
                        break block5;
                    }
                    case 7: 
                    case 8: {
                        newFormat = DateFormat.getDateInstance(0, this.locale);
                        break block5;
                    }
                }
                newFormat = DateFormat.getDateInstance(2, this.locale);
                try {
                    ((SimpleDateFormat)newFormat).applyPattern(segments[3].toString());
                    break;
                }
                catch (Exception e4) {
                    this.maxOffset = oldMaxOffset;
                    throw new IllegalArgumentException("Pattern incorrect or locale does not support formats, error at ");
                }
            }
            case 5: 
            case 6: {
                switch (MessageFormat.findKeyword(segments[3].toString(), dateModifierList)) {
                    case 0: {
                        newFormat = DateFormat.getTimeInstance(2, this.locale);
                        break block5;
                    }
                    case 1: 
                    case 2: {
                        newFormat = DateFormat.getTimeInstance(3, this.locale);
                        break block5;
                    }
                    case 3: 
                    case 4: {
                        newFormat = DateFormat.getTimeInstance(2, this.locale);
                        break block5;
                    }
                    case 5: 
                    case 6: {
                        newFormat = DateFormat.getTimeInstance(1, this.locale);
                        break block5;
                    }
                    case 7: 
                    case 8: {
                        newFormat = DateFormat.getTimeInstance(0, this.locale);
                        break block5;
                    }
                }
                newFormat = DateFormat.getTimeInstance(2, this.locale);
                try {
                    ((SimpleDateFormat)newFormat).applyPattern(segments[3].toString());
                    break;
                }
                catch (Exception e5) {
                    this.maxOffset = oldMaxOffset;
                    throw new IllegalArgumentException("Pattern incorrect or locale does not support formats, error at ");
                }
            }
            case 7: 
            case 8: {
                try {
                    newFormat = new ChoiceFormat(segments[3].toString());
                    break;
                }
                catch (Exception e6) {
                    this.maxOffset = oldMaxOffset;
                    throw new IllegalArgumentException("Choice Pattern incorrect, error at ");
                }
            }
            default: {
                this.maxOffset = oldMaxOffset;
                throw new IllegalArgumentException("unknown format type at ");
            }
        }
        this.formats[offsetNumber] = newFormat;
        segments[1].setLength(0);
        segments[2].setLength(0);
        segments[3].setLength(0);
    }

    private static final int findKeyword(String s2, String[] list) {
        s2 = s2.trim().toLowerCase();
        for (int i2 = 0; i2 < list.length; ++i2) {
            if (!s2.equals(list[i2])) continue;
            return i2;
        }
        return -1;
    }

    NumberFormat getIntegerFormat(Locale locale) {
        NumberFormat temp = NumberFormat.getInstance(locale);
        if (temp instanceof DecimalFormat) {
            DecimalFormat temp2 = (DecimalFormat)temp;
            temp2.setMaximumFractionDigits(0);
            temp2.setDecimalSeparatorAlwaysShown(false);
            temp2.setParseIntegerOnly(true);
        }
        return temp;
    }

    private static final void copyAndFixQuotes(String source, int start, int end, StringBuffer target) {
        for (int i2 = start; i2 < end; ++i2) {
            char ch = source.charAt(i2);
            if (ch == '{') {
                target.append("'{'");
                continue;
            }
            if (ch == '}') {
                target.append("'}'");
                continue;
            }
            if (ch == '\'') {
                target.append("''");
                continue;
            }
            target.append(ch);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean isValid;
        in.defaultReadObject();
        boolean bl = isValid = this.maxOffset >= -1;
        if (isValid) {
            int lastOffset = this.pattern.length() + 1;
            for (int i2 = this.maxOffset; i2 >= 0; --i2) {
                if (this.offsets[i2] < 0 || this.offsets[i2] > lastOffset) {
                    isValid = false;
                    break;
                }
                lastOffset = this.offsets[i2];
            }
        }
        if (!isValid) {
            throw new InvalidObjectException("Could not reconstruct MessageFormat from corrupt stream.");
        }
    }
}

