/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.util;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.util.Assertion;
import java.util.ArrayList;
import java.util.List;

public final class SingletonTimingLogger {
    private static final String INDENT = "  ";
    private static final int TIME_SIZE = 10;
    private static final String TIMER_PREFIX = "com.metamatrix.";
    private static final String TIMER_HTML_PROPERTY = "timerHtml";
    private static final boolean TIMER_HTML;
    private static final String TIMER_FLOOR_PROPERTY = "timerFloor";
    private static final double TIMER_FLOOR;
    private static final String METHOD_TAG = "<method time=\"\" name=\"\">";
    private static final int METHOD_TIME_INDEX = 14;
    private static final int METHOD_NAME_INDEX = 22;
    private static final String METHOD_END_TAG = "</method>";
    private static final String CONSTRUCTOR_TAG = "<constructor time=\"\" name=\"\">";
    private static final int CONSTRUCTOR_TIME_INDEX = 19;
    private static final int CONSTRUCTOR_NAME_INDEX = 27;
    private static final String CONSTRUCTOR_END_TAG = "</constructor>";
    private static final String CONSTRUCTOR_CONTEXT = "aspect_ConstructorTiming";
    private TimerEntry currentEntry;
    private static SingletonTimingLogger instance;

    private SingletonTimingLogger() {
    }

    public static SingletonTimingLogger getInstance() {
        if (instance == null) {
            instance = new SingletonTimingLogger();
        }
        return instance;
    }

    private String getLogMsg(TimerEntry theEntry) {
        StringBuffer result = new StringBuffer();
        if ((double)theEntry.getTotalTime() >= TIMER_FLOOR) {
            result = new StringBuffer(TIMER_HTML ? theEntry.getStartHtml() : theEntry.getStartMsg());
            if (!theEntry.nestedEntries.isEmpty()) {
                int size = theEntry.nestedEntries.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    TimerEntry kid = (TimerEntry)theEntry.nestedEntries.get(i2);
                    result.append(this.getLogMsg(kid));
                }
            }
            result.append(TIMER_HTML ? theEntry.getStopHtml() : theEntry.getStopMsg());
        }
        return result.toString();
    }

    private void print(TimerEntry theEntry) {
        if ((double)theEntry.getTotalTime() >= TIMER_FLOOR) {
            CorePlugin.Util.print("", this.getLogMsg(theEntry));
        }
        theEntry = null;
    }

    public void start(String theContext, String theTimerId) {
        TimerEntry entry = new TimerEntry(this.currentEntry, theContext, theTimerId, System.currentTimeMillis());
        if (entry.parent == null) {
            entry.indent = "";
        } else {
            this.currentEntry.nestedEntries.add(entry);
            entry.indent = this.currentEntry.indent + INDENT;
        }
        this.currentEntry = entry;
    }

    public void stop(String theContext, String theTimerId) {
        if (this.currentEntry.id.equals(theTimerId) && this.currentEntry.context.equals(theContext)) {
            this.currentEntry.stopTime = System.currentTimeMillis();
            if (this.currentEntry.parent == null) {
                this.print(this.currentEntry);
                this.currentEntry = null;
            } else {
                this.currentEntry = this.currentEntry.parent;
            }
        } else {
            Assertion.failed("Current entry ID <" + this.currentEntry.id + "> and entry being stopped <" + theTimerId + "> are not the same.");
        }
    }

    static {
        String prop = System.getProperty(TIMER_FLOOR_PROPERTY);
        double value = -1.0;
        if (prop == null) {
            value = 0.0;
        } else {
            try {
                double temp = Double.parseDouble(prop);
                value = temp < 0.0 ? 0.0 : temp;
            }
            catch (NumberFormatException theException) {
                value = 0.0;
            }
        }
        TIMER_FLOOR = value;
        TIMER_HTML = System.getProperty(TIMER_HTML_PROPERTY) != null;
    }

    private class TimerEntry {
        TimerEntry parent;
        String context;
        long startTime = -1L;
        long stopTime = -1L;
        String id;
        List nestedEntries;
        String indent = "";
        boolean isMethod = true;

        public TimerEntry(TimerEntry theParent, String theContext, String theId, long theStartTime) {
            this.parent = theParent;
            this.context = theContext;
            this.id = theId;
            this.startTime = theStartTime;
            this.nestedEntries = new ArrayList();
            if (this.context.equals(SingletonTimingLogger.CONSTRUCTOR_CONTEXT)) {
                this.isMethod = false;
            }
        }

        private String format(String theTimerId) {
            String result = null;
            int index = theTimerId.indexOf(SingletonTimingLogger.TIMER_PREFIX);
            if (index == -1) {
                result = theTimerId;
            } else {
                StringBuffer temp = new StringBuffer(theTimerId);
                temp.replace(index, index + SingletonTimingLogger.TIMER_PREFIX.length(), "");
                result = temp.toString();
            }
            return result;
        }

        private String getNormalizedTimeText(String theText) {
            StringBuffer result = new StringBuffer(theText);
            while (result.length() < 10) {
                result.insert(0, ' ');
            }
            result.insert(0, "| ");
            result.append(" |");
            return result.toString();
        }

        public String getStartHtml() {
            StringBuffer html = null;
            int timeIndex = -1;
            int nameIndex = -1;
            if (this.isMethod) {
                html = new StringBuffer(SingletonTimingLogger.METHOD_TAG);
                timeIndex = 14;
                nameIndex = 22;
            } else {
                html = new StringBuffer(SingletonTimingLogger.CONSTRUCTOR_TAG);
                timeIndex = 19;
                nameIndex = 27;
            }
            html.insert(nameIndex, this.id);
            html.insert(timeIndex, this.getTotalTime());
            return html.toString();
        }

        public String getStartMsg() {
            String prefix = this.parent == null ? "" : "+ ";
            return prefix + this.context + this.getNormalizedTimeText("") + this.indent + this.format(this.id) + '\n';
        }

        public String getStopHtml() {
            return this.isMethod ? SingletonTimingLogger.METHOD_END_TAG : SingletonTimingLogger.CONSTRUCTOR_END_TAG;
        }

        public String getStopMsg() {
            String prefix = this.parent == null ? "- " : "+ ";
            StringBuffer result = new StringBuffer().append(prefix).append(this.context).append(this.getNormalizedTimeText(Long.toString(this.getTotalTime()))).append(this.indent).append(this.format(this.id));
            if (this.parent != null) {
                result.append('\n');
            }
            return result.toString();
        }

        public long getTotalTime() {
            return this.stopTime - this.startTime;
        }

        public String paramString() {
            String temp = this.parent == null ? "null" : this.parent.id;
            return "parent=" + temp + '\n' + "id=" + this.id + '\n' + "context=" + this.context + '\n' + "start=" + this.startTime + '\n' + "stop=" + this.stopTime + '\n' + "indent length=" + this.indent.length() + '\n' + "children count=" + this.nestedEntries.size() + "\n\n";
        }

        public String toString() {
            return this.paramString();
        }
    }
}

