/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml.vdb;

import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.internal.core.xml.vdb.VdbModelInfo;
import com.metamatrix.internal.core.xml.vdb.VdbNonModelInfo;
import java.util.HashMap;
import java.util.Map;

public final class VdbHeader {
    public static final String SEVERITY_OK = "OK";
    public static final String SEVERITY_INFO = "INFO";
    public static final String SEVERITY_WARNING = "WARNING";
    public static final String SEVERITY_ERROR = "ERROR";
    public static final Map severityNameToValueMap = new HashMap();
    private static final String DEFAULT_SEVERITY = "OK";
    private String name;
    private String uuid;
    private String description;
    private String severity = "OK";
    private String timeLastChanged;
    private String timeLastProduced;
    private String producerName;
    private String producerVersion;
    private ObjectVector modelInfos = new ObjectVector();
    private ObjectVector nonModelInfos = new ObjectVector();
    private String xmiVersion;

    public VdbModelInfo[] getModelInfos() {
        Object[] result = new VdbModelInfo[this.modelInfos.size];
        this.modelInfos.copyInto(result);
        return result;
    }

    public VdbNonModelInfo[] getNonModelInfos() {
        Object[] result = new VdbNonModelInfo[this.nonModelInfos.size];
        this.nonModelInfos.copyInto(result);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSeverity() {
        return this.severity;
    }

    public int getSeverityCode() {
        return this.getSeverityValue();
    }

    public String getXmiVersion() {
        return this.xmiVersion;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public String getProducerVersion() {
        return this.producerVersion;
    }

    public String getTimeLastChanged() {
        return this.timeLastChanged;
    }

    public String getTimeLastProduced() {
        return this.timeLastProduced;
    }

    public void addModelInfo(VdbModelInfo modelInfo) {
        if (modelInfo != null && !this.modelInfos.contains(modelInfo)) {
            this.modelInfos.add(modelInfo);
        }
    }

    public void addNonModelInfo(VdbNonModelInfo nonModelInfo) {
        if (nonModelInfo != null && !this.nonModelInfos.contains(nonModelInfo)) {
            this.nonModelInfos.add(nonModelInfo);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public void setXmiVersion(String xmiVersion) {
        this.xmiVersion = xmiVersion;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public void setProducerVersion(String producerVersion) {
        this.producerVersion = producerVersion;
    }

    public void setTimeLastChanged(String timeLastChanged) {
        this.timeLastChanged = timeLastChanged;
    }

    public void setTimeLastProduced(String timeLastProduced) {
        this.timeLastProduced = timeLastProduced;
    }

    protected Integer getSeverityValue() {
        Integer value = (Integer)severityNameToValueMap.get(this.getSeverity());
        return value != null ? value : (Integer)severityNameToValueMap.get("OK");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("MetaMatrix-VdbManifestModel Header:");
        sb.append("\n  XMI version: ");
        sb.append(this.getXmiVersion());
        sb.append("\n  Name:        ");
        sb.append(this.getName());
        sb.append("\n  UUID:        ");
        sb.append(this.getUUID());
        sb.append("\n  Description: ");
        sb.append(this.getDescription());
        sb.append("\n  Severity: ");
        sb.append(this.getSeverity());
        sb.append("\n  Producer Name: ");
        sb.append(this.getProducerName());
        sb.append("\n  Producer Version: ");
        sb.append(this.getProducerVersion());
        sb.append("\n  Time last changed: ");
        sb.append(this.getTimeLastChanged());
        sb.append("\n  Time last produced: ");
        sb.append(this.getTimeLastProduced());
        sb.append("\n  VdbModelInfos:");
        VdbModelInfo[] mdlInfos = this.getModelInfos();
        for (int i2 = 0; i2 < mdlInfos.length; ++i2) {
            sb.append("\n    ");
            sb.append(mdlInfos[i2]);
        }
        sb.append("\n  VdbNonModelInfos:");
        VdbNonModelInfo[] nonMdlInfos = this.getNonModelInfos();
        for (int i3 = 0; i3 < nonMdlInfos.length; ++i3) {
            sb.append("\n    ");
            sb.append(nonMdlInfos[i3]);
        }
        return sb.toString();
    }

    static {
        severityNameToValueMap.put("OK", new Integer(0));
        severityNameToValueMap.put(SEVERITY_INFO, new Integer(1));
        severityNameToValueMap.put(SEVERITY_WARNING, new Integer(2));
        severityNameToValueMap.put(SEVERITY_ERROR, new Integer(3));
    }
}

