/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.admin.api.core.Admin;
import com.metamatrix.admin.api.embedded.EmbeddedAdmin;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.util.AdminExceptionConverter;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.dqp.embedded.DQPEmbeddedManager;
import com.metamatrix.dqp.embedded.admin.DQPConfigAdminImpl;
import com.metamatrix.dqp.embedded.admin.DQPMonitoringAdminImpl;
import com.metamatrix.dqp.embedded.admin.DQPRuntimeStateAdminImpl;
import com.metamatrix.dqp.embedded.admin.DQPSecurityAdminImpl;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.ConnectionListener;
import com.metamatrix.jdbc.EmbeddedDriver;
import com.metamatrix.jdbc.EmbeddedSQLException;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;

public class EmbeddedConnection
extends MMConnection {
    private static final String SERVER_NAME = "MetaMatrix Query";
    DQPEmbeddedManager manager = null;
    ConnectionListener listener = null;
    Properties properties = null;
    static /* synthetic */ Class class$com$metamatrix$jdbc$EmbeddedConnection;
    static /* synthetic */ Class class$com$metamatrix$dqp$embedded$DQPEmbeddedManager;
    static /* synthetic */ Class class$com$metamatrix$common$comm$api$ServerConnection;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$com$metamatrix$jdbc$ConnectionListener;
    static /* synthetic */ Class class$com$metamatrix$admin$api$embedded$EmbeddedAdmin;

    public static EmbeddedConnection newInstance(DQPEmbeddedManager manager, ServerConnection serverConn, Properties info, ConnectionListener listner) {
        if (AOP.useproxy()) {
            return (EmbeddedConnection)ProxyFactory.extend((Class)(class$com$metamatrix$jdbc$EmbeddedConnection == null ? (class$com$metamatrix$jdbc$EmbeddedConnection = EmbeddedConnection.class$("com.metamatrix.jdbc.EmbeddedConnection")) : class$com$metamatrix$jdbc$EmbeddedConnection), (Class[])new Class[]{class$com$metamatrix$dqp$embedded$DQPEmbeddedManager == null ? (class$com$metamatrix$dqp$embedded$DQPEmbeddedManager = EmbeddedConnection.class$("com.metamatrix.dqp.embedded.DQPEmbeddedManager")) : class$com$metamatrix$dqp$embedded$DQPEmbeddedManager, class$com$metamatrix$common$comm$api$ServerConnection == null ? (class$com$metamatrix$common$comm$api$ServerConnection = EmbeddedConnection.class$("com.metamatrix.common.comm.api.ServerConnection")) : class$com$metamatrix$common$comm$api$ServerConnection, class$java$util$Properties == null ? (class$java$util$Properties = EmbeddedConnection.class$("java.util.Properties")) : class$java$util$Properties, class$com$metamatrix$jdbc$ConnectionListener == null ? (class$com$metamatrix$jdbc$ConnectionListener = EmbeddedConnection.class$("com.metamatrix.jdbc.ConnectionListener")) : class$com$metamatrix$jdbc$ConnectionListener}, (Object[])new Object[]{manager, serverConn, info, listner});
        }
        return new EmbeddedConnection(manager, serverConn, info, listner);
    }

    public EmbeddedConnection(DQPEmbeddedManager manager, ServerConnection serverConn, Properties info, ConnectionListener listner) {
        super(serverConn, info, null);
        this.manager = manager;
        this.listener = listner;
        this.properties = info;
        this.listener.connectionAdded(this.getConectionID(), (Connection)((Object)this));
    }

    public Admin getAdminAPI() throws SQLException {
        InvocationHandler handler = new InvocationHandler(){
            Object[] implementors;
            {
                this.implementors = new Object[]{new DQPConfigAdminImpl(EmbeddedConnection.this.manager), new DQPMonitoringAdminImpl(EmbeddedConnection.this.manager), new DQPRuntimeStateAdminImpl(EmbeddedConnection.this.manager), new DQPSecurityAdminImpl(EmbeddedConnection.this.manager)};
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ClassLoader callingClassLoader;
                block11: {
                    IllegalArgumentException ex = null;
                    if (!EmbeddedConnection.this.manager.isDQPAlive()) {
                        throw new AdminProcessingException(JDBCPlugin.Util.getString("EmbeddedConnection.DQP_shutDown"));
                    }
                    callingClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    for (int i2 = 0; i2 < this.implementors.length; ++i2) {
                        try {
                            Object object = method.invoke(this.implementors[i2], args);
                            return object;
                        }
                        catch (IllegalArgumentException e2) {
                        }
                        catch (IllegalAccessException e3) {
                            throw e3;
                        }
                        catch (InvocationTargetException e4) {
                            Throwable target = e4.getTargetException();
                            if (target instanceof AdminException) {
                                throw target;
                            }
                            throw AdminExceptionConverter.convertToComponentException(e4, e4.getMessage());
                        }
                        {
                            ex = e2;
                            continue;
                        }
                    }
                    if (ex == null) break block11;
                    throw ex;
                }
                Object var6_7 = null;
                return var6_7;
                finally {
                    Thread.currentThread().setContextClassLoader(callingClassLoader);
                }
            }
        };
        return (EmbeddedAdmin)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$com$metamatrix$admin$api$embedded$EmbeddedAdmin == null ? (class$com$metamatrix$admin$api$embedded$EmbeddedAdmin = EmbeddedConnection.class$("com.metamatrix.admin.api.embedded.EmbeddedAdmin")) : class$com$metamatrix$admin$api$embedded$EmbeddedAdmin}, handler);
    }

    public synchronized void close() throws SQLException {
        super.close();
        this.listener.connectionRemoved(this.getConectionID(), (Connection)((Object)this));
    }

    String getConectionID() {
        return (String)this.properties.get("connectionID");
    }

    public void commit() throws SQLException {
        this.checkTransactionsAllowed();
    }

    public void rollback() throws SQLException {
        this.checkTransactionsAllowed();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkTransactionsAllowed();
        super.setAutoCommit(autoCommit);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.checkTransactionsAllowed();
        super.setTransactionIsolation(level);
    }

    private void checkTransactionsAllowed() throws SQLException {
        if (this.allowExplicitTransactions()) {
            throw new EmbeddedSQLException(JDBCPlugin.Util.getString("EmbeddedConnection.txn_notsupported"));
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return super.getMetaData((BaseDriver)new EmbeddedDriver());
    }

    String getDatabaseName() {
        return SERVER_NAME;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

