/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.relational.aspects.validation.rules;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.relational.AccessPattern;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.ForeignKey;
import com.metamatrix.metamodels.relational.Index;
import com.metamatrix.metamodels.relational.LogicalRelationship;
import com.metamatrix.metamodels.relational.Procedure;
import com.metamatrix.metamodels.relational.ProcedureParameter;
import com.metamatrix.metamodels.relational.RelationalEntity;
import com.metamatrix.metamodels.relational.RelationalPlugin;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.relational.UniqueKey;
import com.metamatrix.metamodels.relational.util.RelationalUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;

public class SiblingNameInSourceRule
implements ObjectValidationRule {
    private static final String nameInSourceFeatureName = RelationalPlugin.Util.getString("_UI_RelationalEntity_nameInSource_feature");
    private static final String RULE_NAME = (class$com$metamatrix$metamodels$relational$aspects$validation$rules$SiblingNameInSourceRule == null ? (class$com$metamatrix$metamodels$relational$aspects$validation$rules$SiblingNameInSourceRule = SiblingNameInSourceRule.class$("com.metamatrix.metamodels.relational.aspects.validation.rules.SiblingNameInSourceRule")) : class$com$metamatrix$metamodels$relational$aspects$validation$rules$SiblingNameInSourceRule).getName();
    static /* synthetic */ Class class$com$metamatrix$metamodels$relational$aspects$validation$rules$SiblingNameInSourceRule;

    public void validate(EObject eObject, ValidationContext context) {
        if (!this.shouldRun(eObject, context)) {
            return;
        }
        List siblings = this.getSiblingsForUniquenessCheck(eObject);
        if (siblings.isEmpty()) {
            return;
        }
        int statusForCaseSensitive = this.getPreferenceStatus(context);
        int statusForCaseInsensitive = statusForCaseSensitive == 4 ? 2 : statusForCaseSensitive;
        ValidationResults validationResults = new ValidationResults(siblings.size());
        for (int i2 = 0; i2 < siblings.size(); ++i2) {
            EObject siblingI = (EObject)siblings.get(i2);
            String nameInSourceA = this.getNameInSource(siblingI);
            ValidationResult result = validationResults.get(i2, siblingI);
            if (!StringUtil.isEmpty(nameInSourceA)) {
                for (int j2 = i2 + 1; j2 < siblings.size(); ++j2) {
                    ValidationProblemImpl problemJ;
                    ValidationResult resultJ;
                    ValidationProblemImpl problem;
                    String msg;
                    Object[] params;
                    EObject siblingJ = (EObject)siblings.get(j2);
                    String nameInSourceB = this.getNameInSource(siblings.get(j2));
                    if (StringUtil.isEmpty(nameInSourceB)) continue;
                    if (nameInSourceA.equals(nameInSourceB)) {
                        params = new Object[]{this.getName(siblingI), this.getName(siblingJ), nameInSourceFeatureName};
                        msg = RelationalPlugin.Util.getString("SiblingNameInSourceRule.failure_message_case_sensitive", params);
                        problem = new ValidationProblemImpl(0, statusForCaseSensitive, msg);
                        problem.setHasPreference(context.hasPreferences());
                        result.addProblem(problem);
                        resultJ = validationResults.get(j2, siblingJ);
                        problemJ = new ValidationProblemImpl(0, statusForCaseSensitive, msg);
                        problemJ.setHasPreference(context.hasPreferences());
                        resultJ.addProblem(problemJ);
                        continue;
                    }
                    if (!nameInSourceA.equalsIgnoreCase(nameInSourceB)) continue;
                    params = new Object[]{this.getName(siblingI), this.getName(siblingJ), nameInSourceFeatureName};
                    msg = RelationalPlugin.Util.getString("SiblingNameInSourceRule.failure_message_case_insensitive", params);
                    problem = new ValidationProblemImpl(0, statusForCaseInsensitive, msg);
                    problem.setHasPreference(context.hasPreferences());
                    result.addProblem(problem);
                    resultJ = validationResults.get(j2, siblingJ);
                    problemJ = new ValidationProblemImpl(0, statusForCaseInsensitive, msg);
                    problemJ.setHasPreference(context.hasPreferences());
                    resultJ.addProblem(problemJ);
                }
            }
            context.addResult(result);
        }
    }

    protected int getPreferenceStatus(ValidationContext context) {
        return context.getPreferenceStatus("relationalPreferences.siblingNameInSource", 0);
    }

    protected List getSiblingsForUniquenessCheck(EObject eObject) {
        Notifier parent = eObject.eContainer();
        if (parent == null) {
            parent = eObject.eResource();
        }
        if (eObject instanceof Table) {
            return RelationalUtil.findTables(parent, 1);
        }
        if (eObject instanceof Procedure) {
            return RelationalUtil.findProcedures(parent, 1);
        }
        if (eObject instanceof ProcedureParameter) {
            return RelationalUtil.findProcedureParameters(parent, 1);
        }
        if (eObject instanceof Column) {
            return RelationalUtil.findColumns(parent, 1);
        }
        if (eObject instanceof Index) {
            return RelationalUtil.findIndexes(parent, 1);
        }
        if (eObject instanceof ForeignKey || eObject instanceof UniqueKey) {
            return RelationalUtil.findKeys(parent, 1);
        }
        if (eObject instanceof AccessPattern) {
            if (parent instanceof Table) {
                return ((Table)parent).getAccessPatterns();
            }
        } else if (eObject instanceof LogicalRelationship) {
            return RelationalUtil.findLogicalRelationships(parent, 1);
        }
        return Collections.EMPTY_LIST;
    }

    private String getNameInSource(Object sibling) {
        if (sibling instanceof RelationalEntity) {
            RelationalEntity entity = (RelationalEntity)sibling;
            return entity.getNameInSource();
        }
        return null;
    }

    private String getName(Object sibling) {
        if (sibling instanceof RelationalEntity) {
            RelationalEntity entity = (RelationalEntity)sibling;
            return entity.getName();
        }
        return ((Object)ModelerCore.getModelEditor().getModelRelativePathIncludingModel((EObject)sibling)).toString();
    }

    private boolean shouldRun(EObject eObject, ValidationContext context) {
        if (this.getPreferenceStatus(context) == 0) {
            return false;
        }
        try {
            ModelAnnotation modelAnnotation = ModelerCore.getModelEditor().getModelAnnotation(eObject);
            int modelType = modelAnnotation.getModelType().getValue();
            if (modelType != 0) {
                return false;
            }
        }
        catch (Exception e2) {
            RelationalPlugin.Util.log(4, e2, e2.getMessage());
        }
        String objType = eObject.eClass().getName();
        if (context.hasRunRule(eObject, RULE_NAME + objType)) {
            return false;
        }
        context.recordRuleRun(eObject, RULE_NAME + objType);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ValidationResults {
        private final ValidationResult[] results;

        public ValidationResults(int size) {
            this.results = new ValidationResult[size];
        }

        public ValidationResult get(int index, EObject object) {
            ValidationResult result = this.results[index];
            if (result == null) {
                this.results[index] = result = new ValidationResultImpl(object);
            }
            return result;
        }
    }
}

