/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.relational.aspects.validation.rules;

import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.RelationalPlugin;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.validation.StructuralFeatureValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class TableMaterializedRule
implements StructuralFeatureValidationRule {
    private final int featureID;
    private static Collection COLUMN_TYPES_THAT_CANNOT_BE_MATERIALIZED;

    public TableMaterializedRule(int featureID) {
        this.featureID = featureID;
    }

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        boolean materialized;
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (eObject == null || !(eObject instanceof Table)) {
            return;
        }
        ValidationResultImpl result = null;
        if (value instanceof Boolean && (materialized = ((Boolean)value).booleanValue())) {
            EmfResource emfResource;
            ModelAnnotation modelAnn;
            boolean virtual = false;
            Resource resource = eObject.eResource();
            if (resource instanceof EmfResource && (modelAnn = (emfResource = (EmfResource)resource).getModelAnnotation()) != null && ModelType.VIRTUAL_LITERAL.equals(modelAnn.getModelType())) {
                virtual = true;
            }
            if (virtual) {
                Table table = (Table)eObject;
                Collection invalidTypes = this.getColumnTypesThatCannotBeMaterialized(context);
                EList columns = table.getColumns();
                Iterator iter = columns.iterator();
                while (iter.hasNext()) {
                    boolean invalid;
                    Column column = (Column)iter.next();
                    EObject datatype = column.getType();
                    if (datatype == null || !(invalid = invalidTypes.contains(datatype))) continue;
                    if (result == null) {
                        result = new ValidationResultImpl(eObject);
                    }
                    String msg = RelationalPlugin.Util.getString("TableMaterializedRule.MaterializedTableFromInvalidColumnTypes");
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                    result.addProblem(problem);
                    context.addResult(result);
                    return;
                }
            }
        }
        if (value == null) {
            return;
        }
    }

    protected Collection getColumnTypesThatCannotBeMaterialized(ValidationContext context) {
        if (COLUMN_TYPES_THAT_CANNOT_BE_MATERIALIZED == null) {
            HashSet<EObject> types = new HashSet<EObject>();
            DatatypeManager dtMgr = context.getDatatypeManager();
            if (dtMgr != null) {
                try {
                    EObject datatype = null;
                    datatype = dtMgr.findDatatype("clob");
                    if (datatype != null) {
                        types.add(datatype);
                    }
                    if ((datatype = dtMgr.findDatatype("blob")) != null) {
                        types.add(datatype);
                    }
                    if ((datatype = dtMgr.findDatatype("object")) != null) {
                        types.add(datatype);
                    }
                }
                catch (ModelerCoreException err) {
                    RelationalPlugin.Util.log(err);
                }
            }
            COLUMN_TYPES_THAT_CANNOT_BE_MATERIALIZED = types;
        }
        return COLUMN_TYPES_THAT_CANNOT_BE_MATERIALIZED;
    }
}

