/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.relational.aspects.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.metamodels.relational.BaseTable;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.NullableType;
import com.metamatrix.metamodels.relational.PrimaryKey;
import com.metamatrix.metamodels.relational.RelationalPlugin;
import com.metamatrix.metamodels.relational.UniqueKey;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class UniqueKeyColumnsRule
implements ObjectValidationRule {
    static /* synthetic */ Class class$com$metamatrix$metamodels$relational$UniqueKey;

    public void validate(EObject eObject, ValidationContext context) {
        ArgCheck.isInstanceOf(class$com$metamatrix$metamodels$relational$UniqueKey == null ? (class$com$metamatrix$metamodels$relational$UniqueKey = UniqueKeyColumnsRule.class$("com.metamatrix.metamodels.relational.UniqueKey")) : class$com$metamatrix$metamodels$relational$UniqueKey, eObject);
        UniqueKey uniqueKey = (UniqueKey)eObject;
        EList ukColumns = uniqueKey.getColumns();
        BaseTable ukTable = uniqueKey.getTable();
        Assertion.isNotNull(ukTable);
        ValidationResultImpl result = new ValidationResultImpl(eObject);
        Iterator colIter = ukColumns.iterator();
        while (colIter.hasNext()) {
            NullableType nullableType;
            Column column = (Column)colIter.next();
            if (uniqueKey instanceof PrimaryKey && (nullableType = column.getNullable()).getValue() == 1) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, RelationalPlugin.Util.getString("UniqueKeyColumnsRule.Primary_key__1") + uniqueKey.getName() + RelationalPlugin.Util.getString("UniqueKeyColumnsRule._references_a_nullable_column._2"));
                result.addProblem(problem);
                break;
            }
            BaseTable colTable = (BaseTable)column.eContainer();
            Assertion.isNotNull(colTable);
            if (ukTable.equals(colTable)) continue;
            String msg = RelationalPlugin.Util.getString("UniqueKeyColumnsRule.Unique_key_{0}_may_not_reference_column_{1}_from_a_different_table_1", uniqueKey.getName(), column.getName());
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem(problem);
            break;
        }
        context.addResult(result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

