/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.container;

import com.metamatrix.core.id.ObjectID;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.resource.EmfResourceSet;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class CrossContainerFinder {
    private final Container sourceContainer;
    private final Container targetContainer;

    public CrossContainerFinder(Container container1, Container container2) {
        this.sourceContainer = container1;
        this.targetContainer = container2;
    }

    public EObject find(EObject object) {
        Resource sourceRes;
        Resource targetRes;
        if (object != null && (targetRes = this.find(sourceRes = object.eResource())) != null) {
            if (!targetRes.isLoaded()) {
                try {
                    targetRes.load(targetRes.getResourceSet().getLoadOptions());
                }
                catch (IOException e2) {
                    ModelerCore.Util.log(e2);
                }
            }
            return targetRes.getEObject(sourceRes.getURIFragment(object));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Resource find(Resource resource) {
        Resource rv;
        void var3_3;
        Container srcCont;
        ResourceSet sourceResourceSet = resource.getResourceSet();
        if (sourceResourceSet instanceof Container) {
            srcCont = (Container)sourceResourceSet;
        } else if (sourceResourceSet instanceof EmfResourceSet) {
            srcCont = ((EmfResourceSet)((Object)sourceResourceSet)).getContainer();
        } else {
            return null;
        }
        Container tgtCont = var3_3 == this.sourceContainer ? this.targetContainer : this.sourceContainer;
        if (resource instanceof EmfResource) {
            EmfResource eRes = (EmfResource)resource;
            ObjectID uuid = eRes.getUuid();
            rv = tgtCont.getResourceFinder().findByUUID(uuid, false);
        } else {
            String xsdName = resource.getURI().lastSegment();
            Resource[] wsRes = tgtCont.getResourceFinder().findByName(xsdName, true, false);
            rv = wsRes[0];
        }
        return rv;
    }

    public static CrossContainerFinder createWorkspaceFinder(Container source) {
        try {
            return new CrossContainerFinder(source, ModelerCore.getModelContainer());
        }
        catch (CoreException e2) {
            ModelerCore.Util.log(e2);
            return null;
        }
    }
}

