/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelVisitor;
import com.metamatrix.modeler.core.util.ModelVisitorProcessor;
import com.metamatrix.modeler.core.util.ModelVisitorWithFinish;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ConcurrentModelVisitorProcessor
extends ModelVisitorProcessor {
    public ConcurrentModelVisitorProcessor(ModelVisitor visitor) {
        this(visitor, 0);
    }

    public ConcurrentModelVisitorProcessor(ModelVisitor visitor, int mode) {
        super(visitor, mode);
    }

    public void walk(Resource startingResource, int depth) throws ModelerCoreException {
        ArgCheck.isNotNull(startingResource);
        this.assertValidDepth(depth);
        if (!this.getModelVisitor().visit(startingResource) || depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        Object[] children = startingResource.getContents().toArray();
        for (int i2 = 0; i2 != children.length; ++i2) {
            Object obj = children[i2];
            if (!(obj instanceof EObject)) continue;
            this.walk((EObject)obj, nextDepth);
        }
    }

    public void walk(EObject startingObject, int depth) throws ModelerCoreException {
        ArgCheck.isNotNull(startingObject);
        this.assertValidDepth(depth);
        if (!this.visitor.visit(startingObject) || depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        Object children = this.navigator.getChildren(startingObject);
        if (children instanceof List) {
            Object[] tmp = ((List)children).toArray();
            for (int i2 = 0; i2 != tmp.length; ++i2) {
                Object obj = tmp[i2];
                if (!(obj instanceof EObject)) continue;
                this.walk((EObject)obj, nextDepth);
            }
        } else if (children instanceof EObject) {
            this.walk((EObject)children, nextDepth);
        }
        if (this.visitor instanceof ModelVisitorWithFinish) {
            ((ModelVisitorWithFinish)this.visitor).postVisit(startingObject);
        }
    }
}

