/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.ResourceValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelStatusImpl;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelFileExtensionRule
implements ResourceValidationRule {
    public void validate(Resource resource, ValidationContext context) {
        IStatus status;
        ArgCheck.isNotNull(resource);
        ArgCheck.isNotNull(context);
        URI uri = resource.getURI();
        if ((uri != null || uri.isFile()) && !(status = ModelFileExtensionRule.validate(uri.lastSegment())).isOK()) {
            ValidationResultImpl result = new ValidationResultImpl(resource);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, status.getMessage());
            result.addProblem(problem);
            context.addResult(result);
        }
    }

    public static IStatus validate(String fileNameWithExtension) {
        String expectedExtension;
        ArgCheck.isNotNull(fileNameWithExtension);
        ArgCheck.isNotZeroLength(fileNameWithExtension);
        String actualExtension = null;
        int beginIndex = fileNameWithExtension.lastIndexOf(46) + 1;
        if (beginIndex > 0 && beginIndex < fileNameWithExtension.length()) {
            actualExtension = fileNameWithExtension.substring(beginIndex);
        }
        if ((expectedExtension = ModelFileExtensionRule.getMatchingKnownExtension(actualExtension)) == null) {
            return ModelStatusImpl.VERIFIED_OK;
        }
        if (expectedExtension.equals(actualExtension)) {
            return ModelStatusImpl.VERIFIED_OK;
        }
        if (expectedExtension.equalsIgnoreCase(actualExtension)) {
            int endIndex = fileNameWithExtension.length() - actualExtension.length();
            String expectedFileName = fileNameWithExtension.substring(0, endIndex) + expectedExtension;
            Object[] params = new Object[]{fileNameWithExtension, expectedFileName};
            String msg = ModelerCore.Util.getString("ModelerCore.file_extension_not_correct_case_please_rename_file", params);
            return new Status(2, "com.metamatrix.modeler.core", -1, msg, null);
        }
        return ModelStatusImpl.VERIFIED_OK;
    }

    private static String getMatchingKnownExtension(String extension) {
        if ("xml".equalsIgnoreCase(extension)) {
            return "xml";
        }
        if ("xmi".equalsIgnoreCase(extension)) {
            return "xmi";
        }
        if ("xsd".equalsIgnoreCase(extension)) {
            return "xsd";
        }
        if ("vdb".equalsIgnoreCase(extension)) {
            return "vdb";
        }
        return null;
    }
}

