/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.internal.core.xml.xmi.XMIHeaderReader;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.core.Identifiable;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.core.custom.impl.XsdModelAnnotationImpl;
import com.metamatrix.metamodels.core.extension.ExtensionFactory;
import com.metamatrix.metamodels.core.extension.XClass;
import com.metamatrix.metamodels.core.extension.XPackage;
import com.metamatrix.metamodels.core.extension.impl.ExtensionFactoryImpl;
import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.modeler.core.ExtensionDescriptor;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import com.metamatrix.modeler.core.TransactionRunnable;
import com.metamatrix.modeler.core.association.AssociationProvider;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.EObjectFinder;
import com.metamatrix.modeler.core.container.ResourceFinder;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAnnotationAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlDatatypeAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlDatatypeCheckerAspect;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import com.metamatrix.modeler.core.types.EnterpriseDatatypeInfo;
import com.metamatrix.modeler.core.util.DisabledCommand;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelResourceContainerFactory;
import com.metamatrix.modeler.core.util.ModelVisitorProcessor;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.ClearReferencesUponDelete;
import com.metamatrix.modeler.internal.core.Configuration;
import com.metamatrix.modeler.internal.core.FindReferencesToDeletedObjects;
import com.metamatrix.modeler.internal.core.FindRelatedObjectsToBeCopied;
import com.metamatrix.modeler.internal.core.FindRelatedObjectsToDeleted;
import com.metamatrix.modeler.internal.core.ObjectExtension;
import com.metamatrix.modeler.internal.core.SafeRemoveCompoundCommand;
import com.metamatrix.modeler.internal.core.XsdConcreteComponentAddCommand;
import com.metamatrix.modeler.internal.core.XsdObjectExtension;
import com.metamatrix.modeler.internal.core.association.AbstractAssociationDescriptor;
import com.metamatrix.modeler.internal.core.container.CloneCommand;
import com.metamatrix.modeler.internal.core.container.ContainerEditingDomain;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelResourceImpl;
import com.metamatrix.modeler.internal.core.metamodel.MetamodelRootClass;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.search.ModelWorkspaceSearch;
import com.metamatrix.modeler.internal.core.transaction.UnitOfWorkImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.CopyToClipboardCommand;
import org.eclipse.emf.edit.command.CreateCopyCommand;
import org.eclipse.emf.edit.command.CutToClipboardCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;

public class ModelEditorImpl
implements ModelEditor {
    private static final String NAME_FEATURE_NAME = "name";
    private static final String ESTRING_MAP_NAME = "EStringToStringMapEntry";
    protected static final String NEW = ModelerCore.Util.getString("ModelEditorImpl.New_1");
    private static ContainerImpl ctnr;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$RemoveCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$SetCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$CreateChildCommand;
    static /* synthetic */ Class class$org$eclipse$emf$edit$provider$IItemLabelProvider;
    static /* synthetic */ Class class$org$eclipse$emf$edit$command$CopyCommand;

    private static ContainerImpl getContainer() {
        if (ctnr != null) {
            return ctnr;
        }
        try {
            return (ContainerImpl)ModelerCore.getModelContainer();
        }
        catch (CoreException err) {
            ModelerCore.Util.log(4, err, err.getMessage());
            return null;
        }
    }

    public static void setContainer(ContainerImpl container) {
        ctnr = container;
    }

    public boolean isDatatypeFeature(EObject object, EStructuralFeature feature) {
        if (object == null || feature == null) {
            return false;
        }
        SqlAspect aspect = AspectManager.getSqlAspect(object);
        if (aspect instanceof SqlDatatypeCheckerAspect) {
            return ((SqlDatatypeCheckerAspect)((Object)aspect)).isDatatypeFeature(object, feature);
        }
        return false;
    }

    public Collection getTags(EObject obj) {
        try {
            Annotation annotation = this.getAnnotation(obj, false);
            if (annotation == null) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Object> tags = new ArrayList<Object>();
            Iterator refs = annotation.eClass().getEReferences().iterator();
            while (refs.hasNext()) {
                Object val;
                EReference ref = (EReference)refs.next();
                if (ref.getEType() == null || ref.getEType().getName() == null || !ref.getEType().getName().equals(ESTRING_MAP_NAME) || (val = annotation.eGet(ref)) == null) continue;
                tags.add(val);
            }
            return tags;
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(4, e2, e2.getMessage());
            return Collections.EMPTY_LIST;
        }
    }

    public boolean equals(EObject eObject1, EObject eObject2) {
        String msg;
        if (eObject1 == null || eObject2 == null) {
            return false;
        }
        if (eObject1 == eObject2) {
            return true;
        }
        EObject eObj1 = eObject1;
        EObject eObj2 = eObject2;
        boolean eObjIsProxy1 = eObj1.eIsProxy();
        boolean eObjIsProxy2 = eObj2.eIsProxy();
        if (eObjIsProxy1 && eObjIsProxy2) {
            URI eProxyUri1 = EcoreUtil.getURI(eObj1);
            URI eProxyUri2 = EcoreUtil.getURI(eObj2);
            return eProxyUri1.equals(eProxyUri2);
        }
        if (eObjIsProxy1) {
            try {
                eObj1 = EcoreUtil.resolve(eObj1, ModelEditorImpl.getContainer());
            }
            catch (Exception e2) {
                msg = ModelerCore.Util.getString("ModelEditorImpl.Error_getting_model_container._1");
                ModelerCore.Util.log(4, e2, msg);
            }
        }
        if (eObjIsProxy2) {
            try {
                eObj2 = EcoreUtil.resolve(eObj2, ModelEditorImpl.getContainer());
            }
            catch (Exception e3) {
                msg = ModelerCore.Util.getString("ModelEditorImpl.Error_getting_model_container._2");
                ModelerCore.Util.log(4, e3, msg);
            }
        }
        return eObj1.equals(eObj2);
    }

    public EObject createInitialModel(Resource resource, EClass eClass) throws ModelerCoreException {
        if (!ModelEditorImpl.isRootObject(eClass)) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ModelEditorImpl.{0}_is_not_a_valid_root_object_1", eClass.getName()));
        }
        EObject rootObject = this.create(eClass);
        if (rootObject != null) {
            resource.getContents().add(rootObject);
        }
        return rootObject;
    }

    public MetamodelDescriptor getMetamodelDescriptor(EObject object) {
        ArgCheck.isNotNull(object);
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        String uri = object.eClass().getEPackage().getNsURI();
        if (uri != null && cntr != null) {
            return cntr.getMetamodelRegistry().getMetamodelDescriptor(URI.createURI(uri));
        }
        if (uri != null && cntr == null) {
            try {
                return ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(URI.createURI(uri));
            }
            catch (ModelerCoreException e2) {
                ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ModelEditorImpl.Error_getting_metamodel_descriptor_for_URI_1", uri));
            }
        }
        return null;
    }

    public MetamodelDescriptor getPrimaryMetamodelDescriptor(ModelResource resource) throws ModelWorkspaceException {
        ArgCheck.isNotNull(resource);
        return resource.getPrimaryMetamodelDescriptor();
    }

    public MetamodelDescriptor getPrimaryMetamodelDescriptor(Resource resource) throws ModelWorkspaceException {
        EmfResource emfResource;
        String primaryMetamodelUri;
        ArgCheck.isNotNull(resource);
        if (resource instanceof EmfResource && (primaryMetamodelUri = ModelEditorImpl.getPrimaryMetamodelURI(emfResource = (EmfResource)resource)) != null && primaryMetamodelUri.length() != 0) {
            MetamodelDescriptor descriptor = ModelerCore.getMetamodels().getMetamodelDescriptor(primaryMetamodelUri);
            if (descriptor == null) {
                StringBuffer sb = new StringBuffer();
                Collection descriptors = ModelerCore.getMetamodels().getMetamodelDescriptors();
                Iterator iter = descriptors.iterator();
                while (iter.hasNext()) {
                    MetamodelDescriptor mmd = (MetamodelDescriptor)iter.next();
                    if (!mmd.isPrimaryMetamodel() || StringUtil.isEmpty(mmd.getURI())) continue;
                    sb.append(mmd.getURI());
                    sb.append(StringUtil.Constants.SPACE);
                }
                Object[] params = new Object[]{primaryMetamodelUri, sb.toString()};
                String msg = ModelerCore.Util.getString("ModelResourceImpl.no_metamodel_found_for_primary_metamodel_URI", params);
                ModelerCore.Util.log(4, msg);
            }
            return descriptor;
        }
        ModelResource modelResource = this.findModelResource(resource);
        return this.getPrimaryMetamodelDescriptor(modelResource);
    }

    public Collection getNewChildCommands(final EObject eObject) throws ModelerCoreException {
        final ContainerImpl container = ModelEditorImpl.getContainer();
        if (container != null) {
            TransactionRunnable runnable = new TransactionRunnable(){

                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    EditingDomain domain = container.getEditingDomain();
                    Collection result = domain.getNewChildDescriptors(eObject, null);
                    ModelEditorImpl.setDescriptorOwner(result, eObject);
                    result = ModelEditorImpl.this.createCommands(result, domain);
                    return result != null ? result : Collections.EMPTY_LIST;
                }
            };
            Object result = this.executeAsTransaction(runnable, container, "Getting Child Commands", false, false, eObject);
            return result instanceof Collection ? (Collection)result : Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean shouldBeDisabled(Object owner, CommandParameter commandParam) {
        if (owner instanceof EObject) {
            EObject parent = (EObject)owner;
            EStructuralFeature feature = commandParam.getEStructuralFeature();
            int maxMultiplicity = feature.getUpperBound();
            if (maxMultiplicity == -1) {
                return false;
            }
            if (maxMultiplicity > 1) {
                Object currentValue = parent.eGet(feature);
                int currentSize = ((List)currentValue).size();
                if (currentSize >= maxMultiplicity) {
                    return true;
                }
            } else {
                boolean isSet;
                try {
                    isSet = parent.eIsSet(feature);
                }
                catch (IllegalArgumentException e2) {
                    return true;
                }
                if (isSet) {
                    return true;
                }
            }
        }
        return false;
    }

    public Collection getNewRootObjectCommands(Resource resource) throws ModelerCoreException {
        ContainerImpl container = ModelEditorImpl.getContainer();
        EditingDomain domain = container.getEditingDomain();
        Collection descriptors = this.getRootDescriptors(resource);
        return this.createCommands(descriptors, domain);
    }

    public Collection getNewSiblingCommands(final EObject eObject) throws ModelerCoreException {
        final ContainerImpl container = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                Collection descriptors = null;
                EditingDomain domain = container.getEditingDomain();
                if (eObject.eContainer() == null) {
                    URI uri = eObject.eClass().eResource().getURI();
                    List rootClasses = ModelerCore.getMetamodels().getMetamodelRootClasses(uri.toString());
                    descriptors = ModelEditorImpl.createSiblingDescriptors(rootClasses, ModelerCore.getMetamodels().getFactory(uri.toString()), eObject);
                    descriptors = ModelEditorImpl.this.createCommands(descriptors, domain);
                } else {
                    descriptors = domain.getNewChildDescriptors(null, eObject);
                    ModelEditorImpl.setDescriptorOwner(descriptors, eObject.eContainer());
                    descriptors = ModelEditorImpl.this.createCommands(descriptors, domain);
                }
                if (descriptors == null) {
                    return Collections.EMPTY_LIST;
                }
                return descriptors;
            }
        };
        Object result = this.executeAsTransaction(runnable, container, "Getting Sibling Commands", false, false, eObject);
        return result instanceof Collection ? (Collection)result : Collections.EMPTY_LIST;
    }

    public Object executeAsTransaction(TransactionRunnable runnable, String description, boolean significant, Object source) throws ModelerCoreException {
        try {
            return this.executeAsTransaction(runnable, null, description, significant, source);
        }
        catch (CoreException err) {
            throw new ModelerCoreException(err);
        }
    }

    public Object executeAsTransaction(TransactionRunnable runnable, String description, boolean significant, boolean undoable, Object source) throws ModelerCoreException {
        try {
            return this.executeAsTransaction(runnable, null, description, significant, undoable, source);
        }
        catch (CoreException err) {
            throw new ModelerCoreException(err);
        }
    }

    /*
     * Loose catch block
     */
    protected Object executeAsTransaction(TransactionRunnable runnable, Container container, String operationDescription, boolean isSignificant, boolean undoable, Object source) throws ModelerCoreException {
        Object result;
        block18: {
            boolean failed;
            boolean startedTxn;
            UnitOfWork uow;
            block19: {
                if (container == null) {
                    container = ModelEditorImpl.getContainer();
                }
                uow = container.getEmfTransactionProvider().getCurrent();
                startedTxn = false;
                if (uow.requiresStart()) {
                    uow.begin();
                    startedTxn = true;
                    uow.setSignificant(isSignificant);
                    uow.setSource(source);
                    uow.setUndoable(undoable);
                    if (operationDescription != null) {
                        uow.setDescription(operationDescription);
                    }
                }
                failed = false;
                result = null;
                result = runnable.run(uow);
                Object var13_11 = null;
                if (!startedTxn) break block18;
                if (failed) break block19;
                try {
                    uow.commit();
                }
                catch (Throwable e2) {
                    ModelerCore.Util.log(e2);
                    failed = true;
                }
            }
            if (failed) {
                try {
                    uow.rollback();
                }
                catch (ModelerCoreException e1) {
                    ModelerCore.Util.log(e1);
                }
            }
            break block18;
            {
                catch (ModelerCoreException t2) {
                    failed = true;
                    throw t2;
                }
                catch (RuntimeException t3) {
                    failed = true;
                    throw new ModelerCoreRuntimeException(t3);
                }
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                if (startedTxn) {
                    if (!failed) {
                        try {
                            uow.commit();
                        }
                        catch (Throwable e2) {
                            ModelerCore.Util.log(e2);
                            failed = true;
                        }
                    }
                    if (failed) {
                        try {
                            uow.rollback();
                        }
                        catch (ModelerCoreException e1) {
                            ModelerCore.Util.log(e1);
                        }
                    }
                }
                throw throwable;
            }
        }
        return result;
    }

    public Object executeAsTransaction(TransactionRunnable runnable, Container container, String operationDescription, boolean isSignificant, Object source) throws ModelerCoreException {
        return this.executeAsTransaction(runnable, container, operationDescription, isSignificant, true, source);
    }

    public EObject createNewChildFromCommand(final EObject parent, final Command cmd) throws ModelerCoreException {
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Create_New_Child_for_{0}_1", this.getPresentationValue(parent));
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                ModelEditorImpl.this.executeCommandInTransaction(uow, parent, cmd);
                EObject child = null;
                if (cmd.getResult() != null) {
                    child = (EObject)cmd.getResult().iterator().next();
                    ModelEditorImpl.this.renameInternal(child, NEW + child.eClass().getName());
                    ModelEditorImpl.this.setUuidFeatureValue(child);
                }
                return child;
            }
        };
        EObject child = (EObject)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return child;
    }

    protected void setUuidFeatureValue(EObject eObj) {
        ObjectID id;
        Identifiable idEObj;
        if (eObj != null && eObj instanceof Identifiable && ((idEObj = (Identifiable)eObj).getUuid() == null || idEObj.getUuid().length() == 0) && (id = eObj.getObjectId()) != null) {
            idEObj.setUuid(((Object)id).toString());
        }
    }

    public EObject createNewRootObjectFromCommand(final Resource parent, final Command cmd) throws ModelerCoreException {
        ArgCheck.isNotNull(parent);
        ArgCheck.isNotNull(cmd);
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Create_New_Child_for_{0}_1", this.getPresentationValue(parent));
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                ModelEditorImpl.this.executeCommandInTransaction(uow, parent, cmd);
                EObject child = null;
                if (cmd.getResult() != null) {
                    child = (EObject)cmd.getResult().iterator().next();
                    ModelEditorImpl.this.renameInternal(child, NEW + child.eClass().getName());
                    ModelEditorImpl.this.setUuidFeatureValue(child);
                }
                return child;
            }
        };
        EObject child = (EObject)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return child;
    }

    public EObject createNewSiblingFromCommand(final EObject sibling, final Command cmd) throws ModelerCoreException {
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Create_New_Sibling_for_{0}_2", this.getPresentationValue(sibling));
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                ModelEditorImpl.this.executeCommandInTransaction(uow, sibling, cmd);
                EObject newSibling = null;
                if (cmd.getResult() != null) {
                    newSibling = (EObject)cmd.getResult().iterator().next();
                    ModelEditorImpl.this.renameInternal(newSibling, NEW + newSibling.eClass().getName());
                    ModelEditorImpl.this.setUuidFeatureValue(newSibling);
                }
                return newSibling;
            }
        };
        EObject newSibling = (EObject)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return newSibling;
    }

    public EObject createNewAssociationFromDescriptor(Object descriptor) throws ModelerCoreException {
        AbstractAssociationDescriptor assocDescr;
        if (descriptor != null && descriptor instanceof AbstractAssociationDescriptor && (assocDescr = (AbstractAssociationDescriptor)descriptor).isComplete()) {
            boolean isSignificant = true;
            String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Create_new_Association_3");
            ContainerImpl cntr = ModelEditorImpl.getContainer();
            TransactionRunnable runnable = new TransactionRunnable(){

                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    EObject result = null;
                    result = assocDescr.isAmbiguous() ? ((AbstractAssociationDescriptor)assocDescr.getChildren()[0]).create() : assocDescr.create();
                    ModelEditorImpl.this.renameInternal(result, NEW + result.eClass().getName());
                    return result;
                }
            };
            EObject result = (EObject)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
            return result;
        }
        return null;
    }

    public Collection getNewAssociationDescriptors(List eObjects) throws ModelerCoreException {
        Configuration config = ModelerCore.getConfiguration();
        List descriptors = config.getAssociationProviderDescriptors();
        HashSet result = new HashSet(descriptors.size());
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            ExtensionDescriptor descriptor = (ExtensionDescriptor)iter.next();
            AssociationProvider provider = (AssociationProvider)descriptor.getExtensionClassInstance();
            if (provider == null) continue;
            result.addAll(provider.getNewAssociationDescriptors(eObjects));
        }
        return result;
    }

    public EObject copy(EObject eObject) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        return this.copy(eObject, null);
    }

    public EObject copy(final EObject eObject, final Map originalsToCopies) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Copy_{0}_4", this.getPresentationValue(eObject));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                CopyCommand.Helper helper = new CopyCommand.Helper();
                if (originalsToCopies != null && !originalsToCopies.isEmpty()) {
                    helper.putAll(originalsToCopies);
                }
                Command command = ModelEditorImpl.createCopyCommand(ed, eObject, helper);
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                EObject result = null;
                if (command.getResult() != null) {
                    result = (EObject)command.getResult().iterator().next();
                    ModelEditorImpl.this.setUuidFeatureValue(result);
                }
                if (originalsToCopies != null && helper != null) {
                    originalsToCopies.putAll(helper);
                }
                return result;
            }
        };
        EObject result = (EObject)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return result;
    }

    public Collection copyMultiple(final EObject eObject, final int numCopies) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        ArgCheck.isPositive(numCopies);
        final ArrayList copies = new ArrayList(numCopies);
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Copy_{0}_4", this.getPresentationValue(eObject));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                while (copies.size() < numCopies) {
                    Command command = CopyCommand.create(ed, eObject);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                    if (command.getResult() != null) {
                        EObject copy = (EObject)command.getResult().iterator().next();
                        ModelEditorImpl.this.setUuidFeatureValue(copy);
                        copies.add(copy);
                        continue;
                    }
                    throw new ModelerCoreException(ModelerCore.Util.getString("ModelEditorImpl.Error_creating_copies_1"));
                }
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return copies;
    }

    public boolean delete(final Collection eObjects) throws ModelerCoreException {
        ArgCheck.isNotNull(eObjects);
        if (eObjects.isEmpty()) {
            return false;
        }
        boolean isSignificant = true;
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Delete_multiple_objects_1");
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                Command command = ModelEditorImpl.this.createDeleteManyCommand(ed, eObjects);
                ModelEditorImpl.this.executeCommandInTransaction(uow, null, command);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return true;
    }

    public Command createDeleteManyCommand(EditingDomain ed, Collection eObjects) throws ModelerCoreException {
        HashMap objectsByContainment = new HashMap();
        LinkedList<Command> commands = new LinkedList<Command>();
        Iterator removedObjects = eObjects.iterator();
        while (removedObjects.hasNext()) {
            EObject eObject = (EObject)removedObjects.next();
            Notifier owner = eObject.eContainer() == null ? eObject.eResource() : eObject.eContainer();
            EReference feature = eObject.eContainmentFeature();
            Object existing = objectsByContainment.get(owner);
            if (existing == null) {
                existing = feature == null ? new HashSet() : new HashMap();
                objectsByContainment.put((Resource)owner, existing);
            }
            if (existing instanceof Collection) {
                ((Collection)existing).add(eObject);
                continue;
            }
            if (!(existing instanceof Map)) continue;
            HashSet<EObject> objectsByFeature = (HashSet<EObject>)((Map)existing).get(feature);
            if (objectsByFeature == null) {
                objectsByFeature = new HashSet<EObject>();
            }
            objectsByFeature.add(eObject);
            ((Map)existing).put(feature, objectsByFeature);
        }
        ModelWorkspaceSearch workspaceSearch = new ModelWorkspaceSearch();
        Collection allDeleted = this.findOtherObjectsToBeDeleted(eObjects, ed, commands, workspaceSearch);
        this.findReferencesToObjectsBeingDeleted(allDeleted, ed, commands, workspaceSearch);
        Iterator iter1 = objectsByContainment.entrySet().iterator();
        while (iter1.hasNext()) {
            Map.Entry entry1 = iter1.next();
            Object key = entry1.getKey();
            if (key instanceof EObject) {
                EObject parent = (EObject)key;
                Map objectsByFeature = (Map)entry1.getValue();
                Iterator iter2 = objectsByFeature.entrySet().iterator();
                while (iter2.hasNext()) {
                    Command command;
                    CommandParameter param;
                    Map.Entry entry2 = iter2.next();
                    EReference ref = (EReference)entry2.getKey();
                    Collection objects = (Collection)entry2.getValue();
                    if (ref.isMany()) {
                        param = new CommandParameter((Object)parent, (Object)ref, objects);
                        command = ed.createCommand(class$org$eclipse$emf$edit$command$RemoveCommand == null ? ModelEditorImpl.class$("org.eclipse.emf.edit.command.RemoveCommand") : class$org$eclipse$emf$edit$command$RemoveCommand, param);
                        commands.addFirst(command);
                        continue;
                    }
                    param = new CommandParameter((Object)parent, (Object)ref, null);
                    command = ed.createCommand(class$org$eclipse$emf$edit$command$SetCommand == null ? ModelEditorImpl.class$("org.eclipse.emf.edit.command.SetCommand") : class$org$eclipse$emf$edit$command$SetCommand, param);
                    commands.addFirst(command);
                }
                continue;
            }
            Collection values = (Collection)entry1.getValue();
            Resource parent = (Resource)key;
            EList contents = parent.getContents();
            CommandParameter param = new CommandParameter((Object)parent, (Object)contents, values);
            Command command = ed.createCommand(class$org$eclipse$emf$edit$command$RemoveCommand == null ? ModelEditorImpl.class$("org.eclipse.emf.edit.command.RemoveCommand") : class$org$eclipse$emf$edit$command$RemoveCommand, param);
            commands.addFirst(command);
        }
        return CompoundCommandFactory.create(eObjects, commands);
    }

    public boolean delete(final EObject eObject, boolean performResourceCheck, final boolean performRelatedObjectCheck) throws ModelerCoreException {
        Resource resource;
        ArgCheck.isNotNull(eObject);
        if (performResourceCheck && (resource = eObject.eResource()) == null) {
            return false;
        }
        boolean isSignificant = true;
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Delete_{0}_5", this.getPresentationValue(eObject));
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                Command command = ModelEditorImpl.createDeleteCommand(ed, eObject);
                if (command == null) {
                    return null;
                }
                if (performRelatedObjectCheck) {
                    LinkedList<Command> additionalCommands = new LinkedList<Command>();
                    Resource emfResource = eObject.eResource();
                    if (emfResource != null) {
                        ModelWorkspaceSearch workspaceSearch = new ModelWorkspaceSearch();
                        Collection allDeleted = ModelEditorImpl.this.findOtherObjectsToBeDeleted(Collections.singleton(eObject), ed, additionalCommands, workspaceSearch);
                        ModelEditorImpl.this.findReferencesToObjectsBeingDeleted(allDeleted, ed, additionalCommands, workspaceSearch);
                        if (!additionalCommands.isEmpty()) {
                            additionalCommands.addFirst(command);
                            command = CompoundCommandFactory.create(eObject, additionalCommands);
                        }
                    }
                }
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return true;
    }

    public boolean delete(EObject eObject, boolean performResourceCheck) throws ModelerCoreException {
        return this.delete(eObject, performResourceCheck, true);
    }

    public boolean delete(EObject eObject) throws ModelerCoreException {
        return this.delete(eObject, true);
    }

    protected static Command createDeleteCommand(EditingDomain editingDomain, EObject eObject) {
        ArgCheck.isNotNull(eObject);
        Command command = null;
        if (eObject.eContainer() == null) {
            EList contents;
            Resource rsrc = eObject.eResource();
            if (rsrc != null && (contents = rsrc.getContents()).contains(eObject)) {
                command = new RemoveCommand(editingDomain, contents, eObject);
            }
        } else {
            EReference sf = eObject.eContainmentFeature();
            if (sf.isMany()) {
                HashSet<EObject> collection = new HashSet<EObject>(1);
                collection.add(eObject);
                CommandParameter param = new CommandParameter((Object)eObject.eContainer(), (Object)sf, collection);
                command = editingDomain.createCommand(class$org$eclipse$emf$edit$command$RemoveCommand == null ? (class$org$eclipse$emf$edit$command$RemoveCommand = ModelEditorImpl.class$("org.eclipse.emf.edit.command.RemoveCommand")) : class$org$eclipse$emf$edit$command$RemoveCommand, param);
            } else {
                CommandParameter param = new CommandParameter((Object)eObject.eContainer(), (Object)sf, null);
                command = editingDomain.createCommand(class$org$eclipse$emf$edit$command$SetCommand == null ? (class$org$eclipse$emf$edit$command$SetCommand = ModelEditorImpl.class$("org.eclipse.emf.edit.command.SetCommand")) : class$org$eclipse$emf$edit$command$SetCommand, param);
            }
        }
        return command;
    }

    public void findReferencesToObjectsBeingDeleted(Collection allDeleted, EditingDomain editingDomain, List additionalCommands, ModelWorkspaceSearch workspaceSearch) throws ModelerCoreException {
        ClearReferencesUponDelete visitor = new ClearReferencesUponDelete(allDeleted, editingDomain, workspaceSearch);
        ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
        Iterator iter = allDeleted.iterator();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (eObject.eResource() == null) continue;
            processor.walk(eObject, 2);
        }
        List removeAndSetCommands = visitor.getAdditionalCommands();
        if (removeAndSetCommands != null && !removeAndSetCommands.isEmpty()) {
            this.addCommands(removeAndSetCommands, additionalCommands);
        }
    }

    private void addCommands(List removeAndSetCommands, List additionalCommands) {
        Object command = null;
        boolean addCommand = true;
        Iterator iter = removeAndSetCommands.iterator();
        while (iter.hasNext()) {
            command = iter.next();
            if (command instanceof RemoveCommand) {
                addCommand = true;
                Iterator addCommandsIter = additionalCommands.iterator();
                while (addCommandsIter.hasNext()) {
                    Object additionalCommand = addCommandsIter.next();
                    if (!(additionalCommand instanceof RemoveCommand) || !((RemoveCommand)additionalCommand).getOwner().equals(((RemoveCommand)command).getOwner()) || ((RemoveCommand)additionalCommand).getCollection().size() != ((RemoveCommand)command).getCollection().size() || !((RemoveCommand)additionalCommand).getCollection().containsAll(((RemoveCommand)command).getCollection())) continue;
                    addCommand = false;
                    break;
                }
                if (!addCommand) continue;
                additionalCommands.add(command);
                continue;
            }
            additionalCommands.add(command);
        }
    }

    public List findRelatedObjects(Collection objects, EditingDomain domain) {
        if (domain instanceof ContainerEditingDomain) {
            FindRelatedObjectsToBeCopied visitor = new FindRelatedObjectsToBeCopied();
            ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
            try {
                processor.walk(objects, 2);
            }
            catch (ModelerCoreException e2) {
                ModelerCore.Util.log(e2);
            }
            return new ArrayList(visitor.getAdditionalObjects());
        }
        return Collections.EMPTY_LIST;
    }

    public Collection findExternalReferencesToObjectsBeingDeleted(EObject eObject, Collection allDeleted) throws ModelerCoreException {
        HashSet<EObject> allDeletedObjects;
        ArgCheck.isNotNull(eObject);
        Resource resource = eObject.eResource();
        if (resource == null) {
            return Collections.EMPTY_LIST;
        }
        HashSet<EObject> hashSet = allDeletedObjects = allDeleted == null ? new HashSet<EObject>() : new HashSet(allDeleted);
        if (!allDeletedObjects.contains(eObject)) {
            allDeletedObjects.add(eObject);
        }
        FindReferencesToDeletedObjects visitor = new FindReferencesToDeletedObjects(allDeleted);
        ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
        try {
            processor.walk(resource, 2);
        }
        catch (Throwable t2) {
            ModelerCore.Util.log(4, t2, t2.getMessage());
        }
        return visitor.getReferencesToDeletedObjects();
    }

    protected Collection findOtherObjectsToBeDeleted(EObject eObject, ModelWorkspaceSearch workspaceSearch) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        EditingDomain ed = cntr.getEditingDomain();
        LinkedList additionalCommands = new LinkedList();
        return this.findOtherObjectsToBeDeleted(Collections.singleton(eObject), ed, additionalCommands, workspaceSearch);
    }

    public Collection findOtherObjectsToBeDeleted(EObject eObject) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        EditingDomain ed = cntr.getEditingDomain();
        LinkedList additionalCommands = new LinkedList();
        return this.findOtherObjectsToBeDeleted(Collections.singleton(eObject), ed, additionalCommands, new ModelWorkspaceSearch());
    }

    public Collection findOtherObjectsToBeDeleted(Collection eObjects, EditingDomain editingDomain, List additionalCommands, ModelWorkspaceSearch workspaceSearch) throws ModelerCoreException {
        HashSet rv = new HashSet();
        Iterator itor = eObjects.iterator();
        while (itor.hasNext()) {
            EObject eObject = (EObject)itor.next();
            Resource resource = eObject.eResource();
            if (resource == null) continue;
            LinkedList<EObject> objectsToDelete = new LinkedList<EObject>();
            objectsToDelete.addFirst(eObject);
            FindRelatedObjectsToDeleted visitor = new FindRelatedObjectsToDeleted(eObject, editingDomain, objectsToDelete, this.getRemovedObjectsForCurrentTxn(), workspaceSearch);
            ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor);
            while (!objectsToDelete.isEmpty()) {
                processor.walk((EObject)objectsToDelete.getFirst(), 2);
            }
            if (visitor.getAdditionalDeleteCommands() != null && !visitor.getAdditionalDeleteCommands().isEmpty()) {
                additionalCommands.addAll(visitor.getAdditionalDeleteCommands());
            }
            rv.addAll(visitor.getAllDeletedObjects());
        }
        return rv;
    }

    private Collection getRemovedObjectsForCurrentTxn() {
        try {
            ContainerImpl container = ModelEditorImpl.getContainer();
            UnitOfWorkImpl uow = (UnitOfWorkImpl)container.getEmfTransactionProvider().getCurrent();
            return uow.getRemovedEObjects();
        }
        catch (Exception err) {
            return new HashSet();
        }
    }

    public boolean rename(final EObject eObject, final String newName) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        final EStructuralFeature nameFeature = this.getNameFeature(eObject);
        if (nameFeature == null) {
            return false;
        }
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Rename_{0}_6", this.getPresentationValue(eObject));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                Command command = SetCommand.create(ed, eObject, nameFeature, newName);
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return true;
    }

    public EStructuralFeature getNameFeature(EObject eObject) {
        ArgCheck.isNotNull(eObject);
        EClass eClass = eObject.eClass();
        Iterator iter = eClass.getEAllStructuralFeatures().iterator();
        while (iter.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)iter.next();
            if (!NAME_FEATURE_NAME.equalsIgnoreCase(feature.getName())) continue;
            return feature;
        }
        return null;
    }

    public String getName(EObject eObject) {
        ArgCheck.isNotNull(eObject);
        EStructuralFeature nameFeature = this.getNameFeature(eObject);
        if (nameFeature == null) {
            return null;
        }
        Object value = eObject.eGet(nameFeature);
        return value != null ? value.toString() : null;
    }

    public boolean hasName(EObject eObject) {
        ArgCheck.isNotNull(eObject);
        EStructuralFeature nameFeature = this.getNameFeature(eObject);
        return nameFeature != null;
    }

    protected boolean renameInternal(EObject eObject, String newName) {
        ArgCheck.isNotNull(eObject);
        EStructuralFeature nameFeature = this.getNameFeature(eObject);
        if (nameFeature != null) {
            this.generateUniqueInternalName(eObject.eContainer() == null ? eObject.eResource().getContents() : eObject.eContainer().eContents(), eObject, nameFeature, newName);
            return true;
        }
        return false;
    }

    private void generateUniqueInternalName(EList siblings, EObject eObject, EStructuralFeature nameFeature, String name) {
        String newName = name;
        if (siblings != null && eObject.eGet(nameFeature) == null) {
            HashSet<Object> siblingNames = new HashSet<Object>();
            Iterator it = siblings.iterator();
            while (it.hasNext()) {
                EObject child = (EObject)it.next();
                if (!eObject.getClass().equals(child.getClass())) continue;
                siblingNames.add(child.eGet(nameFeature));
            }
            boolean foundUniqueName = false;
            int index = 1;
            while (!foundUniqueName) {
                if (siblingNames.contains(newName)) {
                    newName = name + String.valueOf(index++);
                    continue;
                }
                foundUniqueName = true;
            }
        }
        eObject.eSet(nameFeature, newName);
    }

    public void executeCommand(final EObject owner, final Command cmd) throws ModelerCoreException {
        boolean isSignificant = true;
        String operationDescription = null;
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                ModelEditorImpl.this.executeCommandInTransaction(uow, owner, cmd);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
    }

    protected void executeCommandInTransaction(UnitOfWork uow, Object owner, Command cmd) throws ModelerCoreException {
        ArgCheck.isNotNull(uow);
        if (cmd == null || !cmd.canExecute()) {
            String nullMsg = ModelerCore.Util.getString("ModelEditorImpl.Can_not_execute_a_null_command_1");
            String reason = cmd == null ? nullMsg : this.getCmdFailureReason(cmd);
            throw new ModelerCoreException(ModelerCore.Util.getString("ModelEditorImpl.Unable_to_execute_Command_1", reason));
        }
        uow.executeCommand(cmd);
    }

    protected String getCmdFailureReason(Command cmd) {
        StringBuffer failures;
        block47: {
            failures = new StringBuffer();
            failures.append(cmd.toString());
            try {
                EReference eReference;
                if (cmd instanceof CompoundCommand && !cmd.canExecute()) {
                    failures.append(ModelerCore.Util.getString("ModelEditorImpl.Compound_Command_with_unexecutable_children_1"));
                    break block47;
                }
                if (cmd instanceof AddCommand && !cmd.canExecute()) {
                    AddCommand add = (AddCommand)cmd;
                    if (add.getOwnerList() == null || add.getCollection() == null || add.getCollection().size() == 0 || add.getIndex() != -1 && (add.getIndex() < 0 || add.getIndex() > add.getOwnerList().size())) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl.Invalid_index_for_Add_operation_2"));
                        return failures.toString();
                    }
                    Iterator objects = add.getCollection().iterator();
                    while (objects.hasNext()) {
                        Object object = objects.next();
                        if (add.getFeature() == null || add.getFeature().getEType().isInstance(object)) continue;
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_add_item_of_type_{0}_to_feature_{1}_3", object.getClass().getName(), add.getFeature().getName()));
                    }
                    if (add.getFeature() instanceof EReference && ((EReference)add.getFeature()).isContainment()) {
                        for (EObject container = add.getOwner(); container != null; container = container.eContainer()) {
                            if (!add.getCollection().contains(container)) continue;
                            failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_add_object_to_a_contained_object_4"));
                            return failures.toString();
                        }
                    }
                    break block47;
                }
                if (cmd instanceof CopyToClipboardCommand && !cmd.canExecute()) {
                    if (((CopyToClipboardCommand)cmd).getSourceObjects() == null) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nSource_Objects_collection_may_not_be_null_for_Copy_operation_5"));
                    } else if (((CopyToClipboardCommand)cmd).getSourceObjects().isEmpty()) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nSource_Objects_collection_may_not_be_empty_for_Copy_operation_6"));
                    } else {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnable_to_execute_copy_to_clipboard_command_7"));
                    }
                    break block47;
                }
                if (cmd instanceof CommandWrapper && !cmd.canExecute()) {
                    Command tmp = ((CommandWrapper)cmd).getCommand();
                    if (tmp != null && tmp != UnexecutableCommand.INSTANCE) {
                        return this.getCmdFailureReason(tmp);
                    }
                    failures.append(ModelerCore.Util.getString("ModelEditorImpl._nWrapped_command_may_not_be_null_or_Unexecutable_8"));
                    break block47;
                }
                if (cmd instanceof CreateCopyCommand && !cmd.canExecute()) {
                    if (((CreateCopyCommand)cmd).getOwner() == null) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_create_copy_of_NULL_object_9"));
                    } else {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnexecutable_Create_Copy_command_10"));
                    }
                    break block47;
                }
                if (cmd instanceof MoveCommand && !cmd.canExecute()) {
                    MoveCommand tmp = (MoveCommand)cmd;
                    if (tmp.getOwnerList() == null) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nOwner_list_may_not_be_null_for_a_Move_Command_11"));
                    } else if (!tmp.getOwnerList().contains(tmp.getValue())) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nOwner_list_must_contain_value_for_a_Move_Command_12"));
                    } else if (tmp.getIndex() < tmp.getOwnerList().size()) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nInvalid_index_for_Move_Command_13"));
                    } else {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnexpected_failure_for_Move_Command_14"));
                    }
                    break block47;
                }
                if (cmd instanceof PasteFromClipboardCommand && !cmd.canExecute()) {
                    PasteFromClipboardCommand tmp = (PasteFromClipboardCommand)cmd;
                    Collection copies = tmp.getChildrenToCopy();
                    if (copies == null || copies.isEmpty()) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nNo_objects_found_to_paste_15"));
                        return failures.toString();
                    }
                    if (tmp.getFeature() != null && tmp.getFeature() instanceof EStructuralFeature) {
                        EStructuralFeature feature = (EStructuralFeature)tmp.getFeature();
                        Iterator objects = copies.iterator();
                        while (objects.hasNext()) {
                            Object object = objects.next();
                            if (feature.getEType().isInstance(object)) continue;
                            failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_paste_item_of_type_{0}_to_feature_{1}_16", object.getClass().getName(), feature.getName()));
                        }
                    }
                    if (tmp.getOwner() instanceof EObject && tmp.getFeature() instanceof EReference && ((EReference)tmp.getFeature()).isContainment()) {
                        for (EObject container = (EObject)tmp.getOwner(); container != null; container = container.eContainer()) {
                            if (!copies.contains(container)) continue;
                            failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_add_object_to_a_contained_object_17"));
                            return failures.toString();
                        }
                    }
                    if (failures.length() == 0) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnexecutable_Paste_From_Clipboard_command_18"));
                    }
                    break block47;
                }
                if (cmd instanceof RemoveCommand && !cmd.canExecute()) {
                    RemoveCommand removeCmd = (RemoveCommand)cmd;
                    if (removeCmd.getOwnerList() == null) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nOwner_list_may_not_be_null_19"));
                    } else if (!removeCmd.getOwnerList().containsAll(removeCmd.getCollection())) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nOwner_list_must_contain_all_values_to_be_removed_20"));
                    }
                    if (failures.length() == 0) {
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnexecutable_Remove_command_21"));
                    }
                    break block47;
                }
                if (!(cmd instanceof SetCommand) || cmd.canExecute()) break block47;
                SetCommand tmp = (SetCommand)cmd;
                EObject owner = tmp.getOwner();
                EStructuralFeature feature = tmp.getFeature();
                Object value = tmp.getValue();
                if (feature == null) {
                    failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_set_value_on_null_feature_22"));
                    return failures.toString();
                }
                if (owner == null) {
                    failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_set_value_on_null_owner_23"));
                    return failures.toString();
                }
                EClass eMetaObject = owner.eClass();
                if (eMetaObject.getEAllAttributes().contains(feature)) {
                    EAttribute eAttribute = (EAttribute)feature;
                    EClassifier eType = eAttribute.getEType();
                    if (eAttribute.isMany() && value instanceof EList) {
                        EList list = (EList)value;
                        Iterator objects = list.iterator();
                        while (objects.hasNext()) {
                            Object next = objects.next();
                            if (eType.isInstance(next)) continue;
                            failures.append(ModelerCore.Util.getString("ModelEditorImpl._nCan_not_add_object_of_type_{0}_to_feature_{1}_24", next.getClass().getName(), tmp.getFeature().getName()));
                        }
                    }
                } else if (eMetaObject.getEAllReferences().contains(feature) && !(eReference = (EReference)feature).isMany() && (value == null || eReference.getEType().isInstance(value)) && eReference.isContainment()) {
                    for (EObject container = owner; container != null; container = container.eContainer()) {
                        if (value != container) continue;
                        failures.append(ModelerCore.Util.getString("ModelEditorImpl._nMay_not_add_value_to_contained_object_25"));
                        break;
                    }
                }
                if (failures.length() == 0) {
                    failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnexpected_failure_executing_Set_command_26"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (failures.length() == 0) {
            failures.append(ModelerCore.Util.getString("ModelEditorImpl._nUnexpected_failure_executing_command___Command_not_executable_27"));
        }
        return failures.toString();
    }

    public boolean move(Object newParent, EObject eObject) throws ModelerCoreException {
        ArgCheck.isNotNull(newParent);
        ArgCheck.isNotNull(eObject);
        if (!this.isValidParent(newParent, eObject)) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ModelEditorImpl.Invalid_parent_for_child_encountered_1"));
        }
        int index = 0;
        if (newParent instanceof EObject) {
            EObject eParent = (EObject)newParent;
            EReference ref = this.getChildReference(eParent, eObject);
            if (ref != null && ref.isMany() && eParent.eGet(ref) instanceof EList) {
                index = ((EList)eParent.eGet(ref)).size();
            }
        } else if (newParent instanceof Resource) {
            index = ((Resource)newParent).getContents().size();
        }
        return this.move(newParent, eObject, index);
    }

    public boolean move(final Object newParent, final EObject eObject, final int index) throws ModelerCoreException {
        ArgCheck.isNotNull(newParent);
        ArgCheck.isNotNull(eObject);
        if (!this.isValidParent(newParent, eObject)) {
            throw new ModelerCoreException(ModelerCore.Util.getString("ModelEditorImpl.Invalid_parent_for_child_encountered_1"));
        }
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Move_{0}_7", this.getPresentationValue(eObject));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                Command command = null;
                if (eObject.eContainer() != null && eObject.eContainer() == newParent) {
                    command = MoveCommand.create(ed, newParent, null, eObject, index);
                } else {
                    if (eObject.eContainer() != null) {
                        command = RemoveCommand.create(ed, (Object)eObject.eContainer(), (Object)eObject.eContainmentFeature(), eObject);
                        ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                    }
                    command = AddCommand.create(ed, newParent, null, eObject, index);
                }
                ModelEditorImpl.this.executeCommandInTransaction(uow, newParent, command);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return true;
    }

    public void copyToClipboard(EObject eObject) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        ArrayList<EObject> objects = new ArrayList<EObject>(1);
        objects.add(eObject);
        this.copyAllToClipboard(objects);
    }

    public void copyAllToClipboard(final Collection eObjects) throws ModelerCoreException {
        ArgCheck.isNotEmpty(eObjects);
        final EObject eObject = (EObject)eObjects.iterator().next();
        boolean isSignificant = false;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Copy_{0}_8", this.getPresentationValue(eObjects));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                Command command = CopyToClipboardCommand.create(ed, eObjects);
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, false, (Object)this);
    }

    public void cutToClipboard(EObject eObject) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        ArrayList<EObject> objects = new ArrayList<EObject>(1);
        objects.add(eObject);
        this.cutAllToClipboard(objects);
    }

    public void cutAllToClipboard(final Collection eObjects) throws ModelerCoreException {
        ArgCheck.isNotEmpty(eObjects);
        final EObject eObject = (EObject)eObjects.iterator().next();
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Cut_{0}_9", this.getPresentationValue(eObjects));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                CompoundCommand command = CompoundCommandFactory.create(eObjects, new ArrayList(1));
                command.append(CutToClipboardCommand.create(ed, eObjects));
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
    }

    public boolean pasteFromClipboard(final Object owner) throws ModelerCoreException {
        ArgCheck.isNotNull(owner);
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Paste_{0}_10", this.getPresentationValue(owner));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                Object realOwner = owner instanceof ModelResource ? ((ModelResource)owner).getEmfResource() : owner;
                Command command = PasteFromClipboardCommand.create(ed, realOwner, null);
                ModelEditorImpl.this.executeCommandInTransaction(uow, realOwner, command);
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return true;
    }

    public Collection getClipboardContents(Object target) {
        try {
            ContainerImpl cntr = ModelEditorImpl.getContainer();
            EditingDomain ed = cntr.getEditingDomain();
            Collection content = ed.getClipboard();
            if (content != null) {
                return Collections.unmodifiableCollection(ed.getClipboard());
            }
            return Collections.EMPTY_LIST;
        }
        catch (Exception e2) {
            return Collections.EMPTY_LIST;
        }
    }

    public Map getClipboardContentsOriginalToCopyMapping(Object target) throws ModelerCoreException {
        try {
            ContainerImpl cntr = ModelEditorImpl.getContainer();
            EditingDomain ed = cntr.getEditingDomain();
            if (ed instanceof ContainerEditingDomain) {
                ContainerEditingDomain ced = (ContainerEditingDomain)ed;
                return ced.getClipboardContentsOriginalToCopyMapping();
            }
        }
        catch (Exception e2) {
            return null;
        }
        return null;
    }

    public Map getClipboardContentsCopyToOriginalMapping(Object target) throws ModelerCoreException {
        Map originalToCopy = this.getClipboardContentsOriginalToCopyMapping(target);
        if (originalToCopy != null) {
            HashMap copyToOriginal = new HashMap();
            Iterator iter = originalToCopy.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object copy = entry.getValue();
                Object orig = entry.getKey();
                copyToOriginal.put(copy, orig);
            }
            return copyToOriginal;
        }
        return null;
    }

    public Collection copyAll(Collection eObjects) throws ModelerCoreException {
        if (eObjects == null || eObjects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.copyAll(eObjects, null);
    }

    public Collection copyAll(final Collection eObjects, final Map originalsToCopies) throws ModelerCoreException {
        if (eObjects == null || eObjects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        final EObject eObject = (EObject)eObjects.iterator().next();
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Copy_{0}_11", this.getPresentationValue(eObjects));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                CopyCommand.Helper helper = new CopyCommand.Helper();
                if (originalsToCopies != null && !originalsToCopies.isEmpty()) {
                    Iterator iter = originalsToCopies.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        helper.put(entry.getKey(), entry.getValue());
                    }
                    helper.putAll(originalsToCopies);
                }
                Command command = ModelEditorImpl.createCopyCommand(ed, eObjects, helper);
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                Iterator copies = command.getResult().iterator();
                while (copies.hasNext()) {
                    Object next = copies.next();
                    if (!(next instanceof EObject)) continue;
                    ModelEditorImpl.this.setUuidFeatureValue((EObject)next);
                }
                if (originalsToCopies != null && helper != null) {
                    originalsToCopies.putAll(helper);
                }
                return command.getResult();
            }
        };
        Collection result = (Collection)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return result;
    }

    public void addValue(Object owner, Object value, EList feature) throws ModelerCoreException {
        this.addValue(owner, value, feature, -1);
    }

    public void addValue(final Object owner, Object value, final EList feature, final int index) throws ModelerCoreException {
        ArgCheck.isNotNull(owner);
        ArgCheck.isNotNull(value);
        ArgCheck.isNotNull(feature);
        final ArrayList<Object> values = new ArrayList<Object>();
        if (value instanceof Collection) {
            values.addAll((Collection)value);
        } else {
            values.add(value);
        }
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        if (cntr == null) {
            feature.add(index, values);
        } else {
            boolean isSignificant = true;
            String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Add_values_to_{0}_1", this.getPresentationValue(owner));
            TransactionRunnable runnable = new TransactionRunnable(){

                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    EditingDomain ed = cntr.getEditingDomain();
                    AddCommand command = AddCommandFactory.create(owner, ed, feature, values, index);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, owner, command);
                    return null;
                }
            };
            this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        }
    }

    public void addMapValue(final Object owner, final Map map, final Object key, final Object value) throws ModelerCoreException {
        ArgCheck.isNotNull(owner);
        ArgCheck.isNotNull(map);
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        if (cntr == null) {
            map.put(key, value);
        } else {
            boolean isSignificant = false;
            String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Add_value_to_map_for_{0}", this.getPresentationValue(owner));
            TransactionRunnable runnable = new TransactionRunnable(){

                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    EditingDomain ed = cntr.getEditingDomain();
                    AddValueToMapCommand command = new AddValueToMapCommand(ed, owner, map, key, value);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, owner, command);
                    return null;
                }
            };
            this.executeAsTransaction(runnable, cntr, operationDescription, false, (Object)this);
        }
    }

    public void removeValue(final Object owner, Object value, final EList feature) throws ModelerCoreException {
        ArgCheck.isNotNull(owner);
        ArgCheck.isNotNull(value);
        ArgCheck.isNotNull(feature);
        final ArrayList<Object> values = new ArrayList<Object>();
        if (value instanceof Collection) {
            values.addAll((Collection)value);
        } else {
            values.add(value);
        }
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        if (cntr == null) {
            feature.remove(values);
        } else {
            boolean isSignificant = true;
            String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Remove_values_from_{0}_1", this.getPresentationValue(owner));
            TransactionRunnable runnable = new TransactionRunnable(){

                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    EditingDomain ed = cntr.getEditingDomain();
                    RemoveCommand command = new RemoveCommand(ed, feature, values);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, owner, command);
                    return null;
                }
            };
            this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        }
    }

    public void removeMapValue(final Object owner, final Map map, final Object key) throws ModelerCoreException {
        ArgCheck.isNotNull(owner);
        ArgCheck.isNotNull(map);
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        if (cntr == null) {
            map.remove(key);
        } else {
            boolean isSignificant = false;
            String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Remove_value_from_map_for_{0}", this.getPresentationValue(owner));
            TransactionRunnable runnable = new TransactionRunnable(){

                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    EditingDomain ed = cntr.getEditingDomain();
                    RemoveValueFromMapCommand command = new RemoveValueFromMapCommand(ed, owner, map, key);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, owner, command);
                    return null;
                }
            };
            this.executeAsTransaction(runnable, cntr, operationDescription, false, (Object)this);
        }
    }

    public boolean setPropertyValue(EObject eObject, Object value, ItemPropertyDescriptor descriptor) {
        if (eObject == null || descriptor == null) {
            return false;
        }
        return this.setPropertyValue(eObject, value, descriptor.getFeature(eObject));
    }

    public boolean setEnterpriseDatatypePropertyValue(EObject owner, final Object object) {
        if (owner == null || object == null || !(owner instanceof XSDSimpleTypeDefinition) || !(object instanceof EnterpriseDatatypeInfo)) {
            return false;
        }
        final EnterpriseDatatypeInfo newEdtInfo = (EnterpriseDatatypeInfo)object;
        final XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)owner;
        final EnterpriseDatatypeInfo oldEdtInfo = ModelerCore.getDatatypeManager(simpleType).getEnterpriseDatatypeInfo(simpleType);
        if (newEdtInfo.equals(oldEdtInfo)) {
            return false;
        }
        newEdtInfo.fillWithDefaultValues(simpleType);
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Set_{0}_1", object.toString());
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                EnterpriseDatatypeInfoSetCommand cmd = new EnterpriseDatatypeInfoSetCommand(ed, simpleType, newEdtInfo, oldEdtInfo);
                ModelEditorImpl.this.executeCommandInTransaction(uow, object, cmd);
                return null;
            }
        };
        try {
            this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(4, e2, e2.getMessage());
            return false;
        }
        return true;
    }

    public boolean unsetEnterpriseDatatypePropertyValue(final EObject owner) {
        if (owner == null || !(owner instanceof XSDSimpleTypeDefinition)) {
            return false;
        }
        final XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)owner;
        final EnterpriseDatatypeInfo oldEdtInfo = ModelerCore.getDatatypeManager(simpleType).getEnterpriseDatatypeInfo(simpleType);
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Set_{0}_1", owner.toString());
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                EnterpriseDatatypeInfoUnsetCommand cmd = new EnterpriseDatatypeInfoUnsetCommand(ed, simpleType, oldEdtInfo);
                ModelEditorImpl.this.executeCommandInTransaction(uow, owner, cmd);
                return null;
            }
        };
        try {
            this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(4, e2, e2.getMessage());
            return false;
        }
        return true;
    }

    public boolean setPropertyValue(final EObject eObject, final Object value, Object feature) {
        if (eObject == null || feature == null || !(feature instanceof EStructuralFeature)) {
            return false;
        }
        final EStructuralFeature sf = (EStructuralFeature)feature;
        if (sf == null) {
            return false;
        }
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Set_{0}_1", sf.getName());
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                if (sf.isMany()) {
                    EList currentValues = (EList)eObject.eGet(sf);
                    ArrayList addedValues = new ArrayList(currentValues.size());
                    ArrayList removedValues = new ArrayList(currentValues.size());
                    Collection<Object> newValues = new ArrayList<Object>();
                    if (value instanceof Collection) {
                        newValues = (Collection)value;
                    } else {
                        newValues.add(value);
                    }
                    removedValues.addAll(currentValues);
                    addedValues.addAll(newValues);
                    if (!currentValues.isEmpty()) {
                        ModelEditorImpl.this.removeValue(eObject, removedValues, currentValues);
                    }
                    if (!addedValues.isEmpty()) {
                        ModelEditorImpl.this.addValue(eObject, addedValues, currentValues);
                    }
                } else {
                    XSDParticleContent particleContent;
                    EObject owner;
                    Object newValue = value;
                    if (value != null && value instanceof String) {
                        EDataType dt = (EDataType)sf.getEType();
                        EPackage ePackage = dt.getEPackage();
                        EFactory fac = ePackage.getEFactoryInstance();
                        newValue = fac.createFromString(dt, (String)value);
                    }
                    if ((owner = eObject) instanceof XSDParticle && !owner.eClass().getEAllStructuralFeatures().contains(sf) && (particleContent = ((XSDParticle)owner).getContent()) != null && particleContent.eClass().getEAllStructuralFeatures().contains(sf)) {
                        owner = particleContent;
                    }
                    SetCommand command = new SetCommand(ed, owner, sf, newValue);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, owner, command);
                }
                return null;
            }
        };
        try {
            this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(4, e2, e2.getMessage());
            return false;
        }
        return true;
    }

    public EObject clone(final EObject eObject) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Clone_{0}_12", this.getPresentationValue(eObject));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                CloneCommand command = new CloneCommand(ed, eObject);
                ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                command.getAffectedObjects();
                return command.getHelper().getCopy(eObject);
            }
        };
        EObject result = (EObject)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return result;
    }

    public Collection cloneMultiple(final EObject eObject, final int numClones) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        ArgCheck.isPositive(numClones);
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Clone_{0}_12", this.getPresentationValue(eObject));
        final ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                EditingDomain ed = cntr.getEditingDomain();
                HashSet results = new HashSet();
                for (int i2 = 0; i2 != numClones; ++i2) {
                    CloneCommand command = new CloneCommand(ed, eObject);
                    ModelEditorImpl.this.executeCommandInTransaction(uow, eObject, command);
                    command.getAffectedObjects();
                    results.addAll(command.getResult());
                }
                return results;
            }
        };
        Collection result = (Collection)this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
        return result;
    }

    public boolean isValidParent(Object parent, EObject child) {
        block17: {
            if (parent instanceof EObject) {
                EObject eParent = (EObject)parent;
                EReference ref = this.getChildReference(eParent, child);
                if (ref == null) {
                    return false;
                }
                if (!ref.isContainment()) {
                    return false;
                }
                EClass eParentClass = eParent.eClass();
                EClass eChildClass = child.eClass();
                if (eParentClass != null && eChildClass != null) {
                    URI eParentMetamodelURI = eParentClass.eResource().getURI();
                    URI eChildMetamodelURI = eChildClass.eResource().getURI();
                    if (eParentMetamodelURI != null && !eParentMetamodelURI.equals(eChildMetamodelURI)) {
                        return false;
                    }
                }
                if (ref.isMany()) {
                    return true;
                }
                Object value = eParent.eGet(ref);
                if (value == null) {
                    return true;
                }
            } else {
                if (parent instanceof Resource) {
                    return ModelEditorImpl.isValidRootObject((Resource)parent, child.eClass());
                }
                if (parent instanceof IFile) {
                    try {
                        Resource rsrc;
                        ModelResource mr = this.findModelResource((IFile)parent);
                        if (mr != null && (rsrc = mr.getEmfResource()) != null) {
                            return ModelEditorImpl.isValidRootObject(rsrc, child.eClass());
                        }
                        break block17;
                    }
                    catch (ModelWorkspaceException e2) {
                        return false;
                    }
                }
                if (parent instanceof ModelResource) {
                    try {
                        Resource rsrc = ((ModelResource)parent).getEmfResource();
                        if (rsrc != null) {
                            return ModelEditorImpl.isValidRootObject(rsrc, child.eClass());
                        }
                    }
                    catch (ModelWorkspaceException modelWorkspaceException) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    public boolean isValidPasteParent(Object potentialParent) {
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        if (cntr == null) {
            return false;
        }
        EditingDomain ed = cntr.getEditingDomain();
        if (ed.getClipboard() == null || ed.getClipboard().isEmpty()) {
            return false;
        }
        Iterator children = ed.getClipboard().iterator();
        while (children.hasNext()) {
            EObject next = (EObject)children.next();
            if (this.isValidParent(potentialParent, next)) continue;
            return false;
        }
        return true;
    }

    public EObject create(EClass eClass) {
        return eClass.getEPackage().getEFactoryInstance().create(eClass);
    }

    private Collection createCommands(Collection commandParams, EditingDomain ed) {
        if (commandParams == null) {
            return commandParams;
        }
        ArrayList<AddCommand> commands = new ArrayList<AddCommand>(commandParams.size());
        Iterator iter = commandParams.iterator();
        while (iter.hasNext()) {
            CommandParameter param = (CommandParameter)iter.next();
            EObject eOwner = param.getEOwner();
            Object owner = param.getOwner();
            Command command = null;
            if (eOwner == null && owner instanceof Resource) {
                EObject value = param.getEValue();
                command = new AddCommand(ed, ((Resource)owner).getContents(), value);
            } else {
                CommandParameter newChildParam = new CommandParameter(param.getOwner(), param.getFeature(), param);
                command = ed.createCommand(class$org$eclipse$emf$edit$command$CreateChildCommand == null ? ModelEditorImpl.class$("org.eclipse.emf.edit.command.CreateChildCommand") : class$org$eclipse$emf$edit$command$CreateChildCommand, newChildParam);
            }
            if (param.getFeature() == null) {
                command = new DisabledCommand(command);
            } else {
                boolean disable = this.shouldBeDisabled(owner, param);
                if (disable && command != null) {
                    command = new DisabledCommand(command);
                }
            }
            commands.add((AddCommand)command);
        }
        return commands;
    }

    private Collection getRootDescriptors(Resource rsrc) {
        Collection descriptors;
        ArgCheck.isNotNull(rsrc);
        String primaryMetamodelURI = ModelEditorImpl.getPrimaryMetamodelURI(rsrc);
        if (primaryMetamodelURI == null) {
            return Collections.EMPTY_LIST;
        }
        if (ModelerCore.getMetamodels().getMetamodelDescriptor(primaryMetamodelURI) == null) {
            StringBuffer sb = new StringBuffer();
            descriptors = ModelerCore.getMetamodels().getMetamodelDescriptors();
            Iterator iter = descriptors.iterator();
            while (iter.hasNext()) {
                MetamodelDescriptor mmd = (MetamodelDescriptor)iter.next();
                if (!mmd.isPrimaryMetamodel() || StringUtil.isEmpty(mmd.getURI())) continue;
                sb.append(mmd.getURI());
                sb.append(StringUtil.Constants.SPACE);
            }
            Object[] params = new Object[]{primaryMetamodelURI, sb.toString()};
            String msg = ModelerCore.Util.getString("ModelEditorImpl.No_root_classes_found_for_metamodel_URI", params);
            ModelerCore.Util.log(4, msg);
        }
        List rootClasses = ModelerCore.getMetamodels().getMetamodelRootClasses(primaryMetamodelURI);
        descriptors = ModelEditorImpl.createSiblingDescriptors(rootClasses, ModelerCore.getMetamodels().getFactory(primaryMetamodelURI), rsrc);
        return descriptors;
    }

    private String getPresentationValue(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof EObject) {
            Iterator iter = ((EObject)obj).eClass().getEAllStructuralFeatures().iterator();
            while (iter.hasNext()) {
                EStructuralFeature feature = (EStructuralFeature)iter.next();
                if (!NAME_FEATURE_NAME.equalsIgnoreCase(feature.getName())) continue;
                Object val = ((EObject)obj).eGet(feature);
                if (val == null) {
                    return ((EObject)obj).eClass().getName();
                }
                return val.toString();
            }
            return ((EObject)obj).eClass().getName();
        }
        if (obj instanceof Resource) {
            return URI.decode(((Resource)obj).getURI().toString());
        }
        if (obj instanceof Collection) {
            if (((Collection)obj).size() > 1) {
                return ModelerCore.Util.getString("ModelEditorImpl.many_1");
            }
            if (((Collection)obj).size() == 0) {
                return ModelerCore.Util.getString("ModelEditorImpl.empty_list_2");
            }
            Object first = ((Collection)obj).iterator().next();
            return this.getPresentationValue(first);
        }
        return obj.toString();
    }

    private static void setDescriptorOwner(Collection descriptors, Object owner) {
        ArgCheck.isNotNull(descriptors);
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            Object descriptor = iter.next();
            if (!(descriptor instanceof CommandParameter)) continue;
            ((CommandParameter)descriptor).setOwner(owner);
        }
    }

    private EReference getChildReference(EObject object, Object child) {
        if (child instanceof EObject) {
            EObject eChild = (EObject)child;
            EObject eParent = object;
            EList refs = eParent.eClass().getEAllReferences();
            Iterator childrenReferences = refs.iterator();
            while (childrenReferences.hasNext()) {
                EReference eReference = (EReference)childrenReferences.next();
                EClassifier eType = eReference.getEType();
                if (!eType.isInstance(eChild) || !eReference.isContainment()) continue;
                return eReference;
            }
        }
        return null;
    }

    private ModelAnnotation getModelAnnotation(Resource rsrc) {
        if (rsrc instanceof EmfResource) {
            ModelAnnotation model = ((EmfResource)rsrc).getModelAnnotation();
            return model;
        }
        ModelResource mr = this.findModelResource(rsrc);
        if (mr != null) {
            try {
                ModelAnnotation ma = mr.getModelAnnotation();
                if (ma != null) {
                    return ma;
                }
            }
            catch (ModelWorkspaceException e2) {
                ModelerCore.Util.log(e2);
            }
        }
        Iterator contents = rsrc.getContents().iterator();
        while (contents.hasNext()) {
            EObject next = (EObject)contents.next();
            if (!(next instanceof ModelAnnotation)) continue;
            return (ModelAnnotation)next;
        }
        return null;
    }

    private static String getPrimaryMetamodelURI(Resource rsrc) {
        String primaryMetamodelUri = null;
        if (ModelUtil.isXsdFile(rsrc)) {
            primaryMetamodelUri = "http://www.eclipse.org/xsd/2002/XSD";
        } else if (ModelUtil.isModelFile(rsrc) && rsrc instanceof EmfResource) {
            EmfResource eRsrc = (EmfResource)rsrc;
            if (eRsrc.isLoaded()) {
                ModelAnnotation annotation = eRsrc.getModelAnnotation();
                if (annotation != null) {
                    primaryMetamodelUri = annotation.getPrimaryMetamodelUri();
                }
            } else {
                XMIHeader header = ModelEditorImpl.getXmiHeader(eRsrc);
                if (header != null) {
                    primaryMetamodelUri = header.getPrimaryMetamodelURI();
                }
            }
        } else if (ModelUtil.isVdbArchiveFile(rsrc)) {
            primaryMetamodelUri = "http://www.metamatrix.com/metamodels/VirtualDatabase";
        }
        return primaryMetamodelUri;
    }

    private static Collection createSiblingDescriptors(Collection rootClasses, EFactory factory, Object owner) {
        if (factory == null) {
            return Collections.EMPTY_LIST;
        }
        boolean ownerIsRoot = owner instanceof Resource || owner instanceof EObject && ((EObject)owner).eContainer() == null;
        HashSet<CommandParameter> result = new HashSet<CommandParameter>(rootClasses.size());
        Iterator iter = rootClasses.iterator();
        while (iter.hasNext()) {
            Resource rsrc = null;
            if (owner instanceof Resource) {
                rsrc = (Resource)owner;
            } else if (owner instanceof EObject) {
                rsrc = ((EObject)owner).eResource();
            }
            if (rsrc != null) {
                Object next = iter.next();
                EClass eClass = null;
                int maxOccurs = -1;
                if (next instanceof MetamodelRootClass) {
                    MetamodelRootClass mmrc = (MetamodelRootClass)next;
                    eClass = mmrc.getEClass();
                    maxOccurs = mmrc.getMaxOccurs();
                } else {
                    eClass = (EClass)next;
                }
                EObject child = factory.create(eClass);
                boolean disable = false;
                if (ownerIsRoot && maxOccurs == 0) {
                    disable = true;
                } else if (ownerIsRoot && maxOccurs > 0) {
                    int count = 0;
                    Iterator iterator = rsrc.getContents().iterator();
                    while (iterator.hasNext()) {
                        EObject root = (EObject)iterator.next();
                        if (!root.eClass().equals(eClass)) continue;
                        ++count;
                    }
                    if (count >= maxOccurs) {
                        disable = true;
                    }
                }
                if (disable) {
                    result.add(new CommandParameter((Object)rsrc, null, child));
                    continue;
                }
                result.add(new CommandParameter((Object)rsrc, (Object)rsrc.getContents(), child));
                continue;
            }
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    private static boolean isRootObject(EClass eclass) {
        URI uri = eclass.eResource().getURI();
        List eclasses = ModelerCore.getMetamodels().getRootClasses(uri.toString());
        if (eclasses == null || eclasses.isEmpty()) {
            return false;
        }
        return eclasses.contains(eclass);
    }

    private static boolean isValidRootObject(Resource rsrc, EClass eclass) {
        if (rsrc == null || eclass == null || !ModelEditorImpl.isRootObject(eclass)) {
            return false;
        }
        try {
            String primaryMetamodelUri = ModelEditorImpl.getPrimaryMetamodelURI(rsrc);
            if (primaryMetamodelUri == null) {
                return false;
            }
            List validRoots = ModelerCore.getMetamodels().getRootClasses(primaryMetamodelUri);
            return validRoots.contains(eclass);
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static XMIHeader getXmiHeader(Resource resource) {
        File resourceFile;
        XMIHeader header = null;
        if (resource != null && resource.getURI().isFile() && (resourceFile = new File(resource.getURI().toFileString())).exists()) {
            try {
                header = XMIHeaderReader.readHeader(resourceFile);
            }
            catch (MetaMatrixCoreException e2) {
                ModelerCore.Util.log(4, e2, e2.getLocalizedMessage());
            }
        }
        return header;
    }

    public String getDescription(EObject eObject) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        Annotation annotation = this.getAnnotation(eObject, false);
        if (annotation != null) {
            return annotation.getDescription();
        }
        return null;
    }

    public void setDescription(final EObject eObject, final String desc) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        if (eObject.eIsProxy()) {
            return;
        }
        boolean isSignificant = true;
        String operationDescription = ModelerCore.Util.getString("ModelEditorImpl.Set_Description_on_{0}_14", eObject.toString());
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                if (desc == null || desc.trim().length() == 0) {
                    Annotation annotation = ModelEditorImpl.this.getAnnotation(eObject, false);
                    if (annotation != null) {
                        annotation.setDescription(null);
                        if (annotation.getKeywords().isEmpty() && annotation.getTags().isEmpty()) {
                            annotation.setAnnotationContainer(null);
                        }
                    }
                } else {
                    Annotation annotation = ModelEditorImpl.this.getAnnotation(eObject, true);
                    annotation.setDescription(desc);
                }
                return null;
            }
        };
        this.executeAsTransaction(runnable, cntr, operationDescription, true, (Object)this);
    }

    public ModelResource findModelResource(Resource resource) {
        return ModelerCore.getModelWorkspace().findModelResource(resource);
    }

    public ModelResource findModelResource(EObject eObject) {
        EObject target;
        ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource(eObject);
        if (modelResource == null && eObject instanceof Diagram && (target = ((Diagram)eObject).getTarget()) != null) {
            modelResource = this.findModelResource(target);
        }
        return modelResource;
    }

    public Resource findResource(Container container, EObject eObject) {
        ArgCheck.isNotNull(container);
        ArgCheck.isNotNull(eObject);
        return this.findResource(container, eObject, true);
    }

    public Resource findResource(Container container, EObject eObject, boolean resolve) {
        ArgCheck.isNotNull(eObject);
        ArgCheck.isNotNull(container);
        Resource resource = eObject.eResource();
        if (resolve && resource == null && eObject.eIsProxy()) {
            try {
                URI uri = ((InternalEObject)eObject).eProxyURI();
                resource = container.getResource(uri.trimFragment(), resolve);
            }
            catch (Exception e2) {}
        } else if (eObject instanceof XsdModelAnnotationImpl) {
            resource = ((XsdModelAnnotationImpl)eObject).getResource();
        }
        return resource;
    }

    public ModelResource findModelResource(IFile resource) throws ModelWorkspaceException {
        ArgCheck.isNotNull(resource);
        return (ModelResource)ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(resource);
    }

    public void addModelImport(EmfResource resource, Resource importedResource) throws ModelerCoreException {
        if (resource != null && importedResource != null && resource != importedResource) {
            ModelImport importToAdd;
            URI importedUri = importedResource.getURI();
            URI resourceUri = resource.getURI();
            if (resourceUri.equals(importedUri)) {
                return;
            }
            ModelImport existingImport = this.findModelImport(resource, importedResource);
            if (existingImport != null) {
                return;
            }
            ModelAnnotation modelWithImports = resource.getModelAnnotation();
            if (modelWithImports != null && (importToAdd = this.createModelImport(resource, importedResource)) != null) {
                this.addValue(modelWithImports, importToAdd, modelWithImports.getModelImports());
            }
        }
    }

    public ModelImport createModelImport(EmfResource resource, Resource importedResource) {
        ArgCheck.isNotNull(importedResource);
        if (!this.isValidImportResource(importedResource)) {
            return null;
        }
        ModelImport modelImport = CoreFactory.eINSTANCE.createModelImport();
        modelImport.setName(this.getResourceName(importedResource));
        URI resourceURI = resource.getURI();
        URI importURI = importedResource.getURI();
        String uriString = URI.decode(importURI.toString());
        if (uriString.startsWith("http") || uriString.startsWith("mtkplugin://") || uriString.startsWith("pathmap://UML2_METAMODELS/")) {
            modelImport.setModelLocation(uriString);
        } else if (importURI.isFile()) {
            URI deresolvedURI;
            boolean deresolve;
            boolean bl = deresolve = resourceURI != null && !resourceURI.isRelative() && resourceURI.isHierarchical();
            if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(resourceURI, true, true, false)).hasRelativePath()) {
                importURI = deresolvedURI;
            }
            modelImport.setModelLocation(URI.decode(importURI.toString()));
        } else {
            ResourceSet globalResourceSet = XSDSchemaImpl.getGlobalResourceSet();
            if (globalResourceSet.getResources().contains(importedResource)) {
                if (importedResource == XSDSchemaImpl.getSchemaForSchema("http://www.w3.org/2001/XMLSchema").eResource()) {
                    modelImport.setModelLocation("http://www.w3.org/2001/XMLSchema");
                } else if (importedResource == XSDSchemaImpl.getSchemaInstance("http://www.w3.org/2001/XMLSchema-instance").eResource()) {
                    modelImport.setModelLocation("http://www.w3.org/2001/XMLSchema-instance");
                } else if (importedResource == XSDSchemaImpl.getMagicSchemaForSchema("http://www.w3.org/2001/XMLSchema").eResource()) {
                    modelImport.setModelLocation(ResourceFinder.MAGIC_SCHEMA_URI.toString());
                }
            } else {
                modelImport.setModelLocation(URI.decode(importURI.toString()));
            }
        }
        if (importedResource instanceof EmfResource) {
            EmfResource emfResource = (EmfResource)importedResource;
            modelImport.setModelType(emfResource.getModelType());
            modelImport.setPrimaryMetamodelUri(emfResource.getPrimaryMetamodelUri().toString());
            modelImport.setUuid(((Object)emfResource.getUuid()).toString());
        } else if (importedResource instanceof XSDResourceImpl) {
            modelImport.setModelType(ModelType.TYPE_LITERAL);
            modelImport.setPrimaryMetamodelUri("http://www.eclipse.org/xsd/2002/XSD");
        }
        return modelImport;
    }

    protected boolean isValidImportResource(Resource importedResource) {
        if (importedResource instanceof EmfResource) {
            EmfResource emfResource = (EmfResource)importedResource;
            if (emfResource.getModelType() == null) {
                return false;
            }
            if (emfResource.getPrimaryMetamodelUri() == null) {
                return false;
            }
            return emfResource.getUuid() != null;
        }
        return importedResource instanceof XSDResourceImpl;
    }

    public void updateModelImport(ModelImport modelImport, Resource importedResource) {
        ArgCheck.isNotNull(modelImport);
        ArgCheck.isNotNull(importedResource);
        Resource resource = modelImport.eResource();
        if (resource != null) {
            URI resourceURI = resource.getURI();
            URI importURI = importedResource.getURI();
            Container cntr = ModelerCore.getContainer(resource);
            if (cntr != null && cntr.getResourceFinder().isBuiltInResource(importedResource)) {
                return;
            }
            if (importURI.isFile()) {
                URI deresolvedURI;
                boolean deresolve;
                boolean bl = deresolve = resourceURI != null && !resourceURI.isRelative() && resourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(resourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
                modelImport.setName(importURI.trimFileExtension().lastSegment());
                modelImport.setModelLocation(URI.decode(importURI.toString()));
            }
        }
    }

    public void removeModelImport(EmfResource resource, Resource importedResource) throws ModelerCoreException {
        if (resource != null && importedResource != null && resource != importedResource) {
            ModelAnnotation modelWithImports;
            ModelImport importToRemove = this.findModelImport(resource, importedResource);
            if (importToRemove == null) {
                return;
            }
            Container cntr = ModelerCore.getContainer(resource);
            if (cntr != null) {
                ResourceFinder finder = cntr.getResourceFinder();
                Resource[] refs = finder.findReferencesFrom(resource, true, true);
                for (int i2 = 0; i2 != refs.length; ++i2) {
                    if (importedResource != refs[i2]) continue;
                    return;
                }
            }
            if ((modelWithImports = resource.getModelAnnotation()) != null) {
                this.removeValue(modelWithImports, importToRemove, modelWithImports.getModelImports());
            }
        }
    }

    public ModelImport findModelImport(EmfResource resource, Resource importedResource) {
        block17: {
            block16: {
                ArgCheck.isNotNull(resource);
                if (importedResource == null) {
                    return null;
                }
                Container cntr = ModelerCore.getContainer(resource);
                if (cntr == null) break block16;
                ResourceFinder finder = cntr.getResourceFinder();
                ModelAnnotation modelAnnot = resource.getModelAnnotation();
                if (modelAnnot == null || modelAnnot.getModelImports() == null) break block17;
                Iterator iter = modelAnnot.getModelImports().iterator();
                while (iter.hasNext()) {
                    ModelImport modelImport = (ModelImport)iter.next();
                    Resource r2 = finder.findByImport(modelImport, true);
                    if (r2 != importedResource) continue;
                    return modelImport;
                }
                break block17;
            }
            String importedResourceUuid = null;
            String importedResourceLocation = null;
            if (importedResource instanceof EmfResource) {
                importedResourceUuid = ((Object)((EmfResource)importedResource).getUuid()).toString();
            }
            URI resourceURI = resource.getURI();
            URI importURI = importedResource.getURI();
            if (XSDSchemaImpl.getGlobalResourceSet().getResources().contains(importedResource)) {
                if (importedResource == XSDSchemaImpl.getSchemaForSchema("http://www.w3.org/2001/XMLSchema").eResource()) {
                    importURI = ResourceFinder.SCHEMA_FOR_SCHEMA_URI;
                } else if (importedResource == XSDSchemaImpl.getSchemaInstance("http://www.w3.org/2001/XMLSchema-instance").eResource()) {
                    importURI = ResourceFinder.SCHEMA_INSTANCE_URI;
                } else if (importedResource == XSDSchemaImpl.getMagicSchemaForSchema("http://www.w3.org/2001/XMLSchema").eResource()) {
                    importURI = ResourceFinder.MAGIC_SCHEMA_URI;
                }
            } else if (resourceURI.isFile() && importURI.isFile()) {
                URI deresolvedURI;
                boolean deresolve;
                boolean bl = deresolve = resourceURI != null && !resourceURI.isRelative() && resourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(resourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                }
            }
            importedResourceLocation = importURI.toString();
            ModelAnnotation modelAnnot = resource.getModelAnnotation();
            if (modelAnnot != null) {
                EList modelImports = modelAnnot.getModelImports();
                if (modelImports.isEmpty()) {
                    return null;
                }
                Iterator iter = modelImports.iterator();
                while (iter.hasNext()) {
                    ModelImport modelImport = (ModelImport)iter.next();
                    String modelImportUuid = modelImport.getUuid();
                    if (modelImportUuid != null && modelImportUuid.equalsIgnoreCase(importedResourceUuid)) {
                        return modelImport;
                    }
                    String modelLocation = modelImport.getModelLocation();
                    if (modelLocation == null || !modelLocation.equalsIgnoreCase(importedResourceLocation)) continue;
                    return modelImport;
                }
            }
        }
        return null;
    }

    public Annotation getAnnotation(EObject eObject, boolean forceCreate) throws ModelerCoreException {
        Resource eObjectResource = eObject.eResource();
        if (eObjectResource instanceof EmfResource) {
            EmfResource emfResource = (EmfResource)eObjectResource;
            ModelContents contents = emfResource.getModelContents();
            Annotation annotation = contents.getAnnotation(eObject);
            if (annotation == null && forceCreate) {
                annotation = ModelResourceContainerFactory.createNewAnnotation(eObject, contents.getAnnotationContainer(true));
            }
            return annotation;
        }
        if (eObjectResource instanceof MetamodelResourceImpl) {
            return null;
        }
        return null;
    }

    public Annotation getAnnotation(ModelResource modelResource, EObject eObject, boolean forceCreate) throws ModelerCoreException {
        return this.getAnnotation(eObject, forceCreate);
    }

    public EObject getExtension(EObject eObject) throws ModelerCoreException {
        XClass xclass;
        XPackage extPackage;
        XSDResourceImpl xsdResource;
        XSDSchema xsdSchema;
        ArgCheck.isNotNull(eObject);
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        if (EcorePackage.eINSTANCE.equals(ePackage)) {
            return null;
        }
        Resource emfResource = eObject.eResource();
        if (emfResource == null) {
            return null;
        }
        if (emfResource instanceof EmfResource) {
            XClass xclass2;
            XPackage extPackage2;
            ModelAnnotation model = this.getModelAnnotation(emfResource);
            if (model != null && (extPackage2 = model.getExtensionPackage()) != null && (xclass2 = extPackage2.findXClass(eClass)) != null) {
                ObjectExtension result = null;
                try {
                    XPackage pkg = extPackage2;
                    ExtensionFactoryImpl factory = null;
                    EFactory existingFactory = pkg.getEFactoryInstance();
                    if (existingFactory == null || !(existingFactory instanceof ExtensionFactory)) {
                        factory = new ExtensionFactoryImpl();
                        factory.setEPackage(extPackage2);
                    }
                    result = new ObjectExtension(eObject, xclass2, this);
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                }
                return result;
            }
        } else if (emfResource instanceof XSDResourceImpl && (xsdSchema = (xsdResource = (XSDResourceImpl)emfResource).getSchema()) != null && (extPackage = XsdObjectExtension.getExtensionPackage(xsdSchema)) != null && (xclass = extPackage.findXClass(eClass)) != null) {
            XsdObjectExtension result = null;
            try {
                XPackage pkg = extPackage;
                ExtensionFactoryImpl factory = null;
                EFactory existingFactory = pkg.getEFactoryInstance();
                if (existingFactory == null || !(existingFactory instanceof ExtensionFactory)) {
                    factory = new ExtensionFactoryImpl();
                    factory.setEPackage(extPackage);
                }
                result = new XsdObjectExtension(eObject, xclass, this);
            }
            catch (Throwable e3) {
                String msg = ModelerCore.Util.getString("ModelEditorImpl.getExtension_0", xsdSchema);
                throw new ModelerCoreException(msg);
            }
            return result;
        }
        return null;
    }

    public ModelResource findModelResource(ModelImport modelImport) {
        ArgCheck.isNotNull(modelImport);
        Path pathInWorkspace = new Path(modelImport.getPath());
        return ModelerCore.getModelWorkspace().findModelResource(pathInWorkspace);
    }

    public URI getUri(EObject object) {
        Resource eResource;
        ArgCheck.isNotNull(object);
        if (object instanceof EClass && (eResource = object.eResource()) != null && ModelerCore.getPlugin() != null) {
            try {
                URI eResourceUri = eResource.getURI();
                MetamodelDescriptor descriptor = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor(eResourceUri);
                if (descriptor != null) {
                    String logicalUri = URI.decode(descriptor.getURI());
                    return URI.createURI(logicalUri).appendFragment(eResource.getURIFragment(object));
                }
            }
            catch (ModelerCoreException e2) {
                ModelerCore.Util.log(4, e2, e2.getLocalizedMessage());
            }
        }
        return EcoreUtil.getURI(object);
    }

    public Object getObjectID(EObject object) {
        ArgCheck.isNotNull(object);
        if (object.getObjectId() != null) {
            return object.getObjectId();
        }
        return EcoreUtil.getURI(object).toString();
    }

    public String getSearchIndexObjectID(EObject eObject) {
        ArgCheck.isNotNull(eObject);
        Object objId = null;
        SqlAspect sqlAspect = AspectManager.getSqlAspect(eObject);
        if (sqlAspect != null) {
            objId = sqlAspect instanceof SqlAnnotationAspect ? this.getObjectID(eObject) : sqlAspect.getObjectID(eObject);
        } else if (eObject instanceof XSDConcreteComponent) {
            if (eObject.eIsProxy()) {
                URI proxyURI = EcoreUtil.getURI(eObject);
                if (proxyURI != null) {
                    objId = proxyURI.fragment();
                }
            } else if (eObject.eResource() != null) {
                objId = eObject.eResource().getURIFragment(eObject);
            }
        } else {
            objId = this.getObjectID(eObject);
        }
        if (objId != null) {
            return objId.toString();
        }
        return null;
    }

    public EObject findObject(Object objectId) throws ModelerCoreException {
        ArgCheck.isNotNull(objectId);
        ContainerImpl cntr = ModelEditorImpl.getContainer();
        return this.findObject(objectId, cntr);
    }

    protected EObject findObject(Object objectId, Container container) {
        if (container == null) {
            return null;
        }
        EObject result = null;
        Object resolvedObjectId = null;
        if (objectId instanceof String) {
            String stringId = (String)objectId;
            try {
                resolvedObjectId = IDGenerator.getInstance().stringToObject(stringId);
            }
            catch (InvalidIDException e1) {
                // empty catch block
            }
            if (resolvedObjectId == null) {
                try {
                    resolvedObjectId = URI.createURI(stringId);
                }
                catch (IllegalArgumentException e2) {}
            }
        } else if (objectId instanceof URI) {
            resolvedObjectId = objectId;
        } else if (objectId instanceof ObjectID) {
            resolvedObjectId = objectId;
        }
        if (result == null && resolvedObjectId != null) {
            EObjectFinder finder = container.getEObjectFinder();
            result = (EObject)finder.find(resolvedObjectId);
        }
        return result;
    }

    public EObject findObject(Object objectId, ModelResource resource, IProgressMonitor monitor) throws ModelerCoreException {
        ArgCheck.isNotNull(objectId);
        ArgCheck.isNotNull(resource);
        if (!resource.isLoaded() || !resource.isOpen()) {
            resource.open(monitor);
            resource.getEmfResource();
        }
        return this.findObject(objectId);
    }

    public Object getChangedObject(Notification notification) {
        ArgCheck.isNotNull(notification);
        return notification.getNotifier();
    }

    public EObject findObjectByPath(Resource resource, IPath modelRelativePath) {
        ArgCheck.isNotNull(resource);
        ArgCheck.isNotNull(modelRelativePath);
        EObject object = null;
        EList children = resource.getContents();
        String[] segments = modelRelativePath.segments();
        for (int i2 = 0; i2 < segments.length; ++i2) {
            String segment = segments[i2];
            object = this.findChildByLabel(children, segment);
            if (object == null) {
                return null;
            }
            children = object.eContents();
        }
        return object;
    }

    protected EObject findChildByLabel(Collection children, String label) {
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            EObject child = (EObject)iter.next();
            AdapterFactory adapterFactory = ModelerCore.getMetamodels().getEmfAdapterFactory();
            IItemLabelProvider provider = (IItemLabelProvider)((Object)adapterFactory.adapt(child, (Object)(class$org$eclipse$emf$edit$provider$IItemLabelProvider == null ? ModelEditorImpl.class$("org.eclipse.emf.edit.provider.IItemLabelProvider") : class$org$eclipse$emf$edit$provider$IItemLabelProvider)));
            String objName = this.formatLabel(provider.getText(child));
            if (!objName.equals(label)) continue;
            return child;
        }
        return null;
    }

    public EObject findObjectByPath(ModelResource resource, IPath modelRelativePath) throws ModelWorkspaceException {
        ArgCheck.isNotNull(resource);
        ArgCheck.isNotNull(modelRelativePath);
        Resource emfResource = resource.getEmfResource();
        return this.findObjectByPath(emfResource, modelRelativePath);
    }

    public IPath getModelRelativePath(EObject object) {
        return this.getModelRelativePath(object, true);
    }

    public IPath getModelRelativePath(EObject object, boolean includeUnnamedObjects) {
        ArgCheck.isNotNull(object);
        return this.computeModelRelativePath(object, false, includeUnnamedObjects);
    }

    public IPath getModelRelativePathIncludingModel(EObject object) {
        return this.getModelRelativePathIncludingModel(object, true);
    }

    public IPath getModelRelativePathIncludingModel(EObject object, boolean includeUnnamedObjects) {
        ArgCheck.isNotNull(object);
        return this.computeModelRelativePath(object, true, includeUnnamedObjects);
    }

    public IPath getFullPathToParent(EObject object) {
        ArgCheck.isNotNull(object);
        Resource resource = object.eResource();
        if (resource == null) {
            return Path.ROOT;
        }
        String resourcePathStr = this.getResourcePath(resource);
        if (resourcePathStr == null) {
            return Path.ROOT;
        }
        Path resourcePath = new Path(resourcePathStr);
        EObject container = object.eContainer();
        if (container != null) {
            IPath relPathWithoutModel = this.computeModelRelativePath(container, false);
            return resourcePath.append(relPathWithoutModel);
        }
        return resourcePath;
    }

    protected IPath computeModelRelativePath(EObject object, boolean includeModelInPath) {
        return this.computeModelRelativePath(object, includeModelInPath, true);
    }

    protected IPath computeModelRelativePath(EObject object, boolean includeModelInPath, boolean includeUnnamedObjects) {
        String modelName;
        AdapterFactory adapterFactory = ModelerCore.getMetamodels().getEmfAdapterFactory();
        IPath path = new Path("");
        EObject tmp = object;
        if (tmp instanceof XSDParticle) {
            path = this.updatePath(path, ((XSDParticle)tmp).getTerm(), adapterFactory, includeUnnamedObjects);
            tmp = tmp.eContainer();
        }
        while (tmp != null) {
            if (!(tmp instanceof XSDParticle)) {
                path = this.updatePath(path, tmp, adapterFactory, includeUnnamedObjects);
            }
            tmp = tmp.eContainer();
        }
        if (includeModelInPath && (modelName = this.getModelName(object)) != null) {
            path = new Path(modelName).append(path);
        }
        return path;
    }

    private IPath updatePath(IPath path, EObject eObject, AdapterFactory factory, boolean includeUnnamedObjects) {
        if (!includeUnnamedObjects && !this.hasName(eObject)) {
            return path;
        }
        IItemLabelProvider provider = (IItemLabelProvider)((Object)factory.adapt(eObject, (Object)(class$org$eclipse$emf$edit$provider$IItemLabelProvider == null ? (class$org$eclipse$emf$edit$provider$IItemLabelProvider = ModelEditorImpl.class$("org.eclipse.emf.edit.provider.IItemLabelProvider")) : class$org$eclipse$emf$edit$provider$IItemLabelProvider)));
        String objName = this.formatLabel(provider.getText(eObject));
        return new Path(objName).append(path);
    }

    private String formatLabel(String name) {
        int ndx = name.indexOf(58);
        if (ndx >= 0) {
            return name.substring(0, ndx).trim();
        }
        return name;
    }

    public String getModelName(EObject object) {
        ArgCheck.isNotNull(object);
        if (object.eIsProxy()) {
            URI proxyUri = ((InternalEObject)object).eProxyURI();
            URI resourceUri = proxyUri.trimFragment();
            return this.getModelName(resourceUri);
        }
        if (object.eResource() != null) {
            return this.getModelName(object.eResource().getURI());
        }
        return "";
    }

    public String getModelName(Resource resource) {
        ArgCheck.isNotNull(resource);
        return this.getModelName(resource.getURI());
    }

    public String getModelName(URI resourceUri) {
        ArgCheck.isNotNull(resourceUri);
        return resourceUri.trimFileExtension().lastSegment();
    }

    public String getModelName(ModelResource modelResource) {
        ArgCheck.isNotNull(modelResource);
        IResource modelFile = modelResource.getResource();
        String modelName = null;
        if (modelFile instanceof IFile) {
            IFile theFile = (IFile)modelFile;
            String extension = theFile.getFileExtension();
            modelName = theFile.getName();
            if (extension != null) {
                int indexOfExtension = modelName.lastIndexOf(extension);
                modelName = indexOfExtension == 0 ? "" : modelName.substring(0, indexOfExtension - 1);
            }
        } else {
            modelName = modelResource.getItemName();
        }
        return modelName;
    }

    public Collection getAllContainers(Resource resource) {
        if (resource == null || !(resource instanceof EmfResource)) {
            return Collections.EMPTY_LIST;
        }
        return ModelResourceContainerFactory.getAllContainers(resource, true);
    }

    public String getResourcePath(Resource resource) {
        ArgCheck.isNotNull(resource);
        return WorkspaceResourceFinderUtil.getWorkspaceUri(resource);
    }

    private String getResourceName(Resource resource) {
        int index;
        ArgCheck.isNotNull(resource);
        URI resourceUri = resource.getURI();
        String modelNameWithExt = resourceUri.lastSegment();
        String extension = resourceUri.fileExtension();
        if (extension != null && (index = modelNameWithExt.indexOf(extension)) > 1) {
            return modelNameWithExt.substring(0, index - 1);
        }
        return modelNameWithExt;
    }

    public static Command createCopyCommand(EditingDomain domain, Object owner, CopyCommand.Helper helper) {
        return domain.createCommand(class$org$eclipse$emf$edit$command$CopyCommand == null ? (class$org$eclipse$emf$edit$command$CopyCommand = ModelEditorImpl.class$("org.eclipse.emf.edit.command.CopyCommand")) : class$org$eclipse$emf$edit$command$CopyCommand, new CommandParameter(owner, null, helper));
    }

    public static Command createCopyCommand(EditingDomain domain, Collection collection, CopyCommand.Helper helper) {
        if (collection == null || collection.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CopyCommand.Helper copyHelper = helper;
        CompoundCommand copyCommand = CompoundCommandFactory.create(Integer.MAX_VALUE);
        Iterator objects = collection.iterator();
        while (objects.hasNext()) {
            copyCommand.append(domain.createCommand(class$org$eclipse$emf$edit$command$CopyCommand == null ? ModelEditorImpl.class$("org.eclipse.emf.edit.command.CopyCommand") : class$org$eclipse$emf$edit$command$CopyCommand, new CommandParameter(objects.next(), null, copyHelper)));
        }
        return copyCommand.unwrap();
    }

    public ModelContents getModelContents(EObject eObject) {
        ArgCheck.isNotNull(eObject);
        Resource resource = eObject.eResource();
        return this.getModelContents(resource);
    }

    public ModelContents getModelContents(Resource resource) {
        ArgCheck.isNotNull(resource);
        if (resource instanceof EmfResource) {
            return ((EmfResource)resource).getModelContents();
        }
        ModelResource modelResource = this.findModelResource(resource);
        return this.getModelContents(modelResource);
    }

    public ModelContents getModelContents(ModelResource modelResource) {
        ArgCheck.isNotNull(modelResource);
        try {
            return ModelContents.getModelContents(modelResource);
        }
        catch (ModelWorkspaceException e2) {
            ModelerCore.Util.log(e2);
            return null;
        }
    }

    public ModelAnnotation getModelAnnotation(EObject eObject) throws ModelerCoreException {
        ArgCheck.isNotNull(eObject);
        Resource resource = eObject.eResource();
        if (resource instanceof EmfResource) {
            return ((EmfResource)resource).getModelAnnotation();
        }
        ModelResource modelResource = resource == null ? null : this.findModelResource(resource);
        return modelResource == null ? null : modelResource.getModelAnnotation();
    }

    protected static SqlDatatypeAspect getSqlAspect(EObject obj) {
        if (obj != null && obj instanceof XSDSimpleTypeDefinition) {
            return (SqlDatatypeAspect)ModelerCore.getMetamodels().getMetamodelAspect(obj, "sqlAspect");
        }
        return null;
    }

    private static EObject resolveWhenProxy(EObject e2) {
        EObject resolvedEObject = e2;
        if (e2.eIsProxy() && (resolvedEObject = EcoreUtil.resolve(e2, ModelEditorImpl.getContainer())).eIsProxy()) {
            throw new MetaMatrixRuntimeException(ModelerCore.Util.getString("ModelEditorImpl.Error_EObject_can_not_be_a_proxy", resolvedEObject.toString()));
        }
        return resolvedEObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CompoundCommandFactory {
        public static CompoundCommand create(int index) {
            return new CompoundCommand(index);
        }

        public static CompoundCommand create(Object owner, List commands) {
            if (owner instanceof XSDConcreteComponent) {
                return new SafeRemoveCompoundCommand(commands);
            }
            if (owner instanceof Collection) {
                Collection col = (Collection)owner;
                Iterator itor = col.iterator();
                while (itor.hasNext()) {
                    Object element = itor.next();
                    if (!(element instanceof XSDConcreteComponent)) continue;
                    return new SafeRemoveCompoundCommand(commands);
                }
            }
            return new CompoundCommand(commands);
        }
    }

    public static class AddCommandFactory {
        public static AddCommand create(Object owner, EditingDomain domain, EList list, Collection collection, int index) {
            if (owner instanceof XSDConcreteComponent) {
                return new XsdConcreteComponentAddCommand(domain, list, collection, index);
            }
            return new AddCommand(domain, list, collection, index);
        }
    }

    public class RemoveValueFromMapCommand
    extends AbstractOverrideableCommand {
        private Object owner;
        private Map map;
        private Object key;
        private Object oldValue;

        public RemoveValueFromMapCommand(EditingDomain ed, Object owner, Map map, Object key) {
            super(ed);
            this.owner = owner;
            this.map = map;
            this.key = key;
            if (map != null) {
                this.oldValue = map.get(key);
            }
        }

        public void doExecute() {
            this.map.remove(this.key);
            if (this.key == null && this.owner instanceof XSDSchema) {
                ((XSDSchema)this.owner).getElement().removeAttribute("xmlns");
            }
            if (this.owner instanceof EObject) {
                ((EObject)this.owner).eNotify(new ENotificationImpl((InternalEObject)this.owner, 4, null, this.oldValue, null));
            }
        }

        public void doRedo() {
            this.map.remove(this.key);
            if (this.key == null && this.owner instanceof XSDSchema) {
                ((XSDSchema)this.owner).getElement().removeAttribute("xmlns");
            }
            if (this.owner instanceof EObject) {
                ((EObject)this.owner).eNotify(new ENotificationImpl((InternalEObject)this.owner, 4, null, this.oldValue, null));
            }
        }

        public void doUndo() {
            if (this.oldValue != null) {
                this.map.put(this.key, this.oldValue);
                if (this.owner instanceof EObject) {
                    ((EObject)this.owner).eNotify(new ENotificationImpl((InternalEObject)this.owner, 3, null, null, this.oldValue));
                }
            }
        }

        protected boolean prepare() {
            if (this.map == null || this.domain == null) {
                this.isExecutable = false;
                return false;
            }
            this.isExecutable = true;
            this.isPrepared = true;
            return true;
        }
    }

    public class AddValueToMapCommand
    extends AbstractOverrideableCommand {
        private Object owner;
        private Map map;
        private Object key;
        private Object oldValue;
        private Object newValue;

        public AddValueToMapCommand(EditingDomain ed, Object owner, Map map, Object key, Object newValue) {
            super(ed);
            this.owner = owner;
            this.map = map;
            this.key = key;
            this.newValue = newValue;
            if (map != null) {
                this.oldValue = map.get(key);
            }
        }

        public void doExecute() {
            this.map.put(this.key, this.newValue);
            if (this.owner instanceof EObject) {
                ((EObject)this.owner).eNotify(new ENotificationImpl((InternalEObject)this.owner, 3, null, this.oldValue, this.newValue));
            }
        }

        public void doRedo() {
            this.map.put(this.key, this.newValue);
            if (this.owner instanceof EObject) {
                ((EObject)this.owner).eNotify(new ENotificationImpl((InternalEObject)this.owner, 3, null, this.oldValue, this.newValue));
            }
        }

        public void doUndo() {
            if (this.oldValue != null) {
                this.map.put(this.key, this.oldValue);
            } else {
                this.map.remove(this.key);
                if (this.key == null && this.owner instanceof XSDSchema) {
                    ((XSDSchema)this.owner).getElement().removeAttribute("xmlns");
                }
            }
            if (this.owner instanceof EObject) {
                ((EObject)this.owner).eNotify(new ENotificationImpl((InternalEObject)this.owner, 4, null, this.newValue, this.oldValue != null ? this.oldValue : null));
            }
        }

        protected boolean prepare() {
            if (this.map == null || this.newValue == null || this.domain == null) {
                this.isExecutable = false;
                return false;
            }
            this.isExecutable = true;
            this.isPrepared = true;
            return true;
        }
    }

    public class EnterpriseDatatypeInfoUnsetCommand
    extends AbstractOverrideableCommand {
        private EnterpriseDatatypeInfo oldEdtInfo;
        private final XSDSimpleTypeDefinition simpleType;

        public EnterpriseDatatypeInfoUnsetCommand(EditingDomain ed, XSDSimpleTypeDefinition simpleType, EnterpriseDatatypeInfo oldEdtInfo) {
            super(ed);
            this.simpleType = simpleType;
            this.oldEdtInfo = oldEdtInfo;
        }

        protected void invokeUnsetOperation() {
            ModelEditorImpl.getSqlAspect(this.simpleType).unSetEnterpriseDataAttributes((XSDSimpleTypeDefinition)ModelEditorImpl.resolveWhenProxy(this.simpleType));
        }

        protected void invokeSetOperation(EnterpriseDatatypeInfo edtInfo) {
            ModelEditorImpl.getSqlAspect(this.simpleType).setEnterpriseDataAttributes((XSDSimpleTypeDefinition)ModelEditorImpl.resolveWhenProxy(this.simpleType), edtInfo);
        }

        public void doExecute() {
            this.invokeUnsetOperation();
            this.simpleType.eNotify(new ENotificationImpl((InternalEObject)((Object)this.simpleType), 2, this.simpleType.eClass().getEStructuralFeature(5), (Object)this.oldEdtInfo, null));
        }

        public void doRedo() {
            this.invokeUnsetOperation();
            this.simpleType.eNotify(new ENotificationImpl((InternalEObject)((Object)this.simpleType), 2, this.simpleType.eClass().getEStructuralFeature(5), (Object)this.oldEdtInfo, null));
        }

        public void doUndo() {
            this.invokeSetOperation(this.oldEdtInfo);
            this.simpleType.eNotify(new ENotificationImpl((InternalEObject)((Object)this.simpleType), 1, this.simpleType.eClass().getEStructuralFeature(5), null, (Object)this.oldEdtInfo));
        }

        protected boolean prepare() {
            if (this.simpleType == null || this.domain == null) {
                this.isExecutable = false;
                return false;
            }
            this.isExecutable = true;
            this.isPrepared = true;
            return true;
        }
    }

    public class EnterpriseDatatypeInfoSetCommand
    extends AbstractOverrideableCommand {
        private EnterpriseDatatypeInfo oldEdtInfo;
        private final EnterpriseDatatypeInfo newEdtInfo;
        private final XSDSimpleTypeDefinition simpleType;

        public EnterpriseDatatypeInfoSetCommand(EditingDomain ed, XSDSimpleTypeDefinition simpleType, EnterpriseDatatypeInfo newEdtInfo, EnterpriseDatatypeInfo oldEdtInfo) {
            super(ed);
            this.simpleType = simpleType;
            this.newEdtInfo = newEdtInfo;
            this.oldEdtInfo = oldEdtInfo;
        }

        protected void invokeSetOperation(EnterpriseDatatypeInfo edtInfo) {
            ModelEditorImpl.getSqlAspect(this.simpleType).setEnterpriseDataAttributes((XSDSimpleTypeDefinition)ModelEditorImpl.resolveWhenProxy(this.simpleType), edtInfo);
        }

        public void doExecute() {
            this.invokeSetOperation(this.newEdtInfo);
            this.simpleType.eNotify(new ENotificationImpl((InternalEObject)((Object)this.simpleType), 1, this.simpleType.eClass().getEStructuralFeature(5), (Object)this.oldEdtInfo, (Object)this.newEdtInfo));
        }

        public void doRedo() {
            this.invokeSetOperation(this.newEdtInfo);
            this.simpleType.eNotify(new ENotificationImpl((InternalEObject)((Object)this.simpleType), 1, this.simpleType.eClass().getEStructuralFeature(5), (Object)this.oldEdtInfo, (Object)this.newEdtInfo));
        }

        public void doUndo() {
            this.invokeSetOperation(this.oldEdtInfo);
            this.simpleType.eNotify(new ENotificationImpl((InternalEObject)((Object)this.simpleType), 2, this.simpleType.eClass().getEStructuralFeature(5), (Object)this.newEdtInfo, (Object)this.oldEdtInfo));
        }

        protected boolean prepare() {
            if (this.simpleType == null || this.newEdtInfo == null || this.domain == null) {
                this.isExecutable = false;
                return false;
            }
            this.isExecutable = true;
            this.isPrepared = true;
            return true;
        }
    }
}

