/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.TransactionRunnable;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.builder.ModelBuildUtil;
import com.metamatrix.modeler.internal.core.index.AbstractIndexSelector;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelResourceIndexSelector
extends AbstractIndexSelector {
    private static final Index[] EMPTY_INDEX_ARRAY = new Index[0];
    private MtkXmiResourceImpl resource;
    private Index[] indexes;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$core$resource$xmi$MtkXmiResourceImpl;

    public ModelResourceIndexSelector(Resource resource) {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$internal$core$resource$xmi$MtkXmiResourceImpl == null ? (class$com$metamatrix$modeler$internal$core$resource$xmi$MtkXmiResourceImpl = ModelResourceIndexSelector.class$("com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl")) : class$com$metamatrix$modeler$internal$core$resource$xmi$MtkXmiResourceImpl, resource);
        this.resource = (MtkXmiResourceImpl)resource;
    }

    public Index[] getIndexes() throws IOException {
        boolean indexesUpdated = this.updateIndexes();
        if (indexesUpdated || this.indexes == null) {
            ObjectVector tmp = new ObjectVector();
            List modelImports = this.getModelImports();
            File[] indexFiles = this.getIndexFiles(modelImports);
            for (int i2 = 0; i2 < indexFiles.length; ++i2) {
                File indexFile = indexFiles[i2];
                if (!IndexUtil.indexFileExists(indexFile.getAbsolutePath())) continue;
                tmp.add(new Index(indexFile.getAbsolutePath(), true));
            }
            this.indexes = new Index[tmp.size()];
            tmp.copyInto(this.indexes);
        }
        return this.indexes;
    }

    public List getModelImports() {
        ModelAnnotation model = this.resource.getModelAnnotation();
        if (model != null) {
            return model.getModelImports();
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getNonIndexedResources() {
        List imports = this.getModelImports();
        ArrayList<IResource> iResources = new ArrayList<IResource>(imports.size() + 1);
        Iterator importIter = imports.iterator();
        while (importIter.hasNext()) {
            ModelResource importResource;
            ModelImport mdlImport = (ModelImport)importIter.next();
            String importedResourcePath = mdlImport.getPath();
            if (importedResourcePath == null || (importResource = ModelerCore.getModelWorkspace().findModelResource(new Path(importedResourcePath))) == null || importResource.getIndexType() == 3 || importResource.getIndexType() == 1) continue;
            iResources.add(importResource.getResource());
        }
        ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource(this.getResource());
        if (modelResource.getIndexType() != 3 && modelResource.getIndexType() != 1) {
            iResources.add(modelResource.getResource());
        }
        return iResources;
    }

    private boolean updateIndexes() {
        try {
            final Collection nonIndexedResources = this.getNonIndexedResources();
            if (nonIndexedResources != null && !nonIndexedResources.isEmpty()) {
                TransactionRunnable runnable = new TransactionRunnable(){

                    public Object run(UnitOfWork uow) throws ModelerCoreException {
                        ModelBuildUtil.createModelIndexes(null, nonIndexedResources);
                        return null;
                    }
                };
                ModelerCore.getModelEditor().executeAsTransaction(runnable, "Updating ModelIndexes", false, false, (Object)this);
                return true;
            }
        }
        catch (CoreException e2) {
            ModelerCore.Util.log(4, e2, ModelerCore.Util.getString("ModelResourceIndexSelector.0"));
        }
        return false;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ModelResourceIndexSelector [");
        Index[] indexes = EMPTY_INDEX_ARRAY;
        try {
            indexes = this.getIndexes();
        }
        catch (IOException e2) {
            // empty catch block
        }
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(indexes[i2].getIndexFile());
        }
        sb.append("]");
        return sb.toString();
    }

    private File[] getIndexFiles(List modelImports) {
        ArgCheck.isNotNull(modelImports);
        ObjectVector tmp = new ObjectVector();
        Iterator iter = modelImports.iterator();
        while (iter.hasNext()) {
            File indexFile;
            ModelImport modelImport = (ModelImport)iter.next();
            if (modelImport == null || (indexFile = this.getIndexFile(modelImport)) == null || !indexFile.exists()) continue;
            tmp.add(indexFile);
        }
        File rsrcIndexFile = new File(IndexUtil.INDEX_PATH, IndexUtil.getRuntimeIndexFileName(this.resource));
        if (rsrcIndexFile.exists()) {
            tmp.add(rsrcIndexFile);
        }
        Object[] result = new File[tmp.size()];
        tmp.copyInto(result);
        return result;
    }

    private File getIndexFile(ModelImport modelImport) {
        String indexFileName = null;
        try {
            indexFileName = IndexUtil.getRuntimeIndexFileName(modelImport.getPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (indexFileName != null) {
            return new File(IndexUtil.INDEX_PATH, indexFileName);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

