/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.index.IDocument;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.internal.core.xml.xmi.XMIHeader;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.MetamodelDescriptor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.index.ModelDocument;
import com.metamatrix.modeler.core.index.ResourceDocument;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.index.ModelIndexer;
import com.metamatrix.modeler.internal.core.search.runtime.SearchRuntimeAdapter;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelSearchIndexer
extends ModelIndexer {
    private static String INDEX_TYPES = ModelerCore.Util.getString("ModelSearchIndexer.Search_Indexes_1");

    public boolean shouldIndex(IDocument document) {
        return document instanceof ResourceDocument;
    }

    public String getIndexType() {
        return INDEX_TYPES;
    }

    protected void setIndexType(ModelResource resource) {
        ArgCheck.isNotNull(resource);
        if (resource.getIndexType() == 0) {
            resource.setIndexType(2);
        } else if (resource.getIndexType() == 1) {
            resource.setIndexType(3);
        }
    }

    protected void addIndexWord(EObject eObject, String modelPath, List wordEntries) {
        ArgCheck.isNotNull(eObject);
        ArgCheck.isNotNull(wordEntries);
        SearchRuntimeAdapter.addObjectSearchWords(eObject, modelPath, wordEntries);
    }

    protected void addResourceWordEntries(IDocument document, List wordEntries) {
        ResourceDocument resourceDocument;
        IResource resourceFile;
        XMIHeader header;
        if (document instanceof ModelDocument) {
            ModelDocument modelDocument = (ModelDocument)document;
            Resource resource = modelDocument.getResource();
            try {
                MetamodelDescriptor descriptor;
                ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource(resource);
                String primaryMetamodelURI = null;
                if (modelResource != null && (descriptor = modelResource.getPrimaryMetamodelDescriptor()) != null) {
                    primaryMetamodelURI = descriptor.getURI();
                }
                SearchRuntimeAdapter.addResourceSearchWords(modelResource.getUuid(), modelDocument.getIResource().getFullPath(), resource.getURI().toString(), primaryMetamodelURI, modelResource.getModelType().getName(), wordEntries);
            }
            catch (ModelerCoreException e2) {
                ModelerCore.Util.log(4, e2, e2.getMessage());
                return;
            }
        } else if (document instanceof ResourceDocument && (header = ModelUtil.getXmiHeader(resourceFile = (resourceDocument = (ResourceDocument)document).getIResource())) != null) {
            SearchRuntimeAdapter.addResourceSearchWords(header.getUUID(), resourceDocument.getIResource().getFullPath(), URI.createFileURI(((Object)resourceFile.getLocation()).toString()), header.getPrimaryMetamodelURI(), ModelType.VDB_ARCHIVE_LITERAL.getName(), wordEntries);
        }
    }

    protected String getIndexFileName(IPath path) {
        return IndexUtil.getIndexFileName(((Object)path).toString(), "SEARCH_INDEX");
    }
}

