/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.index;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.index.IndexSelectorFactory;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.internal.core.index.CompositeIndexSelector;
import com.metamatrix.modeler.internal.core.index.ModelWorkspaceIndexSelector;
import com.metamatrix.modeler.internal.core.index.ResourceFileIndexSelector;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ModelWorkspaceIndexSelectorFactory
implements IndexSelectorFactory {
    public IndexSelector createIndexSelector(List modelWorkspaceItems) throws CoreException {
        Object item;
        ArgCheck.isNotNull(modelWorkspaceItems);
        int numItems = modelWorkspaceItems.size();
        if (numItems == 0) {
            return new ModelWorkspaceIndexSelector();
        }
        if (numItems == 1 && (item = modelWorkspaceItems.get(0)) instanceof ModelWorkspace) {
            return new ModelWorkspaceIndexSelector();
        }
        LinkedList modelResources = new LinkedList();
        Iterator iter = modelWorkspaceItems.iterator();
        while (iter.hasNext()) {
            ModelWorkspaceItem item2;
            ModelWorkspaceItem wsItem = item2 = (ModelWorkspaceItem)iter.next();
            this.doAddModelResources(wsItem, modelResources);
        }
        LinkedList<ResourceFileIndexSelector> selectors = new LinkedList<ResourceFileIndexSelector>();
        Iterator resourceIter = modelResources.iterator();
        while (resourceIter.hasNext()) {
            ModelResource modelResource = (ModelResource)resourceIter.next();
            IResource resource = modelResource.getCorrespondingResource();
            String filePath = ((Object)resource.getFullPath()).toString();
            ResourceFileIndexSelector selector = new ResourceFileIndexSelector(filePath);
            selectors.add(selector);
        }
        if (selectors.size() == 0) {
            return new ModelWorkspaceIndexSelector();
        }
        if (selectors.size() == 1) {
            return (IndexSelector)selectors.get(0);
        }
        return new CompositeIndexSelector(selectors);
    }

    protected void doAddModelResources(ModelWorkspaceItem item, List modelResources) throws CoreException {
        if (item instanceof ModelWorkspace) {
            modelResources.add(item);
        } else if (item instanceof ModelResource) {
            modelResources.add(item);
        } else {
            ModelWorkspaceItem[] children = item.getChildren();
            for (int i2 = 0; i2 < children.length; ++i2) {
                ModelWorkspaceItem child = children[i2];
                this.doAddModelResources(child, modelResources);
            }
        }
    }
}

