/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.search.commands;

import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.index.IndexConstants;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.search.MetadataSearch;
import com.metamatrix.modeler.core.search.commands.FindObjectCommand;
import com.metamatrix.modeler.core.search.runtime.ResourceObjectRecord;
import com.metamatrix.modeler.core.search.runtime.SearchRecord;
import com.metamatrix.modeler.core.search.runtime.TypedObjectRecord;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.index.ModelWorkspaceSearchIndexSelector;
import com.metamatrix.modeler.internal.core.search.runtime.SearchRuntimeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class FindObjectCommandImpl
implements FindObjectCommand {
    private EClass metaClass = null;
    private String featureName = null;
    private String textPattern = null;
    private boolean containsPattern = true;
    private Collection recordInfos = Collections.EMPTY_LIST;
    private IndexSelector selector = null;

    public Collection getRecordInfo() {
        return this.recordInfos;
    }

    public void setFeatureCriteria(String featureName, String textPattern, boolean containsPattern) {
        this.featureName = featureName;
        this.textPattern = textPattern;
        this.containsPattern = containsPattern;
    }

    public void setMetaClass(EClass metaClass) {
        this.metaClass = metaClass;
    }

    public void setIndexSelector(IndexSelector selector) {
        this.selector = selector;
    }

    public boolean canExecute() {
        return this.isMetaclassSearch() || this.isFeatureSearch();
    }

    private IStatus executeObjectUriSearch() {
        Status result = null;
        try {
            Object obj = ModelerCore.getModelContainer().getEObjectFinder().find(this.textPattern);
            if (obj != null && obj instanceof EObject) {
                this.recordInfos = Collections.singletonList(SearchRuntimeAdapter.createResourceObjectRecord((EObject)obj));
            }
            result = new Status(0, "com.metamatrix.modeler.core", 0, "", null);
        }
        catch (CoreException theException) {
            ModelerCore.Util.log(theException);
            String msg = ModelerCore.Util.getString("FindObjectCommandImpl.objectUriSearchError", this.textPattern);
            return new Status(4, "com.metamatrix.modeler.core", 0, msg, theException);
        }
        return result;
    }

    public IStatus execute() {
        if (!this.canExecute()) {
            return null;
        }
        if (this.isFeatureSearch() && this.featureName.equals(MetadataSearch.OBJECT_URI_FEATURE)) {
            return this.executeObjectUriSearch();
        }
        try {
            String metaclassUri = FindObjectCommandImpl.getMetaclassUri(this.metaClass);
            String matchPattern = this.getMatchPattern(this.featureName, this.textPattern, metaclassUri);
            IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), matchPattern.toCharArray(), '\u00a0');
            this.recordInfos = new ArrayList(results.length);
            for (int i2 = 0; i2 < results.length; ++i2) {
                IEntryResult result = results[i2];
                this.recordInfos.add(SearchRuntimeAdapter.getSearchRecord(result.getWord()));
            }
            if (this.isFeatureSearch() && !this.containsPattern) {
                matchPattern = this.featureName.equals(MetadataSearch.DESCRIPTION_SEARCH_FEATURE) ? this.getMatchPattern(MetadataSearch.NAME_SEARCH_FEATURE, MetadataSearch.TEXT_PATTERN_ANY_STRING, metaclassUri) : this.getMatchPattern(this.featureName, IndexConstants.RECORD_STRING.MATCH_CHAR_STRING, metaclassUri);
                results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), matchPattern.toCharArray(), '\u00a0');
                HashMap<String, SearchRecord> tmp = new HashMap<String, SearchRecord>(results.length);
                for (int i3 = 0; i3 < results.length; ++i3) {
                    IEntryResult result = results[i3];
                    SearchRecord record = SearchRuntimeAdapter.getSearchRecord(result.getWord());
                    String mapKey = this.getMapKey(record);
                    if (mapKey == null) continue;
                    tmp.put(mapKey, record);
                }
                Iterator iter = this.recordInfos.iterator();
                while (iter.hasNext()) {
                    SearchRecord record = (SearchRecord)iter.next();
                    String mapKey = this.getMapKey(record);
                    if (!tmp.containsKey(mapKey)) continue;
                    tmp.remove(mapKey);
                }
                this.recordInfos = tmp.values();
            }
        }
        catch (Exception e2) {
            ModelerCore.Util.log(e2);
            String msg = ModelerCore.Util.getString("FindObjectCommandImpl.Error_trying_to_execute_command");
            return new Status(4, "com.metamatrix.modeler.core", 0, msg, e2);
        }
        return new Status(0, "com.metamatrix.modeler.core", 0, "", null);
    }

    private String getMatchPattern(String feature, String text, String metaClassUri) {
        String pattern = null;
        if (feature != null && feature.equals(MetadataSearch.DESCRIPTION_SEARCH_FEATURE)) {
            String descCriteria = text != null && text.length() != 0 ? text.toUpperCase() : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            String metaclassCriteria = metaClassUri != null && metaClassUri.length() != 0 ? metaClassUri : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            pattern = "J\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + descCriteria + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + metaclassCriteria + '\u00a0';
        } else {
            String nameCriteria = IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            if (feature != null && feature.equals(MetadataSearch.NAME_SEARCH_FEATURE)) {
                nameCriteria = text != null && text.length() != 0 ? text.toUpperCase() : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            }
            String uuidCriteria = IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            if (feature != null && feature.equals(MetadataSearch.UUID_SEARCH_FEATURE)) {
                uuidCriteria = text != null && text.length() != 0 ? text : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            }
            String metaclassCriteria = metaClassUri != null && metaClassUri.length() != 0 ? metaClassUri : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            pattern = "C\u00a0" + uuidCriteria + '\u00a0' + nameCriteria + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + metaclassCriteria + '\u00a0';
        }
        return pattern;
    }

    private boolean isFeatureSearch() {
        return this.featureName != null && this.textPattern != null && this.textPattern.length() > 0;
    }

    private boolean isMetaclassSearch() {
        return this.metaClass != null;
    }

    private IndexSelector getIndexSelector() {
        this.selector = this.selector != null ? this.selector : new ModelWorkspaceSearchIndexSelector();
        return this.selector;
    }

    private static String getMetaclassUri(EClass eClass) {
        if (eClass != null) {
            return ModelerCore.getModelEditor().getUri(eClass).toString();
        }
        return null;
    }

    private String getMapKey(SearchRecord record) {
        if (record != null) {
            String key = record.getUUID();
            if (key != null) {
                return key;
            }
            if (record instanceof ResourceObjectRecord) {
                key = ((ResourceObjectRecord)record).getObjectURI();
                return key;
            }
            if (record instanceof TypedObjectRecord) {
                key = ((TypedObjectRecord)record).getObjectURI();
                return key;
            }
        }
        return null;
    }
}

