/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.search.commands;

import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.index.IndexConstants;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.search.commands.FindRelationshipTypesCommand;
import com.metamatrix.modeler.core.search.runtime.RelationshipTypeRecord;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.index.ModelWorkspaceSearchIndexSelector;
import com.metamatrix.modeler.internal.core.search.runtime.SearchRuntimeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FindRelationshipTypesCommandImpl
implements FindRelationshipTypesCommand {
    private String typeNamePattern = null;
    private boolean includeSubtypes = false;
    private Collection relationTypeInfo = Collections.EMPTY_LIST;
    private IndexSelector selector;

    public boolean canExecute() {
        return true;
    }

    public IndexSelector getIndexSelector() {
        this.selector = this.selector != null ? this.selector : new ModelWorkspaceSearchIndexSelector();
        return this.selector;
    }

    public void setIndexSelector(IndexSelector selector) {
        this.selector = selector;
    }

    public IStatus execute() {
        if (!this.canExecute()) {
            return null;
        }
        try {
            Collection types = this.getRelationshipTypes(this.typeNamePattern);
            if (!StringUtil.isEmpty(this.typeNamePattern) && this.includeSubtypes) {
                Iterator typeIter = types.iterator();
                ArrayList children = new ArrayList();
                while (typeIter.hasNext()) {
                    RelationshipTypeRecord record = (RelationshipTypeRecord)typeIter.next();
                    String typeUUID = record.getUUID();
                    children.addAll(this.getChildTypes(typeUUID));
                }
                types.addAll(children);
            }
            this.relationTypeInfo = types;
        }
        catch (Exception e2) {
            ModelerCore.Util.log(e2);
            return new Status(4, "com.metamatrix.modeler.core", 0, ModelerCore.Util.getString("FindRelationshipTypesCommandImpl.Error_trying_to_execute_command,_problem_trying_to_query_relationship_search_indexes._1"), e2);
        }
        return new Status(0, "com.metamatrix.modeler.core", 0, "", null);
    }

    private Collection getRelationshipTypes(String namePattern) throws Exception {
        String searchPrefix = IndexUtil.getPrefixPattern('G', this.typeNamePattern);
        IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), searchPrefix.toCharArray(), true, false);
        ArrayList<RelationshipTypeRecord> relationTypes = new ArrayList<RelationshipTypeRecord>(results.length);
        for (int i2 = 0; i2 < results.length; ++i2) {
            IEntryResult result = results[i2];
            relationTypes.add(SearchRuntimeAdapter.createRelationshipTypeRecord(result.getWord()));
        }
        return relationTypes;
    }

    private Collection getChildTypes(String typeUUID) throws Exception {
        String searchPrefix = "G\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + typeUUID + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
        IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), searchPrefix.toCharArray(), false, false);
        ArrayList<RelationshipTypeRecord> relationTypes = new ArrayList<RelationshipTypeRecord>(results.length);
        for (int i2 = 0; i2 < results.length; ++i2) {
            IEntryResult result = results[i2];
            relationTypes.add(SearchRuntimeAdapter.createRelationshipTypeRecord(result.getWord()));
        }
        return relationTypes;
    }

    public Collection getRelationShipTypeInfo() {
        return this.relationTypeInfo;
    }

    public void setIncludeSubTypes(boolean includeSubTypes) {
        this.includeSubtypes = includeSubTypes;
    }

    public void setRelationshipTypeName(String namePattern) {
        this.typeNamePattern = namePattern;
    }
}

