/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.search.commands;

import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.index.IndexConstants;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.core.search.commands.FindRelationshipsCommand;
import com.metamatrix.modeler.core.search.commands.SearchCommand;
import com.metamatrix.modeler.core.search.runtime.RelatedObjectRecord;
import com.metamatrix.modeler.core.search.runtime.RelationshipRecord;
import com.metamatrix.modeler.core.search.runtime.RelationshipTypeRecord;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.index.ModelWorkspaceSearchIndexSelector;
import com.metamatrix.modeler.internal.core.search.commands.FindRelatedObjectsCommandImpl;
import com.metamatrix.modeler.internal.core.search.commands.FindRelationshipTypesCommandImpl;
import com.metamatrix.modeler.internal.core.search.runtime.SearchRuntimeAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FindRelationshipsCommandImpl
implements FindRelationshipsCommand {
    private String relationshipTypeName = null;
    private String namePattern = null;
    private String relationshipUUID = null;
    private List participantList = null;
    private List relationshipScope = null;
    private boolean caseSensitive = false;
    private boolean includeSubtypes = false;
    private Collection relationsInfo = Collections.EMPTY_LIST;
    private IndexSelector selector;

    private IndexSelector getIndexSelector() {
        this.selector = this.selector != null ? this.selector : new ModelWorkspaceSearchIndexSelector();
        return this.selector;
    }

    public void setIndexSelector(IndexSelector selector) {
        this.selector = selector;
    }

    public boolean canExecute() {
        return this.participantList == null || !this.participantList.isEmpty();
    }

    public IStatus execute() {
        if (!this.canExecute()) {
            return null;
        }
        try {
            if (!StringUtil.isEmpty(this.relationshipUUID)) {
                String prefix = IndexUtil.getPrefixPattern('E', this.relationshipUUID);
                IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), prefix.toCharArray(), true, true);
                this.relationsInfo = new HashSet(results.length);
                for (int i2 = 0; i2 < results.length; ++i2) {
                    IEntryResult result = results[i2];
                    this.relationsInfo.add(SearchRuntimeAdapter.createRelationshipRecord(result.getWord()));
                }
            } else {
                IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), this.getNameSearchPattern().toCharArray(), false, false);
                this.relationsInfo = new HashSet(results.length);
                for (int i3 = 0; i3 < results.length; ++i3) {
                    IEntryResult result = results[i3];
                    this.relationsInfo.add(SearchRuntimeAdapter.createRelationshipRecord(result.getWord()));
                }
                this.postFilter();
            }
        }
        catch (Exception e2) {
            ModelerCore.Util.log(e2);
            return new Status(4, "com.metamatrix.modeler.core", 0, ModelerCore.Util.getString("FindRelationshipsCommandImpl.Error_trying_to_execute_command,_problem_trying_to_query_relationship_search_indexes._1"), e2);
        }
        return new Status(0, "com.metamatrix.modeler.core", 0, "", null);
    }

    private String getNameSearchPattern() {
        String pattern = null;
        if (this.namePattern == null) {
            this.namePattern = "";
        }
        pattern = this.caseSensitive ? "E\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + this.namePattern + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING : "E\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + this.namePattern.toUpperCase() + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0';
        return pattern;
    }

    public void postFilter() {
        HashSet<RelationshipRecord> filteredResults = new HashSet<RelationshipRecord>();
        Iterator iter = this.relationsInfo.iterator();
        block0: while (iter.hasNext()) {
            IStatus status;
            SearchCommand command;
            RelationshipRecord record = (RelationshipRecord)iter.next();
            if (this.relationshipScope != null) {
                Iterator relIter = this.relationshipScope.iterator();
                while (relIter.hasNext()) {
                    ModelWorkspaceItem item = (ModelWorkspaceItem)relIter.next();
                    String resourcePath = ((Object)item.getPath()).toString();
                    if (record.getResourcePath().equals(resourcePath)) continue;
                }
            }
            if (!StringUtil.isEmpty(this.relationshipTypeName)) {
                command = new FindRelationshipTypesCommandImpl();
                command.setIndexSelector(this.selector);
                command.setRelationshipTypeName(this.relationshipTypeName);
                command.setIncludeSubTypes(this.includeSubtypes);
                status = command.execute();
                Collection typeInfo = null;
                if (status != null && !status.isOK()) continue;
                typeInfo = command.getRelationShipTypeInfo();
                boolean foundMatch = false;
                Iterator typeIter = typeInfo.iterator();
                while (typeIter.hasNext()) {
                    RelationshipTypeRecord typeRecord = (RelationshipTypeRecord)typeIter.next();
                    if (!record.getTypeName().equals(typeRecord.getName())) continue;
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) continue;
            }
            if (this.participantList != null) {
                command = new FindRelatedObjectsCommandImpl();
                command.setIndexSelector(this.selector);
                status = command.execute();
                Collection relInfo = null;
                if (status == null || status.isOK()) {
                    relInfo = command.getRelatedObjectInfo();
                }
                if (this.participantList != null) {
                    Iterator partIter = this.participantList.iterator();
                    while (partIter.hasNext()) {
                        String participantPath = (String)partIter.next();
                        boolean foundMatch = false;
                        Iterator relIter = relInfo.iterator();
                        while (relIter.hasNext()) {
                            RelatedObjectRecord relRecord = (RelatedObjectRecord)relIter.next();
                            if (!record.getUUID().equals(relRecord.getRelationshipUUID()) || !relRecord.getResourcePath().equals(participantPath) && !relRecord.getRelatedResourcePath().equals(participantPath)) continue;
                            foundMatch = true;
                            break;
                        }
                        if (foundMatch) continue;
                        continue block0;
                    }
                }
            }
            filteredResults.add(record);
        }
        this.relationsInfo.clear();
        this.relationsInfo.addAll(filteredResults);
    }

    public Collection getRelationShipInfo() {
        return this.relationsInfo;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setNamePattern(String namePattern) {
        this.namePattern = namePattern;
    }

    public void setParticipantList(List participantList) {
        this.participantList = participantList;
    }

    public void setRelationshipResourceScopeList(List scopeResourceList) {
        this.relationshipScope = scopeResourceList;
    }

    public void setIncludeSubtypes(boolean includeSubtypes) {
        this.includeSubtypes = includeSubtypes;
    }

    public void setRelationshipTypeName(String relationshipTypeName) {
        this.relationshipTypeName = relationshipTypeName;
    }

    public void setRelationshipUUID(String uuid) {
        this.relationshipUUID = uuid;
    }
}

