/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.search.runtime;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.ImportsAspect;
import com.metamatrix.modeler.core.metamodel.aspect.relationship.RelationshipAspect;
import com.metamatrix.modeler.core.metamodel.aspect.relationship.RelationshipMetamodelAspect;
import com.metamatrix.modeler.core.metamodel.aspect.relationship.RelationshipTypeAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAnnotationAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlDatatypeAspect;
import com.metamatrix.modeler.core.search.runtime.AnnotatedObjectRecord;
import com.metamatrix.modeler.core.search.runtime.ReferencesRecord;
import com.metamatrix.modeler.core.search.runtime.RelatedObjectRecord;
import com.metamatrix.modeler.core.search.runtime.RelationshipRecord;
import com.metamatrix.modeler.core.search.runtime.RelationshipTypeRecord;
import com.metamatrix.modeler.core.search.runtime.ResourceImportRecord;
import com.metamatrix.modeler.core.search.runtime.ResourceObjectRecord;
import com.metamatrix.modeler.core.search.runtime.ResourceRecord;
import com.metamatrix.modeler.core.search.runtime.SearchRecord;
import com.metamatrix.modeler.core.search.runtime.TypedObjectRecord;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.metadata.runtime.RuntimeAdapter;
import com.metamatrix.modeler.internal.core.search.runtime.AnnotatedObjectRecordImpl;
import com.metamatrix.modeler.internal.core.search.runtime.ReferencesRecordImpl;
import com.metamatrix.modeler.internal.core.search.runtime.RelatedObjectRecordImpl;
import com.metamatrix.modeler.internal.core.search.runtime.RelationshipRecordImpl;
import com.metamatrix.modeler.internal.core.search.runtime.RelationshipTypeRecordImpl;
import com.metamatrix.modeler.internal.core.search.runtime.ResourceImportRecordImpl;
import com.metamatrix.modeler.internal.core.search.runtime.ResourceObjectRecordImpl;
import com.metamatrix.modeler.internal.core.search.runtime.ResourceRecordImpl;
import com.metamatrix.modeler.internal.core.search.runtime.TypedObjectRecordImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class SearchRuntimeAdapter
extends RuntimeAdapter {
    static /* synthetic */ Class class$org$eclipse$emf$edit$provider$IItemLabelProvider;

    public static void addObjectSearchWords(EObject eObject, String modelPath, List wordEntries) {
        SearchRuntimeAdapter.addEObjectSearchWords(eObject, modelPath, wordEntries);
        SearchRuntimeAdapter.addTypedObjectSearchWords(eObject, modelPath, wordEntries);
        SearchRuntimeAdapter.addAnnotatedObjectSearchWords(eObject, modelPath, wordEntries);
        SearchRuntimeAdapter.addModelImportsSearchWords(eObject, modelPath, wordEntries);
        SearchRuntimeAdapter.addUniDirectionalReferencesSearchWords(eObject, wordEntries);
        SearchRuntimeAdapter.addRelationshipIndexWords(eObject, modelPath, wordEntries);
    }

    public static void addTypedObjectSearchWords(EObject eObject, String modelPath, Collection wordEntries) {
        if (eObject == null) {
            return;
        }
        EClass eClass = eObject.eClass();
        ModelEditor editor = ModelerCore.getModelEditor();
        Iterator iter = eClass.getEReferences().iterator();
        while (iter.hasNext()) {
            Object value;
            EReference eRef = (EReference)iter.next();
            if (!editor.isDatatypeFeature(eObject, eRef) || (value = eObject.eGet(eRef)) == null) continue;
            if (value instanceof EObject) {
                EObject datatype = (EObject)value;
                StringBuffer sb = new StringBuffer();
                String objectID = SearchRuntimeAdapter.createTypedObjectSearchWord(eObject, datatype, modelPath, sb);
                SearchRuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
                continue;
            }
            if (!(value instanceof List)) continue;
            Object[] values = ((List)value).toArray();
            for (int i2 = 0; i2 != values.length; ++i2) {
                Object obj = values[i2];
                if (!(obj instanceof EObject)) continue;
                EObject datatype = (EObject)obj;
                StringBuffer sb = new StringBuffer();
                String objectID = SearchRuntimeAdapter.createTypedObjectSearchWord(eObject, datatype, modelPath, sb);
                SearchRuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
            }
        }
    }

    private static String createTypedObjectSearchWord(EObject eObject, EObject datatype, String modelPath, StringBuffer sb) {
        ModelEditor editor = ModelerCore.getModelEditor();
        sb.append('I');
        sb.append('\u00a0');
        String objectID = SearchRuntimeAdapter.getObjectIdString(eObject);
        SearchRuntimeAdapter.appendID(objectID, sb);
        sb.append('\u00a0');
        SqlAspect sqlAspect = AspectManager.getSqlAspect(eObject);
        String name = sqlAspect != null ? sqlAspect.getName(eObject) : editor.getName(eObject);
        SearchRuntimeAdapter.appendObject(name, sb);
        sb.append('\u00a0');
        String fullname = sqlAspect != null ? sqlAspect.getFullName(eObject) : name;
        SearchRuntimeAdapter.appendObject(fullname, sb);
        sb.append('\u00a0');
        URI uri = editor.getUri(eObject);
        SearchRuntimeAdapter.appendObject(uri, sb);
        sb.append('\u00a0');
        SqlDatatypeAspect dtSqlAspect = (SqlDatatypeAspect)AspectManager.getSqlAspect(datatype);
        name = dtSqlAspect != null ? dtSqlAspect.getName(datatype) : editor.getName(datatype);
        SearchRuntimeAdapter.appendObject(name, sb);
        sb.append('\u00a0');
        objectID = dtSqlAspect != null ? dtSqlAspect.getUuidString(datatype) : SearchRuntimeAdapter.getObjectIdString(datatype);
        SearchRuntimeAdapter.appendID(objectID, sb);
        sb.append('\u00a0');
        String runtimeType = dtSqlAspect != null ? dtSqlAspect.getRuntimeTypeName(datatype) : null;
        SearchRuntimeAdapter.appendObject(runtimeType, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(modelPath, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendURI(eObject.eClass(), sb);
        sb.append('\u00a0');
        return objectID;
    }

    public static void addEObjectSearchWords(EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = SearchRuntimeAdapter.getObjectIdString(eObject);
        SqlAspect sqlAspect = AspectManager.getSqlAspect(eObject);
        String name = sqlAspect != null ? sqlAspect.getName(eObject) : ModelerCore.getModelEditor().getName(eObject);
        String fullname = sqlAspect != null ? sqlAspect.getFullName(eObject) : null;
        URI uri = ModelerCore.getModelEditor().getUri(eObject);
        EClass metaClass = eObject.eClass();
        SearchRuntimeAdapter.addEObjectSearchWords(objectID, name, fullname, uri, modelPath, metaClass, wordEntries);
        if (eObject instanceof XSDSimpleTypeDefinition && objectID.startsWith("mmuuid")) {
            if (eObject.eIsProxy()) {
                URI proxyURI = EcoreUtil.getURI(eObject);
                if (proxyURI != null) {
                    objectID = proxyURI.fragment();
                }
            } else {
                objectID = eObject.eResource().getURIFragment(eObject);
            }
            SearchRuntimeAdapter.addEObjectSearchWords(objectID, name, fullname, uri, modelPath, metaClass, wordEntries);
        }
    }

    public static void addEObjectSearchWords(String objectID, String name, String fullname, URI uri, String modelPath, EClass metaClass, Collection wordEntries) {
        StringBuffer sb = new StringBuffer();
        sb.append('C');
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(objectID, sb);
        sb.append('\u00a0');
        String upperName = name != null ? name.toUpperCase() : null;
        SearchRuntimeAdapter.appendObject(upperName, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(name, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(fullname, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(uri, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(modelPath, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendURI(metaClass, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addAnnotatedObjectSearchWords(EObject eObject, String modelPath, Collection wordEntries) {
        SqlAspect sqlAspect = AspectManager.getSqlAspect(eObject);
        if (sqlAspect != null && sqlAspect instanceof SqlAnnotationAspect) {
            SqlAnnotationAspect sqlAnnotationAspect = (SqlAnnotationAspect)sqlAspect;
            StringBuffer sb = new StringBuffer();
            sb.append('J');
            sb.append('\u00a0');
            String objectID = SearchRuntimeAdapter.getObjectIdString(sqlAnnotationAspect.getObjectID(eObject));
            SearchRuntimeAdapter.appendID(objectID, sb);
            sb.append('\u00a0');
            String name = sqlAnnotationAspect.getName(eObject);
            SearchRuntimeAdapter.appendObject(name, sb);
            sb.append('\u00a0');
            String fullname = sqlAnnotationAspect.getFullName(eObject);
            SearchRuntimeAdapter.appendObject(fullname, sb);
            sb.append('\u00a0');
            URI uri = sqlAnnotationAspect.getURI(eObject);
            SearchRuntimeAdapter.appendObject(uri, sb);
            sb.append('\u00a0');
            Map tags = sqlAnnotationAspect.getTags(eObject);
            SearchRuntimeAdapter.appendStrings(tags, 31, sb);
            sb.append('\u00a0');
            String description = sqlAnnotationAspect.getDescription(eObject);
            if (description != null) {
                description = description.toUpperCase();
            }
            SearchRuntimeAdapter.appendObject(description, sb);
            sb.append('\u00a0');
            SearchRuntimeAdapter.appendObject(modelPath, sb);
            sb.append('\u00a0');
            SearchRuntimeAdapter.appendURI(sqlAnnotationAspect.getMetaclassURI(eObject), sb);
            sb.append('\u00a0');
            SearchRuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
        }
    }

    public static void addUniDirectionalReferencesSearchWords(EObject eObject, Collection wordEntries) {
        EClass eClass = eObject.eClass();
        EList references = eClass.getEAllReferences();
        Iterator refIter = references.iterator();
        while (refIter.hasNext()) {
            Object value;
            EReference reference = (EReference)refIter.next();
            if (reference.isContainment() || reference.isVolatile() || !reference.isChangeable() || reference.getEOpposite() != null || (value = eObject.eGet(reference)) == null) continue;
            if (reference.isMany()) {
                Iterator valIter = ((EList)value).iterator();
                while (valIter.hasNext()) {
                    SearchRuntimeAdapter.addUniDirectionalReferenceWord(eObject, (EObject)valIter.next(), wordEntries);
                }
                continue;
            }
            SearchRuntimeAdapter.addUniDirectionalReferenceWord(eObject, (EObject)value, wordEntries);
        }
    }

    public static void addUniDirectionalReferenceWord(EObject eObject, EObject referencedObj, Collection wordEntries) {
        if (referencedObj == null || referencedObj.eResource() == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append('D');
        sb.append('\u00a0');
        String objectID = SearchRuntimeAdapter.getObjectIdString(referencedObj);
        SearchRuntimeAdapter.appendID(objectID, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(eObject, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addResourceSearchWords(Object resourceUUID, IPath resourcePath, Object resourceURI, String metamodelURI, String modelType, Collection wordEntries) {
        if (resourceUUID == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(50);
        sb.append('A');
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(resourceUUID, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(resourcePath, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(resourceURI, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(metamodelURI, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(modelType, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.addNewWordEntryToList(resourceUUID.toString(), sb, wordEntries);
    }

    public static void addModelImportsSearchWords(EObject eObject, String modelPath, Collection wordEntries) {
        ModelResource mdlResource;
        ImportsAspect importAspect = AspectManager.getModelImportsAspect(eObject);
        if (importAspect == null) {
            return;
        }
        IPath path = importAspect.getModelPath(eObject);
        if (path == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(50);
        sb.append('B');
        sb.append('\u00a0');
        sb.append(path);
        sb.append('\u00a0');
        String resourceUUID = importAspect.getModelUuid(eObject);
        if (resourceUUID == null && eObject instanceof ModelImport && (mdlResource = ModelerCore.getModelEditor().findModelResource((ModelImport)eObject)) != null) {
            try {
                resourceUUID = mdlResource.getUuid();
            }
            catch (Exception e2) {
                ModelerCore.Util.log(e2);
            }
        }
        SearchRuntimeAdapter.appendObject(resourceUUID, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(modelPath, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.addNewWordEntryToList(resourceUUID, sb, wordEntries);
    }

    public static void addRelationshipIndexWords(Object eObject, String modelPath, Collection wordEntries) {
        RelationshipMetamodelAspect relAspect = AspectManager.getRelationshipAspect((EObject)eObject);
        if (relAspect == null) {
            return;
        }
        if (relAspect.isRecordType('F')) {
            SearchRuntimeAdapter.addRelatedObjectWords((RelationshipAspect)relAspect, (EObject)eObject, wordEntries);
        }
        if (relAspect.isRecordType('E')) {
            SearchRuntimeAdapter.addRelationshipWord((RelationshipAspect)relAspect, modelPath, (EObject)eObject, wordEntries);
        }
        if (relAspect.isRecordType('G')) {
            SearchRuntimeAdapter.addRelationshipTypeWord((RelationshipTypeAspect)relAspect, (EObject)eObject, wordEntries);
        }
    }

    public static void addRelationshipWord(RelationshipAspect relationAspect, String modelPath, EObject eObject, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(100);
        sb.append('E');
        sb.append('\u00a0');
        Object objectID = relationAspect.getObjectID(eObject);
        SearchRuntimeAdapter.appendID(objectID, sb);
        sb.append('\u00a0');
        String name = relationAspect.getName(eObject);
        String upperName = name != null ? name.toUpperCase() : null;
        SearchRuntimeAdapter.appendID(name, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(upperName, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationAspect.getType(eObject), sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationAspect.getTypeName(eObject), sb);
        sb.append('\u00a0');
        URI uri = eObject != null ? EcoreUtil.getURI(eObject) : null;
        SearchRuntimeAdapter.appendObject(uri, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(modelPath, sb);
        sb.append('\u00a0');
        String stringID = objectID != null ? objectID.toString() : " ";
        SearchRuntimeAdapter.addNewWordEntryToList(stringID, sb, wordEntries);
    }

    public static void addRelationshipTypeWord(RelationshipTypeAspect relationAspect, EObject eObject, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(100);
        sb.append('G');
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationAspect.getName(eObject), sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationAspect.getSuperType(eObject), sb);
        sb.append('\u00a0');
        Object objectID = relationAspect.getObjectID(eObject);
        SearchRuntimeAdapter.appendID(objectID, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationAspect.getSourceRoleName(eObject), sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationAspect.getTargetRoleName(eObject), sb);
        sb.append('\u00a0');
        URI uri = eObject != null ? EcoreUtil.getURI(eObject) : null;
        SearchRuntimeAdapter.appendObject(uri, sb);
        sb.append('\u00a0');
        String relationTypeID = objectID != null ? objectID.toString() : " ";
        SearchRuntimeAdapter.addNewWordEntryToList(relationTypeID, sb, wordEntries);
    }

    public static void addRelatedObjectWords(RelationshipAspect relationAspect, EObject relObject, Collection wordEntries) {
        Iterator srcIter = relationAspect.getSources(relObject).iterator();
        while (srcIter.hasNext()) {
            Object srcObj = srcIter.next();
            Iterator tgtIter = relationAspect.getTargets(relObject).iterator();
            while (tgtIter.hasNext()) {
                Object tgtObj = tgtIter.next();
                SearchRuntimeAdapter.addRelatedObjectWord(srcObj, tgtObj, relationAspect, relObject, true, wordEntries);
                SearchRuntimeAdapter.addRelatedObjectWord(tgtObj, srcObj, relationAspect, relObject, false, wordEntries);
            }
        }
    }

    public static void addRelatedObjectWord(Object eObject, Object relatedObj, RelationshipAspect relationAspect, EObject relationObj, boolean isSource, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(100);
        sb.append('F');
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(eObject, sb);
        sb.append('\u00a0');
        String relatedObjectID = SearchRuntimeAdapter.getObjectIdString(relatedObj);
        SearchRuntimeAdapter.appendID(relatedObj, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationObj, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendBoolean(isSource, sb);
        sb.append('\u00a0');
        String metaClassURI = null;
        if (relatedObj instanceof EObject) {
            metaClassURI = ModelerCore.getMetamodels().getMetaClassURI(((EObject)eObject).eClass());
        }
        SearchRuntimeAdapter.appendObject(metaClassURI, sb);
        sb.append('\u00a0');
        String relatedClassURI = null;
        if (relatedObj instanceof EObject) {
            relatedClassURI = ModelerCore.getMetamodels().getMetaClassURI(((EObject)relatedObj).eClass());
        }
        SearchRuntimeAdapter.appendObject(relatedClassURI, sb);
        sb.append('\u00a0');
        String sourceRoleName = relationAspect.getSourceRoleName(relationObj);
        String targetRoleName = relationAspect.getTargetRoleName(relationObj);
        if (isSource) {
            SearchRuntimeAdapter.appendObject(sourceRoleName, sb);
            sb.append('\u00a0');
            SearchRuntimeAdapter.appendObject(targetRoleName, sb);
            sb.append('\u00a0');
        } else {
            SearchRuntimeAdapter.appendObject(targetRoleName, sb);
            sb.append('\u00a0');
            SearchRuntimeAdapter.appendObject(sourceRoleName, sb);
            sb.append('\u00a0');
        }
        String name = eObject instanceof EObject ? SearchRuntimeAdapter.getName((EObject)eObject) : null;
        SearchRuntimeAdapter.appendObject(name, sb);
        sb.append('\u00a0');
        String relatedName = eObject instanceof EObject ? SearchRuntimeAdapter.getName((EObject)relatedObj) : null;
        SearchRuntimeAdapter.appendObject(relatedName, sb);
        sb.append('\u00a0');
        URI uri = eObject instanceof EObject ? EcoreUtil.getURI((EObject)eObject) : null;
        SearchRuntimeAdapter.appendObject(uri, sb);
        sb.append('\u00a0');
        URI relatedUri = eObject instanceof EObject ? EcoreUtil.getURI((EObject)relatedObj) : null;
        SearchRuntimeAdapter.appendObject(relatedUri, sb);
        sb.append('\u00a0');
        ModelEditor editor = ModelerCore.getModelEditor();
        ModelResource modelRsc = eObject instanceof EObject ? editor.findModelResource((EObject)eObject) : null;
        String resourcePath = null;
        if (modelRsc != null) {
            resourcePath = ((Object)modelRsc.getPath()).toString();
        }
        SearchRuntimeAdapter.appendObject(resourcePath, sb);
        sb.append('\u00a0');
        ModelResource relatedModelRsc = eObject instanceof EObject ? editor.findModelResource((EObject)relatedObj) : null;
        String relatedResourcePath = null;
        if (relatedModelRsc != null) {
            relatedResourcePath = ((Object)relatedModelRsc.getPath()).toString();
        }
        SearchRuntimeAdapter.appendObject(relatedResourcePath, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.addNewWordEntryToList(relatedObjectID, sb, wordEntries);
    }

    private static String getName(EObject eObject) {
        IItemLabelProvider provider;
        AdapterFactory adapterFactory = ModelerCore.getMetamodels().getEmfAdapterFactory();
        if (adapterFactory != null && (provider = (IItemLabelProvider)((Object)adapterFactory.adapt(eObject, (Object)(class$org$eclipse$emf$edit$provider$IItemLabelProvider == null ? (class$org$eclipse$emf$edit$provider$IItemLabelProvider = SearchRuntimeAdapter.class$("org.eclipse.emf.edit.provider.IItemLabelProvider")) : class$org$eclipse$emf$edit$provider$IItemLabelProvider)))) != null) {
            return provider.getText(eObject);
        }
        return null;
    }

    public static SearchRecord getSearchRecord(char[] record) {
        if (record == null || record.length == 0) {
            return null;
        }
        switch (record[0]) {
            case 'E': {
                return SearchRuntimeAdapter.createRelationshipRecord(record);
            }
            case 'F': {
                return SearchRuntimeAdapter.createRelatedObjectRecord(record);
            }
            case 'G': {
                return SearchRuntimeAdapter.createRelationshipTypeRecord(record);
            }
            case 'H': {
                return null;
            }
            case 'A': {
                return SearchRuntimeAdapter.createResourceRecord(record);
            }
            case 'C': {
                return SearchRuntimeAdapter.createResourceObjectRecord(record);
            }
            case 'D': {
                return SearchRuntimeAdapter.createResourceObjRefRecord(record);
            }
            case 'B': {
                return SearchRuntimeAdapter.createResourceImportRecord(record);
            }
            case 'I': {
                return SearchRuntimeAdapter.createTypedObjectRecord(record);
            }
            case 'J': {
                return SearchRuntimeAdapter.createAnnotatedObjectRecord(record);
            }
        }
        throw new IllegalArgumentException(ModelerCore.Util.getString("RelationshipRuntimeAdapter.Invalid_relationship_search_record_type_{0}_for_creating_RelationshipSearchRecord._1", record[0]));
    }

    public static ResourceObjectRecord createResourceObjectRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split(str, String.valueOf('\u00a0'));
        ResourceObjectRecordImpl objRecord = new ResourceObjectRecordImpl();
        int tokenIndex = 1;
        objRecord.setUUID((String)tokens.get(tokenIndex++));
        objRecord.setName((String)tokens.get(tokenIndex++));
        objRecord.setName((String)tokens.get(tokenIndex++));
        objRecord.setFullname((String)tokens.get(tokenIndex++));
        objRecord.setObjectURI((String)tokens.get(tokenIndex++));
        objRecord.setResourcePath((String)tokens.get(tokenIndex++));
        objRecord.setMetaclassURI((String)tokens.get(tokenIndex++));
        return objRecord;
    }

    public static TypedObjectRecord createTypedObjectRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split(str, String.valueOf('\u00a0'));
        TypedObjectRecordImpl objRecord = new TypedObjectRecordImpl();
        int tokenIndex = 1;
        objRecord.setUUID((String)tokens.get(tokenIndex++));
        objRecord.setName((String)tokens.get(tokenIndex++));
        objRecord.setFullname((String)tokens.get(tokenIndex++));
        objRecord.setObjectURI((String)tokens.get(tokenIndex++));
        objRecord.setDatatypeName((String)tokens.get(tokenIndex++));
        objRecord.setDatatypeID((String)tokens.get(tokenIndex++));
        objRecord.setRuntimeType((String)tokens.get(tokenIndex++));
        objRecord.setResourcePath((String)tokens.get(tokenIndex++));
        objRecord.setMetaclassURI((String)tokens.get(tokenIndex++));
        return objRecord;
    }

    public static AnnotatedObjectRecord createAnnotatedObjectRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split(str, String.valueOf('\u00a0'));
        AnnotatedObjectRecordImpl annotRecord = new AnnotatedObjectRecordImpl();
        int tokenIndex = 1;
        annotRecord.setUUID((String)tokens.get(tokenIndex++));
        annotRecord.setName((String)tokens.get(tokenIndex++));
        annotRecord.setFullname((String)tokens.get(tokenIndex++));
        annotRecord.setObjectURI((String)tokens.get(tokenIndex++));
        annotRecord.setProperties(SearchRuntimeAdapter.getProperties((String)tokens.get(tokenIndex++), '\u001f', '\u2060'));
        annotRecord.setDescription((String)tokens.get(tokenIndex++));
        annotRecord.setResourcePath((String)tokens.get(tokenIndex++));
        annotRecord.setMetaclassURI((String)tokens.get(tokenIndex++));
        return annotRecord;
    }

    public static ReferencesRecord createResourceObjRefRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split(str, String.valueOf('\u00a0'));
        ReferencesRecordImpl refRecord = new ReferencesRecordImpl();
        int tokenIndex = 1;
        refRecord.setReferencedUUID((String)tokens.get(tokenIndex++));
        refRecord.setUUID((String)tokens.get(tokenIndex++));
        return refRecord;
    }

    public static ResourceObjectRecord createResourceObjectRecord(EObject theEObject) {
        ResourceObjectRecordImpl objRecord = new ResourceObjectRecordImpl();
        ModelEditor editor = ModelerCore.getModelEditor();
        objRecord.setUUID(((Object)theEObject.getObjectId()).toString());
        objRecord.setObjectURI(editor.getUri(theEObject).toFileString());
        objRecord.setMetaclassURI(theEObject.eClass().getName());
        SqlAspect sqlAspect = AspectManager.getSqlAspect(theEObject);
        String name = sqlAspect == null ? editor.getName(theEObject) : sqlAspect.getName(theEObject);
        objRecord.setName(name);
        String fullName = sqlAspect == null ? null : sqlAspect.getFullName(theEObject);
        objRecord.setFullname(fullName);
        String path = sqlAspect == null ? ((Object)editor.getModelRelativePathIncludingModel(theEObject)).toString() : ((Object)sqlAspect.getPath(theEObject)).toString();
        objRecord.setResourcePath(path);
        return objRecord;
    }

    public static ResourceRecord createResourceRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split(str, String.valueOf('\u00a0'));
        ResourceRecordImpl resourceRecord = new ResourceRecordImpl();
        int tokenIndex = 1;
        resourceRecord.setUUID((String)tokens.get(tokenIndex++));
        resourceRecord.setPath((String)tokens.get(tokenIndex++));
        resourceRecord.setURI((String)tokens.get(tokenIndex++));
        resourceRecord.setMetamodelURI((String)tokens.get(tokenIndex++));
        resourceRecord.setModelType((String)tokens.get(tokenIndex++));
        return resourceRecord;
    }

    public static ResourceImportRecord createResourceImportRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split(str, String.valueOf('\u00a0'));
        ResourceImportRecordImpl importRecord = new ResourceImportRecordImpl();
        int tokenIndex = 1;
        importRecord.setImportedPath((String)tokens.get(tokenIndex++));
        importRecord.setUUID((String)tokens.get(tokenIndex++));
        importRecord.setPath((String)tokens.get(tokenIndex++));
        return importRecord;
    }

    public static RelationshipRecord createRelationshipRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split(str, String.valueOf('\u00a0'));
        RelationshipRecordImpl relationRecord = new RelationshipRecordImpl();
        int tokenIndex = 1;
        relationRecord.setUUID((String)tokens.get(tokenIndex++));
        relationRecord.setName((String)tokens.get(tokenIndex++));
        int n2 = ++tokenIndex;
        relationRecord.setTypeUUID((String)tokens.get(n2));
        int n3 = ++tokenIndex;
        relationRecord.setTypeName((String)tokens.get(n3));
        int n4 = ++tokenIndex;
        relationRecord.setUri((String)tokens.get(n4));
        int n5 = ++tokenIndex;
        ++tokenIndex;
        relationRecord.setResourcePath((String)tokens.get(n5));
        return relationRecord;
    }

    public static RelationshipTypeRecord createRelationshipTypeRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split(str, String.valueOf('\u00a0'));
        RelationshipTypeRecordImpl relationTypeRecord = new RelationshipTypeRecordImpl();
        int tokenIndex = 1;
        relationTypeRecord.setName((String)tokens.get(tokenIndex++));
        relationTypeRecord.setSuperTypeUUID((String)tokens.get(tokenIndex++));
        relationTypeRecord.setUUID((String)tokens.get(tokenIndex++));
        relationTypeRecord.setSourceRoleName((String)tokens.get(tokenIndex++));
        relationTypeRecord.setTargetRoleName((String)tokens.get(tokenIndex++));
        relationTypeRecord.setUri((String)tokens.get(tokenIndex++));
        return relationTypeRecord;
    }

    public static RelatedObjectRecord createRelatedObjectRecord(char[] record) {
        String str = new String(record);
        List tokens = StringUtil.split(str, String.valueOf('\u00a0'));
        RelatedObjectRecordImpl relatedRecord = new RelatedObjectRecordImpl();
        int tokenIndex = 1;
        relatedRecord.setUUID((String)tokens.get(tokenIndex++));
        relatedRecord.setRelatedObjectUUID((String)tokens.get(tokenIndex++));
        relatedRecord.setRelationshipUUID((String)tokens.get(tokenIndex++));
        char[] booleanValues = ((String)tokens.get(tokenIndex++)).toCharArray();
        relatedRecord.setSourceObject(SearchRuntimeAdapter.getBooleanValue(booleanValues[0]));
        relatedRecord.setMetaClassUri((String)tokens.get(tokenIndex++));
        relatedRecord.setRelatedMetaClassUri((String)tokens.get(tokenIndex++));
        relatedRecord.setRoleName((String)tokens.get(tokenIndex++));
        relatedRecord.setRelatedRoleName((String)tokens.get(tokenIndex++));
        relatedRecord.setName((String)tokens.get(tokenIndex++));
        relatedRecord.setRelatedObjectName((String)tokens.get(tokenIndex++));
        relatedRecord.setUri((String)tokens.get(tokenIndex++));
        relatedRecord.setRelatedObjectUri((String)tokens.get(tokenIndex++));
        relatedRecord.setResourcePath((String)tokens.get(tokenIndex++));
        relatedRecord.setRelatedResourcePath((String)tokens.get(tokenIndex++));
        return relatedRecord;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

