/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.transaction;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.AnnotationContainer;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.diagram.DiagramContainer;
import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.metamodels.transformation.TransformationContainer;
import com.metamatrix.modeler.core.transaction.SourcedNotification;
import com.metamatrix.modeler.internal.core.transaction.SourcedNotificationImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TxnNotificationFilter {
    private final List eventSets;
    private final ResourceSet resourceSet;

    public TxnNotificationFilter(ResourceSet theResourceSet) {
        ArgCheck.isNotNull(theResourceSet);
        this.eventSets = new ArrayList();
        this.resourceSet = theResourceSet;
    }

    public List getSourcedNotifications(Object source) {
        this.removeEmptyEventSets();
        ArrayList<SourcedNotification> result = new ArrayList<SourcedNotification>(this.eventSets.size());
        Iterator i2 = this.eventSets.iterator();
        while (i2.hasNext()) {
            SourcedNotification sn;
            NotifierEventSet es = (NotifierEventSet)i2.next();
            if (es.isEmpty() || (sn = es.getSourcedNotification(source)) == null) continue;
            result.add(sn);
        }
        return result;
    }

    public void clear() {
        Iterator i2 = this.eventSets.iterator();
        while (i2.hasNext()) {
            NotifierEventSet es = (NotifierEventSet)i2.next();
            es.clear();
        }
        this.eventSets.clear();
    }

    public boolean addNotification(Notification notification) {
        if (this.isIgnorable(notification)) {
            return false;
        }
        this.removeEmptyEventSets();
        Object notifier = notification.getNotifier();
        NotifierEventSet eventSet = this.getExistingEventSet(notifier);
        if (eventSet != null) {
            eventSet.addNotification(notification);
            return true;
        }
        Object feature = notification.getFeature();
        if (feature == null && (notifier instanceof Resource || notifier instanceof ResourceSet)) {
            eventSet = new NotifierEventSet(notifier);
            eventSet.addNotification(notification);
            this.eventSets.add(eventSet);
            return true;
        }
        Iterator i2 = this.eventSets.iterator();
        while (i2.hasNext()) {
            NotifierEventSet es = (NotifierEventSet)i2.next();
            if (es.isEmpty() || !this.isAncestor(notifier, es.getNotifier()) || this.isRemove(notification) && !this.isAncestor(es.getAddObjects(), notifier)) continue;
            es.clear();
            i2.remove();
        }
        eventSet = new NotifierEventSet(notifier);
        eventSet.addNotification(notification);
        this.eventSets.add(eventSet);
        return true;
    }

    protected boolean isIgnorable(Notification notification) {
        if (notification == null || notification.getNotifier() == null) {
            return true;
        }
        if (notification.isTouch()) {
            return true;
        }
        Object notifier = notification.getNotifier();
        if (notification.getFeature() == null && notifier instanceof EObject) {
            return true;
        }
        if (this.isSpecial(notification)) {
            return false;
        }
        Object oldVal = notification.getOldValue();
        Object newVal = notification.getNewValue();
        switch (notification.getEventType()) {
            case 4: {
                if (newVal != null || !(oldVal instanceof ModelAnnotation) && !(oldVal instanceof DiagramContainer) && !(oldVal instanceof TransformationContainer) && !(oldVal instanceof AnnotationContainer)) break;
                return true;
            }
            case 3: {
                if (oldVal != null || !(newVal instanceof ModelAnnotation) && !(newVal instanceof DiagramContainer) && !(newVal instanceof TransformationContainer) && !(newVal instanceof AnnotationContainer)) break;
                return true;
            }
            case 1: {
                if (notification.getFeature() == null) {
                    return true;
                }
                if (oldVal != newVal && (oldVal == null || !oldVal.equals(newVal))) break;
                return true;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 2: {
                break;
            }
            case 7: {
                break;
            }
        }
        Resource r2 = null;
        if (notifier instanceof EObject ? (r2 = ((EObject)notifier).eResource()) == null || !this.resourceSet.getResources().contains(r2) : (notifier instanceof Resource ? (r2 = (Resource)notifier) == null || !this.resourceSet.getResources().contains(r2) : notifier instanceof EClass && ((r2 = ((EClass)notifier).eResource()) == null || !this.resourceSet.getResources().contains(r2)))) {
            return true;
        }
        Iterator i2 = this.eventSets.iterator();
        while (i2.hasNext()) {
            NotifierEventSet es = (NotifierEventSet)i2.next();
            if (es.isEmpty() || !this.isAncestor(es.getNotifier(), notifier)) continue;
            return !this.isRemove(notification) || this.isAncestor(es.getAddObjects(), notifier);
        }
        return false;
    }

    protected boolean isSpecial(Notification notification) {
        Object notifier = notification.getNotifier();
        switch (notification.getEventType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (!(notifier instanceof SqlTransformation) || this.getExistingEventSet(((EObject)notifier).eContainer()) == null) break;
                return true;
            }
        }
        return false;
    }

    protected Collection getNotificationTarget(Notification notification) {
        Object oldVal = notification.getOldValue();
        Object newVal = notification.getNewValue();
        List target = Collections.singletonList(notification.getNotifier());
        switch (notification.getEventType()) {
            case 4: {
                target = Collections.singletonList(oldVal);
                break;
            }
            case 6: {
                target = ((List)oldVal).isEmpty() ? Collections.EMPTY_LIST : (List)oldVal;
                break;
            }
            case 3: {
                target = Collections.singletonList(newVal);
                break;
            }
            case 5: {
                target = ((List)newVal).isEmpty() ? Collections.EMPTY_LIST : (List)newVal;
                break;
            }
        }
        return target;
    }

    protected boolean isRemove(Notification notification) {
        switch (notification.getEventType()) {
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected boolean isAdd(Notification notification) {
        switch (notification.getEventType()) {
            case 3: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    protected NotifierEventSet getExistingEventSet(Object notifier) {
        Iterator i2 = this.eventSets.iterator();
        while (i2.hasNext()) {
            NotifierEventSet es = (NotifierEventSet)i2.next();
            if (es.getNotifier() != notifier) continue;
            return es;
        }
        return null;
    }

    protected void removeEmptyEventSets() {
        Iterator i2 = this.eventSets.iterator();
        while (i2.hasNext()) {
            NotifierEventSet eventSet = (NotifierEventSet)i2.next();
            if (!eventSet.isEmpty()) continue;
            eventSet.clear();
            i2.remove();
        }
    }

    protected boolean isAncestor(Collection ancestors, Object obj) {
        if (ancestors != null && !ancestors.isEmpty()) {
            Iterator i2 = ancestors.iterator();
            while (i2.hasNext()) {
                if (!this.isAncestor(i2.next(), obj)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAncestor(Object ancestor, Object obj) {
        ResourceSet parent;
        if (ancestor == null || obj == null || ancestor == obj) {
            return false;
        }
        if (obj instanceof EObject) {
            if (ancestor instanceof EObject) {
                return EcoreUtil.isAncestor((EObject)ancestor, (EObject)obj);
            }
            if (ancestor instanceof Resource) {
                return EcoreUtil.isAncestor((Resource)ancestor, (EObject)obj);
            }
            if (ancestor instanceof ResourceSet) {
                return EcoreUtil.isAncestor((ResourceSet)ancestor, (EObject)obj);
            }
        } else if (obj instanceof Resource && ancestor instanceof ResourceSet && ancestor == (parent = ((Resource)obj).getResourceSet())) {
            return true;
        }
        return false;
    }

    private class NotifierEventSet {
        private final Object notifier;
        private final List notifications;
        private final Map addEvents;
        private final Map removeEvents;
        private final Set addObjects;
        private final Set removeObjects;

        public NotifierEventSet(Object theNotifier) {
            this.notifier = theNotifier;
            this.notifications = new ArrayList();
            this.addEvents = new HashMap();
            this.removeEvents = new HashMap();
            this.addObjects = new HashSet();
            this.removeObjects = new HashSet();
        }

        public boolean addNotification(Notification notification) {
            if (this.isIgnorable(notification)) {
                return false;
            }
            Object oldVal = notification.getOldValue();
            Object newVal = notification.getNewValue();
            switch (notification.getEventType()) {
                case 4: {
                    Object feature;
                    Notification event = (Notification)this.addEvents.get(oldVal);
                    if (event != null && event.getEventType() == 3) {
                        this.addEvents.remove(oldVal);
                        this.addObjects.remove(oldVal);
                        this.notifications.remove(event);
                        return false;
                    }
                    if (oldVal == null || (event = (Notification)this.removeEvents.get(oldVal)) != null && (feature = event.getFeature()) instanceof EReference && ((EReference)feature).isContainment()) break;
                    this.removeEvents.put(oldVal, notification);
                    this.removeObjects.add(oldVal);
                    break;
                }
                case 6: {
                    Object feature;
                    Object eventVal;
                    if (!(oldVal instanceof List) || ((List)oldVal).isEmpty()) break;
                    Object firstOldVal = ((List)oldVal).get(0);
                    Notification event = (Notification)this.addEvents.get(firstOldVal);
                    if (event != null && event.getEventType() == 5 && (eventVal = event.getNewValue()) instanceof List && oldVal.equals(eventVal)) {
                        this.addEvents.remove(firstOldVal);
                        this.addObjects.removeAll((List)oldVal);
                        this.notifications.remove(event);
                        return false;
                    }
                    if (firstOldVal == null || (event = (Notification)this.removeEvents.get(firstOldVal)) != null && (feature = event.getFeature()) instanceof EReference && ((EReference)feature).isContainment()) break;
                    this.removeEvents.put(firstOldVal, notification);
                    this.removeObjects.addAll((List)oldVal);
                    break;
                }
                case 3: {
                    Object feature;
                    Notification event = (Notification)this.removeEvents.get(newVal);
                    if (event != null && event.getEventType() == 4) {
                        this.removeEvents.remove(newVal);
                        this.removeObjects.remove(newVal);
                        this.notifications.remove(event);
                        if (this.isMoveNotification(event, notification)) {
                            Notification moveEvent = this.createMoveNotification(event, notification);
                            this.notifications.add(moveEvent);
                            return true;
                        }
                        return false;
                    }
                    if (newVal == null || (event = (Notification)this.addEvents.get(newVal)) != null && (feature = event.getFeature()) instanceof EReference && ((EReference)feature).isContainment()) break;
                    this.addEvents.put(newVal, notification);
                    this.addObjects.add(newVal);
                    break;
                }
                case 5: {
                    Object feature;
                    Object eventVal;
                    if (!(newVal instanceof List) || ((List)newVal).isEmpty()) break;
                    Object firstNewVal = ((List)newVal).get(0);
                    Notification event = (Notification)this.removeEvents.get(firstNewVal);
                    if (event != null && event.getEventType() == 6 && (eventVal = event.getOldValue()) instanceof List && newVal.equals(eventVal)) {
                        this.removeEvents.remove(firstNewVal);
                        this.removeObjects.removeAll((List)newVal);
                        this.notifications.remove(event);
                        return false;
                    }
                    if (firstNewVal == null || (event = (Notification)this.addEvents.get(firstNewVal)) != null && (feature = event.getFeature()) instanceof EReference && ((EReference)feature).isContainment()) break;
                    this.addEvents.put(firstNewVal, notification);
                    this.addObjects.addAll((List)newVal);
                    break;
                }
                case 1: {
                    Object feature;
                    if (newVal != null && oldVal == null) {
                        Object feature2;
                        Notification event = (Notification)this.removeEvents.get(newVal);
                        if (event != null && event.getEventType() == 1) {
                            this.removeEvents.remove(newVal);
                            this.notifications.remove(event);
                            return false;
                        }
                        event = (Notification)this.addEvents.get(newVal);
                        if (event != null && (feature2 = event.getFeature()) instanceof EReference && ((EReference)feature2).isContainment()) break;
                        this.addEvents.put(newVal, notification);
                        this.addObjects.add(newVal);
                        break;
                    }
                    if (newVal != null || oldVal == null) break;
                    Notification event = (Notification)this.addEvents.get(oldVal);
                    if (event != null && event.getEventType() == 1) {
                        this.addEvents.remove(oldVal);
                        this.addObjects.remove(oldVal);
                        this.notifications.remove(event);
                        return false;
                    }
                    event = (Notification)this.removeEvents.get(oldVal);
                    if (event != null && (feature = event.getFeature()) instanceof EReference && ((EReference)feature).isContainment()) break;
                    this.removeEvents.put(oldVal, notification);
                    this.removeObjects.add(oldVal);
                    break;
                }
                case 2: {
                    break;
                }
                case 7: {
                    break;
                }
            }
            this.notifications.add(notification);
            return true;
        }

        public Notification getPrimaryNotification() {
            if (this.notifications.isEmpty()) {
                return null;
            }
            Iterator i2 = this.notifications.iterator();
            while (i2.hasNext()) {
                Notification n2 = (Notification)i2.next();
                Object feature = n2.getFeature();
                if (!(feature instanceof EReference) || !((EReference)feature).isContainment()) continue;
                switch (n2.getEventType()) {
                    case 4: {
                        return n2;
                    }
                    case 6: {
                        return n2;
                    }
                    case 3: {
                        return n2;
                    }
                    case 5: {
                        return n2;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                }
            }
            return (Notification)this.notifications.get(0);
        }

        public Object getNotifier() {
            return this.notifier;
        }

        public SourcedNotification getSourcedNotification(Object source) {
            SourcedNotificationImpl sn = null;
            if (!this.isEmpty()) {
                sn = new SourcedNotificationImpl(source, this.getPrimaryNotification());
                Iterator i2 = this.notifications.iterator();
                while (i2.hasNext()) {
                    sn.add((Notification)i2.next());
                }
            }
            return sn;
        }

        public Collection getRemoveObjects() {
            return this.removeObjects;
        }

        public Collection getAddObjects() {
            return this.addObjects;
        }

        public boolean isEmpty() {
            return this.notifications.isEmpty();
        }

        public void clear() {
            this.notifications.clear();
            this.addEvents.clear();
            this.removeEvents.clear();
        }

        protected boolean isIgnorable(Notification notification) {
            if (notification == null || notification.getNotifier() == null) {
                return true;
            }
            if (notification.isTouch()) {
                return true;
            }
            if (notification.getNotifier() != this.notifier) {
                return true;
            }
            return notification.getFeature() == null && notification.getNotifier() instanceof EObject;
        }

        protected boolean isMoveNotification(Notification removeEvent, Notification addEvent) {
            return addEvent.getNotifier() instanceof EObject && addEvent.getFeature() == removeEvent.getFeature() && addEvent.getPosition() != removeEvent.getPosition();
        }

        protected Notification createMoveNotification(Notification removeEvent, Notification addEvent) {
            ENotificationImpl moveEvent = new ENotificationImpl((InternalEObject)addEvent.getNotifier(), 7, (EStructuralFeature)addEvent.getFeature(), (Object)new Integer(removeEvent.getPosition()), addEvent.getNewValue(), addEvent.getPosition());
            return moveEvent;
        }
    }
}

