/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.util.UriPathConverter;
import java.util.Arrays;
import org.eclipse.emf.common.util.URI;

public class BasicUriPathConverter
implements UriPathConverter {
    private static final String SEGMENT_EMPTY = "";
    private static final String SEGMENT_SELF = ".";
    private static final String SEGMENT_PARENT = "..";
    private static final char SEGMENT_SEPARATOR = '/';

    public String makeAbsolute(String relativePath, String basePath) {
        ArgCheck.isNotNull(relativePath);
        URI relativeURI = URI.createURI(relativePath);
        if (relativeURI.hasAbsolutePath()) {
            return relativePath;
        }
        ArgCheck.isNotNull(basePath);
        URI baseURI = URI.createURI(basePath);
        return this.makeAbsolute(relativeURI, baseURI).toString();
    }

    public URI makeAbsolute(URI relativeURI, URI baseURI) {
        ArgCheck.isNotNull(relativeURI);
        if (relativeURI.hasAbsolutePath()) {
            return relativeURI;
        }
        ArgCheck.isNotNull(baseURI);
        if (baseURI.isRelative()) {
            String[] segments = this.mergePath(relativeURI, baseURI, true);
            StringBuffer sb = new StringBuffer(200);
            for (int i2 = 0; i2 != segments.length; ++i2) {
                sb.append('/');
                sb.append(segments[i2]);
            }
            return URI.createURI(sb.toString());
        }
        return relativeURI.resolve(baseURI);
    }

    public String makeRelative(String absolutePath, String basePath) {
        ArgCheck.isNotNull(absolutePath);
        URI absoluteURI = URI.createURI(absolutePath);
        URI baseURI = URI.createURI(basePath);
        return this.makeRelative(absoluteURI, baseURI).toString();
    }

    public URI makeRelative(URI absoluteURI, URI baseURI) {
        ArgCheck.isNotNull(absoluteURI);
        ArgCheck.isNotNull(baseURI);
        ArgCheck.isNotNull(baseURI);
        if (baseURI.isRelative()) {
            String[] segments = this.findRelativePath(absoluteURI, baseURI, true);
            StringBuffer sb = new StringBuffer(200);
            String seg = segments[0];
            if (!(segments.length <= 1 || SEGMENT_SELF.equals(seg) || SEGMENT_PARENT.equals(seg) || SEGMENT_EMPTY.equals(seg))) {
                sb.append('/');
            }
            for (int i2 = 0; i2 != segments.length; ++i2) {
                seg = segments[i2];
                if (i2 > 0) {
                    sb.append('/');
                }
                sb.append(seg);
            }
            return URI.createURI(sb.toString());
        }
        return absoluteURI.deresolve(baseURI);
    }

    private String[] mergePath(URI relativeURI, URI baseURI, boolean preserveRootParents) {
        int i2;
        int segmentCount = relativeURI.segmentCount();
        String[] segments = relativeURI.segments();
        int baseSegmentCount = baseURI.segmentCount();
        String[] stack = new String[baseSegmentCount + segmentCount];
        int sp = 0;
        for (i2 = 0; i2 < baseSegmentCount - 1; ++i2) {
            sp = BasicUriPathConverter.accumulate(stack, sp, baseURI.segment(i2), preserveRootParents);
        }
        for (i2 = 0; i2 < segmentCount; ++i2) {
            sp = BasicUriPathConverter.accumulate(stack, sp, segments[i2], preserveRootParents);
        }
        if (sp > 0 && (segmentCount == 0 || SEGMENT_EMPTY.equals(segments[segmentCount - 1]) || SEGMENT_PARENT.equals(segments[segmentCount - 1]) || SEGMENT_SELF.equals(segments[segmentCount - 1]))) {
            stack[sp++] = SEGMENT_EMPTY;
        }
        String[] result = new String[sp];
        System.arraycopy(stack, 0, result, 0, sp);
        return result;
    }

    private static int accumulate(String[] stack, int sp, String segment, boolean preserveRootParents) {
        if (SEGMENT_PARENT.equals(segment)) {
            if (sp == 0) {
                if (preserveRootParents) {
                    stack[sp++] = segment;
                }
            } else if (SEGMENT_PARENT.equals(stack[sp - 1])) {
                stack[sp++] = segment;
            } else {
                --sp;
            }
        } else if (!SEGMENT_EMPTY.equals(segment) && !SEGMENT_SELF.equals(segment)) {
            stack[sp++] = segment;
        }
        return sp;
    }

    private String[] findRelativePath(URI absoluteURI, URI baseURI, boolean preserveRootParents) {
        int diff;
        int count;
        String[] segments = absoluteURI.segments();
        String[] startPath = this.collapseSegments(baseURI, preserveRootParents);
        String[] endPath = segments;
        int startCount = startPath.length > 0 ? startPath.length - 1 : 0;
        int endCount = endPath.length;
        int n2 = count = startCount < endCount ? startCount : endCount - 1;
        for (diff = 0; diff < count && startPath[diff].equals(endPath[diff]); ++diff) {
        }
        int upCount = startCount - diff;
        int downCount = endCount - diff;
        if (downCount == 1 && SEGMENT_EMPTY.equals(endPath[endCount - 1])) {
            downCount = 0;
        }
        if (upCount + downCount == 0) {
            return new String[]{SEGMENT_SELF};
        }
        Object[] result = new String[upCount + downCount];
        Arrays.fill(result, 0, upCount, SEGMENT_PARENT);
        System.arraycopy(endPath, diff, result, upCount, downCount);
        return result;
    }

    String[] collapseSegments(URI uri, boolean preserveRootParents) {
        String[] segments = uri.segments();
        if (!this.hasCollapsableSegments(uri, preserveRootParents)) {
            return segments;
        }
        int segmentCount = segments.length;
        String[] stack = new String[segmentCount];
        int sp = 0;
        for (int i2 = 0; i2 < segmentCount; ++i2) {
            sp = BasicUriPathConverter.accumulate(stack, sp, segments[i2], preserveRootParents);
        }
        if (sp > 0 && (SEGMENT_EMPTY.equals(segments[segmentCount - 1]) || SEGMENT_PARENT.equals(segments[segmentCount - 1]) || SEGMENT_SELF.equals(segments[segmentCount - 1]))) {
            stack[sp++] = SEGMENT_EMPTY;
        }
        String[] result = new String[sp];
        System.arraycopy(stack, 0, result, 0, sp);
        return result;
    }

    private boolean hasCollapsableSegments(URI uri, boolean preserveRootParents) {
        String[] segments = uri.segments();
        int len = segments.length;
        for (int i2 = 0; i2 < len; ++i2) {
            String segment = segments[i2];
            if ((i2 >= len - 1 || !SEGMENT_EMPTY.equals(segment)) && !SEGMENT_SELF.equals(segment) && (!SEGMENT_PARENT.equals(segment) || preserveRootParents && (i2 == 0 || SEGMENT_PARENT.equals(segments[i2 - 1])))) continue;
            return true;
        }
        return false;
    }
}

