/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.internal.core.xml.JdomHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class DotProjectUtils {
    public static final String DOT_PROJECT = ".project";

    private DotProjectUtils() {
    }

    public static IFile getDotProjectFile(IContainer container) {
        IProject project = container.getProject();
        if (project != null) {
            return container.getProject().getFile(DOT_PROJECT);
        }
        return null;
    }

    public static int getDotProjectCount(String fileName, boolean recurse, boolean onlyModelerProjects) throws IOException, JDOMException {
        File file = new File(fileName);
        return DotProjectUtils.getDotProjectCount(file, recurse, onlyModelerProjects);
    }

    public static int getDotProjectCount(File file, boolean recurse, boolean onlyModelerProjects) throws IOException, JDOMException {
        int dotProjectCount = 0;
        int depth = 0;
        ArrayList<File> resources = new ArrayList<File>();
        resources.add(file);
        while (resources.size() > 0) {
            File resource = (File)resources.get(0);
            if (resource.isFile()) {
                if (DotProjectUtils.isDotProject(resource, onlyModelerProjects)) {
                    ++dotProjectCount;
                }
                if (dotProjectCount > 1) {
                    return dotProjectCount;
                }
            } else if (recurse || depth == 0) {
                File[] members = resource.listFiles();
                for (int i2 = 0; i2 < members.length; ++i2) {
                    resources.add(members[i2]);
                }
                ++depth;
            }
            resources.remove(0);
        }
        return dotProjectCount;
    }

    public static boolean isDotProject(String file, boolean onlyModelerProject) throws IOException, JDOMException {
        return DotProjectUtils.isDotProject(new File(file), onlyModelerProject);
    }

    public static boolean isDotProject(File file, boolean onlyModelerProject) throws IOException, JDOMException {
        if (file.getName().equals(DOT_PROJECT)) {
            if (onlyModelerProject) {
                Document doc = JdomHelper.buildDocument(file);
                Element elementFound = JdomHelper.findElement(doc.getRootElement(), "nature");
                if (elementFound == null) {
                    return false;
                }
                return elementFound.getText().equals("com.metamatrix.modeler.core.modelNature");
            }
            return true;
        }
        return false;
    }

    public static int getDotProjectCount(IResource targetResource, boolean recurse, boolean onlyModelerProjects) throws CoreException, IOException, JDOMException {
        int dotProjectCount = 0;
        int depth = 0;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        resources.add(targetResource);
        while (resources.size() > 0) {
            IResource resource = (IResource)resources.get(0);
            if (!(resource instanceof IContainer)) {
                if (DotProjectUtils.isDotProject(resource, onlyModelerProjects)) {
                    ++dotProjectCount;
                }
                if (dotProjectCount > 1) {
                    return dotProjectCount;
                }
            } else if (recurse || depth == 0) {
                IResource[] members = ((IContainer)resource).members();
                for (int i2 = 0; i2 < members.length; ++i2) {
                    resources.add(members[i2]);
                }
                ++depth;
            }
            resources.remove(0);
        }
        return dotProjectCount;
    }

    public static boolean isDotProject(IResource resource, boolean onlyModelerProject) throws CoreException, IOException, JDOMException {
        if (resource.getName().equals(DOT_PROJECT) && resource.getType() == 1) {
            if (onlyModelerProject) {
                if (resource.isAccessible()) {
                    IProjectNature nature = resource.getProject().getNature("com.metamatrix.modeler.core.modelNature");
                    return nature != null;
                }
                return DotProjectUtils.isDotProject(((IFile)resource).getLocation().toFile(), onlyModelerProject);
            }
            return true;
        }
        return false;
    }
}

