/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.internal.core.util.OverflowingLRUCache;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceInfo;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceItemCache;
import java.util.HashMap;
import java.util.Map;

public class ModelWorkspaceCache {
    public static final int OPENABLE_CACHE_SIZE = 2000;
    protected ModelWorkspaceInfo workspaceInfo;
    protected Map projectAndRootCache = new HashMap(50);
    protected OverflowingLRUCache openableCache = new ModelWorkspaceItemCache(2000);
    protected Map childrenCache = new HashMap(40000);

    public double openableFillingRatio() {
        return this.openableCache.fillingRatio();
    }

    public int pkgSize() {
        return 0;
    }

    public Object getInfo(ModelWorkspaceItem item) {
        ArgCheck.isNotNull(item);
        switch (item.getItemType()) {
            case 1: {
                return this.workspaceInfo;
            }
            case 2: 
            case 4: {
                return this.projectAndRootCache.get(item);
            }
            case 5: {
                return this.openableCache.get(item);
            }
        }
        return this.childrenCache.get(item);
    }

    protected Object peekAtInfo(ModelWorkspaceItem item) {
        ArgCheck.isNotNull(item);
        switch (item.getItemType()) {
            case 1: {
                return this.workspaceInfo;
            }
            case 2: 
            case 4: {
                return this.projectAndRootCache.get(item);
            }
            case 5: {
                return this.openableCache.peek(item);
            }
        }
        return this.childrenCache.get(item);
    }

    protected void putInfo(ModelWorkspaceItem item, Object info) {
        ArgCheck.isNotNull(item);
        ArgCheck.isNotNull(info);
        switch (item.getItemType()) {
            case 1: {
                this.workspaceInfo = (ModelWorkspaceInfo)info;
                break;
            }
            case 2: 
            case 4: {
                this.projectAndRootCache.put(item, info);
                break;
            }
            case 5: {
                this.openableCache.put(item, info);
                break;
            }
            default: {
                this.childrenCache.put(item, info);
            }
        }
    }

    protected void removeInfo(ModelWorkspaceItem item) {
        ArgCheck.isNotNull(item);
        switch (item.getItemType()) {
            case 1: {
                this.workspaceInfo = null;
                break;
            }
            case 2: 
            case 4: {
                this.projectAndRootCache.remove(item);
                break;
            }
            case 5: {
                this.openableCache.remove(item);
                break;
            }
            default: {
                this.childrenCache.remove(item);
            }
        }
    }

    public void clear() {
        this.childrenCache.clear();
        this.openableCache.flush();
        this.projectAndRootCache.clear();
        this.workspaceInfo = null;
    }
}

