/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.workspace;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.refactor.ModelResourceCollectorVisitor;
import com.metamatrix.modeler.core.workspace.ModelProject;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelResourceReloadVetoListener;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceNotificationListener;
import com.metamatrix.modeler.internal.core.workspace.ModelProjectImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelStatusImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceInfo;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.core.workspace.OpenableImpl;
import com.metamatrix.modeler.internal.core.workspace.OpenableModelWorkspaceItemInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelWorkspaceImpl
extends OpenableImpl
implements ModelWorkspace {
    private static final String[] MODEL_NATURES = new String[]{"com.metamatrix.modeler.core.modelNature"};
    public static HashSet existingExternalFiles = new HashSet();

    public static void flushExternalFileCache() {
        existingExternalFiles = new HashSet();
    }

    public static Object getTarget(IContainer container, IPath path, boolean checkResourceExistence) {
        IResource resource;
        if (path == null) {
            return null;
        }
        if (path.getDevice() == null && (resource = container.findMember(path)) != null) {
            if (!checkResourceExistence || resource.exists()) {
                return resource;
            }
            return null;
        }
        if (!path.isAbsolute()) {
            return null;
        }
        File externalFile = new File(path.toOSString());
        if (!checkResourceExistence) {
            return externalFile;
        }
        if (existingExternalFiles.contains(externalFile)) {
            return externalFile;
        }
        if (ModelWorkspaceManager.ZIP_ACCESS_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [ModelWorkspaceImpl.getTarget(...)] Checking existence of " + ((Object)path).toString());
        }
        if (externalFile.exists()) {
            existingExternalFiles.add(externalFile);
            return externalFile;
        }
        return null;
    }

    ModelWorkspaceImpl() {
        super(1, null, "");
    }

    public IPath getPath() {
        return Path.ROOT;
    }

    public IResource getResource() {
        return this.getWorkspace().getRoot();
    }

    public IResource getUnderlyingResource() throws ModelWorkspaceException {
        return null;
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected boolean generateInfos(OpenableModelWorkspaceItemInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelWorkspaceException {
        ModelWorkspaceManager.getModelWorkspaceManager().putInfo(this, info);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int max = projects.length;
        for (int i2 = 0; i2 < max; ++i2) {
            IProject project = projects[i2];
            if (!ModelerCore.hasModelNature(project)) continue;
            info.addChild(this.getModelProject(project));
        }
        return true;
    }

    public ModelProject findModelProject(String name) {
        ArgCheck.isNotNull(name);
        try {
            ModelProject[] projects = this.getModelProjects();
            int ndx = projects.length;
            while (--ndx >= 0) {
                ModelProject project = projects[ndx];
                if (!name.equals(project.getItemName())) continue;
                return project;
            }
        }
        catch (ModelWorkspaceException e2) {
            ModelerCore.Util.log(e2);
        }
        return null;
    }

    public ModelProject findModelProject(IResource resource) {
        ArgCheck.isNotNull(resource);
        IProject rsrcProject = null;
        switch (resource.getType()) {
            case 2: {
                rsrcProject = ((IFolder)resource).getProject();
                break;
            }
            case 1: {
                rsrcProject = ((IFile)resource).getProject();
                break;
            }
            case 4: {
                rsrcProject = (IProject)resource;
                break;
            }
        }
        try {
            ModelProject[] projects = this.getModelProjects();
            int ndx = projects.length;
            while (--ndx >= 0) {
                ModelProject mdlProject = projects[ndx];
                if (rsrcProject == null || !rsrcProject.equals(mdlProject.getResource())) continue;
                return mdlProject;
            }
        }
        catch (ModelWorkspaceException modelWorkspaceException) {
            // empty catch block
        }
        return null;
    }

    public ModelWorkspaceItem getParent(IResource resource) {
        ArgCheck.isNotNull(resource);
        IProject project = resource.getProject();
        if (project.isAccessible() && !ModelerCore.hasModelNature(project)) {
            return null;
        }
        if (resource instanceof IProject) {
            return this;
        }
        IContainer parent = resource.getParent();
        if (parent == null) {
            return null;
        }
        IPath path = resource.getFullPath();
        IPath parentPath = path.removeLastSegments(1);
        return this.getWorkspaceItem(parentPath);
    }

    public ModelWorkspaceItem getWorkspaceItem(IPath path, int resourceType) {
        ArgCheck.isNotNull(path);
        try {
            ModelProject[] projects = this.getModelProjects();
            block2: for (int i2 = 0; i2 < projects.length; ++i2) {
                ModelProject project = projects[i2];
                if (resourceType == 4) {
                    if (!((Object)project.getPath()).equals(path)) continue;
                    return project;
                }
                if (!project.isOpen()) continue;
                if (path.segmentCount() < 2) {
                    return null;
                }
                if (!path.segment(0).equals(project.getProject().getName())) continue;
                ModelWorkspaceItem item = project;
                String[] segments = path.segments();
                for (int j2 = 1; j2 < segments.length; ++j2) {
                    String segment = segments[j2];
                    if (!item.exists()) {
                        return null;
                    }
                    if ((item = item.getChild(segment)) == null) continue block2;
                    if (!((Object)item.getPath()).equals(path)) continue;
                    return item;
                }
            }
        }
        catch (ModelWorkspaceException modelWorkspaceException) {
            // empty catch block
        }
        return null;
    }

    public ModelWorkspaceItem getWorkspaceItem(IPath path) {
        ArgCheck.isNotNull(path);
        try {
            ModelProject[] projects = this.getModelProjects();
            block2: for (int i2 = 0; i2 < projects.length; ++i2) {
                ModelProject project = projects[i2];
                if (!project.exists()) continue;
                if (!project.isOpen()) {
                    IProject iproj = (IProject)project.getResource();
                    if (!iproj.isOpen()) continue;
                    project.open(null);
                    if (!project.isOpen()) continue;
                }
                if (((Object)project.getPath()).equals(path)) {
                    return project;
                }
                ModelWorkspaceItem item = project;
                String[] segments = path.segments();
                for (int j2 = 1; j2 < segments.length; ++j2) {
                    IContainer itemContainer;
                    IResource child;
                    String segment = segments[j2];
                    if (!item.exists()) {
                        return null;
                    }
                    IResource itemResource = item.getResource();
                    if ((item = item.getChild(segment)) == null && itemResource instanceof IContainer && (child = (itemContainer = (IContainer)itemResource).findMember(segment)) != null) {
                        item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(child, true);
                    }
                    if (item == null) continue block2;
                    if (!((Object)item.getPath()).equals(path)) continue;
                    return item;
                }
            }
        }
        catch (ModelWorkspaceException modelWorkspaceException) {
            // empty catch block
        }
        return null;
    }

    public ModelProject createModelProject(String name, IPath path, IProgressMonitor monitor) throws CoreException {
        ArgCheck.isNotNull(name);
        if (this.findModelProject(name) != null) {
            throw new ModelWorkspaceException(ModelerCore.Util.getString("ModelWorkspaceImpl.cannotCreateModelProject", name));
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(name, 4);
        if (!status.isOK()) {
            throw new ModelWorkspaceException(new ModelStatusImpl(status.getSeverity(), status.getCode(), status.getMessage()));
        }
        final IProject project = workspace.getRoot().getProject(name);
        final IProjectDescription desc = workspace.newProjectDescription(project.getName());
        desc.setLocation(path);
        desc.setNatureIds(MODEL_NATURES);
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.create(desc, monitor);
                project.open(monitor);
            }
        };
        workspace.run(op, monitor);
        return new ModelProjectImpl(project, this);
    }

    public ModelProject getModelProject(IResource resource) {
        if (!ModelerCore.hasModelNature(resource.getProject())) {
            return null;
        }
        ModelProject modelProject = this.findModelProject(resource);
        if (modelProject == null) {
            IProject project = resource.getProject();
            switch (resource.getType()) {
                case 1: 
                case 2: 
                case 4: {
                    return new ModelProjectImpl(project, this);
                }
                case 8: {
                    return null;
                }
            }
            throw new IllegalArgumentException(ModelerCore.Util.getString("ModelWorkspaceImpl.Invalid_resource_for_ModelProject", resource, this));
        }
        return modelProject;
    }

    public ModelProject[] getModelProjects() throws ModelWorkspaceException {
        ArrayList list = this.getChildrenOfType(2);
        ModelProject[] array = new ModelProject[list.size()];
        list.toArray(array);
        return array;
    }

    public ModelResource[] getModelResources() throws CoreException {
        ArrayList temp = new ArrayList();
        ModelProject[] projects = this.getModelProjects();
        for (int i2 = 0; i2 < projects.length; ++i2) {
            ModelProject mProject = projects[i2];
            ModelResourceCollectorVisitor visitor = new ModelResourceCollectorVisitor();
            if (mProject == null || !mProject.isOpen()) continue;
            mProject.getProject().accept(visitor);
            temp.addAll(visitor.getModelResources());
        }
        ModelResource[] modelResources = new ModelResource[temp.size()];
        temp.toArray(modelResources);
        return modelResources;
    }

    public Resource[] getEmfResources() throws CoreException {
        Resource[] result = null;
        ModelResource[] modelResources = this.getModelResources();
        if (modelResources.length == 0) {
            result = new Resource[]{};
        } else {
            ArrayList<Resource> temp = new ArrayList<Resource>(modelResources.length);
            for (int i2 = 0; i2 < modelResources.length; ++i2) {
                try {
                    Resource resource = modelResources[i2].getEmfResource();
                    if (resource == null) continue;
                    temp.add(resource);
                    continue;
                }
                catch (ModelWorkspaceException theException) {
                    ModelerCore.Util.log(theException);
                }
            }
            result = temp.toArray(new Resource[temp.size()]);
        }
        return result;
    }

    public Object[] getNonModelingResources() throws ModelWorkspaceException {
        return ((ModelWorkspaceInfo)this.getItemInfo()).getNonModelResources();
    }

    protected OpenableModelWorkspaceItemInfo createItemInfo() {
        return new ModelWorkspaceInfo();
    }

    public ModelResource findModelResource(IResource resource) {
        ArgCheck.isNotNull(resource);
        if (!ModelUtil.isModelFile(resource)) {
            return null;
        }
        return (ModelResource)this.getWorkspaceItem(resource.getFullPath(), 1);
    }

    public ModelResource findModelResource(Resource resource) {
        ArgCheck.isNotNull(resource);
        return ModelWorkspaceManager.getModelWorkspaceManager().findModelResource(resource);
    }

    public ModelResource findModelResource(IPath pathInWorkspace) {
        ArgCheck.isNotNull(pathInWorkspace);
        try {
            ModelWorkspaceItem item = this;
            String[] segments = pathInWorkspace.segments();
            for (int i2 = 0; i2 < segments.length; ++i2) {
                String segment = segments[i2];
                if (item == null) break;
                item = item.getChild(segment);
            }
            if (item == null || item.getItemType() != 5) {
                return null;
            }
            return (ModelResource)item;
        }
        catch (ModelWorkspaceException e2) {
            ModelerCore.Util.log(e2);
            return null;
        }
    }

    public ModelResource findModelResource(EObject eObject) {
        ArgCheck.isNotNull(eObject);
        try {
            Container container = ModelerCore.getModelContainer();
            Resource resource = ModelerCore.getModelEditor().findResource(container, eObject, false);
            if (resource != null) {
                return this.findModelResource(resource);
            }
        }
        catch (CoreException err) {
            ModelerCore.Util.log(err);
        }
        return null;
    }

    public void addNotificationListener(ModelWorkspaceNotificationListener listener) {
        ArgCheck.isNotNull(listener);
        ModelWorkspaceManager.getModelWorkspaceManager().addNotificationListener(listener);
    }

    public void removeNotificationListener(ModelWorkspaceNotificationListener listener) {
        ArgCheck.isNotNull(listener);
        ModelWorkspaceManager.getModelWorkspaceManager().removeNotificationListener(listener);
    }

    public void addModelResourceReloadVetoListener(ModelResourceReloadVetoListener listener) {
        ArgCheck.isNotNull(listener);
        ModelWorkspaceManager.getModelWorkspaceManager().addModelResourceReloadVetoListener(listener);
    }

    public void removeModelResourceReloadVetoListener(ModelResourceReloadVetoListener listener) {
        ArgCheck.isNotNull(listener);
        ModelWorkspaceManager.getModelWorkspaceManager().removeModelResourceReloadVetoListener(listener);
    }
}

