/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.TransformationFactory;
import com.metamatrix.metamodels.transformation.TransformationMapping;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.metadata.runtime.ColumnRecord;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.core.metadata.runtime.ProcedureParameterRecord;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationMappingHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationSqlHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.query.m.d;
import com.metamatrix.query.o.g.g;
import com.metamatrix.query.o.h.k;
import com.metamatrix.query.o.i.a;
import com.metamatrix.query.o.i.j;
import com.metamatrix.query.o.j.ai;
import com.metamatrix.query.o.j.an;
import com.metamatrix.query.o.j.l;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;

public class AttributeMappingHelper {
    private static final boolean NOT_SIGNIFICANT = false;
    private static final boolean IS_UNDOABLE = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateAttributeMappings(Object transMappingRoot, Object txnSource) {
        boolean changed = false;
        if (!TransformationHelper.isTransformationMappingRoot(transMappingRoot)) {
            return changed;
        }
        List targetAttrs = TransformationHelper.getTransformationTargetAttributes((EObject)transMappingRoot);
        if (targetAttrs == null || targetAttrs.isEmpty()) {
            return changed;
        }
        boolean requiredStart = ModelerCore.startTxn(false, true, "Update attr mappings", txnSource);
        boolean succeeded = false;
        try {
            AttributeMappingHelper.cleanAttributeMappings(transMappingRoot, txnSource);
            changed = AttributeMappingHelper.reconcileAttributeMappings(transMappingRoot, targetAttrs, txnSource);
            boolean isValid = SqlMappingRootCache.isSelectValid(transMappingRoot);
            if (!isValid) {
                boolean bl = changed;
                return bl;
            }
            l command = SqlMappingRootCache.getSelectCommand(transMappingRoot);
            List projectedSymbols = command.gg();
            List attrs = TransformationHelper.getTransformationTargetAttributes((EObject)transMappingRoot);
            TransformationMappingHelper.removeNonSelectableColumnAttributes(attrs);
            ArrayList<EObject> unmapped = new ArrayList<EObject>();
            Iterator iter = attrs.iterator();
            while (iter.hasNext()) {
                j seSymbol;
                EObject attr = (EObject)iter.next();
                if (!TransformationHelper.isSqlColumn(attr)) continue;
                String colName = TransformationHelper.getSqlEObjectName(attr);
                if (!AttributeMappingHelper.hasAttributeMapping(transMappingRoot, attr)) {
                    AttributeMappingHelper.createAttributeMapping(transMappingRoot, attr, txnSource);
                    changed = true;
                }
                if ((seSymbol = AttributeMappingHelper.getSymbolWithName(projectedSymbols, colName)) != null) {
                    Collection elemSymbols = k.e8(seSymbol, true);
                    List elemEObjs = TransformationSqlHelper.getElementSymbolEObjects(elemSymbols, command);
                    changed = AttributeMappingHelper.setAttributeMapping(transMappingRoot, attr, elemEObjs, txnSource) || changed;
                    continue;
                }
                unmapped.add(attr);
            }
            List<EObject> attrsInAP = null;
            TransformationMappingRoot root = (TransformationMappingRoot)transMappingRoot;
            attrsInAP = root.getOutputs().size() > 0 && root.getOutputs().get(0) instanceof MappingClass ? unmapped : TransformationHelper.getTransformationTargetAttributesInAccessPattern((EObject)transMappingRoot);
            List nonSelectable = TransformationHelper.getTransformationTargetAttributes((EObject)transMappingRoot);
            TransformationMappingHelper.removeSelectableColumnAttributes(nonSelectable);
            if (nonSelectable.size() > 0) {
                if (attrsInAP.size() == 0) {
                    attrsInAP = nonSelectable;
                } else {
                    attrsInAP.addAll(nonSelectable);
                }
            }
            if (attrsInAP.size() == 0) {
                succeeded = true;
                boolean elemSymbols = changed;
                return elemSymbols;
            }
            Map attributesToParameters = AttributeMappingHelper.createAttributeToParameterMap(command, attrsInAP, transMappingRoot);
            Iterator i2 = attributesToParameters.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                EObject attr = (EObject)entry.getKey();
                List elemObjs = (List)entry.getValue();
                if (!AttributeMappingHelper.hasAttributeMapping(transMappingRoot, attr)) {
                    AttributeMappingHelper.createAttributeMapping(transMappingRoot, attr, txnSource);
                    changed = true;
                }
                changed = AttributeMappingHelper.setAttributeMapping(transMappingRoot, attr, elemObjs, txnSource) || changed;
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return changed;
    }

    private static Map createAttributeToParameterMap(l command, List attrsInAP, Object transMappingRoot) {
        Iterator sources = TransformationHelper.getTransformationSources(transMappingRoot).iterator();
        ArrayList possibleParameters = new ArrayList();
        while (sources.hasNext()) {
            EObject source = (EObject)sources.next();
            if (!SqlAspectHelper.isTable(source)) continue;
            possibleParameters.addAll(TransformationHelper.getTargetAttributes(source));
        }
        TransformationMappingHelper.removeNonParameterColumnAttributes(possibleParameters);
        HashMap attributesToParameters = new HashMap();
        if (possibleParameters.size() > 0) {
            final ArrayList criteria = new ArrayList();
            com.metamatrix.query.o.a visitor = new com.metamatrix.query.o.a(){

                public void visit(ai obj) {
                    if (obj.es() == 1 && obj.eu() instanceof a && obj.e1() instanceof a) {
                        criteria.add(obj);
                    }
                }
            };
            g.d5(command, visitor);
            Iterator critIter = criteria.iterator();
            while (critIter.hasNext()) {
                ai crit = (ai)critIter.next();
                a symbol = (a)crit.eu();
                a otherSymbol = (a)crit.e1();
                Object mid = symbol.bf();
                Object otherMid = otherSymbol.bf();
                if (!(mid instanceof ColumnRecord) || !(otherMid instanceof ColumnRecord)) continue;
                ColumnRecord column = (ColumnRecord)mid;
                ColumnRecord otherColumn = (ColumnRecord)otherMid;
                if (attrsInAP.contains(column.getEObject()) && possibleParameters.contains(otherColumn.getEObject())) {
                    AttributeMappingHelper.updateAttributeToParameterMap(attributesToParameters, column.getEObject(), otherColumn.getEObject());
                    continue;
                }
                if (!attrsInAP.contains(otherColumn.getEObject()) || !possibleParameters.contains(column.getEObject())) continue;
                AttributeMappingHelper.updateAttributeToParameterMap(attributesToParameters, otherColumn.getEObject(), column.getEObject());
            }
        }
        List procInputParams = TransformationSqlHelper.getProcedureInputParams(command);
        Iterator procParamIter = procInputParams.iterator();
        while (procParamIter.hasNext()) {
            EObject attribute;
            Object mid;
            an spp = (an)procParamIter.next();
            if (!(spp.s() instanceof a) || !((mid = ((a)spp.s()).bf()) instanceof ColumnRecord) || !attrsInAP.contains(attribute = ((ColumnRecord)mid).getEObject())) continue;
            Object paramMid = spp.j();
            EObject eObj = null;
            if (paramMid != null && paramMid instanceof ProcedureParameterRecord) {
                eObj = ((ProcedureParameterRecord)paramMid).getEObject();
            }
            AttributeMappingHelper.updateAttributeToParameterMap(attributesToParameters, attribute, eObj);
        }
        return attributesToParameters;
    }

    private static void updateAttributeToParameterMap(Map attributesToParameters, EObject column, EObject otherColumn) {
        LinkedList<EObject> params = (LinkedList<EObject>)attributesToParameters.get(column);
        if (params == null) {
            params = new LinkedList<EObject>();
            attributesToParameters.put(column, params);
        }
        if (otherColumn != null) {
            params.add(otherColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean reconcileAttributeMappings(Object transMappingRoot, List targetAttrs, Object txnSource) {
        boolean changed = false;
        if (TransformationHelper.isTransformationMappingRoot(transMappingRoot) && targetAttrs != null) {
            boolean requiredStart = ModelerCore.startTxn(false, true, "Reconcile attr mappings", txnSource);
            boolean succeeded = false;
            try {
                List currentMappedAttributes = AttributeMappingHelper.getMappedAttributes(transMappingRoot);
                Iterator iter = targetAttrs.iterator();
                while (iter.hasNext()) {
                    EObject targetAttr = (EObject)iter.next();
                    if (TransformationHelper.isNonSelectableSqlColumn(targetAttr) || currentMappedAttributes.contains(targetAttr)) continue;
                    TransformationFactory mappingFactory = TransformationFactory.eINSTANCE;
                    TransformationMapping attrMapping = mappingFactory.createTransformationMapping();
                    attrMapping.setNestedIn((MappingRoot)transMappingRoot);
                    EList outputs = attrMapping.getOutputs();
                    outputs.add(targetAttr);
                    changed = true;
                }
                for (int i2 = currentMappedAttributes.size() - 1; i2 >= 0; --i2) {
                    EObject mappingAttr = (EObject)currentMappedAttributes.get(i2);
                    if (!TransformationHelper.isNonSelectableSqlColumn(mappingAttr) && targetAttrs.contains(mappingAttr)) continue;
                    AttributeMappingHelper.removeAttributeMapping(transMappingRoot, mappingAttr, txnSource);
                    changed = true;
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAttributeMapping(Object transMappingRoot, EObject targetAttr, Object txnSource) {
        List currentMappedAttributes;
        if (TransformationHelper.isTransformationMappingRoot(transMappingRoot) && targetAttr != null && TransformationHelper.isSqlColumn(targetAttr) && !(currentMappedAttributes = AttributeMappingHelper.getMappedAttributes(transMappingRoot)).contains(targetAttr)) {
            boolean requiredStart = ModelerCore.startTxn(false, true, "Create attr mapping", txnSource);
            boolean succeeded = false;
            try {
                TransformationFactory mappingFactory = TransformationFactory.eINSTANCE;
                TransformationMapping attrMapping = mappingFactory.createTransformationMapping();
                attrMapping.setNestedIn((MappingRoot)transMappingRoot);
                EList outputs = attrMapping.getOutputs();
                outputs.add(targetAttr);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static Mapping getAttributeMapping(Object transMappingRoot, EObject targetAttr) {
        Mapping attrMapping = null;
        List attrMappings = AttributeMappingHelper.getAttributeMappings(transMappingRoot);
        Iterator iter = attrMappings.iterator();
        while (iter.hasNext()) {
            EObject target;
            EList targets;
            EObject eObj = (EObject)iter.next();
            if (!(eObj instanceof Mapping) || (targets = ((Mapping)eObj).getOutputs()).isEmpty() || (target = (EObject)targets.get(0)) == null || !target.equals(targetAttr)) continue;
            attrMapping = (Mapping)eObj;
            break;
        }
        return attrMapping;
    }

    public static boolean hasAttributeMapping(Object transMappingRoot, EObject targetAttr) {
        boolean hasMapping = false;
        List attrMappings = AttributeMappingHelper.getAttributeMappings(transMappingRoot);
        Iterator iter = attrMappings.iterator();
        while (iter.hasNext()) {
            EObject target;
            EList targets;
            EObject eObj = (EObject)iter.next();
            if (!(eObj instanceof Mapping) || (targets = ((Mapping)eObj).getOutputs()).isEmpty() || (target = (EObject)targets.get(0)) == null || !target.equals(targetAttr)) continue;
            hasMapping = true;
            break;
        }
        return hasMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAttributeMapping(Object transMappingRoot, EObject targetAttr, Object txnSource) {
        Mapping mapping = AttributeMappingHelper.getAttributeMapping(transMappingRoot, targetAttr);
        if (mapping != null) {
            boolean requiredStart = ModelerCore.startTxn(false, true, "Remove attr mapping", txnSource);
            boolean succeeded = false;
            try {
                ModelerCore.getModelEditor().delete(mapping);
                succeeded = true;
            }
            catch (ModelerCoreException e2) {
                String message = TransformationPlugin.Util.getString("AttributeMappingHelper.removeAttrMappingError", transMappingRoot.toString());
                TransformationPlugin.Util.log(4, e2, message);
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setAttributeMapping(Object transMappingRoot, EObject targetAttr, Collection sourceAttrs, Object txnSource) {
        boolean changed = false;
        Mapping attrMapping = AttributeMappingHelper.getAttributeMapping(transMappingRoot, targetAttr);
        if (attrMapping != null) {
            boolean requiredStart = ModelerCore.startTxn(false, true, "Set attr mapping", txnSource);
            boolean succeeded = false;
            try {
                EList inputs = attrMapping.getInputs();
                Iterator iter = inputs.iterator();
                while (iter.hasNext()) {
                    Object currInput = iter.next();
                    if (sourceAttrs.contains(currInput)) {
                        sourceAttrs.remove(currInput);
                        continue;
                    }
                    iter.remove();
                    changed = true;
                }
                iter = sourceAttrs.iterator();
                while (iter.hasNext()) {
                    Object attr = iter.next();
                    if (attr == null) continue;
                    inputs.add(attr);
                    changed = true;
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAttributeMappingInputs(Object transMappingRoot, Object txnSource) {
        List attrMappings = AttributeMappingHelper.getAttributeMappings(transMappingRoot);
        if (!attrMappings.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn(false, true, "Clear attr mappings", txnSource);
            boolean succeeded = false;
            try {
                Iterator iter = attrMappings.iterator();
                while (iter.hasNext()) {
                    Mapping mapping = (Mapping)iter.next();
                    EList mappingInputs = mapping.getInputs();
                    Iterator mIter = mappingInputs.iterator();
                    while (mIter.hasNext()) {
                        mIter.next();
                        mIter.remove();
                    }
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanAttributeMappings(Object transMappingRoot, Object txnSource) {
        ArrayList attrMappings = new ArrayList(AttributeMappingHelper.getAttributeMappings(transMappingRoot));
        if (!attrMappings.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn(false, true, "check attr mappings", txnSource);
            boolean succeeded = false;
            try {
                Iterator iter = attrMappings.iterator();
                while (iter.hasNext()) {
                    Mapping mapping = (Mapping)iter.next();
                    EList outputs = mapping.getOutputs();
                    if (outputs != null && outputs.size() != 0) continue;
                    ModelerCore.getModelEditor().delete(mapping);
                }
                succeeded = true;
            }
            catch (ModelerCoreException e2) {
                String message = TransformationPlugin.Util.getString("AttributeMappingHelper.cleanAttrMappingError", transMappingRoot.toString());
                TransformationPlugin.Util.log(4, e2, message);
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAttributeMappings(Object transMappingRoot, Object txnSource) {
        ArrayList attrMappings = new ArrayList(AttributeMappingHelper.getAttributeMappings(transMappingRoot));
        if (!attrMappings.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn(false, true, "Clear attr mappings", txnSource);
            boolean succeeded = false;
            try {
                Iterator iter = attrMappings.iterator();
                while (iter.hasNext()) {
                    Mapping mapping = (Mapping)iter.next();
                    ModelerCore.getModelEditor().delete(mapping);
                }
                succeeded = true;
            }
            catch (ModelerCoreException e2) {
                String message = TransformationPlugin.Util.getString("AttributeMappingHelper.removeAttrMappingError", transMappingRoot.toString());
                TransformationPlugin.Util.log(4, e2, message);
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private static List getMappedAttributes(Object transMappingRoot) {
        List attrMappings = AttributeMappingHelper.getAttributeMappings(transMappingRoot);
        ArrayList mappedAttrs = new ArrayList(attrMappings.size());
        Iterator iter = attrMappings.iterator();
        while (iter.hasNext()) {
            EList targets;
            EObject eObj = (EObject)iter.next();
            if (!(eObj instanceof Mapping) || (targets = ((Mapping)eObj).getOutputs()).isEmpty()) continue;
            mappedAttrs.add(targets.get(0));
        }
        return mappedAttrs;
    }

    public static List getAttributeMappings(Object transMappingRoot) {
        List result = Collections.EMPTY_LIST;
        if (transMappingRoot != null && TransformationHelper.isTransformationMappingRoot(transMappingRoot)) {
            result = ((MappingRoot)transMappingRoot).getNested();
        }
        return result;
    }

    private static j getSymbolWithName(List seSymbols, String name) {
        j result = null;
        Iterator iter = seSymbols.iterator();
        while (iter.hasNext()) {
            j seSymbol = (j)iter.next();
            String symbolName = TransformationSqlHelper.getSingleElementSymbolShortName(seSymbol, false);
            if (symbolName == null || !symbolName.equalsIgnoreCase(name)) continue;
            result = seSymbol;
            break;
        }
        return result;
    }

    public static String getSymbolShortName(j symbol) {
        String fullName = AttributeMappingHelper.getSymbolFullName(symbol);
        int index = fullName.lastIndexOf(".");
        return fullName.substring(index + 1);
    }

    public static String getSymbolFullName(j symbol) {
        Object metadataID;
        ArgCheck.isNotNull(symbol);
        if (symbol instanceof a && (metadataID = ((a)symbol).bf()) != null) {
            if (metadataID instanceof MetadataRecord) {
                MetadataRecord record = (MetadataRecord)metadataID;
                return record.getFullName();
            }
            d tempID = (d)metadataID;
            return tempID.a();
        }
        return symbol.ak();
    }
}

