/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.modeler.core.refactor.ReferenceUpdator;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.UpdateLanguageObjectNameVisitor;
import com.metamatrix.modeler.transformation.validation.SqlTransformationResult;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.query.o.g.g;
import com.metamatrix.query.o.j.l;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mapping.Mapping;

public class TransformationReferenceUpdator
implements ReferenceUpdator {
    public void updateEObject(EObject eObject, Map oldToNewObjects) {
        if (eObject instanceof SqlTransformation) {
            UpdateLanguageObjectNameVisitor visitor = new UpdateLanguageObjectNameVisitor(oldToNewObjects);
            SqlTransformation sqlTransformation = (SqlTransformation)eObject;
            this.updateSqlTransformation(sqlTransformation, visitor);
        }
    }

    private void updateSqlTransformation(SqlTransformation sqlTransformation, UpdateLanguageObjectNameVisitor visitor) {
        SqlTransformationResult deleteResult;
        String deleteSql;
        SqlTransformationResult updateResult;
        String updateSql;
        SqlTransformationResult insertResult;
        String insertSql;
        SqlTransformationResult selectResult;
        Mapping mappingRoot = sqlTransformation.getMapper();
        String selectSql = sqlTransformation.getSelectSql();
        if (selectSql != null && (selectResult = TransformationValidator.parseSQL(selectSql)).isParsable()) {
            l selectCmd = selectResult.getCommand();
            g.d5(selectCmd, visitor);
            String newSelect = selectCmd.toString();
            if (!selectSql.equalsIgnoreCase(newSelect)) {
                SqlMappingRootCache.invalidateSelectStatus(mappingRoot, true, null);
                sqlTransformation.setSelectSql(newSelect);
            }
        }
        if ((insertSql = sqlTransformation.getInsertSql()) != null && (insertResult = TransformationValidator.parseSQL(insertSql)).isParsable()) {
            l insertCmd = insertResult.getCommand();
            g.d5(insertCmd, visitor);
            String newInsert = insertCmd.toString();
            if (!insertSql.equalsIgnoreCase(newInsert)) {
                SqlMappingRootCache.invalidateInsertStatus(mappingRoot, true, null);
                sqlTransformation.setInsertSql(newInsert);
            }
        }
        if ((updateSql = sqlTransformation.getUpdateSql()) != null && (updateResult = TransformationValidator.parseSQL(updateSql)).isParsable()) {
            l updateCmd = updateResult.getCommand();
            g.d5(updateCmd, visitor);
            String newUpdate = updateCmd.toString();
            if (!updateSql.equalsIgnoreCase(newUpdate)) {
                SqlMappingRootCache.invalidateUpdateStatus(mappingRoot, true, null);
                sqlTransformation.setUpdateSql(newUpdate);
            }
        }
        if ((deleteSql = sqlTransformation.getDeleteSql()) != null && (deleteResult = TransformationValidator.parseSQL(deleteSql)).isParsable()) {
            l deleteCmd = deleteResult.getCommand();
            g.d5(deleteCmd, visitor);
            String newDelete = deleteCmd.toString();
            if (!deleteSql.equalsIgnoreCase(newDelete)) {
                SqlMappingRootCache.invalidateDeleteStatus(mappingRoot, true, null);
                sqlTransformation.setDeleteSql(newDelete);
            }
        }
    }
}

