/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.validation;

import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.query.f.c.e;
import com.metamatrix.query.o.j.l;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;

public class SqlTransformationResult
implements e {
    private boolean isParsable = false;
    private boolean isResolvable = false;
    private boolean isValidatable = false;
    private IStatus targetValidStatus = null;
    private String sqlString = null;
    private l command = null;
    private boolean isUUIDStatus;
    private Collection sourceGroups = Collections.EMPTY_LIST;
    private Map externalMetadataMap = null;
    private Collection statuses = null;

    public SqlTransformationResult() {
    }

    public SqlTransformationResult(l command, Collection statuses) {
        this.command = command;
        this.statuses = statuses;
        this.isParsable = command != null;
    }

    public SqlTransformationResult(l command, IStatus status) {
        this(command, new HashSet(1));
        if (status != null) {
            this.statuses.add(status);
        }
    }

    public SqlTransformationResult(boolean parsable, boolean resolvable, boolean validatable, IStatus targetValidStatus, String sqlString, l command, Set sourceGroups, Map externalMap) {
        this.isParsable = parsable;
        this.isResolvable = resolvable;
        this.isValidatable = validatable;
        this.targetValidStatus = targetValidStatus;
        this.sqlString = sqlString;
        this.command = command;
        this.setSourceGroups(sourceGroups);
        this.externalMetadataMap = externalMap;
    }

    public void setParsable(boolean parsable) {
        this.isParsable = parsable;
    }

    public void setResolvable(boolean resolvable) {
        this.isResolvable = resolvable;
    }

    public void setValidatable(boolean validatable) {
        this.isValidatable = validatable;
    }

    public void setCommand(l command) {
        this.command = command;
    }

    public void setSourceGroups(Collection sourceGroups) {
        if (sourceGroups != null) {
            this.sourceGroups = sourceGroups;
        }
    }

    public void setExternalMetadataMap(Map map) {
        this.externalMetadataMap = map;
    }

    public void setSqlString(String sqlString) {
        this.sqlString = sqlString;
    }

    public boolean isParsable() {
        return this.isParsable;
    }

    public boolean isResolvable() {
        return this.isResolvable;
    }

    public boolean isValidatable() {
        return this.isValidatable;
    }

    public boolean isTargetValid() {
        return this.targetValidStatus == null || this.targetValidStatus.isOK();
    }

    public IStatus getTargetValidStatus() {
        return this.targetValidStatus;
    }

    public l getCommand() {
        return this.command;
    }

    public Collection getSourceGroups() {
        return this.sourceGroups;
    }

    public boolean hasSourceGroup(Object sourceGrp) {
        return this.sourceGroups != null && this.sourceGroups.contains(sourceGrp);
    }

    public boolean areSrcGroupMdlResourcesValid() {
        boolean isValid = true;
        if (this.sourceGroups == null || this.sourceGroups.isEmpty()) {
            isValid = false;
        } else {
            Iterator iter = this.sourceGroups.iterator();
            while (iter.hasNext()) {
                EObject sourceGrp = (EObject)iter.next();
                ModelResource mdlRsrc = ModelerCore.getModelEditor().findModelResource(sourceGrp);
                if (mdlRsrc != null && mdlRsrc.exists()) continue;
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    public Map getExternalMetadataMap() {
        return this.externalMetadataMap;
    }

    public String getSqlString() {
        return this.sqlString;
    }

    public boolean isUUIDStatus() {
        return this.isUUIDStatus;
    }

    public void setUUIDStatus(boolean b2) {
        this.isUUIDStatus = b2;
    }

    public Collection getStatusList() {
        return this.statuses;
    }

    public void setTargetValidStatus(IStatus targetValidStatus) {
        this.targetValidStatus = targetValidStatus;
    }
}

