/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.transformation.validation;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.relational.Procedure;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.webservice.Operation;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.workspace.ModelWorkspace;
import com.metamatrix.modeler.internal.core.index.AbstractIndexSelector;
import com.metamatrix.modeler.internal.core.index.ModelResourceIndexSelector;
import com.metamatrix.modeler.internal.core.index.NullIndexSelector;
import com.metamatrix.modeler.internal.core.index.TargetLocationIndexSelector;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.transformation.util.SqlAspectHelper;
import com.metamatrix.modeler.internal.transformation.util.SqlMappingRootCache;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationSqlHelper;
import com.metamatrix.modeler.transformation.TransformationPlugin;
import com.metamatrix.modeler.transformation.metadata.QueryMetadataContext;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadataFacade;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadataFactory;
import com.metamatrix.modeler.transformation.metadata.VdbMetadata;
import com.metamatrix.modeler.transformation.validation.SqlTransformationResult;
import com.metamatrix.modeler.transformation.validation.TransformationValidationResult;
import com.metamatrix.query.c.h;
import com.metamatrix.query.d.b;
import com.metamatrix.query.f.c.e;
import com.metamatrix.query.f.c.f;
import com.metamatrix.query.o.f.d;
import com.metamatrix.query.o.h.g;
import com.metamatrix.query.o.j.l;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;

public class TransformationValidator
implements f {
    private static final boolean DEFAULT_USE_CACHING = true;
    public static final String QUERY_METADATA_INTERFACE = ClassUtil.getSimpleClassName(class$com$metamatrix$modeler$transformation$validation$TransformationValidator == null ? (class$com$metamatrix$modeler$transformation$validation$TransformationValidator = TransformationValidator.class$("com.metamatrix.modeler.transformation.validation.TransformationValidator")) : class$com$metamatrix$modeler$transformation$validation$TransformationValidator) + ".QUERY_METADATA_INTERFACE";
    private com.metamatrix.query.m.e metadata;
    private final boolean restrictSearch;
    private final SqlTransformationMappingRoot mappingRoot;
    private final EObject targetGroup;
    private final ValidationContext validationContext;
    private static final String XML_URI = "http://www.metamatrix.com/metamodels/XmlDocument";
    static /* synthetic */ Class class$com$metamatrix$modeler$transformation$validation$TransformationValidator;

    public TransformationValidator(SqlTransformationMappingRoot eObject) {
        this(eObject, null, true, false);
    }

    public TransformationValidator(SqlTransformationMappingRoot eObject, boolean useCaching) {
        this(eObject, null, useCaching, false);
    }

    public TransformationValidator(SqlTransformationMappingRoot eObject, boolean useCaching, boolean restrictSearch) {
        this(eObject, null, useCaching, restrictSearch);
    }

    public TransformationValidator(SqlTransformationMappingRoot eObject, ValidationContext context, boolean useCaching, boolean restrictSearch) {
        this.restrictSearch = restrictSearch;
        this.mappingRoot = eObject;
        this.targetGroup = eObject.getTarget();
        this.validationContext = context;
    }

    public TransformationValidationResult validateTransformation() {
        EmfResource emfResource = (EmfResource)this.mappingRoot.eResource();
        if (emfResource.getModelAnnotation() != null) {
            ModelType type = emfResource.getModelAnnotation().getModelType();
            String stringURI = emfResource.getModelAnnotation().getPrimaryMetamodelUri();
            if (type.equals(ModelType.LOGICAL_LITERAL) && XML_URI.equals(stringURI)) {
                return new TransformationValidationResult();
            }
        }
        SqlTransformation sqlTrans = (SqlTransformation)this.mappingRoot.getHelper();
        String objectPath = TransformationHelper.getSqlEObjectPath(this.targetGroup);
        if (sqlTrans == null) {
            String msg = TransformationPlugin.Util.getString("TransformationValidator.Error_in_the_Sql_tranformation_for_1", objectPath);
            ArrayList<Status> statuses = new ArrayList<Status>(1);
            statuses.add(new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null));
            return new TransformationValidationResult(statuses);
        }
        TransformationValidationResult transformResult = new TransformationValidationResult();
        SqlTransformationResult selectStatus = SqlMappingRootCache.getSqlTransformationStatus(this.mappingRoot, 0, SqlMappingRootCache.EITHER_STATUS, this.restrictSearch, this.validationContext);
        if (selectStatus == null) {
            String msg = TransformationPlugin.Util.getString("TransformationValidator.Found_problems_validating_transformation_defining_{0},_re-validate_in_the_transformation_editor._1", objectPath);
            ArrayList<Status> statuses = new ArrayList<Status>(1);
            statuses.add(new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null));
            return new TransformationValidationResult(statuses);
        }
        transformResult.setSelectResult(selectStatus);
        if (transformResult.isValid() && SqlAspectHelper.isUpdatableGroup(this.targetGroup)) {
            if (sqlTrans.isInsertAllowed()) {
                transformResult.setInsertResult(SqlMappingRootCache.getSqlTransformationStatus(this.mappingRoot, 1, SqlMappingRootCache.EITHER_STATUS, this.restrictSearch, this.validationContext));
                transformResult.setInsertAllowed(true);
            }
            if (sqlTrans.isUpdateAllowed()) {
                transformResult.setUpdateResult(SqlMappingRootCache.getSqlTransformationStatus(this.mappingRoot, 2, SqlMappingRootCache.EITHER_STATUS, this.restrictSearch, this.validationContext));
                transformResult.setUpdateAllowed(true);
            }
            if (sqlTrans.isDeleteAllowed()) {
                transformResult.setDeleteResult(SqlMappingRootCache.getSqlTransformationStatus(this.mappingRoot, 3, SqlMappingRootCache.EITHER_STATUS, this.restrictSearch, this.validationContext));
                transformResult.setDeleteAllowed(true);
            }
        }
        return transformResult;
    }

    public e validateSql(String sql, int transformType, boolean isUUIDSql, boolean cacheResult) {
        l command;
        SqlTransformationResult commandValidationResult = null;
        commandValidationResult = TransformationValidator.parseSQL(sql);
        if (commandValidationResult.isParsable() && transformType != -1 && (commandValidationResult = this.resolveCommand(command = commandValidationResult.getCommand(), transformType)).isResolvable()) {
            commandValidationResult = this.validateCommand(command);
            commandValidationResult.setResolvable(true);
        }
        commandValidationResult.setSqlString(sql);
        commandValidationResult.setSourceGroups(this.mappingRoot.getInputs());
        commandValidationResult.setUUIDStatus(isUUIDSql);
        if (cacheResult) {
            SqlMappingRootCache.setStatus(this.mappingRoot, transformType, commandValidationResult);
        }
        return commandValidationResult;
    }

    public static SqlTransformationResult parseSQL(String sqlString) {
        l command = null;
        Status status = null;
        try {
            b parser = new b();
            command = parser.f(sqlString);
        }
        catch (Exception e2) {
            status = new Status(4, "com.metamatrix.modeler.transformation", 0, e2.getMessage(), e2);
        }
        SqlTransformationResult result = new SqlTransformationResult(command, status);
        if (status != null && !status.isOK()) {
            result.setParsable(false);
        }
        return result;
    }

    public SqlTransformationResult resolveCommand(l command, int transformType) {
        IStatus status = TransformationValidator.checkCommandType(command, transformType, this.targetGroup);
        if (status != null && status.getSeverity() != 0) {
            SqlTransformationResult resolverResult = new SqlTransformationResult(command, status);
            resolverResult.setTargetValidStatus(status);
            return resolverResult;
        }
        Map externalMetadata = Collections.EMPTY_MAP;
        try {
            externalMetadata = TransformationHelper.getExternalMetadataMap(command, this.mappingRoot, this.getQueryMetadata());
        }
        catch (QueryMetadataException e2) {
            Status errorStatus = new Status(4, "com.metamatrix.modeler.transformation", 0, e2.getMessage(), e2);
            return new SqlTransformationResult(command, errorStatus);
        }
        catch (MetaMatrixComponentException e3) {
            Status errorStatus = new Status(4, "com.metamatrix.modeler.transformation", 0, e3.getMessage(), e3);
            return new SqlTransformationResult(command, errorStatus);
        }
        return this.resolveCommand(command, externalMetadata);
    }

    public SqlTransformationResult validateCommand(l command) {
        ArgCheck.isNotNull(command);
        Collection statusList = null;
        try {
            h report = com.metamatrix.query.c.b.c(command, this.getQueryMetadata());
            if (!report.b()) {
                statusList = this.validateSources(command, statusList);
                statusList = this.validateReferences(command, statusList);
            } else {
                statusList = this.createStatusList(report);
            }
        }
        catch (MetaMatrixComponentException e2) {
            statusList = statusList != null ? statusList : new ArrayList<Status>(1);
            statusList.add(new Status(4, "com.metamatrix.modeler.transformation", 0, e2.getMessage(), e2));
        }
        SqlTransformationResult result = new SqlTransformationResult(command, statusList);
        if (statusList == null || statusList.isEmpty()) {
            result.setValidatable(true);
            result.setResolvable(true);
        }
        return result;
    }

    public com.metamatrix.query.m.e getQueryMetadata() {
        if (this.metadata == null) {
            boolean useServerMetadata;
            TransformationMetadataFactory factory = TransformationMetadataFactory.getInstance();
            boolean bl = useServerMetadata = this.validationContext != null && this.validationContext.useServerIndexes();
            if (!useServerMetadata) {
                ModelResourceIndexSelector selector = new ModelResourceIndexSelector(this.mappingRoot.eResource());
                QueryMetadataContext queryContext = new QueryMetadataContext(selector);
                queryContext.setRestrictedSearch(this.restrictSearch);
                if (this.validationContext != null) {
                    queryContext.setContainer(this.validationContext.getResourceContainer());
                    if (!this.validationContext.useIndexesToResolve()) {
                        queryContext.setIndexSelector(new NullIndexSelector());
                    }
                    queryContext.setResources(Arrays.asList(this.validationContext.getResourcesInScope()));
                } else {
                    try {
                        queryContext.setContainer(ModelerCore.getModelContainer());
                        ModelWorkspace workspace = ModelerCore.getModelWorkspace();
                        queryContext.setResources(Arrays.asList(workspace.getEmfResources()));
                    }
                    catch (CoreException e2) {
                        TransformationPlugin.Util.log(e2);
                    }
                }
                this.metadata = factory.getModelerMetadata(queryContext);
            } else {
                Assertion.isNotNull(this.validationContext);
                AbstractIndexSelector selector = null;
                if (this.validationContext.useIndexesToResolve()) {
                    if (this.validationContext.getData(QUERY_METADATA_INTERFACE) != null) {
                        this.metadata = (com.metamatrix.query.m.e)this.validationContext.getData(QUERY_METADATA_INTERFACE);
                        if (!(this.metadata instanceof VdbMetadata) && this.metadata instanceof TransformationMetadataFacade && !(((TransformationMetadataFacade)this.metadata).getDelegate() instanceof VdbMetadata)) {
                            throw new MetaMatrixRuntimeException(TransformationPlugin.Util.getString("TransformationValidator.QMI_of_unexpected_type"));
                        }
                    } else {
                        selector = new TargetLocationIndexSelector(this.validationContext.getIndexLocation());
                    }
                } else {
                    selector = new NullIndexSelector();
                }
                if (this.metadata == null) {
                    QueryMetadataContext queryContext = new QueryMetadataContext(selector);
                    queryContext.setContainer(this.validationContext.getResourceContainer());
                    queryContext.setResources(Arrays.asList(this.validationContext.getResourcesInScope()));
                    queryContext.setRestrictedSearch(this.restrictSearch);
                    this.metadata = factory.getVdbMetadata(queryContext);
                    this.validationContext.setData(QUERY_METADATA_INTERFACE, this.metadata);
                }
            }
        }
        return this.metadata;
    }

    public static IStatus checkCommandType(l command, int transformType, Object targetGroup) {
        ArgCheck.isNotNull(command);
        ArgCheck.isNotNull(targetGroup);
        int cmdType = command.gn();
        switch (transformType) {
            case 0: {
                if (targetGroup instanceof Table) {
                    if (cmdType == 1 || cmdType == 6) break;
                    String msg = TransformationPlugin.Util.getString("TransformationValidator.Query_defining_a_virtual_group_can_only_be_of_type_Select_or_Exec._1");
                    return new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null);
                }
                if (targetGroup instanceof Procedure) {
                    if (cmdType == 7 && !((d)command).gw()) break;
                    String msg = TransformationPlugin.Util.getString("TransformationValidator.Query_defining_a_virtual_procedure_can_only_be_of_type_Virtual_procedure._2");
                    return new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null);
                }
                if (!(targetGroup instanceof Operation) || cmdType == 7) break;
                String msg = TransformationPlugin.Util.getString("TransformationValidator.Query_defining_an_operation_can_only_be_of_type_Virtual_procedure._1");
                return new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null);
            }
            case 1: 
            case 2: 
            case 3: {
                if (cmdType == 7 && ((d)command).gw()) break;
                String msg = TransformationPlugin.Util.getString("TransformationValidator.Only_update_procedures_are_allowed_in_the_INSERT/UPDATE/DELETE_tabs._1");
                return new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null);
            }
            default: {
                String msg = TransformationPlugin.Util.getString("TransformationValidator.Invalid_transformation_type,_only_allowed_transformations_are_select,_insert,_update,_delete_transforms._1");
                return new Status(4, "com.metamatrix.modeler.transformation", 0, msg, null);
            }
        }
        return null;
    }

    protected List createStatusList(h report) {
        if (report != null && report.b()) {
            Collection items = report.g();
            ArrayList<Status> statusList = new ArrayList<Status>(items.size());
            Iterator itemIter = items.iterator();
            while (itemIter.hasNext()) {
                com.metamatrix.query.g.b item = (com.metamatrix.query.g.b)itemIter.next();
                Status status = new Status(4, "com.metamatrix.modeler.transformation", 0, item.toString(), null);
                statusList.add(status);
            }
            return statusList;
        }
        return Collections.EMPTY_LIST;
    }

    protected SqlTransformationResult resolveCommand(l command, Map externalMetadata) {
        Status status = null;
        ArgCheck.isNotNull(command);
        try {
            com.metamatrix.query.m.e metadata = this.getQueryMetadata();
            com.metamatrix.query.f.b.a(command, externalMetadata, false, metadata, com.metamatrix.query.k.b.e());
        }
        catch (MetaMatrixComponentException e2) {
            status = new Status(4, "com.metamatrix.modeler.transformation", 0, e2.getMessage(), e2);
        }
        catch (QueryResolverException e3) {
            status = new Status(4, "com.metamatrix.modeler.transformation", 0, e3.getMessage(), e3);
        }
        SqlTransformationResult resolverResult = new SqlTransformationResult(command, status);
        resolverResult.setExternalMetadataMap(externalMetadata);
        if (status == null) {
            resolverResult.setResolvable(true);
        }
        return resolverResult;
    }

    protected Collection validateReferences(l command, Collection statusList) {
        List references = g.er(command);
        if (!references.isEmpty()) {
            statusList = statusList != null ? statusList : new ArrayList(1);
            Status status = new Status(4, "com.metamatrix.modeler.transformation", 0, TransformationPlugin.Util.getString("TransformationValidator.The_transformation_contains_Reference_Symbols_(_),_which_is_not_allowed,_replace___with_a_constant,_element,_or_parameter_name._1"), null);
            statusList.add(status);
        }
        return statusList;
    }

    protected Collection validateSources(l command, Collection statusList) {
        if (this.isTargetASourceInCommand(command)) {
            statusList = statusList != null ? statusList : new ArrayList(1);
            String message = TransformationPlugin.Util.getString("TransformationValidator.errorTargetIsSourceMsg", ModelerCore.getModelEditor().getName(this.targetGroup));
            Status status = new Status(4, "com.metamatrix.modeler.transformation", 0, message, null);
            statusList.add(status);
        }
        return statusList;
    }

    protected boolean isTargetASourceInCommand(l command) {
        boolean result = false;
        Collection sourceSymbols = TransformationSqlHelper.getGroupSymbols(command);
        List sourceEObjects = TransformationSqlHelper.getGroupSymbolEObjects(sourceSymbols);
        if (!sourceEObjects.isEmpty() && this.mappingRoot != null) {
            EObject tRootTarget = this.mappingRoot.getTarget();
            Iterator iter = sourceEObjects.iterator();
            Object nextObj = null;
            while (iter.hasNext() && !result) {
                nextObj = iter.next();
                if (!nextObj.equals(tRootTarget)) continue;
                result = true;
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

