/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.function;

import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.FunctionExecutionException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.query.a;
import com.metamatrix.query.i.g;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class FunctionMethods {
    private static final String DEFAULT_DECODE_STRING_DELIMITER = ",";
    private static final double log10baseE = Math.log(10.0);
    private static final String[] dayNames = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final char SPACE = ' ';
    public static final Character SPACE_CHAR = new Character(' ');
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public static Object plus(Object object, Object object2) throws FunctionExecutionException {
        try {
            if (object == null || object2 == null) {
                return null;
            }
            if (object instanceof Integer) {
                if (object2 instanceof Integer) {
                    return new Integer((Integer)object + (Integer)object2);
                }
            } else if (object instanceof Long) {
                if (object2 instanceof Long) {
                    return new Long((Long)object + (Long)object2);
                }
            } else if (object instanceof Float) {
                if (object2 instanceof Float) {
                    return new Float(((Float)object).floatValue() + ((Float)object2).floatValue());
                }
            } else if (object instanceof Double) {
                if (object2 instanceof Double) {
                    return new Double((Double)object + (Double)object2);
                }
            } else if (object instanceof BigInteger) {
                if (object2 instanceof BigInteger) {
                    return ((BigInteger)object).add((BigInteger)object2);
                }
            } else if (object instanceof BigDecimal && object2 instanceof BigDecimal) {
                return ((BigDecimal)object).add((BigDecimal)object2);
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0006", a.b.getString("ERR.015.001.0006", object, object2));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", new Object[]{"plus", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object minus(Object object, Object object2) throws FunctionExecutionException {
        try {
            if (object == null || object2 == null) {
                return null;
            }
            if (object instanceof Integer) {
                if (object2 instanceof Integer) {
                    return new Integer((Integer)object - (Integer)object2);
                }
            } else if (object instanceof Long) {
                if (object2 instanceof Long) {
                    return new Long((Long)object - (Long)object2);
                }
            } else if (object instanceof Float) {
                if (object2 instanceof Float) {
                    return new Float(((Float)object).floatValue() - ((Float)object2).floatValue());
                }
            } else if (object instanceof Double) {
                if (object2 instanceof Double) {
                    return new Double((Double)object - (Double)object2);
                }
            } else if (object instanceof BigInteger) {
                if (object2 instanceof BigInteger) {
                    return ((BigInteger)object).subtract((BigInteger)object2);
                }
            } else if (object instanceof BigDecimal && object2 instanceof BigDecimal) {
                return ((BigDecimal)object).subtract((BigDecimal)object2);
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0008", a.b.getString("ERR.015.001.0008", object, object2));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", new Object[]{"minus", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object multiply(Object object, Object object2) throws FunctionExecutionException {
        try {
            if (object == null || object2 == null) {
                return null;
            }
            if (object instanceof Integer) {
                if (object2 instanceof Integer) {
                    return new Integer((Integer)object * (Integer)object2);
                }
            } else if (object instanceof Long) {
                if (object2 instanceof Long) {
                    return new Long((Long)object * (Long)object2);
                }
            } else if (object instanceof Float) {
                if (object2 instanceof Float) {
                    return new Float(((Float)object).floatValue() * ((Float)object2).floatValue());
                }
            } else if (object instanceof Double) {
                if (object2 instanceof Double) {
                    return new Double((Double)object * (Double)object2);
                }
            } else if (object instanceof BigInteger) {
                if (object2 instanceof BigInteger) {
                    return ((BigInteger)object).multiply((BigInteger)object2);
                }
            } else if (object instanceof BigDecimal && object2 instanceof BigDecimal) {
                return ((BigDecimal)object).multiply((BigDecimal)object2);
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0010", a.b.getString("ERR.015.001.0010", object, object2));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", new Object[]{"multiply", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object divide(Object object, Object object2) throws FunctionExecutionException {
        try {
            if (object == null || object2 == null) {
                return null;
            }
            if (object instanceof Integer) {
                if (object2 instanceof Integer) {
                    return new Integer((Integer)object / (Integer)object2);
                }
            } else if (object instanceof Long) {
                if (object2 instanceof Long) {
                    return new Long((Long)object / (Long)object2);
                }
            } else if (object instanceof Float) {
                if (object2 instanceof Float) {
                    return new Float(((Float)object).floatValue() / ((Float)object2).floatValue());
                }
            } else if (object instanceof Double) {
                if (object2 instanceof Double) {
                    return new Double((Double)object / (Double)object2);
                }
            } else if (object instanceof BigInteger) {
                if (object2 instanceof BigInteger) {
                    return ((BigInteger)object).divide((BigInteger)object2);
                }
            } else if (object instanceof BigDecimal && object2 instanceof BigDecimal) {
                return ((BigDecimal)object).divide((BigDecimal)object2, 4);
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0012", a.b.getString("ERR.015.001.0012", object, object2));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", new Object[]{"divide", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object abs(Object object) throws FunctionExecutionException {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof Integer) {
                return new Integer(Math.abs((Integer)object));
            }
            if (object instanceof Long) {
                return new Long(Math.abs((Long)object));
            }
            if (object instanceof Float) {
                return new Float(Math.abs(((Float)object).floatValue()));
            }
            if (object instanceof Double) {
                return new Double(Math.abs((Double)object));
            }
            if (object instanceof BigInteger) {
                return ((BigInteger)object).abs();
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).abs();
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0014", a.b.getString("ERR.015.001.0014", object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "abs", object.getClass().getName()));
    }

    public static Object ceiling(Object object) throws FunctionExecutionException {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof Float) {
                return new Double(Math.ceil(((Float)object).floatValue()));
            }
            if (object instanceof Double) {
                return new Double(Math.ceil((Double)object));
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0016", a.b.getString("ERR.015.001.0016", object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "ceiling", object.getClass().getName()));
    }

    public static Object exp(Object object) throws FunctionExecutionException {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof Float) {
                return new Double(Math.exp(((Float)object).floatValue()));
            }
            if (object instanceof Double) {
                return new Double(Math.exp((Double)object));
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0018", a.b.getString("ERR.015.001.0018", object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "exp", object.getClass().getName()));
    }

    public static Object floor(Object object) throws FunctionExecutionException {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof Float) {
                return new Double(Math.floor(((Float)object).floatValue()));
            }
            if (object instanceof Double) {
                return new Double(Math.floor((Double)object));
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0020", a.b.getString("ERR.015.001.0020", object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "floor", object.getClass().getName()));
    }

    public static Object log(Object object) throws FunctionExecutionException {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof Float) {
                return new Double(Math.log(((Float)object).floatValue()));
            }
            if (object instanceof Double) {
                return new Double(Math.log((Double)object));
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0022", a.b.getString("ERR.015.001.0022", object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "log", object.getClass().getName()));
    }

    public static Object log10(Object object) throws FunctionExecutionException {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof Float) {
                return new Double(Math.log(((Float)object).floatValue()) / log10baseE);
            }
            if (object instanceof Double) {
                return new Double(Math.log((Double)object) / log10baseE);
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0024", a.b.getString("ERR.015.001.0024", object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "log10", object.getClass().getName()));
    }

    public static Object rand(g g2, Object object) throws FunctionExecutionException {
        if (g2 != null) {
            if (object == null) {
                return new Double(g2.getNextRand());
            }
            if (object instanceof Integer) {
                return new Double(g2.getNextRand(((Integer)object).longValue()));
            }
        }
        throw new FunctionExecutionException("ERR.015.001.0069", a.b.getString("ERR.015.001.0069", "rand", object.getClass().getName()));
    }

    public static Object rand(g g2) throws FunctionExecutionException {
        if (g2 != null) {
            return new Double(g2.getNextRand());
        }
        throw new FunctionExecutionException("ERR.015.001.0069", a.b.getString("ERR.015.001.0069", "rand"));
    }

    public static Object mod(Object object, Object object2) throws FunctionExecutionException {
        try {
            if (object == null || object2 == null) {
                return null;
            }
            if (object instanceof Integer) {
                if (object2 instanceof Integer) {
                    return new Integer((Integer)object % (Integer)object2);
                }
            } else if (object instanceof Long) {
                if (object2 instanceof Long) {
                    return new Long((Long)object % (Long)object2);
                }
            } else if (object instanceof Float) {
                if (object2 instanceof Float) {
                    return new Float(((Float)object).floatValue() % ((Float)object2).floatValue());
                }
            } else if (object instanceof Double) {
                if (object2 instanceof Double) {
                    return new Double((Double)object % (Double)object2);
                }
            } else if (object instanceof BigInteger && object2 instanceof BigInteger) {
                return ((BigInteger)object).mod((BigInteger)object2);
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0026", a.b.getString("ERR.015.001.0026", object, object2));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", new Object[]{"mod", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object power(Object object, Object object2) throws FunctionExecutionException {
        try {
            if (object == null || object2 == null) {
                return null;
            }
            if (object instanceof Integer) {
                if (object2 instanceof Integer) {
                    return new Double(Math.pow(((Integer)object).intValue(), ((Integer)object2).intValue()));
                }
            } else if (object instanceof Long) {
                if (object2 instanceof Long) {
                    return new Double(Math.pow(((Long)object).longValue(), ((Long)object2).longValue()));
                }
            } else if (object instanceof Float) {
                if (object2 instanceof Float) {
                    return new Double(Math.pow(((Float)object).floatValue(), ((Float)object2).floatValue()));
                }
            } else if (object instanceof Double) {
                if (object2 instanceof Double) {
                    return new Double(Math.pow((Double)object, (Double)object2));
                }
            } else if (object instanceof BigInteger && object2 instanceof Integer) {
                return ((BigInteger)object).pow((Integer)object2);
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0028", a.b.getString("ERR.015.001.0028", object, object2));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", new Object[]{"power", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object round(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        int n2 = (Integer)object2;
        double d2 = Math.pow(10.0, n2);
        if (object instanceof Integer) {
            Integer n3 = (Integer)object;
            if (n2 <= 0) {
                return new Integer((int)((double)Math.round((double)n3.intValue() * d2) / d2));
            }
            return object;
        }
        if (object instanceof Float) {
            Float f2 = (Float)object;
            return new Float((float)((double)Math.round((double)f2.floatValue() * d2) / d2));
        }
        if (object instanceof Double) {
            Double d3 = (Double)object;
            return new Double((double)Math.round(d3 * d2) / d2);
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            int n4 = bigDecimal.scale();
            bigDecimal = bigDecimal.multiply(new BigDecimal("" + d2));
            bigDecimal = bigDecimal.setScale(0, 4);
            BigDecimal bigDecimal2 = new BigDecimal("" + d2);
            if (n2 > 0) {
                bigDecimal = bigDecimal.setScale(n4, 4);
                bigDecimal = bigDecimal.divide(bigDecimal2, 4);
            } else {
                bigDecimal = bigDecimal.divide(bigDecimal2, 4);
                bigDecimal = bigDecimal.setScale(n4, 4);
            }
            return bigDecimal;
        }
        Object[] objectArray = new Object[]{"round", object.getClass().getName(), object2.getClass().getName()};
        throw new FunctionExecutionException("ERR.015.001.0065", a.b.getString("ERR.015.001.0065", objectArray));
    }

    public static Object sign(Object object) throws FunctionExecutionException {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof Integer) {
                int n2 = (Integer)object;
                if (n2 > 0) {
                    return new Integer(1);
                }
                if (n2 == 0) {
                    return new Integer(0);
                }
                return new Integer(-1);
            }
            if (object instanceof Long) {
                long l2 = (Long)object;
                if (l2 > 0L) {
                    return new Integer(1);
                }
                if (l2 == 0L) {
                    return new Integer(0);
                }
                return new Integer(-1);
            }
            if (object instanceof Float) {
                float f2 = ((Float)object).floatValue();
                if (f2 > 0.0f) {
                    return new Integer(1);
                }
                if (f2 == 0.0f) {
                    return new Integer(0);
                }
                return new Integer(-1);
            }
            if (object instanceof Double) {
                double d2 = (Double)object;
                if (d2 > 0.0) {
                    return new Integer(1);
                }
                if (d2 == 0.0) {
                    return new Integer(0);
                }
                return new Integer(-1);
            }
            if (object instanceof BigInteger) {
                return new Integer(((BigInteger)object).signum());
            }
            if (object instanceof BigDecimal) {
                return new Integer(((BigDecimal)object).signum());
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0030", a.b.getString("ERR.015.001.0030", object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "sign", object.getClass().getName()));
    }

    public static Object sqrt(Object object) throws FunctionExecutionException {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof Integer) {
                return new Double(Math.sqrt(((Integer)object).intValue()));
            }
            if (object instanceof Long) {
                return new Double(Math.sqrt(((Long)object).longValue()));
            }
            if (object instanceof Float) {
                return new Double(Math.sqrt(((Float)object).floatValue()));
            }
            if (object instanceof Double) {
                return new Double(Math.sqrt((Double)object));
            }
        }
        catch (Throwable throwable) {
            throw new FunctionExecutionException(throwable, "ERR.015.001.0032", a.b.getString("ERR.015.001.0032", object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "sqrt", object.getClass().getName()));
    }

    public static Object currentDate() {
        return TimestampWithTimezone.createDate(new java.util.Date());
    }

    public static Object currentTime() {
        return TimestampWithTimezone.createTime(new java.util.Date());
    }

    public static Object currentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    private static int getField(java.util.Date date, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(n2);
    }

    public static Object dayName(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return dayNames[FunctionMethods.getField((java.util.Date)object, 7) - 1];
        }
        if (object instanceof Timestamp) {
            return dayNames[FunctionMethods.getField((Timestamp)object, 7) - 1];
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "dayName", object.getClass().getName()));
    }

    public static Object dayOfMonth(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return new Integer(FunctionMethods.getField((java.util.Date)object, 5));
        }
        if (object instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)object, 5));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "dayOfMonth", object.getClass().getName()));
    }

    public static Object dayOfWeek(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return new Integer(FunctionMethods.getField((java.util.Date)object, 7));
        }
        if (object instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)object, 7));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "dayOfWeek", object.getClass().getName()));
    }

    public static Object dayOfYear(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return new Integer(FunctionMethods.getField((java.util.Date)object, 6));
        }
        if (object instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)object, 6));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "dayOfYear", object.getClass().getName()));
    }

    public static Object hour(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return new Integer(FunctionMethods.getField((Time)object, 11));
        }
        if (object instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)object, 11));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "hour", object.getClass().getName()));
    }

    public static Object minute(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return new Integer(FunctionMethods.getField((Time)object, 12));
        }
        if (object instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)object, 12));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "minute", object.getClass().getName()));
    }

    public static Object month(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return new Integer(FunctionMethods.getField((java.util.Date)object, 2) + 1);
        }
        if (object instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)object, 2) + 1);
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "month", object.getClass().getName()));
    }

    public static Object monthName(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return monthNames[FunctionMethods.getField((java.util.Date)object, 2)];
        }
        if (object instanceof Timestamp) {
            return monthNames[FunctionMethods.getField((Timestamp)object, 2)];
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "monthName", object.getClass().getName()));
    }

    public static Object second(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return new Integer(FunctionMethods.getField((Time)object, 13));
        }
        if (object instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)object, 13));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "second", object.getClass().getName()));
    }

    public static Object week(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return new Integer(FunctionMethods.getField((java.util.Date)object, 3));
        }
        if (object instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)object, 3));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "week", object.getClass().getName()));
    }

    public static Object year(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return new Integer(FunctionMethods.getField((java.util.Date)object, 1));
        }
        if (object instanceof Timestamp) {
            return new Integer(FunctionMethods.getField((Timestamp)object, 1));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "year", object.getClass().getName()));
    }

    public static Object quarter(Object object) throws FunctionExecutionException {
        String string = null;
        if (object == null) {
            return null;
        }
        if (object instanceof java.util.Date) {
            string = monthNames[FunctionMethods.getField((java.util.Date)object, 2)];
        } else if (object instanceof Timestamp) {
            string = monthNames[FunctionMethods.getField((Timestamp)object, 2)];
        }
        if (string.equals("January") || string.equals("February") || string.equals("March")) {
            return new Integer(1);
        }
        if (string.equals("April") || string.equals("May") || string.equals("June")) {
            return new Integer(2);
        }
        if (string.equals("July") || string.equals("August") || string.equals("September")) {
            return new Integer(3);
        }
        if (string.equals("October") || string.equals("November") || string.equals("December")) {
            return new Integer(4);
        }
        throw new FunctionExecutionException("ERR.015.001.0066", a.b.getString("ERR.015.001.0066", new Object[]{"quarter", object.getClass().getName()}));
    }

    public static Object timestampAdd(Object object, Object object2, Object object3) throws FunctionExecutionException {
        Calendar calendar = Calendar.getInstance();
        if (object == null || object2 == null || object3 == null) {
            return null;
        }
        if (object instanceof String && object2 instanceof Integer) {
            String string = (String)object;
            if (object3 instanceof Timestamp) {
                int n2 = ((Timestamp)object3).getNanos();
                calendar.setTime((Timestamp)object3);
                if (string.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
                    int n3 = (Integer)object2;
                    if ((n2 += n3) > 999999999) {
                        int n4 = n2 / 999999999;
                        int n5 = n2 % 999999999;
                        calendar.add(13, n4);
                        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
                        timestamp.setNanos(n5);
                        return timestamp;
                    }
                    Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
                    timestamp.setNanos(n2);
                    return timestamp;
                }
                FunctionMethods.addField(string, (Integer)object2, calendar);
                Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
                timestamp.setNanos(n2);
                return timestamp;
            }
            if (object3 instanceof Time) {
                calendar.setTime((Time)object3);
                FunctionMethods.addField(string, (Integer)object2, calendar);
                return new Time(calendar.getTime().getTime());
            }
            if (object3 instanceof java.util.Date) {
                calendar.setTime((java.util.Date)object3);
                FunctionMethods.addField(string, (Integer)object2, calendar);
                return new Date(calendar.getTime().getTime());
            }
        }
        throw new FunctionExecutionException("ERR.015.001.0067", a.b.getString("ERR.015.001.0067", new Object[]{"timestampAdd", object.getClass().getName(), object2.getClass().getName(), object3.getClass().getName()}));
    }

    private static void addField(String string, Integer n2, Calendar calendar) {
        int n3 = n2;
        if (!string.equalsIgnoreCase("SQL_TSI_FRAC_SECOND")) {
            if (string.equalsIgnoreCase("SQL_TSI_SECOND")) {
                calendar.add(13, n3);
            } else if (string.equalsIgnoreCase("SQL_TSI_MINUTE")) {
                calendar.add(12, n3);
            } else if (string.equalsIgnoreCase("SQL_TSI_HOUR")) {
                calendar.add(11, n3);
            } else if (string.equalsIgnoreCase("SQL_TSI_DAY")) {
                calendar.add(6, n3);
            } else if (string.equalsIgnoreCase("SQL_TSI_WEEK")) {
                calendar.add(3, n3);
            } else if (string.equalsIgnoreCase("SQL_TSI_MONTH")) {
                calendar.add(2, n3);
            } else if (string.equalsIgnoreCase("SQL_TSI_QUARTER")) {
                calendar.add(2, n3 * 3);
            } else if (string.equalsIgnoreCase("SQL_TSI_YEAR")) {
                calendar.add(1, n3);
            }
        }
    }

    public static Object timestampDiff(Object object, Object object2, Object object3) throws FunctionExecutionException {
        if (object == null || object2 == null || object3 == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            long l2 = ((java.util.Date)object2).getTime() / 1000L * 1000L;
            long l3 = ((java.util.Date)object3).getTime() / 1000L * 1000L;
            long l4 = l3 - l2;
            int n2 = 0;
            if (object2 instanceof Timestamp) {
                int n3 = ((Timestamp)object2).getNanos();
                int n4 = ((Timestamp)object3).getNanos();
                n2 = n4 - n3;
                if (n2 < 0 && l4 > 0L) {
                    --l4;
                    n2 += 1000000;
                } else if (l4 < 0L && n2 > 0) {
                    ++l4;
                    n2 -= 1000000;
                }
            }
            long l5 = 0L;
            if (object.equals("SQL_TSI_FRAC_SECOND")) {
                l5 = object2 instanceof Timestamp ? l4 * 1000000L + (long)n2 : l4;
            } else if (string.equalsIgnoreCase("SQL_TSI_SECOND")) {
                l5 = l4 / 1000L + (long)n2;
            } else if (string.equalsIgnoreCase("SQL_TSI_MINUTE")) {
                l5 = l4 / 1000L / 60L;
            } else if (string.equalsIgnoreCase("SQL_TSI_HOUR")) {
                l5 = l4 / 1000L / 3600L;
            } else if (string.equalsIgnoreCase("SQL_TSI_DAY")) {
                l5 = l4 / 1000L / 86400L;
            } else if (string.equalsIgnoreCase("SQL_TSI_WEEK")) {
                l5 = l4 / 1000L / 604800L;
            } else if (string.equalsIgnoreCase("SQL_TSI_MONTH")) {
                l5 = l4 / 1000L / 2592000L;
            } else if (string.equalsIgnoreCase("SQL_TSI_QUARTER")) {
                l5 = l4 / 1000L / 7862400L;
            } else if (string.equalsIgnoreCase("SQL_TSI_YEAR")) {
                l5 = l4 / 1000L / 31536000L;
            }
            return new Long(l5);
        }
        throw new FunctionExecutionException("ERR.015.001.0067", a.b.getString("ERR.015.001.0067", new Object[]{"timestampDiff", object.getClass().getName(), object2.getClass().getName(), object3.getClass().getName()}));
    }

    public static Object timestampCreate(Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Time)object2);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime((Date)object);
        calendar2.set(11, calendar.get(11));
        calendar2.set(12, calendar.get(12));
        calendar2.set(13, calendar.get(13));
        return new Timestamp(calendar2.getTime().getTime());
    }

    public static Object length(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new Integer(((String)object).length());
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "length", object.getClass().getName()));
    }

    public static Object concat(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        if (object instanceof String && object2 instanceof String) {
            return (String)object + (String)object2;
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", new Object[]{"concat", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object concat2(Object object, Object object2) throws FunctionExecutionException {
        if (object == null && object2 == null) {
            return null;
        }
        if (object != null && object2 == null) {
            return object;
        }
        if (object == null && object2 != null) {
            return object2;
        }
        if (object instanceof String && object2 instanceof String) {
            return (String)object + (String)object2;
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", new Object[]{"concat", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object substring(Object object, Object object2, Object object3) throws FunctionExecutionException {
        if (object == null || object2 == null || object3 == null) {
            return null;
        }
        if (object instanceof String && object2 instanceof Integer && object3 instanceof Integer) {
            String string = (String)object;
            int n2 = (Integer)object2;
            int n3 = (Integer)object3;
            return FunctionMethods.substring(string, n2, n3);
        }
        throw new FunctionExecutionException("ERR.015.001.0013", a.b.getString("ERR.015.001.0013", new Object[]{"substring", object.getClass().getName(), object2.getClass().getName(), object3.getClass().getName()}));
    }

    private static Object substring(String string, int n2, int n3) {
        if (n2 < 0) {
            n2 = string.length() + n2;
        } else if (n2 > 0) {
            --n2;
        }
        if (n2 < 0 || n2 >= string.length()) {
            return null;
        }
        if (n3 < 0) {
            return null;
        }
        int n4 = Math.min(n2 + n3, string.length());
        return string.substring(n2, n4);
    }

    public static Object substring(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        if (object instanceof String && object2 instanceof Integer) {
            String string = (String)object;
            int n2 = (Integer)object2;
            return FunctionMethods.substring(string, n2, string.length());
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", new Object[]{"substring", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object left(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        if (object instanceof String && object2 instanceof Integer) {
            String string = (String)object;
            int n2 = (Integer)object2;
            if (n2 < 0) {
                throw new FunctionExecutionException("ERR.015.001.0017", a.b.getString("ERR.015.001.0017", n2));
            }
            if (string.length() < n2) {
                return string;
            }
            return string.substring(0, n2);
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", new Object[]{"left", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object right(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        if (object instanceof String && object2 instanceof Integer) {
            String string = (String)object;
            int n2 = (Integer)object2;
            if (n2 < 0) {
                throw new FunctionExecutionException("ERR.015.001.0017", a.b.getString("ERR.015.001.0017", n2));
            }
            if (string.length() < n2) {
                return string;
            }
            return string.substring(string.length() - n2);
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", new Object[]{"right", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object lowerCase(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return ((String)object).toLowerCase();
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "lowerCase", object.getClass().getName()));
    }

    public static Object upperCase(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return ((String)object).toUpperCase();
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "upperCase", object.getClass().getName()));
    }

    public static Object locate(Object object, Object object2) throws FunctionExecutionException {
        if (object2 == null || object == null) {
            return null;
        }
        if (object instanceof String && object2 instanceof String) {
            return new Integer(((String)object2).indexOf((String)object) + 1);
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", new Object[]{"locate", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object locate(Object object, Object object2, Object object3) throws FunctionExecutionException {
        if (object2 == null || object == null) {
            return null;
        }
        if (object instanceof String && object2 instanceof String) {
            if (object3 == null) {
                return new Integer(((String)object2).indexOf((String)object) + 1);
            }
            if (object3 instanceof Integer) {
                return new Integer(((String)object2).indexOf((String)object, (Integer)object3 - 1) + 1);
            }
        }
        throw new FunctionExecutionException("ERR.015.001.0013", a.b.getString("ERR.015.001.0013", new Object[]{"locate", object.getClass().getName(), object2.getClass().getName(), object3.getClass().getName()}));
    }

    public static Object leftTrim(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (string.charAt(i2) == ' ') continue;
                return string.substring(i2);
            }
            return "";
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "leftTrim", object.getClass().getName()));
    }

    public static Object rightTrim(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            for (int i2 = string.length() - 1; i2 >= 0; --i2) {
                if (string.charAt(i2) == ' ') continue;
                return string.substring(0, i2 + 1);
            }
            return "";
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "rightTrim", object.getClass().getName()));
    }

    public static Object replace(Object object, Object object2, Object object3) throws FunctionExecutionException {
        if (object == null || object2 == null || object3 == null) {
            return null;
        }
        if (object instanceof String && object2 instanceof String && object3 instanceof String) {
            String string = (String)object;
            String string2 = (String)object2;
            String string3 = (String)object3;
            if (string2.length() > string.length() || string.length() == 0 || string2.length() == 0) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (true) {
                int n3;
                if ((n3 = string.indexOf(string2, n2)) < 0) break;
                stringBuffer.append(string.substring(n2, n3));
                stringBuffer.append(string3);
                n2 = n3 + string2.length();
            }
            stringBuffer.append(string.substring(n2));
            return stringBuffer.toString();
        }
        throw new FunctionExecutionException("ERR.015.001.0013", a.b.getString("ERR.015.001.0013", new Object[]{"replace", object.getClass().getName(), object2.getClass().getName(), object3.getClass().getName()}));
    }

    public static Object insert(Object object, Object object2, Object object3, Object object4) throws FunctionExecutionException {
        if (object == null || object2 == null || object3 == null || object4 == null) {
            return null;
        }
        if (object instanceof String && object4 instanceof String && object2 instanceof Integer && object3 instanceof Integer) {
            String string = (String)object;
            int n2 = (Integer)object2;
            int n3 = (Integer)object3;
            if (n2 < 1 || n2 - 1 > ((String)object).length()) {
                throw new FunctionExecutionException("ERR.015.001.0061", a.b.getString("ERR.015.001.0061", object2, object));
            }
            if (n3 < 0) {
                throw new FunctionExecutionException("ERR.015.001.0062", a.b.getString("ERR.015.001.0062", n3));
            }
            if (((String)object).length() == 0 && (n2 > 1 || n3 > 0)) {
                throw new FunctionExecutionException("ERR.015.001.0063", a.b.getString("ERR.015.001.0063"));
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n2 - 1));
            int n4 = n2 + n3 - 1;
            if (n4 > ((String)object).length()) {
                stringBuffer.append((String)object4);
            } else {
                stringBuffer.append((String)object4);
                stringBuffer.append(string.substring(n4));
            }
            return stringBuffer.toString();
        }
        throw new FunctionExecutionException("ERR.015.001.0064", a.b.getString("ERR.015.001.0064", new Object[]{"insert", object.getClass().getName(), object2.getClass().getName(), object3.getClass().getName(), object4.getClass().getName()}));
    }

    public static Object repeat(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        if (object instanceof String && object2 instanceof Integer) {
            int n2 = (Integer)object2;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append((String)object);
            }
            return stringBuffer.toString();
        }
        throw new FunctionExecutionException("ERR.015.001.0065", a.b.getString("ERR.015.001.0065", new Object[]{"repeat", object.getClass().getName(), object2.getClass().getName()}));
    }

    public static Object space(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
        throw new FunctionExecutionException("ERR.015.001.0066", a.b.getString("ERR.015.001.0066", new Object[]{"space", object.getClass().getName()}));
    }

    public static Object ascii(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        char c2 = '\u0000';
        if (object instanceof Character) {
            c2 = ((Character)object).charValue();
        } else if (object instanceof String) {
            String string = (String)object;
            if (string.length() >= 1) {
                c2 = string.charAt(0);
            } else if (string.length() == 0) {
                throw new FunctionExecutionException("ERR.015.001.0021", a.b.getString("ERR.015.001.0021"));
            }
        } else {
            throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "ascii", object.getClass().getName()));
        }
        return new Integer(c2);
    }

    public static Object chr(Object object) {
        if (object == null) {
            return null;
        }
        Integer n2 = (Integer)object;
        return new Character((char)n2.intValue());
    }

    public static Object initCap(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (bl) {
                    stringBuffer.append(Character.toUpperCase(c2));
                } else {
                    stringBuffer.append(Character.toLowerCase(c2));
                }
                bl = Character.isWhitespace(c2);
            }
            return stringBuffer.toString();
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "initCap", object.getClass().getName()));
    }

    public static Object lpad(Object object, Object object2, Object object3) throws FunctionExecutionException {
        CharSequence charSequence;
        if (object == null || object2 == null || object3 == null) {
            return null;
        }
        String string = (String)object;
        int n2 = (Integer)object2;
        if (n2 < 1) {
            throw new FunctionExecutionException("ERR.015.001.0025", a.b.getString("ERR.015.001.0025"));
        }
        int n3 = n2 - string.length();
        if (n3 <= 0) {
            return string;
        }
        char c2 = '\u0000';
        if (object3 instanceof String) {
            charSequence = (String)object3;
            if (((String)charSequence).length() != 1) {
                throw new FunctionExecutionException("ERR.015.001.0027", a.b.getString("ERR.015.001.0027"));
            }
            c2 = ((String)charSequence).charAt(0);
        } else {
            c2 = ((Character)object3).charValue();
        }
        charSequence = new StringBuffer();
        for (int i2 = 0; i2 < n3; ++i2) {
            ((StringBuffer)charSequence).append(c2);
        }
        ((StringBuffer)charSequence).append(string);
        return ((StringBuffer)charSequence).toString();
    }

    public static Object lpad(Object object, Object object2) throws FunctionExecutionException {
        return FunctionMethods.lpad(object, object2, SPACE_CHAR);
    }

    public static Object rpad(Object object, Object object2, Object object3) throws FunctionExecutionException {
        CharSequence charSequence;
        if (object == null || object2 == null || object3 == null) {
            return null;
        }
        String string = (String)object;
        int n2 = (Integer)object2;
        if (n2 < 1) {
            throw new FunctionExecutionException("ERR.015.001.0025", a.b.getString("ERR.015.001.0025"));
        }
        int n3 = n2 - string.length();
        if (n3 <= 0) {
            return string;
        }
        char c2 = '\u0000';
        if (object3 instanceof String) {
            charSequence = (String)object3;
            if (((String)charSequence).length() != 1) {
                throw new FunctionExecutionException("ERR.015.001.0029", a.b.getString("ERR.015.001.0029"));
            }
            c2 = ((String)charSequence).charAt(0);
        } else {
            c2 = ((Character)object3).charValue();
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append(string);
        for (int i2 = 0; i2 < n3; ++i2) {
            ((StringBuffer)charSequence).append(c2);
        }
        return ((StringBuffer)charSequence).toString();
    }

    public static Object rpad(Object object, Object object2) throws FunctionExecutionException {
        return FunctionMethods.rpad(object, object2, SPACE_CHAR);
    }

    public static Object translate(Object object, Object object2, Object object3) throws FunctionExecutionException {
        if (object == null || object2 == null || object3 == null) {
            return null;
        }
        String string = (String)object;
        String string2 = (String)object2;
        String string3 = (String)object3;
        if (string2.length() != string3.length()) {
            throw new FunctionExecutionException("ERR.015.001.0031", a.b.getString("ERR.015.001.0031"));
        }
        if (string2.length() == 0 || string.length() == 0) {
            return object;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            boolean bl = false;
            for (int i3 = 0; i3 < string2.length(); ++i3) {
                char c3 = string2.charAt(i3);
                if (c2 != c3) continue;
                stringBuffer.append(string3.charAt(i3));
                bl = true;
                break;
            }
            if (bl) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static Object convert(Object object, Object object2) throws FunctionExecutionException {
        String string;
        Class clazz;
        if (object == null) {
            return null;
        }
        if (object2 instanceof String && (clazz = DataTypeManager.getDataTypeClass(string = (String)object2)) != null) {
            if (clazz.equals(object.getClass())) {
                return object;
            }
            try {
                Transform transform = DataTypeManager.getTransform(object.getClass(), clazz);
                return transform.transform(object);
            }
            catch (Throwable throwable) {
                throw new FunctionExecutionException(throwable, "ERR.015.001.0033", a.b.getString("ERR.015.001.0033", new Object[]{object, DataTypeManager.getDataTypeName(object.getClass()), string}));
            }
        }
        throw new FunctionExecutionException("ERR.015.001.0034", a.b.getString("ERR.015.001.0034", object2));
    }

    public static Object context(Object object, Object object2) throws FunctionExecutionException {
        throw new FunctionExecutionException("ERR.015.001.0035", a.b.getString("ERR.015.001.0035"));
    }

    public static Object relateSource(Object object) throws FunctionExecutionException {
        throw new FunctionExecutionException(a.b.getString("FunctionMethods.cant_execute_relateSource"));
    }

    public static Object relateTarget(Object object) throws FunctionExecutionException {
        throw new FunctionExecutionException(a.b.getString("FunctionMethods.cant_execute_relateTarget"));
    }

    public static Object relate(Object object, Object object2, Object object3) throws FunctionExecutionException {
        throw new FunctionExecutionException(a.b.getString("FunctionMethods.cant_execute_relate"));
    }

    public static Object rowlimit(Object object) throws FunctionExecutionException {
        throw new FunctionExecutionException("ERR.015.001.0035a", a.b.getString("ERR.015.001.0035a"));
    }

    public static Object rowlimitexception(Object object) throws FunctionExecutionException {
        throw new FunctionExecutionException("ERR.015.001.0035a", a.b.getString("ERR.015.001.0035a"));
    }

    public static Object lookup(Object object, Object object2, Object object3, Object object4) {
        throw new UnsupportedOperationException("This method should never be called.");
    }

    public static Object decodeInteger(Object object, Object object2) throws FunctionExecutionException {
        return FunctionMethods.decode(object, object2, DEFAULT_DECODE_STRING_DELIMITER, class$java$lang$Integer == null ? (class$java$lang$Integer = FunctionMethods.class$("java.lang.Integer")) : class$java$lang$Integer);
    }

    public static Object decodeString(Object object, Object object2) throws FunctionExecutionException {
        return FunctionMethods.decode(object, object2, DEFAULT_DECODE_STRING_DELIMITER, class$java$lang$String == null ? (class$java$lang$String = FunctionMethods.class$("java.lang.String")) : class$java$lang$String);
    }

    public static Object decodeInteger(Object object, Object object2, Object object3) throws FunctionExecutionException {
        return FunctionMethods.decode(object, object2, object3, class$java$lang$Integer == null ? (class$java$lang$Integer = FunctionMethods.class$("java.lang.Integer")) : class$java$lang$Integer);
    }

    public static Object decodeString(Object object, Object object2, Object object3) throws FunctionExecutionException {
        return FunctionMethods.decode(object, object2, object3, class$java$lang$String == null ? (class$java$lang$String = FunctionMethods.class$("java.lang.String")) : class$java$lang$String);
    }

    private static Object decode(Object object, Object object2, Object object3, Class clazz) throws FunctionExecutionException {
        Object object4 = null;
        if (object2 == null) {
            throw new FunctionExecutionException("ERR.015.001.0036", a.b.getString("ERR.015.001.0036"));
        }
        if (object3 == null) {
            throw new FunctionExecutionException("ERR.015.001.0037", a.b.getString("ERR.015.001.0037"));
        }
        if (object2 instanceof String && object3 instanceof String) {
            String string = (String)object3;
            String string2 = (String)object2;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = FunctionMethods.convertString(stringTokenizer.nextToken().trim());
                if (!stringTokenizer.hasMoreTokens()) {
                    try {
                        object4 = FunctionMethods.convertType(clazz, string3);
                        break;
                    }
                    catch (TransformationException transformationException) {
                        throw new FunctionExecutionException((Throwable)transformationException, "ERR.015.001.0038", a.b.getString("ERR.015.001.0038", string3, clazz != null ? clazz.getName() : "null"));
                    }
                }
                String string4 = FunctionMethods.convertString(stringTokenizer.nextToken().trim());
                boolean bl = FunctionMethods.areSemanticallyEqual(object, string3);
                if (bl) {
                    try {
                        object4 = FunctionMethods.convertType(clazz, string4);
                        break;
                    }
                    catch (TransformationException transformationException) {
                        throw new FunctionExecutionException((Throwable)transformationException, "ERR.015.001.0038", a.b.getString("ERR.015.001.0038", string4, clazz != null ? clazz.getName() : "null"));
                    }
                }
                if (stringTokenizer.hasMoreTokens()) continue;
                try {
                    object4 = FunctionMethods.convertType(clazz, object);
                }
                catch (TransformationException transformationException) {
                    throw new FunctionExecutionException((Throwable)transformationException, "ERR.015.001.0039", a.b.getString("ERR.015.001.0039", object));
                }
            }
            return object4;
        }
        throw new FunctionExecutionException("ERR.015.001.0040", a.b.getString("ERR.015.001.0040"));
    }

    private static boolean areSemanticallyEqual(Object object, String string) {
        Class<?> clazz;
        if (object == null) {
            return string == null;
        }
        if (string == null) {
            return false;
        }
        if (object.equals(string)) {
            return true;
        }
        if (DataTypeManager.isTransformable(class$java$lang$String == null ? (class$java$lang$String = FunctionMethods.class$("java.lang.String")) : class$java$lang$String, clazz = object.getClass())) {
            Transform transform = DataTypeManager.getPreferredTransform(class$java$lang$String == null ? (class$java$lang$String = FunctionMethods.class$("java.lang.String")) : class$java$lang$String, clazz);
            Object object2 = null;
            try {
                object2 = transform.getSourceType().equals(class$java$lang$String == null ? (class$java$lang$String = FunctionMethods.class$("java.lang.String")) : class$java$lang$String) ? transform.transform(string) : transform.transform(object);
            }
            catch (TransformationException transformationException) {
                return false;
            }
            return object2.equals(object);
        }
        return false;
    }

    private static Object convertType(Class clazz, Object object) throws TransformationException, FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (clazz == object.getClass()) {
            return object;
        }
        Transform transform = null;
        if (!DataTypeManager.isTransformable(clazz, object.getClass())) {
            throw new FunctionExecutionException("ERR.015.001.0041", a.b.getString("ERR.015.001.0041", new Object[]{object, object.getClass().getName(), clazz.getName()}));
        }
        transform = DataTypeManager.getTransform(object.getClass(), clazz);
        return transform.transform(object);
    }

    public static String convertString(String string) {
        if (string.equals("")) {
            return null;
        }
        if (string.equalsIgnoreCase("null")) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            if (string.length() == 2) {
                string = "";
            } else if (!string.equalsIgnoreCase("'") && !string.equalsIgnoreCase("\"")) {
                string = string.substring(1);
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static Object nvl(Object object, Object object2) {
        if (object == null) {
            return object2;
        }
        return object;
    }

    public static Object formatDate(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object2);
            return simpleDateFormat.format((java.util.Date)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FunctionExecutionException("ERR.015.001.0042", a.b.getString("ERR.015.001.0042", illegalArgumentException.getMessage()));
        }
    }

    public static Object formatTime(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object2);
            return simpleDateFormat.format((Time)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FunctionExecutionException("ERR.015.001.0042", a.b.getString("ERR.015.001.0042", illegalArgumentException.getMessage()));
        }
    }

    public static Object formatTimestamp(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object2);
            return simpleDateFormat.format((Timestamp)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FunctionExecutionException("ERR.015.001.0042", a.b.getString("ERR.015.001.0042", illegalArgumentException.getMessage()));
        }
    }

    public static Object parseDate(Object object, Object object2) throws FunctionExecutionException {
        java.util.Date date = null;
        if (object == null || object2 == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object2);
            date = simpleDateFormat.parse((String)object);
            return new Date(date.getTime());
        }
        catch (ParseException parseException) {
            throw new FunctionExecutionException("ERR.015.001.0043", a.b.getString("ERR.015.001.0043", object, object2));
        }
    }

    public static Object parseTime(Object object, Object object2) throws FunctionExecutionException {
        java.util.Date date = null;
        if (object == null || object2 == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object2);
            date = simpleDateFormat.parse((String)object);
            return new Time(date.getTime());
        }
        catch (ParseException parseException) {
            throw new FunctionExecutionException("ERR.015.001.0043", a.b.getString("ERR.015.001.0043", object, object2));
        }
    }

    public static Object parseTimestamp(Object object, Object object2) throws FunctionExecutionException {
        java.util.Date date = null;
        if (object == null || object2 == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object2);
            date = simpleDateFormat.parse((String)object);
            return new Timestamp(date.getTime());
        }
        catch (ParseException parseException) {
            throw new FunctionExecutionException("ERR.015.001.0043", a.b.getString("ERR.015.001.0043", object, object2));
        }
    }

    public static Object formatInteger(Object object, Object object2) throws FunctionExecutionException {
        return FunctionMethods.formatNumberHelper(object, object2);
    }

    public static Object formatLong(Object object, Object object2) throws FunctionExecutionException {
        return FunctionMethods.formatNumberHelper(object, object2);
    }

    public static Object formatDouble(Object object, Object object2) throws FunctionExecutionException {
        return FunctionMethods.formatNumberHelper(object, object2);
    }

    public static Object formatFloat(Object object, Object object2) throws FunctionExecutionException {
        return FunctionMethods.formatNumberHelper(object, object2);
    }

    public static Object formatBigInteger(Object object, Object object2) throws FunctionExecutionException {
        return FunctionMethods.formatNumberHelper(object, object2);
    }

    public static Object formatBigDecimal(Object object, Object object2) throws FunctionExecutionException {
        return FunctionMethods.formatNumberHelper(object, object2);
    }

    public static Object parseInteger(Object object, Object object2) throws FunctionExecutionException {
        Number number = FunctionMethods.parseNumberHelper(object, object2);
        return new Integer(number.intValue());
    }

    public static Object parseLong(Object object, Object object2) throws FunctionExecutionException {
        Number number = FunctionMethods.parseNumberHelper(object, object2);
        return new Long(number.longValue());
    }

    public static Object parseDouble(Object object, Object object2) throws FunctionExecutionException {
        Number number = FunctionMethods.parseNumberHelper(object, object2);
        return new Double(number.doubleValue());
    }

    public static Object parseFloat(Object object, Object object2) throws FunctionExecutionException {
        Number number = FunctionMethods.parseNumberHelper(object, object2);
        return new Float(number.floatValue());
    }

    public static Object parseBigInteger(Object object, Object object2) throws FunctionExecutionException {
        Number number = FunctionMethods.parseNumberHelper(object, object2);
        return new BigInteger(number.toString());
    }

    public static Object parseBigDecimal(Object object, Object object2) throws FunctionExecutionException {
        Number number = FunctionMethods.parseNumberHelper(object, object2);
        return new BigDecimal(number.toString());
    }

    public static String formatNumberHelper(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        try {
            DecimalFormat decimalFormat = new DecimalFormat((String)object2);
            return decimalFormat.format(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FunctionExecutionException("ERR.015.001.0042", a.b.getString("ERR.015.001.0042", illegalArgumentException.getMessage()));
        }
    }

    private static Number parseNumberHelper(Object object, Object object2) throws FunctionExecutionException {
        Number number = null;
        if (object == null || object2 == null) {
            return null;
        }
        if (object instanceof String && object2 instanceof String) {
            try {
                DecimalFormat decimalFormat = new DecimalFormat((String)object2);
                number = decimalFormat.parse((String)object);
            }
            catch (ParseException parseException) {
                throw new FunctionExecutionException("ERR.015.001.0043", a.b.getString("ERR.015.001.0043", object, object2));
            }
        }
        return number;
    }

    public static Object acos(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return new Double(Math.acos((Double)object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "acos", object.getClass().getName()));
    }

    public static Object asin(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return new Double(Math.asin((Double)object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "asin", object.getClass().getName()));
    }

    public static Object atan(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return new Double(Math.atan((Double)object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "atan", object.getClass().getName()));
    }

    public static Object atan2(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        if (object instanceof Double && object2 instanceof Double) {
            return new Double(Math.atan2((Double)object, (Double)object2));
        }
        throw new FunctionExecutionException("ERR.015.001.0007", a.b.getString("ERR.015.001.0007", "atan2", object.getClass().getName(), object2.getClass().getName()));
    }

    public static Object cos(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return new Double(Math.cos((Double)object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "cos", object.getClass().getName()));
    }

    public static Object cot(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return new Double(1.0 / Math.tan((Double)object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "cot", object.getClass().getName()));
    }

    public static Object degrees(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return new Double(Math.toDegrees((Double)object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "degrees", object.getClass().getName()));
    }

    public static Object pi() {
        return new Double(Math.PI);
    }

    public static Object radians(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return new Double(Math.toRadians((Double)object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "redians", object.getClass().getName()));
    }

    public static Object sin(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return new Double(Math.sin((Double)object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "sin", object.getClass().getName()));
    }

    public static Object tan(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return new Double(Math.tan((Double)object));
        }
        throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "tan", object.getClass().getName()));
    }

    public static Object bitand(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        if (!(object instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "bitand", object.getClass().getName()));
        }
        if (!(object2 instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "bitand", object2.getClass().getName()));
        }
        return new Integer((Integer)object & (Integer)object2);
    }

    public static Object bitor(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        if (!(object instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "bitor", object.getClass().getName()));
        }
        if (!(object2 instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "bitor", object2.getClass().getName()));
        }
        return new Integer((Integer)object | (Integer)object2);
    }

    public static Object bitxor(Object object, Object object2) throws FunctionExecutionException {
        if (object == null || object2 == null) {
            return null;
        }
        if (!(object instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "bitxor", object.getClass().getName()));
        }
        if (!(object2 instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "bitxor", object2.getClass().getName()));
        }
        return new Integer((Integer)object ^ (Integer)object2);
    }

    public static Object bitnot(Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Integer)) {
            throw new FunctionExecutionException("ERR.015.001.0015", a.b.getString("ERR.015.001.0015", "bitxor", object.getClass().getName()));
        }
        return new Integer(~((Integer)object).intValue());
    }

    public static Object user(g g2) {
        return g2.getUserName();
    }

    public static Object commandPayload(g g2) {
        Serializable serializable = g2.getCommandPayload();
        if (serializable == null) {
            return null;
        }
        return serializable.toString();
    }

    public static Object commandPayload(g g2, Object object) throws ExpressionEvaluationException, FunctionExecutionException {
        Serializable serializable = g2.getCommandPayload();
        if (serializable == null || object == null) {
            return null;
        }
        if (object instanceof String) {
            if (serializable instanceof Properties) {
                String string = (String)object;
                return ((Properties)serializable).getProperty(string);
            }
            throw new ExpressionEvaluationException(a.b.getString("ExpressionEvaluator.Expected_props_for_payload_function", "commandPayload", serializable.getClass().getName()));
        }
        throw new FunctionExecutionException("ERR.015.001.0071", a.b.getString("ERR.015.001.0070", "commandPayload", object.getClass().getName()));
    }

    public static Object env(g g2, Object object) throws FunctionExecutionException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = ((String)object).toLowerCase();
            Properties properties = g2.getEnvironmentProperties();
            if (properties != null) {
                return properties.getProperty(string);
            }
        }
        throw new FunctionExecutionException("ERR.015.001.0070", a.b.getString("ERR.015.001.0070", "env", object.getClass().getName()));
    }

    public static Object modifyTimeZone(Object object, Object object2, Object object3) {
        TimeZone timeZone;
        if (object == null || object2 == null || object3 == null) {
            return null;
        }
        TimeZone timeZone2 = TimeZone.getTimeZone((String)object2);
        if (timeZone2.equals(timeZone = TimeZone.getTimeZone((String)object3))) {
            return object;
        }
        Timestamp timestamp = (Timestamp)object;
        Calendar calendar = FunctionMethods.changeTimeZone(timestamp, timeZone2, timeZone);
        Timestamp timestamp2 = new Timestamp(calendar.getTime().getTime());
        timestamp2.setNanos(timestamp.getNanos());
        return timestamp2;
    }

    public static Object modifyTimeZone(Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        TimeZone timeZone = LOCAL_TZ;
        TimeZone timeZone2 = TimeZone.getTimeZone((String)object2);
        if (timeZone.equals(timeZone2)) {
            return object;
        }
        Timestamp timestamp = (Timestamp)object;
        Calendar calendar = FunctionMethods.changeTimeZone(timestamp, timeZone, timeZone2);
        Timestamp timestamp2 = new Timestamp(calendar.getTime().getTime());
        timestamp2.setNanos(timestamp.getNanos());
        return timestamp2;
    }

    static Calendar changeTimeZone(Timestamp timestamp, TimeZone timeZone, TimeZone timeZone2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        int n2 = calendar.get(0);
        int n3 = calendar.get(1);
        int n4 = calendar.get(2);
        int n5 = calendar.get(5);
        int n6 = calendar.get(7);
        int n7 = calendar.get(14);
        int n8 = timeZone.getOffset(n2, n3, n4, n5, n6, n7);
        int n9 = timeZone2.getOffset(n2, n3, n4, n5, n6, n7);
        int n10 = n9 - n8;
        calendar.add(14, n10);
        return calendar;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

