/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.edit;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.event.IChangeListener;
import com.metamatrix.core.event.IChangeNotifier;
import com.metamatrix.core.plugin.PluginUtilities;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.PluginUtilImpl;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.vdb.edit.VdbArtifactGenerator;
import com.metamatrix.vdb.edit.VdbContext;
import com.metamatrix.vdb.edit.VdbContextEditor;
import com.metamatrix.vdb.edit.VdbEditingContext;
import com.metamatrix.vdb.internal.edit.InternalVdbEditingContext;
import com.metamatrix.vdb.internal.edit.RuntimeIndexArtifactGenerator;
import com.metamatrix.vdb.internal.edit.SharedWsVdbContextEditor;
import com.metamatrix.vdb.internal.edit.SharedWsVdbContextValidator;
import com.metamatrix.vdb.internal.edit.VdbContextImpl;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImpl;
import com.metamatrix.vdb.internal.edit.WsVdbInputResourceFinder;
import com.metamatrix.vdb.internal.edit.WsdlArtifactGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.osgi.framework.BundleContext;

public class VdbEditPlugin
extends Plugin {
    public static final String VDB_WORKING_FOLDER_NAME = "vdbWorkingFolder";
    private static String producerVersion = "5.0";
    public static final String PLUGIN_ID = "com.metamatrix.vdb.edit";
    private static final String BUNDLE_NAME = "com.metamatrix.vdb.edit.i18n";
    public static final PluginUtil Util = new PluginUtilImpl("com.metamatrix.vdb.edit", "com.metamatrix.vdb.edit.i18n", ResourceBundle.getBundle("com.metamatrix.vdb.edit.i18n"));
    public static final String DELIMITER = ".";
    private static final ResourceLocator RESOURCE_LOCATOR = new ResourceLocator(){

        public URL getBaseURL() {
            if (INSTANCE != null) {
                URL baseUrl;
                try {
                    baseUrl = Platform.resolve(INSTANCE.getBundle().getEntry("/"));
                }
                catch (IOException err) {
                    baseUrl = null;
                }
                return baseUrl;
            }
            try {
                URI uri = URI.createURI(this.getClass().getResource("plugin.properties").toString());
                URL baseUrl = new URL(uri.trimSegments(1).toString() + "/");
                return baseUrl;
            }
            catch (IOException exception) {
                throw new WrappedException(exception);
            }
        }

        public Object getImage(String key) {
            try {
                URL baseUrl = this.getBaseURL();
                URL url = new URL(baseUrl + "icons/" + key + ".gif");
                InputStream inputStream = url.openStream();
                inputStream.close();
                return url;
            }
            catch (MalformedURLException exception) {
                throw new WrappedException(exception);
            }
            catch (IOException exception) {
                throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_StringResourceNotFound_exception", new Object[]{key}), this.getClass().getName(), key);
            }
        }

        public String getString(String key) {
            return Util.getString(key);
        }

        public String getString(String key, Object[] substitutions) {
            return Util.getString(key, substitutions);
        }

        public String getString(String key, boolean translate) {
            return this.getString(key);
        }

        public String getString(String key, Object[] substitutions, boolean translate) {
            return this.getString(key, substitutions);
        }
    };
    public static final String URL_ROOT_FOR_VDB = "http://vdb.metamatrix.com";
    public static final String URL_SUFFIX_FOR_VDB = "?vdbToken=true";
    public static final String URL_FOR_DATA_WEBSERVICE = "http://vdb.dataservice.metamatrix.com";
    public static boolean DEBUG = false;
    private static VdbEditPlugin INSTANCE = null;
    private static final Map vdbEditingContextCache = new HashMap();
    private static final Map vdbContextCache = new HashMap();
    private static final IChangeListener vdbContextChangeListener = new IChangeListener(){

        public void stateChanged(IChangeNotifier theSource) {
            VdbContextEditor context;
            if (theSource instanceof VdbEditingContext) {
                VdbEditingContext context2 = (VdbEditingContext)theSource;
                if (!context2.isOpen()) {
                    String key = ((Object)((InternalVdbEditingContext)context2).getPathToVdb().makeAbsolute()).toString();
                    vdbEditingContextCache.remove(key);
                    context2.removeChangeListener(vdbContextChangeListener);
                }
            } else if (theSource instanceof VdbContextEditor && !(context = (VdbContextEditor)theSource).isOpen()) {
                Path pathToVdbFile = new Path(context.getVdbFile().getAbsolutePath());
                String key = ((Object)pathToVdbFile.makeAbsolute()).toString();
                vdbEditingContextCache.remove(key);
                context.removeChangeListener(vdbContextChangeListener);
            }
        }
    };
    private static final ArrayList vdbContextCreationListeners = new ArrayList();

    public static ResourceLocator getPluginResourceLocator() {
        return RESOURCE_LOCATOR;
    }

    public static VdbEditPlugin getInstance() {
        return INSTANCE;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        ((PluginUtilImpl)Util).initializePlatformLogger(this);
        String version = context.getBundle().getHeaders().get("Bundle-Version").toString();
        if (version != null && version.trim().length() != 0) {
            producerVersion = version;
        }
        VdbEditPlugin.cleanVdbWorkingDirectory();
    }

    public static VdbEditingContext createVdbEditingContext(IPath pathToVdbFile) throws CoreException {
        ArgCheck.isNotNull(pathToVdbFile);
        String key = ((Object)pathToVdbFile.makeAbsolute()).toString();
        VdbEditingContext context = (VdbEditingContext)vdbEditingContextCache.get(key);
        if (context == null || !context.isOpen()) {
            context = new VdbEditingContextImpl(pathToVdbFile);
            vdbEditingContextCache.put(key, context);
            context.addChangeListener(vdbContextChangeListener);
            VdbEditPlugin.fireVdbEditingContextCreated(context);
        }
        return context;
    }

    public static VdbEditingContext createVdbEditingContext(IPath pathToVdbFile, IPath vdbWorkingPath) throws CoreException {
        ArgCheck.isNotNull(pathToVdbFile);
        String key = ((Object)pathToVdbFile.makeAbsolute()).toString();
        VdbEditingContext context = (VdbEditingContext)vdbEditingContextCache.get(key);
        if (context == null || !context.isOpen()) {
            context = new VdbEditingContextImpl(pathToVdbFile, vdbWorkingPath, new WsVdbInputResourceFinder());
            vdbEditingContextCache.put(key, context);
            context.addChangeListener(vdbContextChangeListener);
            VdbEditPlugin.fireVdbEditingContextCreated(context);
        }
        return context;
    }

    public static VdbContext createVdbContext(IPath pathToVdbFile, IPath vdbWorkingPath) throws CoreException {
        ArgCheck.isNotNull(pathToVdbFile);
        String key = ((Object)pathToVdbFile.makeAbsolute()).toString();
        VdbContext context = (VdbContext)vdbContextCache.get(key);
        if (context == null || !context.isOpen()) {
            File vdbFile = pathToVdbFile.toFile();
            File vdbWorkingFolder = vdbWorkingPath.toFile();
            if (!vdbWorkingFolder.exists()) {
                vdbWorkingFolder.mkdirs();
            }
            context = new VdbContextImpl(vdbFile, vdbWorkingFolder);
            vdbContextCache.put(key, context);
            context.addChangeListener(vdbContextChangeListener);
            VdbEditPlugin.fireVdbContextCreated(context);
        }
        return context;
    }

    public static VdbContextEditor createSharedWsVdbContextEditor(IPath pathToVdbFile, IPath vdbWorkingPath) throws CoreException {
        ArgCheck.isNotNull(pathToVdbFile);
        String key = ((Object)pathToVdbFile.makeAbsolute()).toString();
        VdbContextEditor context = (VdbContextEditor)vdbContextCache.get(key);
        if (context == null || !context.isOpen()) {
            File vdbFile = pathToVdbFile.toFile();
            File vdbWorkingFolder = vdbWorkingPath.toFile();
            if (!vdbWorkingFolder.exists()) {
                vdbWorkingFolder.mkdirs();
            }
            Container sharedContainer = ModelerCore.getModelContainer();
            context = new SharedWsVdbContextEditor(vdbFile, vdbWorkingFolder, sharedContainer);
            context.setVdbContextValidator(new SharedWsVdbContextValidator());
            List contributedGenerators = VdbEditPlugin.getVdbArtifactGenerators();
            Iterator i2 = contributedGenerators.iterator();
            while (i2.hasNext()) {
                VdbArtifactGenerator generator = (VdbArtifactGenerator)i2.next();
                context.addArtifactGenerator(generator);
            }
            context.addArtifactGenerator(new WsdlArtifactGenerator());
            context.addArtifactGenerator(new RuntimeIndexArtifactGenerator());
            vdbContextCache.put(key, context);
            context.addChangeListener(vdbContextChangeListener);
            VdbEditPlugin.fireVdbContextCreated(context);
        }
        return context;
    }

    public static File getVdbWorkingDirectory() {
        IPath pluginPath = VdbEditPlugin.getInstance().getStateLocation();
        IPath vdbWorkingPath = pluginPath.append(VDB_WORKING_FOLDER_NAME);
        String absolutePath = vdbWorkingPath.toOSString();
        File vdbWorkingFolder = new File(absolutePath);
        if (!vdbWorkingFolder.exists()) {
            vdbWorkingFolder.mkdir();
        }
        return vdbWorkingFolder;
    }

    public static String getProducerVersion() {
        return producerVersion;
    }

    private static void cleanVdbWorkingDirectory() {
        File directory = VdbEditPlugin.getVdbWorkingDirectory();
        if (directory.exists()) {
            VdbEditPlugin.removeDirectoryAndChildren(directory);
        }
    }

    private static void removeDirectoryAndChildren(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i2 = 0; i2 < files.length; ++i2) {
                File file = files[i2];
                if (file.isDirectory()) {
                    VdbEditPlugin.removeDirectoryAndChildren(file);
                    continue;
                }
                if (file.delete()) continue;
                file.deleteOnExit();
            }
        }
        if (!directory.delete()) {
            directory.deleteOnExit();
        }
    }

    public static List getVdbArtifactGenerators() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (INSTANCE != null) {
            IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.vdb.edit.vdbArtifactGenerator");
            for (int i2 = 0; i2 < extensions.length; ++i2) {
                IExtension extension = extensions[i2];
                String classElement = "class";
                String classNameAttribute = "name";
                try {
                    Object obj = PluginUtilities.createExecutableExtension(extension, "class", "name");
                    if (!(obj instanceof VdbArtifactGenerator)) continue;
                    result.add(obj);
                    continue;
                }
                catch (CoreException err) {
                    Util.log(err);
                    continue;
                }
                catch (Throwable err) {
                    Util.log(err);
                }
            }
        }
        return result;
    }

    public static void addVdbEditingContextCreationListener(IChangeListener listener) {
        ArgCheck.isNotNull(listener);
        if (!vdbContextCreationListeners.contains(listener)) {
            vdbContextCreationListeners.add(listener);
        }
    }

    public static void removeVdbEditingContextCreationListener(IChangeListener listener) {
        ArgCheck.isNotNull(listener);
        vdbContextCreationListeners.remove(listener);
    }

    private static void fireVdbEditingContextCreated(VdbEditingContext theContext) {
        Object[] listeners = vdbContextCreationListeners.toArray();
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            IChangeListener list = (IChangeListener)listeners[i2];
            list.stateChanged(theContext);
        }
    }

    private static void fireVdbContextCreated(VdbContext theContext) {
        Object[] listeners = vdbContextCreationListeners.toArray();
        for (int i2 = 0; i2 < listeners.length; ++i2) {
            IChangeListener list = (IChangeListener)listeners[i2];
            list.stateChanged(theContext);
        }
    }

    public static class EXTENSION_POINT {

        public static class VDB_ARTIFACT_GENERATOR {
            public static final String ID = "vdbArtifactGenerator";
            public static final String UNIQUE_ID = "com.metamatrix.vdb.edit.vdbArtifactGenerator";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String CLASS = "class";
            }
        }
    }
}

