/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.edit.loader;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.common.xml.XMLReaderWriterImpl;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.core.util.ZipFileUtil;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.loader.VDBDefnXMLHelper;
import com.metamatrix.vdb.edit.loader.VDBReader;
import com.metamatrix.vdb.edit.loader.VdbProcessingException;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBModelDefn;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.jdom.Document;
import org.jdom.Element;

public class VDBWriter {
    private static final Random random = new Random(System.currentTimeMillis());
    private TempDirectory tempVDBFiles = null;

    private VDBWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportVDBArchive(OutputStream vdbArchive, VDBDefn vdbDefn, Properties headerProps) throws Exception {
        if (vdbDefn == null) {
            ArgCheck.isNotNull(vdbDefn, VdbEditPlugin.Util.getString("VDBWriter.Invalid_VDB_defintion"));
        }
        if (vdbDefn.getVDBJar() == null || vdbDefn.getVDBJar().length == 0) {
            ArgCheck.isNotNull(vdbDefn, VdbEditPlugin.Util.getString("VDBWriter.Invalid_VDB_archive"));
        }
        VDBWriter writer = new VDBWriter();
        try {
            writer.exportToOutputStream(vdbArchive, vdbDefn, headerProps);
        }
        finally {
            writer.cleanupTempFiles();
        }
    }

    public static void exportVDBArchive(String vdbArchiveFileName, VDBDefn vdbDefn, Properties headerProps) throws Exception {
        if (vdbDefn == null) {
            ArgCheck.isNotNull(vdbDefn, VdbEditPlugin.Util.getString("VDBWriter.Invalid_VDB_defintion"));
        }
        if (vdbDefn.getVDBJar() == null || vdbDefn.getVDBJar().length == 0) {
            ArgCheck.isNotNull(vdbDefn, VdbEditPlugin.Util.getString("VDBWriter.Invalid_VDB_archivee"));
        }
        VDBWriter.writeVDBArchive(null, vdbArchiveFileName, vdbDefn.getVDBJar());
        VDBWriter.addVDBDefnToArchive(vdbDefn, vdbArchiveFileName, headerProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVDBDefnToArchive(VDBDefn vdbDefn, String vdbArchiveFileName, Properties headerProps) throws Exception {
        if (vdbDefn == null) {
            ArgCheck.isNotNull(vdbDefn, VdbEditPlugin.Util.getString("VDBWriter.Invalid_VDB_defintion"));
        }
        if (vdbArchiveFileName == null || vdbArchiveFileName.trim().length() == 0) {
            ArgCheck.isNotNull(vdbDefn, VdbEditPlugin.Util.getString("VDBWriter.Invalid_VDB_archive_filename"));
        }
        VDBWriter writer = new VDBWriter();
        try {
            writer.addDefnToVDBArchive(vdbDefn, vdbArchiveFileName, headerProps);
        }
        finally {
            writer.cleanupTempFiles();
        }
    }

    public static void exportVDBDefn(VDBDefn vdbDefn, String vdbDefnFileName, String vdbArchiveFileName, String directory, Properties headerProps) throws Exception {
        if (vdbDefn == null) {
            ArgCheck.isNotNull(vdbDefn, VdbEditPlugin.Util.getString("VDBWriter.Invalid_VDB_defintion"));
        }
        if (vdbDefnFileName == null || vdbDefnFileName.trim().length() == 0) {
            ArgCheck.isNotNull(vdbDefn, VdbEditPlugin.Util.getString("VDBWriter.Invalid_VDB_defintion_filename"));
        }
        if (vdbArchiveFileName == null || vdbArchiveFileName.trim().length() == 0) {
            ArgCheck.isNotNull(vdbDefn, VdbEditPlugin.Util.getString("VDBWriter.Invalid_VDB_archive_filename"));
        }
        if (directory != null && directory.trim().length() == 0) {
            directory = null;
        }
        File fDef = new File(directory, vdbDefnFileName);
        FileOutputStream outDef = new FileOutputStream(fDef);
        VDBWriter.writeVDBDefn(outDef, vdbDefn, headerProps);
        if (vdbArchiveFileName == null) {
            vdbArchiveFileName = vdbDefn.getFileName() != null ? vdbDefn.getFileName() : FileUtils.toFileNameWithExtension(vdbDefn.getName(), ".vdb");
        }
        VDBWriter.writeVDBArchive(directory, vdbDefn.getFileName(), vdbDefn.getVDBJar());
    }

    static void writeVDBArchive(String dir, String archiveFileName, byte[] archive) {
        if (archive != null) {
            File f2 = null;
            f2 = dir != null ? new File(dir, archiveFileName) : new File(archiveFileName);
            if (f2.exists()) {
                f2.delete();
            }
            FileUtil fileUtil = new FileUtil(f2.getAbsolutePath());
            fileUtil.writeBytes(archive);
        }
    }

    public static void updateConfigDefFile(File deffile, String vdbName) throws Exception {
        VDBDefnXMLHelper helper = new VDBDefnXMLHelper();
        Element root = helper.getRoot(deffile);
        Document doc = root.getDocument();
        helper.updateVDBName(root, vdbName, vdbName + ".vdb");
        FileOutputStream fos = new FileOutputStream(deffile);
        try {
            new XMLReaderWriterImpl().writeDocument(doc, fos);
        }
        catch (Exception e2) {
            try {
                fos.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    public static void writeVDBDefn(OutputStream outputStream, VDBDefn vdbDefn, Properties headerProps) throws IOException, Exception {
        VDBWriter writer = new VDBWriter();
        writer.writeVDBDefnToOutputStream(outputStream, vdbDefn, null, headerProps);
    }

    private void writeVDBDefnToOutputStream(OutputStream outputStream, VDBDefn vdbDefn, String archiveFileName, Properties headerProps) throws IOException, Exception {
        XMLConfigurationImportExportUtility exportUtil = new XMLConfigurationImportExportUtility();
        VDBDefnXMLHelper vdbHelper = new VDBDefnXMLHelper();
        Element root = vdbHelper.createRootDocumentElement();
        Document doc = new Document(root);
        vdbHelper.addHeaderElement(root, headerProps);
        Element vdbDefnElement = vdbHelper.createVDBInfoElement(vdbDefn, archiveFileName);
        root.addContent(vdbDefnElement);
        HashSet routingNames = new HashSet();
        Iterator it = vdbDefn.getModels().iterator();
        while (it.hasNext()) {
            BasicVDBModelDefn md = (BasicVDBModelDefn)it.next();
            Element modelElement = vdbHelper.createVDBModelElement(md);
            List connectorBindingNames = md.getConnectorBindingNames();
            if (connectorBindingNames != null && connectorBindingNames.size() > 0) {
                vdbHelper.addConnectorRefs(connectorBindingNames, modelElement);
                routingNames.addAll(connectorBindingNames);
            }
            root.addContent(modelElement);
        }
        ConnectorBinding[] connectorBindings = new ConnectorBinding[routingNames.size()];
        ComponentType[] connectorTypes = new ComponentType[routingNames.size()];
        Iterator it2 = routingNames.iterator();
        int i2 = 0;
        while (it2.hasNext()) {
            String cbName = (String)it2.next();
            ConnectorBinding cb = vdbDefn.getConnectorBindingByName(cbName);
            if (cb != null) {
                ComponentType ctype;
                connectorBindings[i2] = cb;
                connectorTypes[i2] = ctype = vdbDefn.getConnectorType(cb.getComponentTypeID().getName());
            }
            ++i2;
        }
        exportUtil.exportConnectorBindings(connectorBindings, connectorTypes, root);
        new XMLReaderWriterImpl().writeDocument(doc, outputStream);
        outputStream.close();
    }

    private void addDefnToVDBArchive(VDBDefn vdbDefn, String vdbArchiveFile, Properties headerProps) throws IOException, Exception {
        boolean added;
        this.createTempDir();
        File arc = new File(vdbArchiveFile);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.writeVDBDefnToOutputStream(bos, vdbDefn, arc.getName(), headerProps);
        byte[] contents = bos.toByteArray();
        bos.close();
        File defnFile = this.writeTempFile(contents, "ConfigurationInfo.def");
        File existingDefFile = VDBReader.getVDBDefFile(vdbArchiveFile);
        if (existingDefFile != null) {
            ZipFileUtil.remove(vdbArchiveFile, existingDefFile.getName(), true);
        }
        if (!(added = ZipFileUtil.add(vdbArchiveFile, defnFile.getName(), defnFile.getAbsolutePath()))) {
            throw new MetaMatrixComponentException(VdbEditPlugin.Util.getString("VDBWriter.Unable_to_add_vdbdefn_to_archive"));
        }
    }

    private void exportToOutputStream(OutputStream vdbArchiveOS, VDBDefn vdbDefn, Properties headerProps) throws IOException, Exception {
        this.createTempDir();
        File archiveFile = this.writeTempFile(vdbDefn.getVDBJar(), vdbDefn.getFileName() != null ? vdbDefn.getFileName() : vdbDefn.getName() + ".vdb");
        this.addDefnToVDBArchive(vdbDefn, archiveFile.getAbsolutePath(), headerProps);
        FileUtils.write(archiveFile, vdbArchiveOS);
    }

    private void createTempDir() throws VdbProcessingException, MetaMatrixComponentException {
        if (this.tempVDBFiles != null) {
            return;
        }
        try {
            this.tempVDBFiles = new TempDirectory(System.currentTimeMillis(), random.nextLong());
            this.tempVDBFiles.create();
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException(e2);
        }
    }

    private File writeTempFile(byte[] contents, String fileName) throws VdbProcessingException, MetaMatrixComponentException {
        File tempFile = null;
        try {
            tempFile = new File(this.tempVDBFiles.getPath(), fileName);
            new FileUtil(tempFile.getAbsolutePath()).writeBytes(contents);
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException(e2);
        }
        return tempFile;
    }

    private void cleanupTempFiles() {
        if (this.tempVDBFiles != null) {
            this.tempVDBFiles.remove();
            this.tempVDBFiles = null;
        }
    }
}

