/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.edit.manifest.impl;

import com.metamatrix.core.util.DateUtil;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.core.impl.ModelImportImpl;
import com.metamatrix.vdb.edit.manifest.ManifestPackage;
import com.metamatrix.vdb.edit.manifest.ModelAccessibility;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.edit.manifest.ModelSource;
import com.metamatrix.vdb.edit.manifest.ProblemMarker;
import com.metamatrix.vdb.edit.manifest.Severity;
import com.metamatrix.vdb.edit.manifest.VirtualDatabase;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ModelReferenceImpl
extends ModelImportImpl
implements ModelReference {
    public static final String copyright = "Copyright (c) 2000-2005 MetaMatrix Corporation.  All rights reserved.";
    protected static final Severity SEVERITY_EDEFAULT = Severity.OK_LITERAL;
    protected Severity severity = SEVERITY_EDEFAULT;
    protected EList markers = null;
    protected static final String VERSION_EDEFAULT = null;
    protected String version = VERSION_EDEFAULT;
    protected static final String URI_EDEFAULT = null;
    protected String uri = URI_EDEFAULT;
    protected static final boolean VISIBLE_EDEFAULT = true;
    protected boolean visible = true;
    protected static final ModelAccessibility ACCESSIBILITY_EDEFAULT = ModelAccessibility.PUBLIC_LITERAL;
    protected ModelAccessibility accessibility = ACCESSIBILITY_EDEFAULT;
    protected static final String TIME_LAST_SYNCHRONIZED_EDEFAULT = null;
    protected String timeLastSynchronized = TIME_LAST_SYNCHRONIZED_EDEFAULT;
    protected static final Date TIME_LAST_SYNCHRONIZED_AS_DATE_EDEFAULT = null;
    protected static final long CHECKSUM_EDEFAULT = 0L;
    protected long checksum = 0L;
    protected EList uses = null;
    protected EList usedBy = null;
    protected ModelSource modelSource = null;
    static /* synthetic */ Class class$com$metamatrix$vdb$edit$manifest$ProblemMarker;
    static /* synthetic */ Class class$com$metamatrix$vdb$edit$manifest$VirtualDatabase;
    static /* synthetic */ Class class$com$metamatrix$vdb$edit$manifest$ModelReference;
    static /* synthetic */ Class class$com$metamatrix$vdb$edit$manifest$ModelSource;
    static /* synthetic */ Class class$com$metamatrix$metamodels$core$ModelAnnotation;
    static /* synthetic */ Class class$com$metamatrix$vdb$edit$manifest$ProblemMarkerContainer;

    protected ModelReferenceImpl() {
    }

    protected EClass eStaticClass() {
        return ManifestPackage.eINSTANCE.getModelReference();
    }

    public Severity getSeverity() {
        return this.calculateSeverity(Severity.OK_LITERAL);
    }

    public Severity getSeverityGen() {
        return this.severity;
    }

    protected Severity calculateSeverity(Severity initialSeverity) {
        Severity severity = initialSeverity;
        if (this.markers != null) {
            Iterator iter = this.markers.iterator();
            while (iter.hasNext()) {
                ProblemMarker marker = (ProblemMarker)iter.next();
                if (marker.getSeverity().getValue() <= severity.getValue()) continue;
                severity = marker.getSeverity();
            }
        }
        return severity;
    }

    public void setSeverity(Severity newSeverity) {
        Severity oldSeverity = this.severity;
        Severity severity = this.severity = newSeverity == null ? SEVERITY_EDEFAULT : newSeverity;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldSeverity, (Object)this.severity));
        }
    }

    public EList getMarkers() {
        if (this.markers == null) {
            this.markers = new EObjectContainmentWithInverseEList(class$com$metamatrix$vdb$edit$manifest$ProblemMarker == null ? (class$com$metamatrix$vdb$edit$manifest$ProblemMarker = ModelReferenceImpl.class$("com.metamatrix.vdb.edit.manifest.ProblemMarker")) : class$com$metamatrix$vdb$edit$manifest$ProblemMarker, this, 8, 6);
        }
        return this.markers;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldVersion, (Object)this.version));
        }
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String newUri) {
        String oldUri = this.uri;
        this.uri = newUri;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldUri, (Object)this.uri));
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean newVisible) {
        boolean oldVisible = this.visible;
        this.visible = newVisible;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 11, oldVisible, this.visible));
        }
    }

    public ModelAccessibility getAccessibility() {
        return this.accessibility;
    }

    public void setAccessibility(ModelAccessibility newAccessibility) {
        ModelAccessibility oldAccessibility = this.accessibility;
        ModelAccessibility modelAccessibility = this.accessibility = newAccessibility == null ? ACCESSIBILITY_EDEFAULT : newAccessibility;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldAccessibility, (Object)this.accessibility));
        }
    }

    public String getTimeLastSynchronized() {
        return this.timeLastSynchronized;
    }

    public void setTimeLastSynchronized(String newTimeLastSynchronized) {
        String oldTimeLastSynchronized = this.timeLastSynchronized;
        this.timeLastSynchronized = newTimeLastSynchronized;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldTimeLastSynchronized, (Object)this.timeLastSynchronized));
        }
    }

    public Date getTimeLastSynchronizedAsDate() {
        String timeLastProducedString = this.getTimeLastSynchronized();
        if (timeLastProducedString != null) {
            try {
                Date result = DateUtil.convertStringToDate(timeLastProducedString);
                return result;
            }
            catch (ParseException e2) {
                try {
                    long longValue = Long.parseLong(timeLastProducedString);
                    Date result = new Date(longValue);
                    return result;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public Date getTimeLastSynchronizedAsDateGen() {
        throw new UnsupportedOperationException();
    }

    public void setTimeLastSynchronizedAsDate(Date newTimeLastSynchronizedAsDate) {
        if (newTimeLastSynchronizedAsDate == null) {
            this.setTimeLastSynchronized(null);
        } else {
            String dateString = DateUtil.getDateAsString(newTimeLastSynchronizedAsDate);
            this.setTimeLastSynchronized(dateString);
        }
    }

    public void setTimeLastSynchronizedAsDateGen(Date newTimeLastSynchronizedAsDate) {
        throw new UnsupportedOperationException();
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(long newChecksum) {
        long oldChecksum = this.checksum;
        this.checksum = newChecksum;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 15, oldChecksum, this.checksum));
        }
    }

    public VirtualDatabase getVirtualDatabase() {
        if (this.eContainerFeatureID != 16) {
            return null;
        }
        return (VirtualDatabase)((Object)this.eContainer);
    }

    public void setVirtualDatabase(VirtualDatabase newVirtualDatabase) {
        if (newVirtualDatabase != this.eContainer || this.eContainerFeatureID != 16 && newVirtualDatabase != null) {
            if (EcoreUtil.isAncestor(this, (EObject)newVirtualDatabase)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eContainer != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newVirtualDatabase != null) {
                msgs = ((InternalEObject)((Object)newVirtualDatabase)).eInverseAdd(this, 15, class$com$metamatrix$vdb$edit$manifest$VirtualDatabase == null ? (class$com$metamatrix$vdb$edit$manifest$VirtualDatabase = ModelReferenceImpl.class$("com.metamatrix.vdb.edit.manifest.VirtualDatabase")) : class$com$metamatrix$vdb$edit$manifest$VirtualDatabase, msgs);
            }
            if ((msgs = this.eBasicSetContainer((InternalEObject)((Object)newVirtualDatabase), 16, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 16, (Object)newVirtualDatabase, (Object)newVirtualDatabase));
        }
    }

    public EList getUses() {
        if (this.uses == null) {
            this.uses = new EObjectWithInverseResolvingEList.ManyInverse(class$com$metamatrix$vdb$edit$manifest$ModelReference == null ? (class$com$metamatrix$vdb$edit$manifest$ModelReference = ModelReferenceImpl.class$("com.metamatrix.vdb.edit.manifest.ModelReference")) : class$com$metamatrix$vdb$edit$manifest$ModelReference, this, 17, 18);
        }
        return this.uses;
    }

    public EList getUsedBy() {
        if (this.usedBy == null) {
            this.usedBy = new EObjectWithInverseResolvingEList.ManyInverse(class$com$metamatrix$vdb$edit$manifest$ModelReference == null ? (class$com$metamatrix$vdb$edit$manifest$ModelReference = ModelReferenceImpl.class$("com.metamatrix.vdb.edit.manifest.ModelReference")) : class$com$metamatrix$vdb$edit$manifest$ModelReference, this, 18, 17);
        }
        return this.usedBy;
    }

    public ModelSource getModelSource() {
        return this.modelSource;
    }

    public NotificationChain basicSetModelSource(ModelSource newModelSource, NotificationChain msgs) {
        ModelSource oldModelSource = this.modelSource;
        this.modelSource = newModelSource;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 19, (Object)oldModelSource, (Object)newModelSource);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public void setModelSource(ModelSource newModelSource) {
        if (newModelSource != this.modelSource) {
            NotificationChain msgs = null;
            if (this.modelSource != null) {
                msgs = ((InternalEObject)((Object)this.modelSource)).eInverseRemove(this, 1, class$com$metamatrix$vdb$edit$manifest$ModelSource == null ? (class$com$metamatrix$vdb$edit$manifest$ModelSource = ModelReferenceImpl.class$("com.metamatrix.vdb.edit.manifest.ModelSource")) : class$com$metamatrix$vdb$edit$manifest$ModelSource, msgs);
            }
            if (newModelSource != null) {
                msgs = ((InternalEObject)((Object)newModelSource)).eInverseAdd(this, 1, class$com$metamatrix$vdb$edit$manifest$ModelSource == null ? (class$com$metamatrix$vdb$edit$manifest$ModelSource = ModelReferenceImpl.class$("com.metamatrix.vdb.edit.manifest.ModelSource")) : class$com$metamatrix$vdb$edit$manifest$ModelSource, msgs);
            }
            if ((msgs = this.basicSetModelSource(newModelSource, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 19, (Object)newModelSource, (Object)newModelSource));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 6, msgs);
                }
                case 8: {
                    return ((InternalEList)this.getMarkers()).basicAdd(otherEnd, msgs);
                }
                case 16: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 16, msgs);
                }
                case 17: {
                    return ((InternalEList)this.getUses()).basicAdd(otherEnd, msgs);
                }
                case 18: {
                    return ((InternalEList)this.getUsedBy()).basicAdd(otherEnd, msgs);
                }
                case 19: {
                    if (this.modelSource != null) {
                        msgs = ((InternalEObject)((Object)this.modelSource)).eInverseRemove(this, -20, null, msgs);
                    }
                    return this.basicSetModelSource((ModelSource)((Object)otherEnd), msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    return this.eBasicSetContainer(null, 6, msgs);
                }
                case 8: {
                    return ((InternalEList)this.getMarkers()).basicRemove(otherEnd, msgs);
                }
                case 16: {
                    return this.eBasicSetContainer(null, 16, msgs);
                }
                case 17: {
                    return ((InternalEList)this.getUses()).basicRemove(otherEnd, msgs);
                }
                case 18: {
                    return ((InternalEList)this.getUsedBy()).basicRemove(otherEnd, msgs);
                }
                case 19: {
                    return this.basicSetModelSource(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (this.eContainerFeatureID >= 0) {
            switch (this.eContainerFeatureID) {
                case 6: {
                    return this.eContainer.eInverseRemove(this, 15, class$com$metamatrix$metamodels$core$ModelAnnotation == null ? (class$com$metamatrix$metamodels$core$ModelAnnotation = ModelReferenceImpl.class$("com.metamatrix.metamodels.core.ModelAnnotation")) : class$com$metamatrix$metamodels$core$ModelAnnotation, msgs);
                }
                case 16: {
                    return this.eContainer.eInverseRemove(this, 15, class$com$metamatrix$vdb$edit$manifest$VirtualDatabase == null ? (class$com$metamatrix$vdb$edit$manifest$VirtualDatabase = ModelReferenceImpl.class$("com.metamatrix.vdb.edit.manifest.VirtualDatabase")) : class$com$metamatrix$vdb$edit$manifest$VirtualDatabase, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove(this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getPath();
            }
            case 2: {
                return this.getModelLocation();
            }
            case 3: {
                return this.getUuid();
            }
            case 4: {
                return this.getModelType();
            }
            case 5: {
                return this.getPrimaryMetamodelUri();
            }
            case 6: {
                return this.getModel();
            }
            case 7: {
                return this.getSeverity();
            }
            case 8: {
                return this.getMarkers();
            }
            case 9: {
                return this.getVersion();
            }
            case 10: {
                return this.getUri();
            }
            case 11: {
                return this.isVisible() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.getAccessibility();
            }
            case 13: {
                return this.getTimeLastSynchronized();
            }
            case 14: {
                return this.getTimeLastSynchronizedAsDate();
            }
            case 15: {
                return new Long(this.getChecksum());
            }
            case 16: {
                return this.getVirtualDatabase();
            }
            case 17: {
                return this.getUses();
            }
            case 18: {
                return this.getUsedBy();
            }
            case 19: {
                return this.getModelSource();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setModelLocation((String)newValue);
                return;
            }
            case 3: {
                this.setUuid((String)newValue);
                return;
            }
            case 4: {
                this.setModelType((ModelType)newValue);
                return;
            }
            case 5: {
                this.setPrimaryMetamodelUri((String)newValue);
                return;
            }
            case 6: {
                this.setModel((ModelAnnotation)newValue);
                return;
            }
            case 7: {
                this.setSeverity((Severity)newValue);
                return;
            }
            case 8: {
                this.getMarkers().clear();
                this.getMarkers().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setVersion((String)newValue);
                return;
            }
            case 10: {
                this.setUri((String)newValue);
                return;
            }
            case 11: {
                this.setVisible((Boolean)newValue);
                return;
            }
            case 12: {
                this.setAccessibility((ModelAccessibility)newValue);
                return;
            }
            case 13: {
                this.setTimeLastSynchronized((String)newValue);
                return;
            }
            case 14: {
                this.setTimeLastSynchronizedAsDate((Date)newValue);
                return;
            }
            case 15: {
                this.setChecksum((Long)newValue);
                return;
            }
            case 16: {
                this.setVirtualDatabase((VirtualDatabase)newValue);
                return;
            }
            case 17: {
                this.getUses().clear();
                this.getUses().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.getUsedBy().clear();
                this.getUsedBy().addAll((Collection)newValue);
                return;
            }
            case 19: {
                this.setModelSource((ModelSource)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setModelLocation(MODEL_LOCATION_EDEFAULT);
                return;
            }
            case 3: {
                this.setUuid(UUID_EDEFAULT);
                return;
            }
            case 4: {
                this.setModelType(MODEL_TYPE_EDEFAULT);
                return;
            }
            case 5: {
                this.setPrimaryMetamodelUri(PRIMARY_METAMODEL_URI_EDEFAULT);
                return;
            }
            case 6: {
                this.setModel(null);
                return;
            }
            case 7: {
                this.setSeverity(SEVERITY_EDEFAULT);
                return;
            }
            case 8: {
                this.getMarkers().clear();
                return;
            }
            case 9: {
                this.setVersion(VERSION_EDEFAULT);
                return;
            }
            case 10: {
                this.setUri(URI_EDEFAULT);
                return;
            }
            case 11: {
                this.setVisible(true);
                return;
            }
            case 12: {
                this.setAccessibility(ACCESSIBILITY_EDEFAULT);
                return;
            }
            case 13: {
                this.setTimeLastSynchronized(TIME_LAST_SYNCHRONIZED_EDEFAULT);
                return;
            }
            case 14: {
                this.setTimeLastSynchronizedAsDate(TIME_LAST_SYNCHRONIZED_AS_DATE_EDEFAULT);
                return;
            }
            case 15: {
                this.setChecksum(0L);
                return;
            }
            case 16: {
                this.setVirtualDatabase(null);
                return;
            }
            case 17: {
                this.getUses().clear();
                return;
            }
            case 18: {
                this.getUsedBy().clear();
                return;
            }
            case 19: {
                this.setModelSource(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return PATH_EDEFAULT == null ? this.getPath() != null : !PATH_EDEFAULT.equals(this.getPath());
            }
            case 2: {
                return MODEL_LOCATION_EDEFAULT == null ? this.modelLocation != null : !MODEL_LOCATION_EDEFAULT.equals(this.modelLocation);
            }
            case 3: {
                return UUID_EDEFAULT == null ? this.uuid != null : !UUID_EDEFAULT.equals(this.uuid);
            }
            case 4: {
                return this.modelType != MODEL_TYPE_EDEFAULT;
            }
            case 5: {
                return PRIMARY_METAMODEL_URI_EDEFAULT == null ? this.primaryMetamodelUri != null : !PRIMARY_METAMODEL_URI_EDEFAULT.equals(this.primaryMetamodelUri);
            }
            case 6: {
                return this.getModel() != null;
            }
            case 7: {
                return this.severity != SEVERITY_EDEFAULT;
            }
            case 8: {
                return this.markers != null && !this.markers.isEmpty();
            }
            case 9: {
                return VERSION_EDEFAULT == null ? this.version != null : !VERSION_EDEFAULT.equals(this.version);
            }
            case 10: {
                return URI_EDEFAULT == null ? this.uri != null : !URI_EDEFAULT.equals(this.uri);
            }
            case 11: {
                return !this.visible;
            }
            case 12: {
                return this.accessibility != ACCESSIBILITY_EDEFAULT;
            }
            case 13: {
                return TIME_LAST_SYNCHRONIZED_EDEFAULT == null ? this.timeLastSynchronized != null : !TIME_LAST_SYNCHRONIZED_EDEFAULT.equals(this.timeLastSynchronized);
            }
            case 14: {
                return TIME_LAST_SYNCHRONIZED_AS_DATE_EDEFAULT == null ? this.getTimeLastSynchronizedAsDate() != null : !TIME_LAST_SYNCHRONIZED_AS_DATE_EDEFAULT.equals(this.getTimeLastSynchronizedAsDate());
            }
            case 15: {
                return this.checksum != 0L;
            }
            case 16: {
                return this.getVirtualDatabase() != null;
            }
            case 17: {
                return this.uses != null && !this.uses.isEmpty();
            }
            case 18: {
                return this.usedBy != null && !this.usedBy.isEmpty();
            }
            case 19: {
                return this.modelSource != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class baseClass) {
        if (baseClass == (class$com$metamatrix$vdb$edit$manifest$ProblemMarkerContainer == null ? (class$com$metamatrix$vdb$edit$manifest$ProblemMarkerContainer = ModelReferenceImpl.class$("com.metamatrix.vdb.edit.manifest.ProblemMarkerContainer")) : class$com$metamatrix$vdb$edit$manifest$ProblemMarkerContainer)) {
            switch (derivedFeatureID) {
                case 7: {
                    return 0;
                }
                case 8: {
                    return 1;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass) {
        if (baseClass == (class$com$metamatrix$vdb$edit$manifest$ProblemMarkerContainer == null ? (class$com$metamatrix$vdb$edit$manifest$ProblemMarkerContainer = ModelReferenceImpl.class$("com.metamatrix.vdb.edit.manifest.ProblemMarkerContainer")) : class$com$metamatrix$vdb$edit$manifest$ProblemMarkerContainer)) {
            switch (baseFeatureID) {
                case 0: {
                    return 7;
                }
                case 1: {
                    return 8;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (severity: ");
        result.append(this.severity);
        result.append(", version: ");
        result.append(this.version);
        result.append(", uri: ");
        result.append(this.uri);
        result.append(", visible: ");
        result.append(this.visible);
        result.append(", accessibility: ");
        result.append(this.accessibility);
        result.append(", timeLastSynchronized: ");
        result.append(this.timeLastSynchronized);
        result.append(", checksum: ");
        result.append(this.checksum);
        result.append(')');
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

