/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.vdb.edit.VdbEditException;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.internal.edit.VdbInputResourceFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;

public class RegisteredVdbInputResourceFinder
implements VdbInputResourceFinder {
    private final Map resourcesByPath = new HashMap();
    private final Map pathsByResource = new HashMap();

    public Resource getEmfResource(IPath modelPath) {
        return (Resource)this.resourcesByPath.get(modelPath);
    }

    public Resource getEmfResource(ModelReference modelRef) {
        String location = modelRef.getModelLocation();
        if (!StringUtil.isEmpty(location)) {
            IPath modelPath = new Path(location).makeAbsolute();
            return this.getEmfResource(modelPath);
        }
        return null;
    }

    public InputStream getEmfResourceStream(Resource emfResource) throws VdbEditException {
        ArgCheck.isNotNull(emfResource);
        if (emfResource.getURI().isFile()) {
            try {
                File f2 = new File(emfResource.getURI().toFileString());
                if (f2.exists()) {
                    return new FileInputStream(f2);
                }
            }
            catch (FileNotFoundException e2) {
                throw new VdbEditException(e2);
            }
        }
        return null;
    }

    public IPath getEmfResourcePath(Resource emfResource) throws VdbEditException {
        return (IPath)this.pathsByResource.get(emfResource);
    }

    public Object register(IPath modelPath, Resource emfResource) {
        this.pathsByResource.put(emfResource, modelPath);
        return this.resourcesByPath.put(modelPath, emfResource);
    }

    public Object unregister(IPath modelPath) {
        Resource emfResource = (Resource)this.resourcesByPath.get(modelPath);
        if (emfResource != null) {
            this.pathsByResource.remove(emfResource);
        }
        return this.resourcesByPath.remove(modelPath);
    }

    public Object unregister(Resource emfResource) {
        IPath modelPath = (IPath)this.pathsByResource.get(emfResource);
        if (modelPath != null) {
            this.resourcesByPath.remove(modelPath);
        }
        return this.pathsByResource.remove(emfResource);
    }
}

