/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.vdb.edit.manifest.ManifestFactory;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.edit.manifest.ProblemMarker;
import com.metamatrix.vdb.edit.manifest.ProblemMarkerContainer;
import com.metamatrix.vdb.edit.manifest.Severity;
import com.metamatrix.vdb.edit.manifest.VirtualDatabase;

public class VdbEditingContextImplProblemMarker {
    private ProblemMarkerContainer marked;
    private int severity;
    private String msg;
    private Throwable throwable;

    public VdbEditingContextImplProblemMarker(ProblemMarkerContainer marked, int severity, String msg, Throwable t2) {
        this.marked = marked;
        this.severity = severity;
        this.msg = msg;
        this.throwable = t2;
    }

    protected void markProblem() {
        ProblemMarker marker = ManifestFactory.eINSTANCE.createProblemMarker();
        switch (this.severity) {
            case 4: {
                marker.setSeverity(Severity.ERROR_LITERAL);
                break;
            }
            case 2: {
                marker.setSeverity(Severity.WARNING_LITERAL);
                break;
            }
            case 1: {
                marker.setSeverity(Severity.INFO_LITERAL);
                break;
            }
            case 0: {
                marker.setSeverity(Severity.OK_LITERAL);
            }
        }
        if (this.marked instanceof VirtualDatabase && ((VirtualDatabase)this.marked).getName() != null) {
            marker.setTarget(((VirtualDatabase)this.marked).getName());
        } else if (this.marked instanceof ModelReference && ((ModelReference)this.marked).getModelLocation() != null) {
            marker.setTarget(((ModelReference)this.marked).getModelLocation());
        }
        marker.setMessage(this.msg);
        if (this.throwable != null) {
            String trace = StringUtil.getStackTrace(this.throwable);
            marker.setStackTrace(trace);
        }
        marker.setMarked(this.marked);
    }
}

