/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.vdb.edit.VdbGenerationContext;
import com.metamatrix.vdb.edit.VdbGenerationContextParameters;
import com.metamatrix.vdb.internal.edit.InternalVdbGenerationContext;
import com.metamatrix.vdb.internal.edit.VdbContextImpl;
import com.metamatrix.vdb.internal.edit.VdbGenerationModelHelper;
import com.metamatrix.vdb.internal.edit.VdbGenerationModelObjectHelper;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.jdom.Document;

public class VdbGenerationContextImpl
implements InternalVdbGenerationContext {
    private final VdbGenerationModelObjectHelper modelObjectHelper;
    private final VdbGenerationModelHelper modelHelper;
    private final Resource[] models;
    private final List problems;
    private final Map artifactsByPath;
    private final Map modelNameByResource;
    private final Map workspacePathByResource;
    private final Map modelVisibilityByResource;
    private final Set newArtifactsByCaseInsensitivePath;
    private final Set existingPathsInVdb;
    private final Set existingUpperCasePathsInVdb;
    private final String tempFolderAbsolutePath;
    private String displayMessage;
    private VdbContextImpl vdbContext;
    private Map dataMap;
    private ResourceSet resourceSet;

    public VdbGenerationContextImpl(VdbGenerationContextParameters parameters) {
        ArgCheck.isNotNull(parameters);
        this.modelObjectHelper = new VdbGenerationModelObjectHelper(parameters.getProblemsByObjectId());
        this.models = parameters.getModels();
        this.problems = new ArrayList();
        this.artifactsByPath = new HashMap();
        this.modelNameByResource = parameters.getModelNameByResource();
        this.workspacePathByResource = parameters.getWorkspacePathByResource();
        this.modelVisibilityByResource = parameters.getModelVisibilityByResource();
        this.modelHelper = new VdbGenerationModelHelper(this.modelNameByResource, this.workspacePathByResource, this.modelVisibilityByResource);
        this.newArtifactsByCaseInsensitivePath = new HashSet();
        this.tempFolderAbsolutePath = parameters.getTempFolderAbsolutePath();
        this.dataMap = new HashMap();
        this.existingPathsInVdb = new HashSet();
        this.existingUpperCasePathsInVdb = new HashSet();
        IPath[] paths = parameters.getExistingPathsInVdb();
        if (paths != null) {
            for (int i2 = 0; i2 < paths.length; ++i2) {
                IPath path = paths[i2];
                if (path == null) continue;
                String thePath = ((Object)path.makeAbsolute()).toString();
                this.existingPathsInVdb.add(((Object)path).toString());
                this.existingUpperCasePathsInVdb.add(thePath.toUpperCase());
                this.existingUpperCasePathsInVdb.add(((Object)path).toString().toUpperCase());
            }
        }
    }

    public VdbGenerationContextImpl(Resource[] models, IProgressMonitor monitor, IPath[] existingPathsInVdb, Map modelNameByResource, Map workspacePathByResource, Map modelVisibilityByResource, Map problemsByObjectId, String tempFolderAbsolutePath) {
        ArgCheck.isNotNull(models);
        ArgCheck.isNotNull(modelNameByResource);
        ArgCheck.isNotNull(workspacePathByResource);
        ArgCheck.isNotNull(modelVisibilityByResource);
        ArgCheck.isNotNull(problemsByObjectId);
        this.modelObjectHelper = new VdbGenerationModelObjectHelper(problemsByObjectId);
        this.models = models;
        this.problems = new ArrayList();
        this.artifactsByPath = new HashMap();
        this.modelNameByResource = new HashMap(modelNameByResource);
        this.workspacePathByResource = new HashMap(workspacePathByResource);
        this.modelVisibilityByResource = new HashMap(modelVisibilityByResource);
        this.modelHelper = new VdbGenerationModelHelper(this.modelNameByResource, this.workspacePathByResource, this.modelVisibilityByResource);
        this.newArtifactsByCaseInsensitivePath = new HashSet();
        this.tempFolderAbsolutePath = tempFolderAbsolutePath;
        this.existingPathsInVdb = new HashSet();
        this.existingUpperCasePathsInVdb = new HashSet();
        if (existingPathsInVdb != null) {
            for (int i2 = 0; i2 < existingPathsInVdb.length; ++i2) {
                IPath path = existingPathsInVdb[i2];
                if (path == null) continue;
                String thePath = ((Object)path.makeAbsolute()).toString();
                this.existingPathsInVdb.add(((Object)path).toString());
                this.existingUpperCasePathsInVdb.add(thePath.toUpperCase());
                this.existingUpperCasePathsInVdb.add(((Object)path).toString().toUpperCase());
            }
        }
    }

    public Set getExistingPathsInVdb() {
        return this.existingPathsInVdb;
    }

    public List getProblems() {
        return this.problems;
    }

    public File getTemporaryDirectory() {
        if (this.tempFolderAbsolutePath != null) {
            return new File(this.tempFolderAbsolutePath);
        }
        return null;
    }

    public Map getGeneratedArtifactsByPath() {
        return new HashMap(this.artifactsByPath);
    }

    public Resource[] getModels() {
        return this.models;
    }

    public Resource[] getModels(String primaryMetamodelUri) {
        ArgCheck.isNotNull(primaryMetamodelUri);
        ArrayList<Resource> results = new ArrayList<Resource>();
        for (int i2 = 0; i2 < this.models.length; ++i2) {
            Resource model = this.models[i2];
            String metamodelUri = this.getPrimaryMetamodel(model);
            if (!primaryMetamodelUri.equals(metamodelUri)) continue;
            results.add(model);
        }
        return results.toArray(new Resource[results.size()]);
    }

    protected String getPrimaryMetamodel(Resource model) {
        return this.modelHelper.getPrimaryMetamodelUri(model);
    }

    public VdbGenerationContext.ModelHelper getModelHelper() {
        return this.modelHelper;
    }

    public VdbGenerationContext.ModelObjectHelper getObjectHelper() {
        return this.modelObjectHelper;
    }

    public void addErrorMessage(String message, int code, Throwable t2) {
        if (message != null) {
            Status status = new Status(4, "com.metamatrix.vdb.edit", code, message, t2);
            this.problems.add(status);
        }
    }

    public void addWarningMessage(String message, int code) {
        if (message != null) {
            Status status = new Status(2, "com.metamatrix.vdb.edit", code, message, null);
            this.problems.add(status);
        }
    }

    public void addInfoMessage(String message, int code) {
        if (message != null) {
            Status status = new Status(1, "com.metamatrix.vdb.edit", code, message, null);
            this.problems.add(status);
        }
    }

    public void setProgressMessage(String displayableMessage) {
        this.displayMessage = displayableMessage;
    }

    public String getProgressMessage() {
        return this.displayMessage;
    }

    public boolean addGeneratedArtifact(String pathInVdb, String content) {
        ArgCheck.isNotZeroLength(pathInVdb);
        return this.doAddGeneratedArtifact(pathInVdb, content);
    }

    public boolean addGeneratedArtifact(String pathInVdb, Document xmlContent) {
        ArgCheck.isNotZeroLength(pathInVdb);
        return this.doAddGeneratedArtifact(pathInVdb, xmlContent);
    }

    public boolean addGeneratedArtifact(String pathInVdb, InputStream content) {
        ArgCheck.isNotZeroLength(pathInVdb);
        return this.doAddGeneratedArtifact(pathInVdb, content);
    }

    public boolean addGeneratedArtifact(String pathInVdb, File content) {
        ArgCheck.isNotZeroLength(pathInVdb);
        return this.doAddGeneratedArtifact(pathInVdb, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAddGeneratedArtifact(String pathInVdb, Object content) {
        Map map = this.artifactsByPath;
        synchronized (map) {
            IPath path = new Path(pathInVdb).makeAbsolute();
            String thePath = ((Object)path).toString();
            if (this.existingUpperCasePathsInVdb.contains(thePath.toUpperCase())) {
                return false;
            }
            if (!this.newArtifactsByCaseInsensitivePath.contains(thePath.toUpperCase())) {
                this.artifactsByPath.put(thePath, content);
                this.newArtifactsByCaseInsensitivePath.add(thePath.toUpperCase());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.problems.clear();
            this.artifactsByPath.clear();
            this.modelNameByResource.clear();
            this.workspacePathByResource.clear();
            this.modelVisibilityByResource.clear();
            this.newArtifactsByCaseInsensitivePath.clear();
            this.existingPathsInVdb.clear();
            this.existingUpperCasePathsInVdb.clear();
            this.dataMap.clear();
            Object var2_1 = null;
            this.displayMessage = null;
            this.vdbContext = null;
            this.resourceSet = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.displayMessage = null;
            this.vdbContext = null;
            this.resourceSet = null;
            throw throwable;
        }
    }

    public Object getData(String theKey) {
        return this.getDataMap().get(theKey);
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public VdbContextImpl getVdbContext() {
        return this.vdbContext;
    }

    public Map getDataMap() {
        return this.dataMap;
    }

    public void setResourceSet(ResourceSet theResourceSet) {
        ArgCheck.isNotNull(theResourceSet);
        this.resourceSet = theResourceSet;
    }

    public void setVdbContext(VdbContextImpl theVdbContext) {
        ArgCheck.isNotNull(theVdbContext);
        this.vdbContext = theVdbContext;
    }
}

