/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.index.IDocument;
import com.metamatrix.core.index.IIndexer;
import com.metamatrix.core.index.IIndexerOutput;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.index.WordEntry;
import com.metamatrix.modeler.core.index.IndexingContext;
import com.metamatrix.modeler.core.index.VDBDocument;
import com.metamatrix.modeler.core.util.ModelObjectCollector;
import com.metamatrix.modeler.internal.core.index.WordEntryComparator;
import com.metamatrix.modeler.internal.core.metadata.runtime.RuntimeAdapter;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class VdbIndexer
implements IIndexer {
    public static boolean PRINT_INDEX_CONTENTS = false;
    private static final String[] FILE_TYPES = new String[]{"xmi", "xsd", "vdb"};
    private static final WordEntryComparator wComparator = new WordEntryComparator();
    private Map indexToCollectionMap = new HashMap();
    private boolean wordsCollected = false;
    private IndexingContext context;
    static /* synthetic */ Class class$com$metamatrix$modeler$core$index$VDBDocument;

    public String[] getFileTypes() {
        return FILE_TYPES;
    }

    public VdbIndexer(IndexingContext context) {
        ArgCheck.isNotNull(context);
        this.context = context;
    }

    public VdbIndexer() {
    }

    public void index(IDocument document, IIndexerOutput output) throws IOException {
        ArgCheck.isInstanceOf(class$com$metamatrix$modeler$core$index$VDBDocument == null ? (class$com$metamatrix$modeler$core$index$VDBDocument = VdbIndexer.class$("com.metamatrix.modeler.core.index.VDBDocument")) : class$com$metamatrix$modeler$core$index$VDBDocument, document);
        ArgCheck.isNotNull(output);
        VDBDocument vdbDocument = (VDBDocument)document;
        String indexName = vdbDocument.getIndexName();
        if (!this.wordsCollected) {
            HashSet wordEntries = new HashSet();
            Collection resources = vdbDocument.getResources();
            Iterator resourceIter = resources.iterator();
            while (resourceIter.hasNext()) {
                URI uri;
                Resource resource = (Resource)resourceIter.next();
                if (resource == null) continue;
                String modelPath = null;
                if (ModelUtil.isModelFile(resource)) {
                    modelPath = vdbDocument.getModelPath(resource.getURI());
                }
                if (StringUtil.isEmpty(modelPath) && (uri = resource.getURI()) != null) {
                    modelPath = uri.toString();
                }
                ModelObjectCollector moc = new ModelObjectCollector(resource);
                List eObjects = moc.getEObjects();
                Iterator iter = eObjects.iterator();
                while (iter.hasNext()) {
                    EObject eObject = (EObject)iter.next();
                    RuntimeAdapter.addIndexWord(eObject, this.context, modelPath, wordEntries);
                }
            }
            this.collectEntityWords(wordEntries);
            this.wordsCollected = true;
            if (PRINT_INDEX_CONTENTS) {
                this.printIndexContents(System.out);
            }
        }
        this.addEntries(document, output, indexName);
    }

    public void setFileTypes(String[] fileTypes) {
    }

    public boolean shouldIndex(IDocument document) {
        return false;
    }

    private void printIndexContents(PrintStream stream) {
        Iterator iter1 = this.indexToCollectionMap.keySet().iterator();
        while (iter1.hasNext()) {
            String indexName = (String)iter1.next();
            stream.println("\n" + indexName);
            Collection wordEntries = (Collection)this.indexToCollectionMap.get(indexName);
            if (wordEntries == null || wordEntries.isEmpty()) continue;
            Iterator iter2 = wordEntries.iterator();
            while (iter2.hasNext()) {
                WordEntry entry = (WordEntry)iter2.next();
                stream.println(entry.toString());
            }
        }
    }

    private void addEntries(IDocument document, IIndexerOutput output, String indexName) {
        List entries = (List)this.indexToCollectionMap.get(indexName);
        if (entries != null && entries.size() > 0) {
            output.addDocument(document);
            Collections.sort(entries, wComparator);
            Iterator entryIter = entries.iterator();
            while (entryIter.hasNext()) {
                WordEntry entry = (WordEntry)entryIter.next();
                output.addRef(entry.getWord());
            }
        }
        this.indexToCollectionMap.remove(indexName);
    }

    private void collectEntityWords(Collection wordEntries) throws IOException {
        Iterator iter = wordEntries.iterator();
        while (iter.hasNext()) {
            WordEntry entry = (WordEntry)iter.next();
            if (entry == null) continue;
            char recordType = entry.getWord()[0];
            if (recordType == '&') {
                recordType = entry.getWord()[1];
            }
            switch (recordType) {
                case 'G': {
                    this.addIndexWord("COLUMNS.INDEX", entry);
                    break;
                }
                case 'B': {
                    this.addIndexWord("TABLES.INDEX", entry);
                    break;
                }
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': {
                    this.addIndexWord("KEYS.INDEX", entry);
                    break;
                }
                case 'V': {
                    this.addIndexWord("VDBS.INDEX", entry);
                    break;
                }
                case 'A': {
                    this.addIndexWord("MODELS.INDEX", entry);
                    break;
                }
                case 'M': {
                    this.addIndexWord("DATATYPES.INDEX", entry);
                    break;
                }
                case 'P': {
                    this.addIndexWord("SELECT_TRANSFORM.INDEX", entry);
                    break;
                }
                case 'Q': {
                    this.addIndexWord("INSERT_TRANSFORM.INDEX", entry);
                    break;
                }
                case 'S': {
                    this.addIndexWord("DELETE_TRANSFORM.INDEX", entry);
                    break;
                }
                case 'R': {
                    this.addIndexWord("UPDATE_TRANSFORM.INDEX", entry);
                    break;
                }
                case 'C': 
                case 'E': 
                case 'F': {
                    this.addIndexWord("PROCEDURES.INDEX", entry);
                    break;
                }
                case 'T': {
                    this.addIndexWord("PROC_TRANSFORM.INDEX", entry);
                    break;
                }
                case 'U': {
                    this.addIndexWord("MAPPING_TRANSFORM.INDEX", entry);
                    break;
                }
                case 'W': {
                    this.addIndexWord("ANNOTATION.INDEX", entry);
                    break;
                }
                case 'X': {
                    this.addIndexWord("PROPERTIES.INDEX", entry);
                    break;
                }
                case 'Z': {
                    break;
                }
            }
        }
    }

    private void addIndexWord(String indexName, WordEntry entry) {
        ArrayList<WordEntry> words;
        if (this.indexToCollectionMap == null) {
            this.indexToCollectionMap = new HashMap();
        }
        if ((words = (ArrayList<WordEntry>)this.indexToCollectionMap.get(indexName)) == null) {
            words = new ArrayList<WordEntry>();
            this.indexToCollectionMap.put(indexName, words);
        }
        words.add(entry);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

