/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.EnhancedStringTokenizer;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.UriUtil;
import com.metamatrix.metamodels.webservice.util.ReferencedXSDSchemaFinder;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelVisitor;
import com.metamatrix.modeler.core.util.ModelVisitorProcessor;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.webservice.IWsdlGenerator;
import com.metamatrix.modeler.webservice.WebServicePlugin;
import com.metamatrix.vdb.edit.VdbContextEditor;
import com.metamatrix.vdb.edit.VdbEditException;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.VdbWsdlGenerationOptions;
import com.metamatrix.vdb.edit.manifest.ManifestFactory;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.edit.manifest.VirtualDatabase;
import com.metamatrix.vdb.edit.manifest.WsdlOptions;
import com.metamatrix.vdb.internal.edit.VdbEditingContextImpl;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.util.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDSchema;

public class VdbWsdlGenerationOptionsImpl
implements VdbWsdlGenerationOptions {
    private final VdbEditingContextImpl context;
    private final VdbContextEditor contextEditor;

    public VdbWsdlGenerationOptionsImpl(VdbEditingContextImpl context) {
        ArgCheck.isNotNull(context);
        this.context = context;
        this.contextEditor = null;
    }

    public VdbWsdlGenerationOptionsImpl(VdbContextEditor context) {
        ArgCheck.isNotNull(context);
        this.context = null;
        this.contextEditor = context;
    }

    public boolean isValidUri(String str) {
        try {
            new URI(str);
        }
        catch (URI.MalformedURIException e2) {
            return false;
        }
        return true;
    }

    public boolean canWsdlBeGenerated() {
        EList models = this.getVirtualDatabase().getModels();
        Iterator iter = models.iterator();
        while (iter.hasNext()) {
            ModelReference model = (ModelReference)iter.next();
            if (!"http://www.metamatrix.com/metamodels/WebService".equals(model.getPrimaryMetamodelUri())) continue;
            return true;
        }
        return false;
    }

    protected WsdlOptions getWsdlOptions(boolean createIfRequired) {
        VirtualDatabase vdb = this.getVirtualDatabase();
        WsdlOptions options = vdb.getWsdlOptions();
        if (options == null && createIfRequired) {
            options = ManifestFactory.eINSTANCE.createWsdlOptions();
            vdb.setWsdlOptions(options);
            options.setDefaultNamespaceUri("http://schemas.xmlsoap.org/wsdl/");
        }
        return options;
    }

    public List getWebServiceModelReferences() {
        ArrayList<ModelReference> results = new ArrayList<ModelReference>();
        EList models = this.getVirtualDatabase().getModels();
        Iterator iter = models.iterator();
        while (iter.hasNext()) {
            ModelReference model = (ModelReference)iter.next();
            if (!"http://www.metamatrix.com/metamodels/WebService".equals(model.getPrimaryMetamodelUri())) continue;
            results.add(model);
        }
        return results;
    }

    public List getWebServiceResources() {
        ArrayList<ModelReference> results = new ArrayList<ModelReference>();
        EList models = this.getVirtualDatabase().getModels();
        Iterator iter = models.iterator();
        while (iter.hasNext()) {
            ModelReference model = (ModelReference)iter.next();
            if (!"http://www.metamatrix.com/metamodels/WebService".equals(model.getPrimaryMetamodelUri())) continue;
            results.add(model);
        }
        return results;
    }

    public String getTargetNamespaceUri() {
        WsdlOptions options = this.getWsdlOptions(false);
        String result = null;
        if (options != null) {
            result = options.getTargetNamespaceUri();
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void setTargetNamespaceUri(String namespaceUri) {
        WsdlOptions options = this.getWsdlOptions(true);
        if (options != null) {
            options.setTargetNamespaceUri(namespaceUri);
        }
        if ("".equals(this.getDefaultNamespaceUri())) {
            this.setDefaultNamespaceUri(namespaceUri);
        }
        if (namespaceUri != null && namespaceUri.trim().length() != 0) {
            try {
                new URI(namespaceUri);
            }
            catch (URI.MalformedURIException err) {
                throw new IllegalArgumentException(err.getLocalizedMessage());
            }
        }
    }

    public Collection getReferencedXsds() throws ModelWorkspaceException {
        List wsModelRefs = this.getWebServiceModelReferences();
        if (wsModelRefs.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ReferencedXSDSchemaFinder visitor = new ReferencedXSDSchemaFinder();
        ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor);
        Iterator iter = wsModelRefs.iterator();
        while (iter.hasNext()) {
            ModelReference modelRef = (ModelReference)iter.next();
            Resource resource = this.getResource(modelRef);
            try {
                processor.walk(resource, 2);
            }
            catch (ModelerCoreException err) {
                throw new ModelWorkspaceException(err);
            }
        }
        return visitor.getXsdSchemas();
    }

    public String[] getAllNamespaceUris() throws ModelWorkspaceException {
        List wsModelRefs = this.getWebServiceModelReferences();
        if (wsModelRefs.isEmpty()) {
            return new String[0];
        }
        ReferencedXSDSchemaFinder visitor = new ReferencedXSDSchemaFinder();
        ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor);
        Iterator iter = wsModelRefs.iterator();
        while (iter.hasNext()) {
            ModelReference modelRef = (ModelReference)iter.next();
            Resource resource = this.getResource(modelRef);
            if (resource == null) continue;
            try {
                processor.walk(resource, 2);
            }
            catch (ModelerCoreException err) {
                throw new ModelWorkspaceException(err);
            }
        }
        HashSet<String> uniqueNamespaceUris = new HashSet<String>(visitor.getXsdTargetNamespaces());
        String tns = this.getTargetNamespaceUri();
        if (tns != null && tns.trim().length() != 0) {
            uniqueNamespaceUris.add(this.getTargetNamespaceUri());
        }
        uniqueNamespaceUris.add("http://schemas.xmlsoap.org/wsdl/");
        Iterator iter2 = visitor.getXsdSchemas().iterator();
        while (iter2.hasNext()) {
            XSDSchema schema = (XSDSchema)iter2.next();
            String sosNamespace = schema.getSchemaForSchemaNamespace();
            uniqueNamespaceUris.add(sosNamespace);
        }
        ArrayList namespaceUris = new ArrayList(uniqueNamespaceUris);
        Collections.sort(namespaceUris, StringUtil.CASE_SENSITIVE_ORDER);
        return namespaceUris.toArray(new String[namespaceUris.size()]);
    }

    public String getDefaultNamespaceUri() {
        WsdlOptions options = this.getWsdlOptions(false);
        String result = null;
        if (options != null) {
            result = options.getDefaultNamespaceUri();
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void setDefaultNamespaceUri(String namespaceUri) {
        WsdlOptions options;
        if (namespaceUri != null && namespaceUri.trim().length() != 0) {
            try {
                new URI(namespaceUri);
            }
            catch (URI.MalformedURIException err) {
                throw new IllegalArgumentException(err.getLocalizedMessage());
            }
        }
        if ((options = this.getWsdlOptions(true)) != null) {
            options.setDefaultNamespaceUri(namespaceUri);
        }
    }

    public InputStream getWsdl(IProgressMonitor monitor) throws IOException, VdbEditException {
        String result = this.getWsdlAsString(monitor);
        return new ByteArrayInputStream(result.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWsdlAsString(IProgressMonitor monitor) throws IOException, VdbEditException {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        BufferedOutputStream stream = new BufferedOutputStream(bas);
        IStatus status = null;
        try {
            status = this.generateWsdl(monitor, stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        if (status.getSeverity() == 4) {
            throw new VdbEditException(status);
        }
        return bas.toString();
    }

    public IStatus generateWsdl(IProgressMonitor monitor, OutputStream stream) {
        String msg;
        ArrayList<IStatus> problems = new ArrayList<IStatus>();
        if (this.canWsdlBeGenerated()) {
            IWsdlGenerator wsdlGenerator = WebServicePlugin.createWsdlGenerator();
            wsdlGenerator.setName(this.getVirtualDatabase().getName());
            wsdlGenerator.setTargetNamespace(this.getTargetNamespaceUri());
            wsdlGenerator.setDefaultNamespaceUri(this.getDefaultNamespaceUri());
            wsdlGenerator.setUrlRootForReferences("http://vdb.metamatrix.com");
            wsdlGenerator.setUrlSuffixForReferences("?vdbToken=true");
            wsdlGenerator.setUrlForWsdlService("http://vdb.dataservice.metamatrix.com");
            wsdlGenerator.setXmlEncoding("UTF-8");
            List modelRefs = this.getWebServiceModelReferences();
            Iterator iter = modelRefs.iterator();
            while (iter.hasNext()) {
                ModelReference modelRef = (ModelReference)iter.next();
                Resource resource = this.getResource(modelRef);
                if (resource == null) continue;
                wsdlGenerator.addWebServiceModel(resource);
            }
            File tempDirFolder = this.getTempDirectoryFolder();
            try {
                Collection xsdSchemas = this.getReferencedXsds();
                Iterator iter2 = xsdSchemas.iterator();
                while (iter2.hasNext()) {
                    Resource emfResource;
                    XSDSchema schema = (XSDSchema)iter2.next();
                    if (schema == null || (emfResource = schema.eResource()) == null || !emfResource.getURI().isFile()) continue;
                    String pathToSchema = this.getPathRelativeToFolder(tempDirFolder, new File(emfResource.getURI().toFileString()));
                    if (pathToSchema != null) {
                        Path path = new Path(pathToSchema);
                        IPath pathWithEncoding = this.encodePathForUseInUri(path);
                        wsdlGenerator.addXsdModel(schema, pathWithEncoding);
                        continue;
                    }
                    wsdlGenerator.addXsdModel(schema, null);
                }
            }
            catch (ModelWorkspaceException e2) {
                String msg2 = VdbEditPlugin.Util.getString("VdbWsdlGenerationOptionsImpl.ErrorAccessingXSDs");
                problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg2, e2));
            }
            IStatus status = wsdlGenerator.generate(monitor);
            if (status.getSeverity() != 4) {
                try {
                    wsdlGenerator.write(stream);
                }
                catch (IOException e3) {
                    String msg3 = VdbEditPlugin.Util.getString("VdbWsdlGenerationOptionsImpl.ProblemsGeneratingWsdl");
                    problems.add(new Status(4, "com.metamatrix.vdb.edit", 0, msg3, e3));
                }
            } else if (status instanceof MultiStatus) {
                IStatus[] children = ((MultiStatus)status).getChildren();
                for (int i2 = 0; i2 < children.length; ++i2) {
                    problems.add(children[i2]);
                }
            } else {
                problems.add(status);
            }
        }
        if (problems.size() == 1) {
            return (IStatus)problems.get(0);
        }
        if (problems.size() == 0) {
            msg = VdbEditPlugin.Util.getString("VdbWsdlGenerationOptionsImpl.SuccessfullyGeneratedWsdl");
            return new Status(0, "com.metamatrix.vdb.edit", 0, msg, null);
        }
        msg = VdbEditPlugin.Util.getString("VdbWsdlGenerationOptionsImpl.ProblemsGeneratingWsdl");
        IStatus[] problemArray = problems.toArray(new IStatus[problems.size()]);
        return new MultiStatus("com.metamatrix.vdb.edit", 0, problemArray, msg, null);
    }

    private VirtualDatabase getVirtualDatabase() {
        VirtualDatabase vdb = null;
        if (this.context != null) {
            vdb = this.context.getVirtualDatabase();
        } else if (this.contextEditor != null) {
            vdb = this.contextEditor.getVirtualDatabase();
        }
        return vdb;
    }

    private File getTempDirectoryFolder() {
        File tempDirFolder = null;
        if (this.context != null) {
            tempDirFolder = new File(this.context.getTempDirectory().getPath());
        } else if (this.contextEditor != null) {
            tempDirFolder = new File(this.contextEditor.getTempDirectory().getPath());
        }
        return tempDirFolder;
    }

    private Resource getResource(ModelReference modelRef) {
        ArgCheck.isNotNull(modelRef);
        Resource resource = null;
        if (this.context != null) {
            resource = this.context.findInternalResource(modelRef.getModelLocation());
        } else if (this.contextEditor != null) {
            File tempDirFolder = new File(this.contextEditor.getTempDirectory().getPath());
            File modelFile = new File(tempDirFolder, modelRef.getModelLocation());
            org.eclipse.emf.common.util.URI modelFileUri = org.eclipse.emf.common.util.URI.createFileURI(modelFile.getAbsolutePath());
            resource = this.contextEditor.getVdbResourceSet().getResource(modelFileUri, true);
        }
        return resource;
    }

    protected String getPathRelativeToFolder(File parentFolder, File f2) {
        ArgCheck.isNotNull(parentFolder);
        ArgCheck.isNotNull(f2);
        String relativePath = null;
        try {
            String folderPath = parentFolder.getCanonicalPath();
            String filePath = f2.getCanonicalPath();
            if (filePath.startsWith(folderPath)) {
                relativePath = filePath.substring(folderPath.length());
            }
        }
        catch (IOException e2) {
            VdbEditPlugin.Util.log(4, e2, e2.getLocalizedMessage());
        }
        return relativePath;
    }

    protected IPath encodePathForUseInUri(IPath pathToResourceInVdb) {
        String[] pathSegments = pathToResourceInVdb.segments();
        IPath pathWithEncoding = Path.ROOT;
        for (int i2 = 0; i2 < pathSegments.length; ++i2) {
            String segment = pathSegments[i2];
            StringBuffer encodedSegment = new StringBuffer();
            String tokenDelimSet = ".?_";
            EnhancedStringTokenizer segmentTokens = new EnhancedStringTokenizer(segment, ".?_");
            while (segmentTokens.hasMoreTokens()) {
                String token = segmentTokens.nextToken();
                String delims = segmentTokens.nextDelimiters();
                String encodedSegmentToken = UriUtil.escape(token);
                encodedSegment.append(encodedSegmentToken);
                if (delims == null) continue;
                encodedSegment.append(delims);
            }
            pathWithEncoding = pathWithEncoding.append(encodedSegment.toString());
        }
        return pathWithEncoding;
    }
}

