/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.runtime.model;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.util.ConfigUtil;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.common.vdb.api.VDBModelDefn;
import com.metamatrix.common.vdb.api.VDBStream;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBInfo;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBModelDefn;
import com.metamatrix.vdb.internal.runtime.model.VDBArchiveSoftRef;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BasicVDBDefn
extends BasicVDBInfo
implements VDBDefn {
    private String vdbVersion;
    private Map connectorTypes = null;
    private Map connectorBindings = null;
    private VDBStream vdbcontent = null;
    private ArrayList validityErrors = null;
    private short status = 1;
    private boolean invalidVDBorModel = false;
    private Map visibilityMap = null;

    public BasicVDBDefn(String name) {
        super(name);
    }

    public BasicVDBDefn(String name, File softReference) {
        super(name);
        if (softReference != null) {
            this.vdbcontent = new VDBArchiveSoftRef(softReference);
        }
    }

    public void setVDBJar(byte[] content) {
        if (content != null) {
            this.vdbcontent = new VDBArchiveSoftRef(content);
        }
    }

    public byte[] getVDBJar() {
        if (this.vdbcontent != null) {
            return this.vdbcontent.toByteArray();
        }
        return null;
    }

    public VDBStream getVDBStream() {
        return this.vdbcontent;
    }

    public String getVersion() {
        return this.vdbVersion;
    }

    public boolean doesVDBHaveValidityError() {
        return this.invalidVDBorModel;
    }

    public void setVersion(String vdbVersion) {
        this.vdbVersion = vdbVersion;
    }

    public void addConnectorBinding(String modelName, ConnectorBinding binding) {
        this.addConnectorBinding(binding);
        BasicVDBModelDefn model = (BasicVDBModelDefn)this.getModel(modelName);
        if (model != null) {
            model.addConnectorBindingByName(binding.getFullName());
        }
    }

    public void addConnectorBinding(ConnectorBinding binding) {
        if (this.connectorBindings == null) {
            this.connectorBindings = new HashMap();
        }
        this.connectorBindings.put(binding.getName(), binding);
    }

    public void renameConnectorBinding(String existingBindingName, String newBindingName) {
        ConnectorBinding cb = this.removeConnectorBindingFromMap(existingBindingName);
        if (cb != null) {
            Collection ms = this.getModels();
            Iterator it = ms.iterator();
            while (it.hasNext()) {
                BasicVDBModelDefn model = (BasicVDBModelDefn)it.next();
                if (!model.isConnectorBindingUsed(cb.getFullName())) continue;
                model.renameConnectorBinding(existingBindingName, newBindingName);
            }
            ConnectorBinding newcb = ConfigUtil.getEditor().createConnectorComponent(cb.getConfigurationID(), cb, newBindingName, cb.getRoutingUUID());
            this.addConnectorBinding(newcb);
        }
    }

    public void removeConnectorBinding(String bindingName) {
        ConnectorBinding cb;
        if (this.connectorBindings != null && (cb = this.getConnectorBindingByName(bindingName)) != null) {
            Collection ms = this.getModels();
            Iterator it = ms.iterator();
            while (it.hasNext()) {
                BasicVDBModelDefn model = (BasicVDBModelDefn)it.next();
                if (!model.isConnectorBindingUsed(cb.getFullName())) continue;
                model.removeConnectorBindingName(cb.getFullName());
            }
            this.removeFromAvailableConnectorBindings(bindingName);
        }
    }

    private ConnectorBinding removeConnectorBindingFromMap(String bindingName) {
        ConnectorBinding cb = null;
        if (this.connectorBindings != null) {
            cb = (ConnectorBinding)this.connectorBindings.remove(bindingName);
        }
        return cb;
    }

    private void removeFromAvailableConnectorBindings(String bindingName) {
        ConnectorBinding cb = this.removeConnectorBindingFromMap(bindingName);
        if (cb != null && !this.isConnectorTypeInUse(cb.getComponentTypeID().getFullName())) {
            this.removeConnectorType(cb.getComponentTypeID().getFullName());
        }
    }

    public void removeConnectorBinding(String modelName, String bindingName) {
        ConnectorBinding cb;
        if (this.connectorBindings != null && (cb = this.getConnectorBindingByName(bindingName)) != null) {
            BasicVDBModelDefn model = (BasicVDBModelDefn)this.getModel(modelName);
            if (model != null) {
                model.removeConnectorBindingName(cb.getFullName());
            }
            if (!this.isBindingInUse(cb)) {
                this.removeFromAvailableConnectorBindings(cb.getFullName());
            }
        }
    }

    public boolean isBindingInUse(ConnectorBinding binding) {
        Collection ms = this.getModels();
        Iterator it = ms.iterator();
        while (it.hasNext()) {
            BasicVDBModelDefn model = (BasicVDBModelDefn)it.next();
            if (!model.isConnectorBindingUsed(binding.getFullName())) continue;
            return true;
        }
        return false;
    }

    private boolean isConnectorTypeInUse(String typeName) {
        if (this.connectorTypes == null) {
            return true;
        }
        Iterator it = this.connectorBindings.values().iterator();
        while (it.hasNext()) {
            ConnectorBinding cb = (ConnectorBinding)it.next();
            if (!cb.getComponentTypeID().getFullName().equalsIgnoreCase(typeName)) continue;
            return true;
        }
        return false;
    }

    public void setConnectorBinding(String modelName, ConnectorBinding binding) {
        this.addConnectorBinding(binding);
        BasicVDBModelDefn model = (BasicVDBModelDefn)this.getModel(modelName);
        if (model != null) {
            ArrayList<String> names = new ArrayList<String>(1);
            names.add(binding.getFullName());
            model.setConnectorBindingNames(names);
        }
    }

    protected void setConnectorBindings(Map bindings) {
        if (bindings != null) {
            if (this.connectorBindings == null) {
                this.connectorBindings = new HashMap(bindings.size());
            }
            this.connectorBindings.putAll(bindings);
        }
    }

    protected void setConnectorTypes(Map types) {
        if (types != null) {
            if (this.connectorTypes == null) {
                this.connectorTypes = new HashMap(types.size());
            }
            this.connectorTypes.putAll(types);
        }
    }

    public void removeConnectorType(String typeName) {
        if (this.connectorTypes != null) {
            this.connectorTypes.remove(typeName);
        }
    }

    public void addConnectorType(ComponentType type) {
        if (this.connectorTypes == null) {
            this.connectorTypes = new HashMap();
        }
        this.connectorTypes.put(type.getName(), type);
    }

    public Map getConnectorTypes() {
        HashMap m2 = new HashMap();
        if (this.connectorTypes != null) {
            m2.putAll(this.connectorTypes);
        }
        return m2;
    }

    public ComponentType getConnectorType(String componentTypeName) {
        if (this.connectorTypes == null) {
            return null;
        }
        if (this.connectorTypes.containsKey(componentTypeName)) {
            return (ComponentType)this.connectorTypes.get(componentTypeName);
        }
        return null;
    }

    public Map getConnectorBindings() {
        HashMap m2 = new HashMap();
        if (this.connectorBindings != null) {
            m2.putAll(this.connectorBindings);
        }
        return m2;
    }

    public ConnectorBinding getConnectorBindingByRouting(String routingUUID) {
        if (this.connectorBindings == null) {
            return null;
        }
        Iterator it = this.connectorBindings.values().iterator();
        while (it.hasNext()) {
            ConnectorBinding cb = (ConnectorBinding)it.next();
            if (!cb.getRoutingUUID().equals(routingUUID)) continue;
            return cb;
        }
        return null;
    }

    public ConnectorBinding getConnectorBindingByName(String bindingName) {
        if (this.connectorBindings == null) {
            return null;
        }
        ConnectorBinding cb = (ConnectorBinding)this.connectorBindings.get(bindingName);
        return cb;
    }

    public Map getModelToBindingMappings() {
        HashMap bm = new HashMap();
        Collection mdlsd = this.getModels();
        Iterator it = mdlsd.iterator();
        while (it.hasNext()) {
            ConnectorBinding cb;
            String name;
            Iterator bits;
            ArrayList<String> uuids;
            VDBModelDefn m2 = (VDBModelDefn)it.next();
            if (m2.getConnectorBindingNames().size() > 0) {
                uuids = new ArrayList<String>();
                bits = m2.getConnectorBindingNames().iterator();
                while (bits.hasNext()) {
                    name = (String)bits.next();
                    cb = (ConnectorBinding)this.connectorBindings.get(name);
                    uuids.add(cb.getRoutingUUID());
                }
                bm.put(m2.getName(), uuids);
                continue;
            }
            if (m2.getConnectorBindingNames().size() <= 0) continue;
            uuids = new ArrayList();
            bits = m2.getConnectorBindingNames().iterator();
            while (bits.hasNext()) {
                name = (String)bits.next();
                cb = (ConnectorBinding)this.connectorBindings.get(name);
                uuids.add(cb.getRoutingUUID());
            }
            bm.put(m2.getName(), uuids);
        }
        return bm;
    }

    public Collection getModelNames() {
        Collection mdlsd = this.getModels();
        ArrayList<String> mdls = new ArrayList<String>(mdlsd.size());
        Iterator it = mdlsd.iterator();
        while (it.hasNext()) {
            VDBModelDefn m2 = (VDBModelDefn)it.next();
            mdls.add(m2.getName());
        }
        return mdls;
    }

    public ModelInfo removeModelInfo(String modelName) {
        ModelInfo m2 = super.removeModelInfo(modelName);
        if (m2 != null) {
            List names = m2.getConnectorBindingNames();
            Iterator it = names.iterator();
            while (it.hasNext()) {
                String cbName = (String)it.next();
                ConnectorBinding cb = this.getConnectorBindingByName(cbName);
                if (cb == null || this.isBindingInUse(cb)) continue;
                this.removeConnectorBinding(cb.getFullName());
            }
        }
        return m2;
    }

    public ModelInfo getMatertializationModel() {
        ModelInfo matModel = null;
        Iterator modelItr = this.getModels().iterator();
        while (modelItr.hasNext()) {
            ModelInfo aModel = (ModelInfo)modelItr.next();
            if (aModel == null || !aModel.isMaterialization()) continue;
            matModel = aModel;
            break;
        }
        return matModel;
    }

    public short getStatus() {
        if (this.invalidVDBorModel) {
            return 1;
        }
        return this.status;
    }

    public void setStatus(short status) {
        this.status = status;
    }

    public boolean isActiveStatus() {
        if (this.invalidVDBorModel) {
            return false;
        }
        return this.status == 3;
    }

    public void setVDBValidityError(boolean hasError) {
        this.invalidVDBorModel = hasError;
    }

    public void setVDBValidityError(boolean hasError, String msg) {
        this.invalidVDBorModel = hasError;
        if (this.validityErrors == null) {
            this.validityErrors = new ArrayList();
        }
        if (msg != null) {
            this.validityErrors.add(msg);
        }
    }

    public String[] getVDBValidityErrors() {
        if (this.validityErrors != null) {
            return this.validityErrors.toArray(new String[this.validityErrors.size()]);
        }
        return new String[0];
    }

    public void determineVdbsStatus() {
        if (this.invalidVDBorModel) {
            this.setStatus((short)1);
            return;
        }
        Map mapConnBind = this.getModelToBindingMappings();
        short siStatus = 0;
        boolean bHasMissingValues = false;
        boolean bHasNoBindings = false;
        boolean requiresBindings = false;
        Iterator mit = this.getModels().iterator();
        while (mit.hasNext()) {
            ModelInfo mi = (ModelInfo)mit.next();
            if (!mi.requiresConnectorBinding()) continue;
            requiresBindings = true;
            break;
        }
        if (!requiresBindings) {
            this.setStatus((short)2);
            return;
        }
        int connBind = 0;
        Iterator it = mapConnBind.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            if (list == null || list.size() == 0) {
                bHasMissingValues = true;
                continue;
            }
            connBind += list.size();
        }
        if (connBind == 0) {
            bHasNoBindings = true;
        }
        siStatus = bHasNoBindings || bHasMissingValues ? (short)1 : 3;
        this.setStatus(siStatus);
    }

    public synchronized void removeUnmappedBindings() {
        HashSet allBindingNames = new HashSet();
        Iterator<Object> iter = this.getModels().iterator();
        while (iter.hasNext()) {
            ModelInfo model = (ModelInfo)iter.next();
            allBindingNames.addAll(model.getConnectorBindingNames());
        }
        iter = this.getConnectorBindings().values().iterator();
        while (iter.hasNext()) {
            ConnectorBinding binding = (ConnectorBinding)iter.next();
            String bindingName = binding.getFullName();
            if (allBindingNames.contains(bindingName)) continue;
            this.connectorBindings.remove(bindingName);
        }
    }

    public boolean isVisible(String resourcePath) {
        if (this.visibilityMap == null) {
            return false;
        }
        Boolean visibility = (Boolean)this.visibilityMap.get(resourcePath);
        if (visibility == null && resourcePath.startsWith("/")) {
            visibility = (Boolean)this.visibilityMap.get(resourcePath.substring(1));
        }
        return visibility != null && !visibility.equals(Boolean.FALSE);
    }

    public void setVisibility(String resoucePath, boolean visible) {
        if (this.visibilityMap == null) {
            this.visibilityMap = new HashMap();
        }
        this.visibilityMap.put(resoucePath, visible ? Boolean.TRUE : Boolean.FALSE);
    }
}

