/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.runtime.model;

import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.internal.runtime.model.URIModelResource;
import com.metamatrix.vdb.internal.runtime.model.URIResourceReader;
import java.util.Map;

public final class URIResource {
    private static Map resources = null;

    public boolean isXMLDocument(String uri) {
        URIModelResource r2 = this.getURIModelResource(uri);
        if (r2 != null) {
            return r2.isXMLDocType();
        }
        return false;
    }

    public String getAuthorizationLevel(String uri) {
        URIModelResource r2 = this.getURIModelResource(uri);
        if (r2 != null) {
            return r2.getAuthLevel();
        }
        return "all";
    }

    public boolean isPhysicalBindingAllowed(String uri) {
        URIModelResource r2 = this.getURIModelResource(uri);
        if (r2 != null) {
            return r2.isPhysicalBindingAllowed();
        }
        return false;
    }

    private URIModelResource getURIModelResource(String uri) {
        if (resources.containsKey(uri)) {
            return (URIModelResource)resources.get(uri);
        }
        return null;
    }

    static {
        try {
            URIResourceReader reader = new URIResourceReader();
            resources = reader.getURIResources();
        }
        catch (Exception e2) {
            String msg = VdbEditPlugin.Util.getString("URIResource.Resource_not_found", new Object[]{"uriprimarymodeltypes.xml"});
            VdbEditPlugin.Util.log(4, e2, msg);
        }
    }
}

