/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.runtime.model;

import com.metamatrix.common.xml.XMLReaderWriter;
import com.metamatrix.common.xml.XMLReaderWriterImpl;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.vdb.internal.runtime.model.BasicURIModelResource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class URIResourceReader {
    private Map resources = new HashMap();
    private static final String FALSE = Boolean.FALSE.toString();
    public static final String RESOURCE_NAME = "uriprimarymodeltypes.xml";
    static /* synthetic */ Class class$com$metamatrix$vdb$internal$runtime$model$URIResourceReader;

    public Map getURIResources() throws Exception {
        InputStream in = this.loadAsResource(RESOURCE_NAME);
        ArgCheck.isNotNull(in);
        Document doc = null;
        try {
            doc = this.getXMLReaderWriter().readDocument(in);
        }
        catch (JDOMException e2) {
            try {
                in.close();
            }
            catch (Exception ce) {
                // empty catch block
            }
            throw new Exception(e2.getMessage());
        }
        Element root = doc.getRootElement();
        List uriElements = root.getChildren("uri");
        Iterator iterator = uriElements.iterator();
        while (iterator.hasNext()) {
            Element uriElement = (Element)iterator.next();
            String name = null;
            String authlevel = "all";
            String isxmldoctype = FALSE;
            String isphysicalbinding = FALSE;
            List attrs = uriElement.getAttributes();
            Iterator ait = attrs.iterator();
            while (ait.hasNext()) {
                Attribute a2 = (Attribute)ait.next();
                String n2 = a2.getName();
                if (n2.equalsIgnoreCase("name")) {
                    name = a2.getValue();
                    continue;
                }
                if (n2.equalsIgnoreCase("authlevel")) {
                    authlevel = a2.getValue();
                    continue;
                }
                if (n2.equalsIgnoreCase("xmldoctype")) {
                    isxmldoctype = a2.getValue();
                    continue;
                }
                if (!n2.equalsIgnoreCase("physicalbindingallowed")) continue;
                isphysicalbinding = a2.getValue();
            }
            ArgCheck.isNotNull(name, "The attribute name was not defined");
            BasicURIModelResource resource = new BasicURIModelResource(name);
            resource.setAuthLevel(authlevel);
            resource.setIsXMLDocType(new Boolean(isxmldoctype));
            resource.setIsPhysicalBindingAllowed(new Boolean(isphysicalbinding));
            this.resources.put(name, resource);
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception ce) {
                // empty catch block
            }
        }
        return this.resources;
    }

    private InputStream loadAsResource(String resourceName) throws Exception {
        InputStream is = null;
        is = (class$com$metamatrix$vdb$internal$runtime$model$URIResourceReader == null ? (class$com$metamatrix$vdb$internal$runtime$model$URIResourceReader = URIResourceReader.class$("com.metamatrix.vdb.internal.runtime.model.URIResourceReader")) : class$com$metamatrix$vdb$internal$runtime$model$URIResourceReader).getResourceAsStream(resourceName);
        ArgCheck.isNotNull(is);
        return is;
    }

    private XMLReaderWriter getXMLReaderWriter() {
        return new XMLReaderWriterImpl();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Constants {
        public static final String URI_RESOURCES = "urimodeltypes";

        public static class URI {
            public static final String ELEMENT = "uri";

            public static class Attribute {
                public static final String NAME = "name";
                public static final String AUTHLEVEL = "authlevel";
                public static final String ISXMLDOCTYPE = "xmldoctype";
                public static final String PHYSICAL_BINDING = "physicalbindingallowed";
            }
        }
    }
}

