/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.codenorm;

import net.sf.saxon.codenorm.NormalizerData;
import net.sf.saxon.codenorm.UnicodeDataParser;
import net.sf.saxon.om.XMLChar;

public class Normalizer {
    static final byte COMPATIBILITY_MASK = 1;
    static final byte COMPOSITION_MASK = 2;
    public static final byte D = 0;
    public static final byte C = 2;
    public static final byte KD = 1;
    public static final byte KC = 3;
    private byte form;
    private static NormalizerData data = null;

    public Normalizer(byte by) {
        this.form = by;
        if (data == null) {
            data = UnicodeDataParser.build();
        }
    }

    public StringBuffer normalize(CharSequence charSequence, StringBuffer stringBuffer) {
        if (charSequence.length() != 0) {
            this.internalDecompose(charSequence, stringBuffer);
            if ((this.form & 2) != 0) {
                this.internalCompose(stringBuffer);
            }
        }
        return stringBuffer;
    }

    public CharSequence normalize(CharSequence charSequence) {
        return this.normalize(charSequence, new StringBuffer(charSequence.length() + 8));
    }

    private void internalDecompose(CharSequence charSequence, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer(8);
        boolean bl = (this.form & 1) == 0;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            int n3;
            stringBuffer2.setLength(0);
            int n4 = charSequence.charAt(n2++);
            if (XMLChar.isHighSurrogate(n4)) {
                n3 = charSequence.charAt(n2++);
                n4 = XMLChar.supplemental((char)n4, (char)n3);
            }
            data.getRecursiveDecomposition(bl, n4, stringBuffer2);
            int n5 = 0;
            while (n5 < stringBuffer2.length()) {
                int n6;
                char c2;
                n3 = stringBuffer2.charAt(n5++);
                if (XMLChar.isHighSurrogate(n4)) {
                    c2 = stringBuffer2.charAt(n5++);
                    n3 = XMLChar.supplemental((char)n3, c2);
                }
                c2 = data.getCanonicalClass(n3);
                if (c2 != '\u0000') {
                    for (n6 = stringBuffer.length(); n6 > 0; --n6) {
                        int n7 = stringBuffer.charAt(n6 - 1);
                        if (XMLChar.isSurrogate(n7)) {
                            char c3 = stringBuffer2.charAt(--n6 - 1);
                            n7 = XMLChar.supplemental(c3, (char)n7);
                        }
                        if (data.getCanonicalClass(n7) <= c2) break;
                    }
                }
                if (n3 < 65536) {
                    stringBuffer.insert(n6, (char)n3);
                    continue;
                }
                String string = "" + XMLChar.highSurrogate(n3) + XMLChar.lowSurrogate(n3);
                stringBuffer.insert(n6, string);
            }
        }
    }

    private void internalCompose(StringBuffer stringBuffer) {
        int n2;
        int n3 = 0;
        int n4 = stringBuffer.charAt(0);
        int n5 = 1;
        if (XMLChar.isHighSurrogate(n4)) {
            n4 = XMLChar.supplemental((char)n4, stringBuffer.charAt(1));
            ++n5;
        }
        if ((n2 = data.getCanonicalClass(n4)) != 0) {
            n2 = 256;
        }
        int n6 = stringBuffer.length();
        int n7 = n5;
        while (n7 < stringBuffer.length()) {
            int n8;
            if (XMLChar.isHighSurrogate(n8 = stringBuffer.charAt(n7++))) {
                n8 = XMLChar.supplemental((char)n8, stringBuffer.charAt(n7++));
            }
            int n9 = data.getCanonicalClass(n8);
            char c2 = data.getPairwiseComposition(n4, n8);
            if (c2 != '\uffff' && (n2 < n9 || n2 == 0)) {
                Normalizer.setCharAt(stringBuffer, n3, c2);
                n4 = c2;
                continue;
            }
            if (n9 == 0) {
                n3 = n5;
                n4 = n8;
            }
            n2 = n9;
            Normalizer.setCharAt(stringBuffer, n5, n8);
            if (stringBuffer.length() != n6) {
                n7 += stringBuffer.length() - n6;
                n6 = stringBuffer.length();
            }
            n5 += n8 < 65536 ? 1 : 2;
        }
        stringBuffer.setLength(n5);
    }

    private static void setCharAt(StringBuffer stringBuffer, int n2, int n3) {
        if (n3 < 65536) {
            if (XMLChar.isHighSurrogate(stringBuffer.charAt(n2))) {
                stringBuffer.setCharAt(n2, (char)n3);
                stringBuffer.deleteCharAt(n2 + 1);
            } else {
                stringBuffer.setCharAt(n2, (char)n3);
            }
        } else if (XMLChar.isHighSurrogate(stringBuffer.charAt(n2))) {
            stringBuffer.setCharAt(n2, XMLChar.highSurrogate(n3));
            stringBuffer.setCharAt(n2 + 1, XMLChar.lowSurrogate(n3));
        } else {
            stringBuffer.setCharAt(n2, XMLChar.highSurrogate(n3));
            stringBuffer.insert(n2 + 1, XMLChar.lowSurrogate(n3));
        }
    }

    boolean getExcluded(char c2) {
        return data.getExcluded(c2);
    }

    String getRawDecompositionMapping(char c2) {
        return data.getRawDecompositionMapping(c2);
    }
}

