/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.codenorm;

import java.util.BitSet;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntToIntHashMap;

public class NormalizerData {
    static final String copyright = "Copyright \u00a9 1998-1999 Unicode, Inc.";
    public static final int NOT_COMPOSITE = 65535;
    private IntToIntHashMap canonicalClass;
    private IntHashMap decompose;
    private IntToIntHashMap compose;
    private BitSet isCompatibility = new BitSet();
    private BitSet isExcluded = new BitSet();

    public int getCanonicalClass(int n2) {
        return this.canonicalClass.get(n2);
    }

    public char getPairwiseComposition(int n2, int n3) {
        if (n2 < 0 || n2 > 0x10FFFF || n3 < 0 || n3 > 0x10FFFF) {
            return '\uffff';
        }
        return (char)this.compose.get(n2 << 16 | n3);
    }

    public void getRecursiveDecomposition(boolean bl, int n2, StringBuffer stringBuffer) {
        String string = (String)this.decompose.get(n2);
        if (!(string == null || bl && this.isCompatibility.get(n2))) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                this.getRecursiveDecomposition(bl, string.charAt(i2), stringBuffer);
            }
        } else if (n2 < 65536) {
            stringBuffer.append((char)n2);
        } else {
            stringBuffer.append(XMLChar.highSurrogate(n2));
            stringBuffer.append(XMLChar.lowSurrogate(n2));
        }
    }

    NormalizerData(IntToIntHashMap intToIntHashMap, IntHashMap intHashMap, IntToIntHashMap intToIntHashMap2, BitSet bitSet, BitSet bitSet2) {
        this.canonicalClass = intToIntHashMap;
        this.decompose = intHashMap;
        this.compose = intToIntHashMap2;
        this.isCompatibility = bitSet;
        this.isExcluded = bitSet2;
    }

    boolean getExcluded(char c2) {
        return this.isExcluded.get(c2);
    }

    String getRawDecompositionMapping(char c2) {
        return (String)this.decompose.get(c2);
    }
}

