/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class TracingFilter
extends ProxyReceiver {
    private static int id = 0;
    private String indent = "";

    public TracingFilter() {
        ++id;
    }

    public TracingFilter(Receiver receiver) {
        ++id;
        this.setUnderlyingReceiver(receiver);
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " ATTRIBUTE " + this.getNamePool().getDisplayName(n2));
        super.attribute(n2, n3, charSequence, n4, n5);
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " CHARACTERS " + (Whitespace.isWhite(charSequence) ? "(whitespace)" : ""));
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() * 3);
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            fastStringBuffer.append(charSequence.charAt(i2) + " ");
        }
        System.err.println("    \"" + fastStringBuffer + '\"');
        super.characters(charSequence, n2, n3);
    }

    public void close() throws XPathException {
        System.err.println("RCVR " + id + this.indent + " CLOSE");
        super.close();
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " COMMENT");
        super.comment(charSequence, n2, n3);
    }

    public void endDocument() throws XPathException {
        System.err.println("RCVR " + id + this.indent + " END DOCUMENT");
        super.endDocument();
    }

    public void endElement() throws XPathException {
        this.indent = this.indent.substring(2);
        System.err.println("RCVR " + id + this.indent + " END ELEMENT");
        super.endElement();
    }

    public void namespace(int n2, int n3) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " NAMESPACE " + this.getNamePool().getPrefixFromNamespaceCode(n2) + "=" + this.getNamePool().getURIFromNamespaceCode(n2));
        super.namespace(n2, n3);
    }

    public void open() throws XPathException {
        System.err.println("RCVR " + id + this.indent + " OPEN");
        super.open();
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " PROCESSING INSTRUCTION");
        super.processingInstruction(string, charSequence, n2, n3);
    }

    public void startContent() throws XPathException {
        System.err.println("RCVR " + id + this.indent + " START CONTENT");
        super.startContent();
    }

    public void startDocument(int n2) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " START DOCUMENT");
        new NullPointerException("debug").printStackTrace();
        super.startDocument(n2);
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        System.err.println("RCVR " + id + this.indent + " START ELEMENT " + this.getNamePool().getDisplayName(n2));
        this.indent = this.indent + "  ";
        super.startElement(n2, n3, n4, n5);
    }
}

