/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.Err;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.Name10Checker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class XML10ContentChecker
extends ProxyReceiver {
    private NameChecker checker = Name10Checker.getInstance();
    private NamePool pool;
    private IntHashSet cache = new IntHashSet(100);

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pool = pipelineConfiguration.getConfiguration().getNamePool();
        super.setPipelineConfiguration(pipelineConfiguration);
    }

    public void startElement(int n2, int n3, int n4, int n5) throws XPathException {
        if (!this.cache.contains(n2)) {
            if (!this.checker.isValidNCName(this.pool.getLocalName(n2))) {
                DynamicError dynamicError = new DynamicError("Invalid XML 1.0 element name " + Err.wrap(this.pool.getLocalName(n2), 1));
                dynamicError.setErrorCode("SERE0005");
                dynamicError.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), n4));
                throw dynamicError;
            }
            this.cache.add(n2);
        }
        this.nextReceiver.startElement(n2, n3, n4, n5);
    }

    public void attribute(int n2, int n3, CharSequence charSequence, int n4, int n5) throws XPathException {
        if (!this.cache.contains(n2)) {
            if (!this.checker.isValidNCName(this.pool.getLocalName(n2))) {
                DynamicError dynamicError = new DynamicError("Invalid XML 1.0 attribute name " + Err.wrap(this.pool.getLocalName(n2), 2));
                dynamicError.setErrorCode("SERE0005");
                dynamicError.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), n4));
                throw dynamicError;
            }
            this.cache.add(n2);
        }
        this.checkString(charSequence, n4);
        this.nextReceiver.attribute(n2, n3, charSequence, n4, n5);
    }

    public void characters(CharSequence charSequence, int n2, int n3) throws XPathException {
        this.checkString(charSequence, n2);
        this.nextReceiver.characters(charSequence, n2, n3);
    }

    public void comment(CharSequence charSequence, int n2, int n3) throws XPathException {
        this.checkString(charSequence, n2);
        this.nextReceiver.comment(charSequence, n2, n3);
    }

    public void processingInstruction(String string, CharSequence charSequence, int n2, int n3) throws XPathException {
        if (!this.checker.isValidNCName(string)) {
            DynamicError dynamicError = new DynamicError("Invalid XML 1.0 processing instruction name " + Err.wrap(string));
            dynamicError.setErrorCode("SERE0005");
            dynamicError.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), n2));
            throw dynamicError;
        }
        this.checkString(charSequence, n2);
        this.nextReceiver.processingInstruction(string, charSequence, n2, n3);
    }

    private void checkString(CharSequence charSequence, int n2) throws XPathException {
        int n3 = charSequence.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = charSequence.charAt(i2);
            if (XMLChar.isHighSurrogate(n4)) {
                char c2 = charSequence.charAt(i2++);
                n4 = XMLChar.supplemental((char)n4, c2);
            }
            if (XMLChar.isValid(n4)) continue;
            DynamicError dynamicError = new DynamicError("The result tree contains a character not allowed by XML 1.0 (hex " + Integer.toHexString(n4) + ')');
            dynamicError.setErrorCode("SERE0006");
            dynamicError.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), n2));
            throw dynamicError;
        }
    }
}

