/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

public class Tokenize
extends SystemFunction {
    private RegularExpression regexp;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        Expression expression = this.simplifyArguments(staticContext);
        if (this.regexp == null && !(expression instanceof Value)) {
            try {
                this.regexp = Matches.tryToCompile(this.argument, 1, 2, staticContext);
            }
            catch (StaticError staticError) {
                staticError.setLocator(this);
                throw staticError;
            }
            if (this.regexp != null && this.regexp.matches("")) {
                StaticError staticError = new StaticError("The regular expression in tokenize() must not be one that matches a zero-length string");
                staticError.setErrorCode("FORX0003");
                staticError.setLocator(this);
                throw staticError;
            }
        }
        return expression;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return EmptyIterator.getInstance();
        }
        CharSequence charSequence = atomicValue.getStringValueCS();
        if (charSequence.length() == 0) {
            return EmptyIterator.getInstance();
        }
        RegularExpression regularExpression = this.regexp;
        if (regularExpression == null) {
            Serializable serializable;
            CharSequence charSequence2;
            atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
            CharSequence charSequence3 = atomicValue.getStringValueCS();
            if (this.argument.length == 2) {
                charSequence2 = "";
            } else {
                atomicValue = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
                charSequence2 = atomicValue.getStringValueCS();
            }
            try {
                serializable = xPathContext.getConfiguration().getPlatform();
                regularExpression = serializable.compileRegularExpression(charSequence3, true, charSequence2);
            }
            catch (XPathException xPathException) {
                DynamicError dynamicError = new DynamicError(xPathException);
                dynamicError.setErrorCode("FORX0002");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(this);
                throw dynamicError;
            }
            if (regularExpression.matches("")) {
                serializable = new StaticError("The regular expression in tokenize() must not be one that matches a zero-length string");
                ((XPathException)serializable).setErrorCode("FORX0003");
                ((TransformerException)serializable).setLocator(this);
                throw serializable;
            }
        }
        return regularExpression.tokenize(charSequence);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        String[] stringArray2 = Pattern.compile(stringArray[1]).split(string, 0);
        System.out.println("results");
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            System.out.println('[' + stringArray2[i2] + ']');
        }
        System.out.println("end results");
    }
}

