/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public final class Attribute
extends SimpleNodeConstructor {
    private Expression attributeName;
    private Expression namespace = null;
    private NamespaceResolver nsContext;
    private SimpleType schemaType;
    private int annotation;
    private int validationAction;
    private boolean allowNameAsQName;
    private int options;

    public Attribute(Expression expression, Expression expression2, NamespaceResolver namespaceResolver, int n2, SimpleType simpleType, int n3, boolean bl) {
        this.attributeName = expression;
        this.namespace = expression2;
        this.nsContext = namespaceResolver;
        this.schemaType = simpleType;
        this.annotation = n3 == -1 ? 642 : n3;
        this.validationAction = n2;
        this.options = 0;
        this.allowNameAsQName = bl;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
    }

    public void setRejectDuplicates() {
        this.options |= 0x20;
    }

    public int getInstructionNameCode() {
        return 131;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.ATTRIBUTE;
    }

    public int getCardinality() {
        return 16384;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.attributeName = this.attributeName.simplify(staticContext);
        if (this.namespace != null) {
            this.namespace = this.namespace.simplify(staticContext);
        }
        return super.simplify(staticContext);
    }

    public void localTypeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.attributeName = this.attributeName.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.attributeName);
        RoleLocator roleLocator = new RoleLocator(4, "attribute/name", 0, null);
        roleLocator.setSourceLocator(this);
        this.attributeName = this.allowNameAsQName ? TypeChecker.staticTypeCheck(this.attributeName, SequenceType.SINGLE_ATOMIC, false, roleLocator, staticContext) : TypeChecker.staticTypeCheck(this.attributeName, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        if (this.namespace != null) {
            this.namespace.typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.namespace);
            roleLocator = new RoleLocator(4, "attribute/namespace", 0, null);
            roleLocator.setSourceLocator(this);
            this.namespace = TypeChecker.staticTypeCheck(this.namespace, SequenceType.SINGLE_STRING, false, roleLocator, staticContext);
        }
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
        if (this.select != null) {
            arrayList.add(this.select);
        }
        arrayList.add(this.attributeName);
        if (this.namespace != null) {
            arrayList.add(this.namespace);
        }
        return arrayList.iterator();
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.attributeName = this.doPromotion(this.attributeName, promotionOffer);
        if (this.namespace != null) {
            this.namespace = this.doPromotion(this.namespace, promotionOffer);
        }
        super.promoteInst(promotionOffer);
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        if (schemaType instanceof SimpleType) {
            StaticError staticError = new StaticError("Attributes are not permitted here: the containing element is of simple type " + schemaType.getDescription());
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        CharSequence charSequence;
        int n2;
        int n3;
        SequenceReceiver sequenceReceiver;
        int n4;
        block12: {
            n4 = this.evaluateNameCode(xPathContext);
            if (n4 == -1) {
                return null;
            }
            sequenceReceiver = xPathContext.getReceiver();
            n3 = this.options;
            n2 = this.annotation;
            charSequence = ((Object)this.expandChildren(xPathContext)).toString();
            if (this.schemaType != null) {
                try {
                    ValidationException validationException = this.schemaType.validateContent(charSequence, DummyNamespaceResolver.getInstance(), xPathContext.getConfiguration().getNameChecker());
                    if (validationException != null) {
                        ValidationException validationException2 = new ValidationException("Attribute value " + Err.wrap(charSequence, 4) + " does not match the required type " + this.schemaType.getDescription() + ". " + validationException.getMessage());
                        validationException2.setErrorCode("XTTE1540");
                        throw validationException2;
                    }
                    break block12;
                }
                catch (UnresolvedReferenceException unresolvedReferenceException) {
                    throw new ValidationException(unresolvedReferenceException);
                }
            }
            if (this.validationAction == 1 || this.validationAction == 2) {
                try {
                    n2 = xPathContext.getConfiguration().validateAttribute(n4, charSequence, this.validationAction);
                }
                catch (ValidationException validationException) {
                    DynamicError dynamicError = DynamicError.makeDynamicError(validationException);
                    String string = validationException.getErrorCodeLocalPart();
                    if (string == null) {
                        string = this.validationAction == 1 ? "XTTE1510" : "XTTE1515";
                    }
                    dynamicError.setErrorCode(string);
                    dynamicError.setXPathContext(xPathContext);
                    dynamicError.setLocator(this);
                    dynamicError.setIsTypeError(true);
                    throw dynamicError;
                }
            }
        }
        if ((n4 & 0xFFFFF) == 388) {
            charSequence = NormalizeSpace.normalize(charSequence);
        }
        try {
            sequenceReceiver.attribute(n4, n2, charSequence, this.locationId, n3);
        }
        catch (XPathException xPathException) {
            throw Attribute.dynamicError(this, xPathException, xPathContext);
        }
        return null;
    }

    protected int evaluateNameCode(XPathContext xPathContext) throws XPathException, XPathException {
        Object object;
        CharSequence charSequence;
        NamePool namePool = xPathContext.getNamePool();
        Item item = this.attributeName.evaluateItem(xPathContext);
        String string = null;
        String string2 = null;
        if (item instanceof StringValue) {
            charSequence = item.getStringValueCS();
            try {
                object = xPathContext.getConfiguration().getNameChecker().getQNameParts(charSequence);
                string = object[0];
                string2 = object[1];
            }
            catch (QNameException qNameException) {
                DynamicError dynamicError = new DynamicError("Invalid attribute name: " + charSequence, this);
                dynamicError.setErrorCode(this.isXSLT() ? "XTDE0850" : "XQDY0074");
                dynamicError.setXPathContext(xPathContext);
                throw Attribute.dynamicError(this, dynamicError, xPathContext);
            }
            if (((Object)charSequence).toString().equals("xmlns") && this.namespace == null) {
                object = new DynamicError("Invalid attribute name: " + charSequence, this);
                ((XPathException)object).setErrorCode(this.isXSLT() ? "XTDE0855" : "XQDY0044");
                ((DynamicError)object).setXPathContext(xPathContext);
                throw Attribute.dynamicError(this, (XPathException)object, xPathContext);
            }
            if (string.equals("xmlns")) {
                if (this.namespace == null) {
                    object = new DynamicError("Invalid attribute name: " + charSequence, this);
                    ((XPathException)object).setErrorCode(this.isXSLT() ? "XTDE0860" : "XQDY0044");
                    ((DynamicError)object).setXPathContext(xPathContext);
                    throw Attribute.dynamicError(this, (XPathException)object, xPathContext);
                }
                string = "";
            }
        } else if (item instanceof QNameValue) {
            string2 = ((QNameValue)item).getLocalName();
            charSequence = ((QNameValue)item).getNamespaceURI();
            if (charSequence == null) {
                charSequence = "";
            }
            this.namespace = new StringValue(charSequence);
            string = ((String)charSequence).equals("") ? "" : ((QNameValue)item).getPrefix();
        } else {
            DynamicError dynamicError = new DynamicError("Attribute name must be either a string or a QName", this);
            dynamicError.setErrorCode("XPTY0004");
            dynamicError.setIsTypeError(true);
            dynamicError.setXPathContext(xPathContext);
            throw Attribute.dynamicError(this, dynamicError, xPathContext);
        }
        if (this.namespace == null) {
            if ("".equals(string)) {
                charSequence = "";
            } else {
                charSequence = this.nsContext.getURIForPrefix(string, false);
                if (charSequence == null) {
                    object = new DynamicError("Undeclared prefix in attribute name: " + string, this);
                    ((XPathException)object).setErrorCode(this.isXSLT() ? "XTDE0860" : "XQDY0074");
                    ((DynamicError)object).setXPathContext(xPathContext);
                    throw Attribute.dynamicError(this, (XPathException)object, xPathContext);
                }
            }
        } else {
            charSequence = this.namespace.evaluateAsString(xPathContext);
            if ("".equals(charSequence)) {
                string = "";
            } else if ("".equals(string) && (string = namePool.suggestPrefixForURI((String)charSequence)) == null) {
                string = "ns0";
            }
        }
        return namePool.allocate(string, (String)charSequence, string2);
    }

    public void display(int n2, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n2) + "attribute ");
        printStream.println(ExpressionTool.indent(n2 + 1) + "name");
        this.attributeName.display(n2 + 2, printStream, configuration);
        super.display(n2 + 1, printStream, configuration);
    }
}

