/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.XPathException;

public class AttributeSet
extends Procedure
implements InstructionInfoProvider {
    int nameCode;
    private AttributeSet[] useAttributeSets;

    public AttributeSet() {
        this.setHostLanguage(50);
    }

    public void setNameCode(int n2) {
        this.nameCode = n2;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public void setUseAttributeSets(AttributeSet[] attributeSetArray) {
        this.useAttributeSets = attributeSetArray;
    }

    public void setStackFrameMap(SlotManager slotManager) {
        if (slotManager != null && slotManager.getNumberOfVariables() > 0) {
            super.setStackFrameMap(slotManager);
        }
    }

    public void expand(XPathContext xPathContext) throws XPathException {
        if (this.useAttributeSets != null) {
            AttributeSet.expand(this.useAttributeSets, xPathContext);
        }
        if (this.getStackFrameMap() != null) {
            XPathContextMajor xPathContextMajor = xPathContext.newContext();
            xPathContextMajor.setOrigin(this);
            xPathContextMajor.openStackFrame(this.getStackFrameMap());
            this.getBody().process(xPathContextMajor);
        } else {
            this.getBody().process(xPathContext);
        }
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(132);
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setProperty("attribute-set", this);
        return instructionDetails;
    }

    protected static void expand(AttributeSet[] attributeSetArray, XPathContext xPathContext) throws XPathException {
        for (int i2 = 0; i2 < attributeSetArray.length; ++i2) {
            attributeSetArray[i2].expand(xPathContext);
        }
    }
}

