/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.GlobalParam;
import net.sf.saxon.instruct.GlobalParameterSet;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public final class Bindery {
    private ValueRepresentation[] globals;
    private boolean[] busy;
    private GlobalParameterSet globalParameters;
    private SlotManager globalVariableMap;

    public void allocateGlobals(SlotManager slotManager) {
        this.globalVariableMap = slotManager;
        int n2 = slotManager.getNumberOfVariables() + 1;
        this.globals = new ValueRepresentation[n2];
        this.busy = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.globals[i2] = null;
            this.busy[i2] = false;
        }
    }

    public void defineGlobalParameters(GlobalParameterSet globalParameterSet) {
        this.globalParameters = globalParameterSet;
    }

    public boolean useGlobalParameter(int n2, GlobalParam globalParam, XPathContext xPathContext) throws XPathException {
        Value value;
        int n3 = globalParam.getSlotNumber();
        if (this.globals[n3] != null) {
            return true;
        }
        if (this.globalParameters == null) {
            return false;
        }
        Object object = this.globalParameters.get(n2);
        if (object == null) {
            return false;
        }
        Configuration configuration = xPathContext.getConfiguration();
        try {
            value = Value.convertJavaObjectToXPath(object, globalParam.getRequiredType(), configuration);
            if (value == null) {
                value = EmptySequence.getInstance();
            }
        }
        catch (XPathException xPathException) {
            xPathException.setLocator(globalParam);
            throw xPathException;
        }
        ItemType itemType = globalParam.getRequiredType().getPrimaryType();
        if (value instanceof AtomicValue && itemType instanceof AtomicType) {
            if ((value = ((AtomicValue)value).convert((AtomicType)itemType, xPathContext, true)) instanceof ValidationErrorValue) {
                throw ((ValidationErrorValue)value).getException();
            }
        } else {
            DynamicError dynamicError = TypeChecker.testConformance(value, globalParam.getRequiredType(), configuration);
            if (dynamicError != null) {
                throw dynamicError;
            }
        }
        this.globals[n3] = value;
        return true;
    }

    public void defineGlobalVariable(GlobalVariable globalVariable, ValueRepresentation valueRepresentation) {
        this.globals[globalVariable.getSlotNumber()] = valueRepresentation;
    }

    public void setExecuting(GlobalVariable globalVariable, boolean bl) throws XPathException {
        int n2 = globalVariable.getSlotNumber();
        if (bl) {
            if (this.busy[n2]) {
                throw new XPathException.Circularity("Circular definition");
            }
            this.busy[n2] = true;
        } else {
            this.busy[n2] = false;
        }
    }

    public ValueRepresentation getGlobalVariableValue(GlobalVariable globalVariable) {
        return this.globals[globalVariable.getSlotNumber()];
    }

    public ValueRepresentation getGlobalVariable(int n2) {
        return this.globals[n2];
    }

    public void assignGlobalVariable(GlobalVariable globalVariable, ValueRepresentation valueRepresentation) {
        this.defineGlobalVariable(globalVariable, valueRepresentation);
    }

    public SlotManager getGlobalVariableMap() {
        return this.globalVariableMap;
    }

    public ValueRepresentation[] getGlobalVariables() {
        return this.globals;
    }
}

