/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jdom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Transform;
import net.sf.saxon.jdom.DocumentWrapper;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

public class JDOMTransform
extends Transform {
    public List preprocess(List list) throws XPathException {
        try {
            ArrayList<DocumentWrapper> arrayList = new ArrayList<DocumentWrapper>(list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                InputSource inputSource;
                Object object;
                Source source = (Source)list.get(i2);
                if (source instanceof SAXSource) {
                    object = (SAXSource)list.get(i2);
                    inputSource = ((SAXSource)object).getInputSource();
                } else if (source instanceof StreamSource) {
                    object = (StreamSource)source;
                    inputSource = ((StreamSource)object).getInputStream() != null ? new InputSource(((StreamSource)object).getInputStream()) : (((StreamSource)object).getReader() != null ? new InputSource(((StreamSource)object).getReader()) : new InputSource(((StreamSource)object).getSystemId()));
                } else {
                    throw new IllegalArgumentException("Unknown kind of source");
                }
                inputSource.setSystemId(source.getSystemId());
                object = new SAXBuilder();
                Document document = ((SAXBuilder)object).build(inputSource);
                DocumentWrapper documentWrapper = new DocumentWrapper(document, inputSource.getSystemId(), this.config);
                arrayList.add(documentWrapper);
            }
            return arrayList;
        }
        catch (JDOMException jDOMException) {
            throw new DynamicError(jDOMException);
        }
        catch (IOException iOException) {
            throw new DynamicError(iOException);
        }
    }

    public static void main(String[] stringArray) {
        new JDOMTransform().doTransform(stringArray, "JDOMTransform");
    }
}

