/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.ExtendedNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;

public class IdrefTest
extends NodeTest {
    private int kind;

    public IdrefTest(int n2) {
        this.kind = n2;
    }

    public ItemType getSuperType(TypeHierarchy typeHierarchy) {
        return NodeKindTest.makeNodeKindTest(this.kind);
    }

    public boolean matches(int n2, int n3, int n4) {
        return false;
    }

    public boolean matches(TinyTree tinyTree, int n2) {
        if (tinyTree.getNodeKind(n2) != this.kind) {
            return false;
        }
        return tinyTree.isIdrefElement(n2);
    }

    public boolean matches(NodeInfo nodeInfo) {
        if (nodeInfo instanceof ExtendedNodeInfo) {
            return ((ExtendedNodeInfo)nodeInfo).isIdref();
        }
        return false;
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getPrimitiveType() {
        return this.kind;
    }

    public int getNodeKindMask() {
        return 1 << this.kind;
    }

    public AtomicType getAtomizedItemType() {
        return Type.ANY_ATOMIC_TYPE;
    }

    public String toString() {
        return this.kind == 1 ? "is-idref(element)" : "is-idref(attribute)";
    }

    public int hashCode() {
        return this.kind << 20 ^ 0xCC2BB;
    }

    public boolean equals(Object object) {
        return object instanceof IdrefTest && ((IdrefTest)object).kind == this.kind;
    }
}

